/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.xbean.classloader.MultiParentClassLoader;
import org.apache.xbean.classloader.NonLockingJarFileClassLoader;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.runtime.m12n.ExtensionModuleScanner;
import org.codehaus.groovy.runtime.m12n.SimpleExtensionModule;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.ExternalJavaProject;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.core.builder.NameEnvironment;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;

public final class GroovyClassLoaderFactory {
    private static Map<String, Map.Entry<IClasspathEntry[], GroovyClassLoader[]>> projectClassLoaderCache = new ConcurrentHashMap<String, Map.Entry<IClasspathEntry[], GroovyClassLoader[]>>();
    private GroovyClassLoader batchLoader;
    private final CompilerOptions compilerOptions;
    private final LookupEnvironment lookupEnvironment;
    private static final boolean NONLOCKING = Boolean.getBoolean("greclipse.nonlocking");

    static {
        if (NONLOCKING) {
            System.out.println("property set: greclipse.nonlocking: will try to avoid locking jars");
        }
    }

    public static void clearCache(String projectName) {
        Map.Entry<IClasspathEntry[], GroovyClassLoader[]> entry = projectClassLoaderCache.remove(projectName);
        if (entry != null) {
            Arrays.stream(entry.getValue()).filter(Objects::nonNull).forEach(GroovyClassLoaderFactory::close);
        }
    }

    private static void close(ClassLoader classLoader) {
        ClassLoader parentLoader;
        if (classLoader instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)classLoader)).close();
            }
            catch (Exception e) {
                Util.log((Throwable)e);
            }
        }
        if ((parentLoader = GroovyClassLoaderFactory.getParent(classLoader)) instanceof URLClassLoader) {
            GroovyClassLoaderFactory.close(parentLoader);
        }
    }

    private static ClassLoader getParent(ClassLoader classLoader) {
        if (classLoader instanceof MultiParentClassLoader) {
            return ((MultiParentClassLoader)classLoader).getParents()[0];
        }
        return classLoader.getParent();
    }

    public GroovyClassLoaderFactory(CompilerOptions compilerOptions, LookupEnvironment lookupEnvironment) {
        this.compilerOptions = compilerOptions;
        this.lookupEnvironment = lookupEnvironment;
    }

    public GroovyClassLoader[] getGroovyClassLoaders(CompilerConfiguration compilerConfiguration) {
        if (this.compilerOptions.groovyProjectName == null) {
            return this.getBatchGroovyClassLoaders(compilerConfiguration);
        }
        return this.getProjectGroovyClassLoaders(compilerConfiguration);
    }

    private GroovyClassLoader[] getBatchGroovyClassLoaders(CompilerConfiguration compilerConfiguration) {
        if (this.batchLoader == null && this.lookupEnvironment != null) {
            try {
                FileSystem.Classpath[] classpaths;
                INameEnvironment nameEnvironment = this.lookupEnvironment.nameEnvironment;
                if (nameEnvironment.getClass().getName().contains(".InMemoryNameEnvironment")) {
                    nameEnvironment = ((INameEnvironment[])ReflectionUtils.throwableGetPrivateField(nameEnvironment.getClass(), "classLibs", nameEnvironment))[0];
                }
                if (nameEnvironment instanceof FileSystem && (classpaths = (FileSystem.Classpath[])ReflectionUtils.throwableGetPrivateField(FileSystem.class, "classpaths", nameEnvironment)) != null) {
                    this.batchLoader = new GroovyClassLoader();
                    FileSystem.Classpath[] classpathArray = classpaths;
                    int n = classpaths.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FileSystem.Classpath classpath = classpathArray[n2];
                        this.batchLoader.addClasspath(classpath.getPath());
                        ++n2;
                    }
                }
            }
            catch (Exception e) {
                Util.log((Throwable)e, (String)"Unexpected problem computing classpath for batch compiler");
            }
        }
        return new GroovyClassLoader[]{new GrapeAwareGroovyClassLoader((ClassLoader)this.batchLoader, compilerConfiguration), this.batchLoader};
    }

    private GroovyClassLoader[] getProjectGroovyClassLoaders(CompilerConfiguration compilerConfiguration) {
        String projectName = this.compilerOptions.groovyProjectName;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        try {
            ExternalJavaProject javaProject = " ".equals(projectName) ? new ExternalJavaProject(JavaCore.create((IProject)project).getRawClasspath()) : JavaCore.create((IProject)project);
            Object[] classpathEntries = javaProject.exists() ? javaProject.getResolvedClasspath(true) : ClasspathEntry.NO_ENTRIES;
            Map.Entry entry = projectClassLoaderCache.computeIfAbsent(projectName, arg_0 -> this.lambda$2((IJavaProject)javaProject, project, compilerConfiguration, (IClasspathEntry[])classpathEntries, arg_0));
            if (Arrays.equals(classpathEntries, (Object[])entry.getKey())) {
                GroovyClassLoader[] values = (GroovyClassLoader[])entry.getValue();
                if ("main".equals(this.getCompilationGroup())) {
                    return new GroovyClassLoader[]{values[0], values[values.length - 1]};
                }
                return Arrays.copyOf(values, 2);
            }
            GroovyClassLoaderFactory.clearCache(projectName);
            return this.getProjectGroovyClassLoaders(compilerConfiguration);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to bootstrap GroovyClassLoaders for project '" + projectName + "'", e);
        }
    }

    private String getCompilationGroup() {
        if (this.lookupEnvironment != null) {
            if (this.lookupEnvironment.nameEnvironment instanceof NameEnvironment) {
                return Optional.ofNullable(ReflectionUtils.getPrivateField(NameEnvironment.class, "compilationGroup", this.lookupEnvironment.nameEnvironment)).map(compilationGroup -> compilationGroup.toString().toLowerCase()).orElse(null);
            }
            if (this.lookupEnvironment.nameEnvironment instanceof SearchableEnvironment) {
                Boolean excludeTestCode = (Boolean)ReflectionUtils.getPrivateField(SearchableEnvironment.class, "excludeTestCode", this.lookupEnvironment.nameEnvironment);
                return Boolean.TRUE.equals(excludeTestCode) ? "main" : "test";
            }
        }
        return null;
    }

    private static void calculateClasspath(IJavaProject javaProject, boolean mainOnly, Set<String> classPaths, Set<String> xformPaths) {
        try {
            IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((IJavaProject)javaProject);
            Arrays.sort(entries, Comparator.comparing(IRuntimeClasspathEntry::getType));
            IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IRuntimeClasspathEntry unresolved = iRuntimeClasspathEntryArray[n2];
                Set<String> paths = unresolved.getType() == 4 ? classPaths : xformPaths;
                IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray2 = GroovyClassLoaderFactory.resolveRuntimeClasspathEntry(unresolved, mainOnly);
                int n3 = iRuntimeClasspathEntryArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IRuntimeClasspathEntry resolved = iRuntimeClasspathEntryArray2[n4];
                    String path = GroovyClassLoaderFactory.getAbsoluteLocation(resolved);
                    if (path != null) {
                        paths.add(path);
                    }
                    ++n4;
                }
                ++n2;
            }
            classPaths.addAll(xformPaths);
            assert (classPaths.stream().map(File::new).allMatch(File::isAbsolute));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry classpathEntry, boolean excludeTestCode) throws ReflectiveOperationException {
        return (IRuntimeClasspathEntry[])JavaRuntime.class.getDeclaredMethod("resolveRuntimeClasspathEntry", IRuntimeClasspathEntry.class, IJavaProject.class, Boolean.TYPE).invoke(JavaRuntime.class, classpathEntry, classpathEntry.getJavaProject(), excludeTestCode);
    }

    private static String getAbsoluteLocation(IRuntimeClasspathEntry classpathEntry) throws Exception {
        String location;
        if (classpathEntry.getType() == 1) {
            try {
                ((IJavaProject)JavaCore.create((IResource)classpathEntry.getResource())).getOutputLocation();
            }
            catch (NullPointerException | JavaModelException ignore) {
                return ResourcesPlugin.getWorkspace().getRoot().getLocation().append(classpathEntry.getPath()).toOSString();
            }
        }
        if ((location = classpathEntry.getLocation()) == null) {
            if (classpathEntry.getType() != 1) {
                location = Util.toLocalFile((URI)classpathEntry.getResource().getLocationURI(), null).getAbsolutePath();
            }
        } else if (!new File(location).exists()) {
            Path path = new Path(location);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
            IProject resource = path.segmentCount() == 1 ? project : project.getFile(path.removeFirstSegments(1));
            location = Optional.ofNullable(resource).map(IResource::getLocation).map(IPath::toOSString).orElse(null);
        }
        return location;
    }

    private static URLClassLoader newClassLoader(Set<String> classpath, ClassLoader parent) {
        URL[] urls = (URL[])classpath.stream().map(file -> {
            try {
                return new File((String)file).toURI().toURL();
            }
            catch (MalformedURLException ignore) {
                return null;
            }
        }).filter(Objects::nonNull).toArray(URL[]::new);
        if (NONLOCKING) {
            if (parent == null) {
                parent = URLClassLoader.newInstance(new URL[0], null);
            }
            return new NonLockingJarFileClassLoader("GDT non-locking loader", urls, parent);
        }
        return URLClassLoader.newInstance(urls, parent);
    }

    private /* synthetic */ Map.Entry lambda$2(IJavaProject iJavaProject, IProject iProject, CompilerConfiguration compilerConfiguration, IClasspathEntry[] iClasspathEntryArray, String x) {
        LinkedHashSet<String> classPaths = new LinkedHashSet<String>();
        LinkedHashSet<String> xformPaths = new LinkedHashSet<String>();
        if (iJavaProject.exists()) {
            GroovyClassLoaderFactory.calculateClasspath(iJavaProject, false, classPaths, xformPaths);
        }
        if (GroovyLogManager.manager.hasLoggers()) {
            GroovyLogManager.manager.log(TraceCategory.AST_TRANSFORM, "Transform classpath: " + String.join((CharSequence)File.pathSeparator, xformPaths));
        }
        ArrayList<EclipseGroovyClassLoader> values = new ArrayList<EclipseGroovyClassLoader>(3);
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (iJavaProject.exists()) {
            LinkedHashSet<String> dontCare = new LinkedHashSet<String>();
            LinkedHashSet<String> mainOnly = new LinkedHashSet<String>();
            GroovyClassLoaderFactory.calculateClasspath(iJavaProject, true, dontCare, mainOnly);
            if (!mainOnly.equals(xformPaths)) {
                classLoader = GroovyClassLoaderFactory.newClassLoader(mainOnly, classLoader);
                xformPaths.removeAll(mainOnly);
                values.add(0, new EclipseGroovyClassLoader(iProject, classLoader, compilerConfiguration, null, null));
            }
        }
        classLoader = GroovyClassLoaderFactory.newClassLoader(xformPaths, classLoader);
        values.add(0, new EclipseGroovyClassLoader(iProject, classLoader, compilerConfiguration, null, null));
        values.add(0, new GrapeAwareGroovyClassLoader(iProject, (ClassLoader)GroovyClassLoaderFactory.newClassLoader(classPaths, ClassLoader.getSystemClassLoader()), compilerConfiguration));
        return new AbstractMap.SimpleEntry<IClasspathEntry[], GroovyClassLoader[]>(iClasspathEntryArray, values.toArray(new GroovyClassLoader[0]));
    }

    private static class EclipseGroovyClassLoader
    extends GroovyClassLoader {
        private final IProject project;

        private EclipseGroovyClassLoader(IProject project, ClassLoader parent) {
            this(project, parent, CompilerConfiguration.DEFAULT);
        }

        private EclipseGroovyClassLoader(IProject project, ClassLoader parent, CompilerConfiguration config) {
            super(parent, config, false);
            this.project = project;
        }

        public void close() throws IOException {
            StaticTypeCheckingSupport.clearExtensionMethodCache((ClassLoader)((Object)this));
            super.close();
        }

        public Enumeration<URL> getResources(String name) throws IOException {
            Enumeration resources = super.getResources(name);
            if (this.project != null && resources.hasMoreElements() && (name.startsWith("META-INF/groovy/") || name.startsWith("META-INF/services/"))) {
                String exclude = this.project.getLocationURI().getPath();
                ArrayList<URL> list = new ArrayList<URL>();
                while (resources.hasMoreElements()) {
                    URL resource = (URL)resources.nextElement();
                    if (resource.getPath().startsWith(exclude)) continue;
                    list.add(resource);
                }
                resources = Collections.enumeration(list);
            }
            return resources;
        }

        /* synthetic */ EclipseGroovyClassLoader(IProject iProject, ClassLoader classLoader, CompilerConfiguration compilerConfiguration, EclipseGroovyClassLoader eclipseGroovyClassLoader, EclipseGroovyClassLoader eclipseGroovyClassLoader2) {
            this(iProject, classLoader, compilerConfiguration);
        }
    }

    public static class GrapeAwareGroovyClassLoader
    extends EclipseGroovyClassLoader {
        public boolean grabbed;
        private volatile Set<Class> defaultCategories;
        private volatile Set<Class> defaultStaticCategories;

        public GrapeAwareGroovyClassLoader(ClassLoader parent, CompilerConfiguration config) {
            super(null, parent, config);
        }

        private GrapeAwareGroovyClassLoader(IProject project, ClassLoader parent, CompilerConfiguration config) {
            super(project, parent, config);
        }

        public void addURL(URL url) {
            super.addURL(url);
            this.grabbed = true;
            this.defaultCategories = null;
            this.defaultStaticCategories = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<Class> getDefaultCategories() {
            if (this.defaultCategories == null) {
                GrapeAwareGroovyClassLoader grapeAwareGroovyClassLoader = this;
                synchronized (grapeAwareGroovyClassLoader) {
                    block8: {
                        if (this.defaultCategories == null) {
                            LinkedHashSet<Class> objectCategories = new LinkedHashSet<Class>();
                            LinkedHashSet<Class> staticCategories = new LinkedHashSet<Class>();
                            try {
                                Class dgm = this.loadFromClasspathOrTools("org.codehaus.groovy.runtime.DefaultGroovyMethods");
                                Class dgsm = this.loadFromClasspathOrTools("org.codehaus.groovy.runtime.DefaultGroovyStaticMethods");
                                Collections.addAll(objectCategories, (Class[])dgm.getField("DGM_LIKE_CLASSES").get(dgm));
                                Collections.addAll(objectCategories, (Class[])dgm.getField("ADDITIONAL_CLASSES").get(dgm));
                                Class vmpf = this.loadFromClasspathOrTools("org.codehaus.groovy.vmplugin.VMPluginFactory");
                                Object vmp = vmpf.getMethod("getPlugin", new Class[0]).invoke((Object)vmpf, new Object[0]);
                                Collections.addAll(objectCategories, (Class[])vmp.getClass().getMethod("getPluginDefaultGroovyMethods", new Class[0]).invoke(vmp, new Object[0]));
                                Collections.addAll(staticCategories, (Class[])vmp.getClass().getMethod("getPluginStaticGroovyMethods", new Class[0]).invoke(vmp, new Object[0]));
                                if (dgm.getClassLoader() != CompilerConfiguration.class.getClassLoader()) {
                                    new ExtensionModuleScanner(module -> {
                                        if (module instanceof SimpleExtensionModule) {
                                            objectCategories.addAll(((SimpleExtensionModule)module).getInstanceMethodsExtensionClasses());
                                            staticCategories.addAll(((SimpleExtensionModule)module).getStaticMethodsExtensionClasses());
                                        }
                                    }, (ClassLoader)((Object)this)).scanClasspathModules();
                                }
                                Predicate<Class> loads = c -> {
                                    try {
                                        c.getDeclaredFields();
                                        return true;
                                    }
                                    catch (LinkageError e) {
                                        if (GroovyLogManager.manager.hasLoggers()) {
                                            GroovyLogManager.manager.log(TraceCategory.CLASSPATH, "Failed to init " + c + " with " + (Object)((Object)this) + "\n\t" + e.getMessage());
                                        }
                                        return false;
                                    }
                                };
                                staticCategories.add(dgsm);
                                staticCategories.removeIf(loads.negate());
                                objectCategories.addAll(staticCategories);
                                objectCategories.removeIf(loads.negate());
                                this.defaultCategories = objectCategories;
                                this.defaultStaticCategories = staticCategories;
                            }
                            catch (LinkageError | ReflectiveOperationException e) {
                                this.defaultCategories = Collections.EMPTY_SET;
                                this.defaultStaticCategories = Collections.EMPTY_SET;
                                if (!GroovyLogManager.manager.hasLoggers()) break block8;
                                GroovyLogManager.manager.log(TraceCategory.CLASSPATH, "Failed to find Default Groovy Methods with " + (Object)((Object)this) + "\n\t" + e.getMessage());
                            }
                        }
                    }
                }
            }
            return Collections.unmodifiableSet(this.defaultCategories);
        }

        public boolean isDefaultStaticCategory(String name) {
            if (this.defaultStaticCategories == null) {
                this.getDefaultCategories();
            }
            return this.defaultStaticCategories.stream().map(Class::getName).anyMatch(name::equals);
        }

        private Class loadFromClasspathOrTools(String name) throws ClassNotFoundException {
            try {
                return this.loadClass(name, false, true, false);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                if (name.startsWith("org.codehaus.groovy.runtime.") || name.startsWith("org.codehaus.groovy.vmplugin.")) {
                    return CompilerConfiguration.class.getClassLoader().loadClass(name);
                }
                throw e;
            }
        }
    }
}

