/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.core;

import java.util.function.Predicate;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;

public class GroovyPropertyTester
extends PropertyTester {
    private static final Predicate<MethodNode> JAVA_MAIN = mn -> mn.isPublic() && mn.isStatic() && mn.isVoidMethod() && GroovyPropertyTester.oneStringArray(mn.getParameters());
    private static final Predicate<MethodNode> JEP_445_MAIN = mn -> !(mn.isPrivate() || !mn.isVoidMethod() && !mn.getReturnType().equals((Object)ClassHelper.OBJECT_TYPE) || mn.getParameters().length != 0 && !GroovyPropertyTester.oneObject(mn.getParameters()) && !GroovyPropertyTester.oneStringArray(mn.getParameters()));

    private static boolean oneObject(Parameter[] p) {
        return p.length == 1 && !p[0].getType().isGenericsPlaceHolder() && p[0].getType().equals((Object)ClassHelper.OBJECT_TYPE);
    }

    private static boolean oneStringArray(Parameter[] p) {
        return p.length == 1 && p[0].getType().isArray() && p[0].getType().getComponentType().equals((Object)ClassHelper.STRING_TYPE);
    }

    public boolean test(Object receiver, String property, Object[] arguments, Object expectedValue) {
        block10: {
            ModuleNode node = (ModuleNode)Adapters.adapt((Object)receiver, ModuleNode.class);
            if (node == null || node.encounteredUnrecoverableError()) break block10;
            switch (property) {
                case "hasMain": {
                    return node.getClasses().stream().flatMap(cn -> cn.getDeclaredMethods("main").stream()).anyMatch(JAVA_MAIN);
                }
                case "isScript": {
                    return !node.getStatementBlock().isEmpty() || !node.getClasses().isEmpty() && ((ClassNode)node.getClasses().get(0)).getNameEnd() < 1 && GroovyUtils.getGroovyVersion().getMajor() >= 5 && ((ClassNode)node.getClasses().get(0)).getDeclaredMethods("main").stream().anyMatch(JEP_445_MAIN.and(JAVA_MAIN.negate()));
                }
            }
        }
        return false;
    }
}

