/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.reflection.ParameterTypes;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.search.AccessorSupport;
import org.eclipse.jdt.groovy.search.GenericsMapper;
import org.eclipse.jdt.groovy.search.ITypeLookup;
import org.eclipse.jdt.groovy.search.SimpleTypeLookup;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;

public class CategoryTypeLookup
implements ITypeLookup {
    @Override
    public TypeLookupResult lookupType(Expression node, VariableScope scope, ClassNode objectExpressionType) {
        if (node instanceof VariableExpression || CategoryTypeLookup.isCompatibleConstantExpression(node, scope, objectExpressionType)) {
            String simpleName = node.getText();
            ClassNode selfType = GroovyUtils.getWrapperTypeIfPrimitive(objectExpressionType != null ? objectExpressionType : scope.getDelegateOrThis());
            boolean isMethodPointer = scope.getEnclosingNode() instanceof MethodPointerExpression;
            ArrayList<MethodNode> candidates = new ArrayList<MethodNode>();
            if (isMethodPointer || scope.isMethodCall() && scope.getWormhole().get("lhs") != node) {
                for (ClassNode category : scope.getCategoryNames()) {
                    for (MethodNode method : category.getDeclaredMethods(simpleName)) {
                        if (!CategoryTypeLookup.isCompatibleCategoryMethod(method, selfType, scope)) continue;
                        candidates.add(method);
                    }
                }
            }
            if (!isMethodPointer) {
                AccessorSupport[] accessorSupportArray = AccessorSupport.values();
                int method = accessorSupportArray.length;
                int n = 0;
                while (n < method) {
                    AccessorSupport kind = accessorSupportArray[n];
                    String methodName = kind.createAccessorName(simpleName);
                    if (methodName != null) {
                        for (ClassNode classNode : scope.getCategoryNames()) {
                            for (MethodNode method2 : classNode.getDeclaredMethods(methodName)) {
                                if (!kind.isAccessorKind(method2, true) || !CategoryTypeLookup.isCompatibleCategoryMethod(method2, selfType, scope) || kind == AccessorSupport.ISSER && !CategoryTypeLookup.isDefaultGroovyMethod(method2, scope) && GroovyUtils.getGroovyVersion().getMajor() <= 3) continue;
                                candidates.add(method2);
                            }
                        }
                    }
                    ++n;
                }
            }
            if (!candidates.isEmpty()) {
                MethodNode method;
                int args = 1 + scope.getMethodCallNumberOfArguments();
                ArrayList<ClassNode> argumentTypes = new ArrayList<ClassNode>(args);
                argumentTypes.add(selfType);
                if (args > 1) {
                    argumentTypes.addAll(scope.getMethodCallArgumentTypes());
                }
                if ((method = CategoryTypeLookup.selectBestMatch(candidates, argumentTypes, scope)) != null) {
                    ClassNode returnType = method.getReturnType();
                    if ("getAt".equals(simpleName) && VariableScope.OBJECT_CLASS_NODE.equals((Object)returnType) && GeneralUtils.isOrImplements((ClassNode)selfType, (ClassNode)VariableScope.MAP_CLASS_NODE)) {
                        for (ClassNode face : GroovyUtils.getAllInterfaces(selfType)) {
                            if (!VariableScope.MAP_CLASS_NODE.equals((Object)face)) continue;
                            GenericsType[] generics = GroovyUtils.getGenericsTypes(face);
                            if (generics.length != 2) break;
                            returnType = generics[1].getType();
                            break;
                        }
                    }
                    TypeLookupResult.TypeConfidence confidence = TypeLookupResult.TypeConfidence.INFERRED;
                    if (CategoryTypeLookup.isDefaultGroovyMethod(method, scope) || !method.getName().equals(simpleName) && method.getName().startsWith("get") && scope.isMethodCall()) {
                        confidence = TypeLookupResult.TypeConfidence.LOOSELY_INFERRED;
                    }
                    TypeLookupResult typeLookupResult = new TypeLookupResult(returnType, method.getDeclaringClass(), (ASTNode)method, confidence, scope);
                    typeLookupResult.isGroovy = true;
                    return typeLookupResult;
                }
            }
        }
        return null;
    }

    private static boolean isCompatibleConstantExpression(Expression node, VariableScope scope, ClassNode selfType) {
        ASTNode enclosingNode;
        if (!(!(node instanceof ConstantExpression) || scope.isTopLevel() || VariableScope.VOID_CLASS_NODE.equals((Object)selfType) || (enclosingNode = scope.getEnclosingNode()) instanceof AttributeExpression || enclosingNode instanceof MethodPointerExpression && VariableScope.CLASS_CLASS_NODE.equals((Object)selfType) && GroovyUtils.getGroovyVersion().getMajor() < 3)) {
            return VariableScope.STRING_CLASS_NODE.equals((Object)node.getType()) && node.getLength() <= node.getText().length();
        }
        return false;
    }

    private static boolean isCompatibleCategoryMethod(MethodNode method, ClassNode firstArgumentType, VariableScope scope) {
        Parameter[] parameters;
        if (method.isPublic() && method.isStatic() && (parameters = method.getParameters()) != null && parameters.length > 0) {
            ClassNode firstParamType = parameters[0].getType();
            if (StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType((ClassNode)firstArgumentType) && !VariableScope.CLASS_CLASS_NODE.equals((Object)firstParamType) && (CategoryTypeLookup.isDefaultGroovyStaticMethod(method, scope) || SimpleTypeLookup.isStaticReferenceToInstanceMethod(scope))) {
                firstParamType = VariableScope.newClassClassNode(firstParamType);
            }
            if (CategoryTypeLookup.isSelfTypeCompatible(firstArgumentType, firstParamType)) {
                if (CategoryTypeLookup.isDefaultGroovyMethod(method, scope)) {
                    if (GroovyUtils.isDeprecated((ASTNode)method)) {
                        return false;
                    }
                    if (scope.getEnclosingNode() instanceof MethodPointerExpression) {
                        ClassNode selfType;
                        ClassNode classNode = selfType = StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType((ClassNode)firstArgumentType) ? VariableScope.getFirstGenerics(firstArgumentType) : firstArgumentType;
                        if (!selfType.equals((Object)parameters[0].getType()) && !selfType.getMethods(method.getName()).isEmpty()) {
                            return false;
                        }
                        if (VariableScope.CLASS_CLASS_NODE.equals((Object)parameters[0].getType()) && StaticTypeCheckingSupport.isClassClassNodeWrappingConcreteType((ClassNode)firstArgumentType) && GroovyUtils.getGroovyVersion().getMajor() < 4) {
                            return false;
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isSelfTypeCompatible(ClassNode source, ClassNode target) {
        if (!Boolean.FALSE.equals(SimpleTypeLookup.isTypeCompatible(source, target))) {
            ClassNode targetGT;
            if (!VariableScope.CLASS_CLASS_NODE.equals((Object)source) || !source.isUsingGenerics() || VariableScope.OBJECT_CLASS_NODE.equals((Object)target) || !target.isUsingGenerics()) {
                return true;
            }
            ClassNode sourceGT = VariableScope.getFirstGenerics(source);
            if (sourceGT.equals((Object)(targetGT = VariableScope.getFirstGenerics(target))) || GroovyUtils.isAssignable(sourceGT, targetGT)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isDefaultGroovyMethod(MethodNode method, VariableScope scope) {
        return VariableScope.DGM_CLASS_NODE.equals((Object)method.getDeclaringClass()) || scope.isDefaultCategory(method.getDeclaringClass());
    }

    private static boolean isDefaultGroovyStaticMethod(MethodNode method, VariableScope scope) {
        return VariableScope.DGSM_CLASS_NODE.equals((Object)method.getDeclaringClass()) || scope.isDefaultStaticCategory(method.getDeclaringClass());
    }

    private static MethodNode selectBestMatch(List<MethodNode> candidates, List<ClassNode> argumentTypes, VariableScope scope) {
        Function<MethodNode, List> argsWithSelfTypeFix = !VariableScope.CLASS_CLASS_NODE.equals((Object)argumentTypes.get(0)) ? x -> argumentTypes : m -> {
            if (CategoryTypeLookup.isDefaultGroovyStaticMethod(m, scope)) {
                ArrayList<ClassNode> adjusted = new ArrayList<ClassNode>(argumentTypes);
                adjusted.set(0, VariableScope.getFirstGenerics((ClassNode)argumentTypes.get(0)));
                return adjusted;
            }
            return argumentTypes;
        };
        LinkedHashMap<String, MethodNode> m2 = new LinkedHashMap<String, MethodNode>();
        for (MethodNode candidate : candidates) {
            long d2;
            long d1;
            StringBuilder signature = new StringBuilder();
            Parameter[] parameters = candidate.getParameters();
            int i = 1;
            int n = parameters.length;
            while (i < n) {
                signature.append(parameters[i].getType().getName()).append(',');
                ++i;
            }
            MethodNode previous = m2.put(signature.toString(), candidate);
            if (previous == null || (d1 = CategoryTypeLookup.selfParameterDistance(argsWithSelfTypeFix.apply(previous), previous.getParameters())) > (d2 = CategoryTypeLookup.selfParameterDistance(argsWithSelfTypeFix.apply(candidate), candidate.getParameters()))) continue;
            m2.put(signature.toString(), previous);
        }
        if (scope.getEnclosingNode() instanceof MethodPointerExpression) {
            return (MethodNode)DefaultGroovyMethods.first(m2.values());
        }
        MethodNode method = null;
        for (MethodNode candidate : m2.values()) {
            long d2;
            long d1;
            int parameterCount;
            int argumentCount = argumentTypes.size();
            if (argumentCount != (parameterCount = candidate.getParameters().length) && (parameterCount <= 1 || argumentCount < parameterCount - 1 || !GenericsMapper.isVargs(candidate.getParameters()))) continue;
            Boolean compatible = SimpleTypeLookup.isTypeCompatible(argumentTypes.subList(1, argumentCount), (Parameter[])DefaultGroovyMethods.tail((Object[])candidate.getParameters()));
            if (compatible == Boolean.TRUE) {
                method = candidate;
                break;
            }
            if (compatible == Boolean.FALSE || method != null && (d1 = CategoryTypeLookup.tailParameterDistance(argumentTypes, method.getParameters())) <= (d2 = CategoryTypeLookup.tailParameterDistance(argumentTypes, candidate.getParameters()))) continue;
            method = candidate;
        }
        if (method == null && argumentTypes.size() == 1 && candidates.size() == 1 && candidates.get(0).getParameters().length == 2 && !ClassHelper.isPrimitiveType((ClassNode)candidates.get(0).getParameters()[1].getOriginType())) {
            method = candidates.get(0);
        }
        return method;
    }

    private static long selfParameterDistance(List<ClassNode> arguments, Parameter[] parameters) {
        try {
            Class[] a = new Class[]{arguments.get(0).getTypeClass()};
            Class[] p = new Class[]{parameters[0].getType().getTypeClass()};
            return MetaClassHelper.calculateParameterDistance((Class[])a, (ParameterTypes)new ParameterTypes(p));
        }
        catch (Throwable t) {
            return Long.MAX_VALUE - (long)(VariableScope.isVoidOrObject(parameters[0].getType()) ? 0 : 1);
        }
    }

    private static long tailParameterDistance(List<ClassNode> arguments, Parameter[] parameters) {
        try {
            int n = arguments.size() - 1;
            Class[] args = new Class[n];
            int i = 0;
            while (i < n) {
                args[i] = arguments.get(i + 1).getTypeClass();
                ++i;
            }
            n = parameters.length - 1;
            Class[] prms = new Class[n];
            int i2 = 0;
            while (i2 < n) {
                prms[i2] = parameters[i2 + 1].getType().getTypeClass();
                ++i2;
            }
            return MetaClassHelper.calculateParameterDistance((Class[])args, (ParameterTypes)new ParameterTypes(prms));
        }
        catch (Throwable t) {
            return Long.MAX_VALUE;
        }
    }
}

