/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.HashSet;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.jdt.groovy.model.GroovyClassFileWorkingCopy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.FieldDeclarationMatch;
import org.eclipse.jdt.core.search.FieldReferenceMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.search.EqualityVisitor;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.internal.core.search.matching.FieldPattern;
import org.eclipse.jdt.internal.core.search.matching.VariablePattern;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jface.text.Position;

public class FieldReferenceSearchRequestor
implements ITypeRequestor {
    protected final SearchRequestor requestor;
    protected final SearchParticipant participant;
    protected final String fieldName;
    protected final String declaringTypeName;
    protected final Set<Position> acceptedPositions = new HashSet<Position>();
    protected final boolean readAccess;
    protected final boolean writeAccess;
    protected final boolean findReferences;
    protected final boolean findDeclarations;

    public FieldReferenceSearchRequestor(FieldPattern pattern, SearchRequestor requestor, SearchParticipant participant) {
        this.requestor = requestor;
        this.participant = participant;
        char[] arr = (char[])ReflectionUtils.getPrivateField(VariablePattern.class, "name", pattern);
        this.fieldName = String.valueOf(arr);
        arr = (char[])ReflectionUtils.getPrivateField(FieldPattern.class, "declaringSimpleName", pattern);
        String declaringSimpleName = arr == null || arr.length == 0 ? "" : String.valueOf(arr);
        arr = (char[])ReflectionUtils.getPrivateField(FieldPattern.class, "declaringQualification", pattern);
        String declaringQualification = arr == null || arr.length == 0 ? "" : String.valueOf(String.valueOf(arr)) + ".";
        this.declaringTypeName = String.valueOf(declaringQualification) + declaringSimpleName;
        this.readAccess = (Boolean)ReflectionUtils.getPrivateField(VariablePattern.class, "readAccess", pattern);
        this.writeAccess = (Boolean)ReflectionUtils.getPrivateField(VariablePattern.class, "writeAccess", pattern);
        this.findReferences = (Boolean)ReflectionUtils.getPrivateField(VariablePattern.class, "findReferences", pattern);
        this.findDeclarations = (Boolean)ReflectionUtils.getPrivateField(VariablePattern.class, "findDeclarations", pattern);
    }

    @Override
    public ITypeRequestor.VisitStatus acceptASTNode(ASTNode node, TypeLookupResult result, IJavaElement enclosingElement) {
        boolean isCompleteMatch;
        Position position;
        if (result.declaringType == null) {
            return ITypeRequestor.VisitStatus.CONTINUE;
        }
        boolean doCheck = false;
        boolean isAssignment = false;
        boolean isDeclaration = node instanceof FieldNode;
        int start = 0;
        int end = 0;
        if (isDeclaration) {
            FieldNode fieldNode = (FieldNode)node;
            if (this.fieldName.equals(fieldNode.getName())) {
                doCheck = true;
                isAssignment = true;
                start = fieldNode.getNameStart();
                end = fieldNode.getNameEnd() + 1;
            }
        } else if (node instanceof FieldExpression) {
            if (this.fieldName.equals(((FieldExpression)node).getFieldName())) {
                doCheck = true;
                isAssignment = EqualityVisitor.checkForAssignment(node, result.enclosingAssignment);
                start = node.getEnd() - this.fieldName.length();
                end = node.getEnd();
            }
        } else if (node instanceof ConstantExpression) {
            if (this.fieldName.equals(((ConstantExpression)node).getText())) {
                ASTNode outer;
                ASTNode aSTNode = outer = result.scope.getCurrentNode() != node ? result.scope.getCurrentNode() : result.scope.getEnclosingNode();
                if (!(outer != null && outer.getNodeMetaData((Object)"static.import.alias") != null && (outer instanceof PropertyExpression && ((PropertyExpression)outer).getProperty() == node || outer instanceof MethodCallExpression && ((MethodCallExpression)outer).getMethod() == node))) {
                    MethodNode methodNode;
                    if (result.declaration instanceof FieldNode || result.declaration instanceof PropertyNode || result.confidence == TypeLookupResult.TypeConfidence.UNKNOWN) {
                        doCheck = true;
                        isAssignment = outer instanceof MapExpression ? ((MapExpression)outer).getMapEntryExpressions().stream().anyMatch(entry -> entry.getKeyExpression() == node) : EqualityVisitor.checkForAssignment(node, result.enclosingAssignment);
                    } else if (result.declaration instanceof MethodNode && (methodNode = (MethodNode)result.declaration).isSynthetic()) {
                        doCheck = true;
                        isAssignment = methodNode.getName().startsWith("set");
                    }
                }
                if (doCheck) {
                    start = node.getStart();
                    end = node.getEnd();
                }
            }
        } else if (node instanceof VariableExpression && this.fieldName.equals(((VariableExpression)node).getName())) {
            MethodNode methodNode;
            if (result.declaration instanceof FieldNode || result.declaration instanceof PropertyNode) {
                doCheck = true;
                isAssignment = EqualityVisitor.checkForAssignment(node, result.enclosingAssignment);
            } else if (result.declaration instanceof MethodNode && (methodNode = (MethodNode)result.declaration).isSynthetic()) {
                doCheck = true;
                isAssignment = methodNode.getName().startsWith("set");
            }
            if (doCheck) {
                start = node.getStart();
                end = node.getEnd();
            }
        }
        if (doCheck && end > 0 && !this.acceptedPositions.contains(position = new Position(start, end - start)) && (isCompleteMatch = this.qualifiedNameMatches(GroovyUtils.getBaseType(result.declaringType))) && (!(isAssignment ? !this.writeAccess : !this.readAccess) || isDeclaration && this.findDeclarations)) {
            FieldDeclarationMatch match = null;
            if (enclosingElement.getOpenable() instanceof GroovyClassFileWorkingCopy) {
                enclosingElement = ((GroovyClassFileWorkingCopy)enclosingElement.getOpenable()).convertToBinary(enclosingElement);
            }
            if (isDeclaration && this.findDeclarations) {
                match = new FieldDeclarationMatch(enclosingElement, this.getAccuracy(result.confidence, isCompleteMatch), start, end - start, this.participant, enclosingElement.getResource());
            } else if (!isDeclaration && this.findReferences) {
                match = new FieldReferenceMatch(enclosingElement, this.getAccuracy(result.confidence, isCompleteMatch), start, end - start, !isAssignment, isAssignment, false, this.participant, enclosingElement.getResource());
            }
            if (match != null) {
                try {
                    this.requestor.acceptSearchMatch(match);
                    this.acceptedPositions.add(position);
                }
                catch (CoreException e) {
                    Util.log((Throwable)e, (String)("Error reporting search match inside of " + enclosingElement + " in resource " + enclosingElement.getResource()));
                }
            }
        }
        return ITypeRequestor.VisitStatus.CONTINUE;
    }

    private boolean qualifiedNameMatches(ClassNode declaringType) {
        if (declaringType == null) {
            return false;
        }
        if (this.declaringTypeName.isEmpty()) {
            return true;
        }
        return declaringType.getName().replace('$', '.').equals(this.declaringTypeName);
    }

    private int getAccuracy(TypeLookupResult.TypeConfidence confidence, boolean isCompleteMatch) {
        if (isCompleteMatch && confidence.isAtLeast(TypeLookupResult.TypeConfidence.INFERRED)) {
            return 0;
        }
        return 1;
    }
}

