/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testops.service;

import com.kms.katalon.composer.testops.service.AnalyticsSettingStore;
import com.kms.katalon.session.core.model.Organization;
import com.kms.katalon.session.core.model.Project;
import com.kms.katalon.testops.core.model.AnalyticsAuthenticationSetting;
import com.kms.katalon.testops.core.model.AnalyticsIntegrationSetting;
import com.kms.katalon.testops.core.model.AnalyticsProject;
import com.kms.katalon.testops.core.model.AnalyticsSetting;
import com.kms.katalon.testops.core.model.AnalyticsTeam;
import com.kms.katalon.testops.core.model.exception.TestOpsPreferencesException;
import com.kms.katalon.testops.core.services.ITestOpsPreferences;
import jakarta.inject.Singleton;
import java.util.List;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class TestOpsPreferences
implements ITestOpsPreferences {
    public AnalyticsSetting getSetting() throws TestOpsPreferencesException {
        AnalyticsSetting setting = new AnalyticsSetting();
        AnalyticsSettingStore store = AnalyticsSettingStore.getStore();
        if (store == null) {
            return setting;
        }
        try {
            boolean enableIntegration;
            boolean overrideAuthentication = store.isOverrideAuthenticationEnabled();
            if (overrideAuthentication) {
                String email = store.getEmail();
                String password = store.getPassword();
                Organization organization = store.getOrganization();
                String serverUrl = store.getServerEndpoint();
                AnalyticsAuthenticationSetting authentication = new AnalyticsAuthenticationSetting();
                authentication.setServerUrl(serverUrl);
                authentication.setEmail(email);
                authentication.setPassword(password);
                authentication.setOrganization(organization);
                setting.setAuthentication(authentication);
            }
            if (enableIntegration = store.isIntegrationEnabled()) {
                AnalyticsProject toProject = store.getProject();
                boolean testCloudIntegration = store.isTestCloudIntegrationEnabled();
                boolean autoUploadReports = store.isAutoUploadReportEnabled();
                boolean switchToTestCloudHub = store.isSwitchToTestCloudHubEnabled();
                boolean isAutoSubmit = store.isAutoSubmit();
                Project project = new Project();
                project.setId(toProject.getId());
                project.setName(toProject.getName());
                project.setOrganizationId(toProject.getOrganizationId());
                project.setTeamId(toProject.getTeamId());
                AnalyticsIntegrationSetting integration = new AnalyticsIntegrationSetting();
                integration.setProject(project);
                integration.setEnabledTestCloudIntegration(testCloudIntegration);
                integration.setAutoUploadReports(autoUploadReports || isAutoSubmit);
                integration.setEnableSwitchToTestCloudHub(switchToTestCloudHub);
                setting.setIntegration(integration);
            }
        }
        catch (Exception e) {
            throw new TestOpsPreferencesException((Throwable)e);
        }
        return setting;
    }

    public void saveSetting(AnalyticsSetting setting) throws TestOpsPreferencesException {
        AnalyticsSettingStore store = AnalyticsSettingStore.getStore();
        if (store == null) {
            return;
        }
        try {
            AnalyticsAuthenticationSetting authentication = setting.getAuthentication();
            store.enableOverrideAuthentication(authentication != null);
            if (authentication != null) {
                store.setEmail(authentication.getEmail());
                store.setPassword(authentication.getPassword());
                store.setOrganization(authentication.getOrganization());
                store.setServerEndPoint(authentication.getServerUrl());
            } else {
                store.removeProperties(List.of("onpremise.email", "onpremise.password", "analytics.onpremise.organization", "analytics.onpremise.server"));
            }
            AnalyticsIntegrationSetting integration = setting.getIntegration();
            store.enableIntegration(integration != null);
            if (integration != null) {
                AnalyticsProject project = new AnalyticsProject();
                project.setId(integration.getProject().getId());
                project.setName(integration.getProject().getName());
                project.setOrganizationId(integration.getProject().getOrganizationId());
                project.setTeamId(integration.getProject().getTeamId());
                store.setProject(project);
                AnalyticsTeam team = new AnalyticsTeam();
                team.setId(integration.getProject().getTeamId());
                store.setTeam(team);
                store.enableTestCloudIntegration(integration.isEnabledTestCloudIntegration());
                store.enableAutoUploadReport(integration.isAutoUploadReports());
                store.enableSwitchToTestCloudHub(integration.isEnableSwitchToTestCloudHub());
                store.removeProperties(List.of("analytics.testresult.autosubmit"));
            } else {
                store.removeProperties(List.of("analytics.project", "analytics.team", "analytics.testcloud.integration.enable", "analytics.testresult.autosubmit", "analytics.testreport.autoupload.enable", "analytics.testcloud.hub.switchHub.enable"));
            }
        }
        catch (Exception e) {
            throw new TestOpsPreferencesException((Throwable)e);
        }
    }
}

