/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.webui.driver;

import com.kms.katalon.configuration.core.interfaces.IDriverConnector;
import com.kms.katalon.core.driver.IDriverType;
import com.kms.katalon.execution.webui.driver.WebUiDriverConnector;
import java.io.IOException;
import java.util.Map;

public abstract class RemoteDebugDriverConnector
extends WebUiDriverConnector {
    protected String debugPort;
    protected String debugHost;

    public RemoteDebugDriverConnector(String configurationFolderPath) throws IOException {
        super(configurationFolderPath);
        if (this.debugHost == null || this.debugHost.isEmpty()) {
            this.debugHost = "localhost";
        }
    }

    public abstract IDriverType getDriverType();

    public Map<String, Object> getUserConfigProperties() {
        return super.getUserConfigProperties();
    }

    public String getDebugPort() {
        return this.debugPort;
    }

    public void setDebugPort(String debugPort) {
        this.debugPort = debugPort;
    }

    public String getDebugHost() {
        return this.debugHost;
    }

    public void setDebugHost(String debugHost) {
        this.debugHost = debugHost;
    }

    protected void loadDriverProperties() throws IOException {
        super.loadDriverProperties();
        this.debugPort = this.driverProperties.get("debugPort") == null ? "" : String.valueOf(this.driverProperties.get("debugPort"));
        this.debugHost = this.driverProperties.get("debugHost") == null ? "" : String.valueOf(this.driverProperties.get("debugHost"));
        this.driverProperties.remove("debugPort");
        this.driverProperties.remove("debugHost");
    }

    public void saveUserConfigProperties() throws IOException {
        this.driverProperties.put("debugPort", this.debugPort);
        this.driverProperties.put("debugHost", this.debugHost);
        super.saveUserConfigProperties();
    }

    public IDriverConnector clone() {
        RemoteDebugDriverConnector driverConnector = this.createDriver();
        if (driverConnector != null) {
            driverConnector.setDebugPort(this.getDebugPort());
            driverConnector.setDebugHost(this.getDebugHost());
            driverConnector.driverProperties = (Map)this.cloneDriverPropertyValue(this.getUserConfigProperties());
        }
        return driverConnector;
    }

    public Map<String, Object> getSystemProperties() {
        Map propertyMap = super.getSystemProperties();
        propertyMap.put("debugHost", this.debugHost);
        propertyMap.put("debugPort", this.debugPort);
        return propertyMap;
    }

    protected abstract RemoteDebugDriverConnector createDriver();
}

