/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.webui.keyword;

import com.kms.katalon.configuration.core.interfaces.IDriverConnector;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.keyword.IActionProvider;
import com.kms.katalon.core.keyword.ICustomProfile;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.configuration.CustomRunConfiguration;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.execution.webui.keyword.CustomKeywordRunConfigurationCollector;
import com.kms.katalon.execution.webui.util.WebUIExecutionUtil;
import com.kms.katalon.logging.LogUtil;
import java.io.IOException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ActionProviderImpl
implements IActionProvider {
    private static String SAVE_CUSTOM_PROFILE_TITLE = "Save Custom Profile status";

    public void saveCustomProfile(ICustomProfile customProfile) {
        String strPluginDriverType = customProfile.getWebDriverType();
        WebUIDriverType driverType = WebUIDriverType.fromStringValue((String)strPluginDriverType);
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        try {
            CustomRunConfiguration runConfig = new CustomRunConfiguration(projectEntity.getFolderLocation(), customProfile.getName());
            IDriverConnector driverConnector = WebUIExecutionUtil.getDriverConnector(driverType, runConfig.getConfigFolder().getAbsolutePath());
            driverConnector.setUserConfigProperties(customProfile.getDesiredCapabilities());
            runConfig.addDriverConnector(customProfile.getName(), driverConnector);
            runConfig.save();
            CustomKeywordRunConfigurationCollector.getInstance().addCustomKeywordRunConfiguration(runConfig);
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)SAVE_CUSTOM_PROFILE_TITLE, (String)"Custom profile is saved successfully");
        }
        catch (ExecutionException | IOException e) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)SAVE_CUSTOM_PROFILE_TITLE, (String)("Custom profile is not saved due to " + e.getMessage()));
            LogUtil.logError((Throwable)e);
        }
    }
}

