/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.webui.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.execution.webui.enums.BrowserType;
import com.kms.katalon.execution.webui.util.GeckodriverInfo;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.network.apache.services.ApacheHttpClient;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.HttpResponse;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.model.exception.HttpException;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import com.kms.katalon.preferences.eclipse.service.EclipseNetworkPreferences;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class BrowserUtil {
    private static final Pattern versionPattern = Pattern.compile("\\d+\\.\\d+\\.\\d+(\\.\\d+)?([-+][\\w.-]+)?", 2);
    private static final String[] CHROME_COMMANDS_WINDOWS = new String[]{"cmd.exe /C wmic datafile where name=\"%PROGRAMFILES:\\=\\\\%\\\\Google\\\\Chrome\\\\Application\\\\chrome.exe\" get Version /value", "cmd.exe /C wmic datafile where name=\"%PROGRAMFILES(X86):\\=\\\\%\\\\Google\\\\Chrome\\\\Application\\\\chrome.exe\" get Version /value", "cmd.exe /C wmic datafile where name=\"%LOCALAPPDATA:\\=\\\\%\\\\Google\\\\Chrome\\\\Application\\\\chrome.exe\" get Version /value", "REG QUERY HKCU\\Software\\Google\\Chrome\\BLBeacon /v version", "powershell.exe -Command (Get-Item \"${env:LOCALAPPDATA}\\Google\\Chrome\\Application\\chrome.exe\").VersionInfo.ProductVersion", "powershell.exe -Command (Get-Item \"${env:PROGRAMFILES(X86)}\\Google\\Chrome\\Application\\chrome.exe\").VersionInfo.ProductVersion", "powershell.exe -Command (Get-Item \"${env:PROGRAMFILES}\\Google\\Chrome\\Application\\chrome.exe\").VersionInfo.ProductVersion"};
    private static final String[] CHROME_COMMANDS_LINUX = new String[]{"/usr/bin/google-chrome --version", "google-chrome --version"};
    private static final String[] CHROME_COMMANDS_MAC = new String[]{"/Applications/Google\\ Chrome.app/Contents/MacOS/Google\\ Chrome --version"};
    private static final String[] FIREFOX_COMMANDS_WINDOWS = new String[]{"cmd.exe /C wmic datafile where name=\"%PROGRAMFILES:\\=\\\\%\\\\Mozilla Firefox\\\\firefox.exe\" get Version /value", "cmd.exe /C wmic datafile where name=\"%PROGRAMFILES(X86):\\=\\\\%\\\\Mozilla Firefox\\\\firefox.exe\" get Version /value", "REG QUERY \"HKCU\\Software\\Mozilla\\Mozilla Firefox\" /v CurrentVersion", "powershell.exe -Command (Get-Item \"${env:PROGRAMFILES(X86)}\\Mozill~1\\firefox.exe\").VersionInfo.ProductVersion", "powershell.exe -Command (Get-Item \"${env:PROGRAMFILES}\\Mozill~1\\firefox.exe\").VersionInfo.ProductVersion"};
    private static final String[] FIREFOX_COMMANDS_LINUX = new String[]{"/usr/bin/firefox -v", "firefox -v", "snap list firefox"};
    private static final String[] FIREFOX_COMMANDS_MAC = new String[]{"/Applications/Firefox.app/Contents/MacOS/firefox -v"};
    private static final String[] EDGE_COMMANDS_WINDOWS = new String[]{"cmd.exe /C wmic datafile where name=\"%PROGRAMFILES(X86):\\=\\\\%\\\\Microsoft\\\\Edge\\\\Application\\\\msedge.exe\" get Version /value", "cmd.exe /C wmic datafile where name=\"%PROGRAMFILES:\\=\\\\%\\\\Microsoft\\\\Edge\\\\Application\\\\msedge.exe\" get Version /value", "REG QUERY HKCU\\Software\\Microsoft\\Edge\\BLBeacon /v version", "powershell.exe -Command (Get-Item \"${env:PROGRAMFILES}\\Microsoft\\Edge\\Application\\msedge.exe\").VersionInfo.ProductVersion", "powershell.exe -Command (Get-Item \"${env:PROGRAMFILES(X86)}\\Microsoft\\Edge\\Application\\msedge.exe\").VersionInfo.ProductVersion"};
    private static final String[] EDGE_COMMANDS_LINUX = new String[]{"/usr/bin/microsoft-edge --version", "microsoft-edge --version"};
    private static final String[] EDGE_COMMANDS_MAC = new String[]{"/Applications/Microsoft\\ Edge.app/Contents/MacOS/Microsoft\\ Edge -version"};

    public static String getBrowserVersion(BrowserType browserType) {
        String[] commands;
        String[] stringArray = commands = (switch (browserType) {
            case BrowserType.CHROME -> {
                if (OSUtil.isWindows()) {
                    yield CHROME_COMMANDS_WINDOWS;
                }
                if (OSUtil.isMac()) {
                    yield CHROME_COMMANDS_MAC;
                }
                yield CHROME_COMMANDS_LINUX;
            }
            case BrowserType.FIREFOX -> {
                if (OSUtil.isWindows()) {
                    yield FIREFOX_COMMANDS_WINDOWS;
                }
                if (OSUtil.isMac()) {
                    yield FIREFOX_COMMANDS_MAC;
                }
                yield FIREFOX_COMMANDS_LINUX;
            }
            case BrowserType.EDGE_CHROMIUM -> {
                if (OSUtil.isWindows()) {
                    yield EDGE_COMMANDS_WINDOWS;
                }
                if (OSUtil.isMac()) {
                    yield EDGE_COMMANDS_MAC;
                }
                yield EDGE_COMMANDS_LINUX;
            }
            default -> throw new IncompatibleClassChangeError();
        });
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            String command = stringArray[n2];
            String result = BrowserUtil.executeCommand(command);
            if (result != null && !result.isEmpty()) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    private static String executeCommand(String command) {
        try {
            String line;
            Process process = null;
            process = OSUtil.isWindows() ? Runtime.getRuntime().exec(command) : Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", command});
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                Matcher matcher = versionPattern.matcher(line);
                if (!matcher.find()) continue;
                return BrowserUtil.extractVersion(line);
            }
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
        return null;
    }

    public static String getWebDriverVersion(String driverPath) {
        if (driverPath == null || driverPath.isEmpty()) {
            return null;
        }
        File driverFile = new File(driverPath);
        if (!driverFile.exists() || !driverFile.canExecute()) {
            return null;
        }
        try {
            String line;
            Process process = null;
            process = OSUtil.isWindows() ? Runtime.getRuntime().exec(new String[]{driverPath, "--version"}) : Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", "\"" + driverPath + "\" --version"});
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                Matcher matcher = versionPattern.matcher(line);
                if (!matcher.find()) continue;
                return BrowserUtil.extractVersion(line);
            }
        }
        catch (Exception e) {
            LogUtil.logError((String)e.getMessage());
        }
        return null;
    }

    public static String getLatestGeckodriverVersion() {
        IHttpClient httpClient = ApacheHttpClient.getInstance();
        INetworkPreferences networkPreferences = EclipseNetworkPreferences.getInstance();
        HashMap headers = new HashMap();
        ProxyConfig proxyConfig = networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).proxy(proxyConfig).build();
        try {
            HttpResponse response = httpClient.get(new URI("https://raw.githubusercontent.com/katalon-studio/katalon-studio/master/gecko-releases.json"), httpOptions);
            List drivers = (List)response.json((TypeReference)new TypeReference<List<GeckodriverInfo>>(){});
            if (drivers.size() > 0) {
                drivers = drivers.stream().sorted(Comparator.comparingInt(GeckodriverInfo::getId).reversed()).collect(Collectors.toList());
                GeckodriverInfo firstItem = (GeckodriverInfo)drivers.get(0);
                return BrowserUtil.extractVersion(firstItem.getVersion());
            }
        }
        catch (HttpException | URISyntaxException e) {
            LogUtil.logError((String)e.getMessage());
        }
        return null;
    }

    public static int getMajorVersion(String version) {
        try {
            return Integer.parseInt(version.split("\\.")[0]);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static int getMinorVersion(String version) {
        try {
            return Integer.parseInt(version.split("\\.")[1]);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private static String extractVersion(String text) {
        Matcher matcher = versionPattern.matcher(text);
        if (matcher.find()) {
            return matcher.group(0);
        }
        return null;
    }
}

