/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.actions;

import com.kms.katalon.composer.mobile.objectspy.actions.IMobileAction;
import com.kms.katalon.composer.mobile.objectspy.actions.MobileActionParam;
import com.kms.katalon.core.testobject.TestObject;
import java.util.ArrayList;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;

public class CustomMobileAction
implements IMobileAction {
    private String description;
    private String mappedKeywordClassName;
    private String mappedKeywordClassSimpleName;
    private String mappedKeywordMethod;
    protected MobileActionParam[] params;
    private boolean isUserInputAction = true;
    private boolean hasElement = false;

    public CustomMobileAction(MethodNode methodNode, String description) {
        this.mappedKeywordClassSimpleName = this.mappedKeywordClassName = methodNode.getDeclaringClass().getNameWithoutPackage();
        this.mappedKeywordMethod = methodNode.getName();
        this.description = description;
        ArrayList<MobileActionParam> paramList = new ArrayList<MobileActionParam>();
        boolean isTestObject = false;
        int i = 0;
        while (i < methodNode.getParameters().length) {
            Parameter parameter = methodNode.getParameters()[i];
            Class clazz = parameter.getType().getTypeClass();
            if (TestObject.class.getName().equals(clazz.getName())) {
                isTestObject = true;
            }
            paramList.add(new MobileActionParam(parameter.getName(), clazz));
            ++i;
        }
        this.params = paramList.toArray(new MobileActionParam[paramList.size()]);
        this.hasElement = isTestObject;
    }

    @Override
    public String getName() {
        return String.format("%s.'%s'", this.mappedKeywordClassName, this.mappedKeywordMethod);
    }

    @Override
    public String getReadableName() {
        return this.mappedKeywordMethod.substring(this.mappedKeywordMethod.lastIndexOf(46) + 1);
    }

    @Override
    public String getMappedKeywordClassSimpleName() {
        return this.mappedKeywordClassSimpleName;
    }

    @Override
    public String getMappedKeywordClassName() {
        return this.mappedKeywordClassName;
    }

    @Override
    public String getMappedKeywordMethod() {
        return this.mappedKeywordMethod;
    }

    @Override
    public boolean hasElement() {
        return this.hasElement;
    }

    @Override
    public boolean hasInput() {
        return this.isUserInputAction;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public MobileActionParam[] getParams() {
        return this.params;
    }

    @Override
    public void setParams(MobileActionParam[] params) {
        this.params = params;
    }
}

