/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.components;

import com.kms.katalon.composer.components.impl.dialogs.ProgressMonitorDialogWithThread;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.mobile.objectspy.actions.MobileAction;
import com.kms.katalon.composer.mobile.objectspy.actions.MobileActionMapping;
import com.kms.katalon.composer.mobile.objectspy.constant.ComposerMobileObjectspyMessageConstants;
import com.kms.katalon.composer.mobile.objectspy.dialog.AppiumMonitorDialog;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileAppDialog;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileInspectorController;
import com.kms.katalon.composer.mobile.objectspy.interfaces.IMobileInspectorController;
import com.kms.katalon.composer.mobile.objectspy.interfaces.MobileAppComposite;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.integration.kobiton.entity.KobitonApplication;
import com.kms.katalon.integration.kobiton.entity.KobitonDevice;
import com.kms.katalon.integration.kobiton.exceptions.KobitonApiException;
import com.kms.katalon.integration.kobiton.preferences.KobitonPreferencesProvider;
import com.kms.katalon.integration.kobiton.providers.KobitonApiProvider;
import com.kms.katalon.tracking.model.MobileDeviceOption;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class KobitonAppComposite
implements MobileAppComposite {
    private static final int START_WITH_APPLICATION_FILE = 0;
    private static final int START_WITH_APPLICATION_ID = 1;
    private Combo cbbKobitonDevices;
    private Combo cbbKobitonApps;
    private Combo cbbStartType;
    private MobileAppDialog parentDialog;
    private Button btnRefreshKobitonDevice;
    private List<KobitonDevice> kobitonDevices = new ArrayList<KobitonDevice>();
    private List<KobitonApplication> kobitonApps = new ArrayList<KobitonApplication>();
    private KobitonDevice selectDevice = null;
    private Link linkLabel;
    private Composite composite;
    private Text txtAppId;
    private Composite appComposite;
    private Composite appIdComposite;
    private StackLayout slAppComposite;
    Composite appFileChooserComposite;

    @Override
    public boolean isAbleToStart() {
        if (this.cbbKobitonDevices.getSelectionIndex() < 0) {
            return false;
        }
        switch (this.cbbStartType.getSelectionIndex()) {
            case 0: {
                return StringUtils.isNotBlank((CharSequence)this.getAppFile());
            }
            case 1: {
                return StringUtils.isNotBlank((CharSequence)this.txtAppId.getText());
            }
        }
        return false;
    }

    public List<String> getAllKobitonDevicesName() {
        ArrayList<String> devicesNameList = new ArrayList<String>();
        for (KobitonDevice kobitonDevice : this.kobitonDevices) {
            devicesNameList.add(kobitonDevice.getDisplayString());
        }
        return devicesNameList;
    }

    public void updateKobitonDeviceList() throws KobitonApiException {
        this.kobitonDevices.clear();
        this.kobitonDevices.addAll(KobitonApiProvider.getKobitonFavoriteDevices((String)KobitonPreferencesProvider.getKobitonServerUrl(), (String)KobitonPreferencesProvider.getKobitonToken()));
    }

    public List<String> getAllKobitonAppsName() {
        ArrayList<String> devicesNameList = new ArrayList<String>();
        for (KobitonApplication kobitonApp : this.kobitonApps) {
            devicesNameList.add(kobitonApp.getName() + ", appId=" + kobitonApp.buildAutomationKey());
        }
        return devicesNameList;
    }

    public void updateKobitonAppList() throws KobitonApiException {
        this.kobitonApps.clear();
        this.kobitonApps.addAll(KobitonApiProvider.getKobitonApplications((String)KobitonPreferencesProvider.getKobitonServerUrl(), (String)KobitonPreferencesProvider.getKobitonToken()));
    }

    public boolean validateKobitonAppSetting() {
        if (this.cbbKobitonDevices.getSelectionIndex() < 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)GlobalStringConstants.ERROR, (String)ComposerMobileObjectspyMessageConstants.DIA_ERROR_MSG_NO_KOBITON_DEVICES);
            return false;
        }
        if (this.cbbKobitonApps.getSelectionIndex() < 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)GlobalStringConstants.ERROR, (String)ComposerMobileObjectspyMessageConstants.DIA_ERROR_MSG_NO_KOBITON_APPS);
            return false;
        }
        return true;
    }

    private Shell getShell() {
        return this.composite.getShell();
    }

    public KobitonDevice getSelectedKobitonDevice() {
        if (this.cbbKobitonDevices == null || this.cbbKobitonDevices.isDisposed()) {
            return this.selectDevice;
        }
        int selectedDeviceIndex = this.cbbKobitonDevices.getSelectionIndex();
        if (selectedDeviceIndex < 0 || selectedDeviceIndex >= this.kobitonDevices.size()) {
            this.selectDevice = null;
            return this.selectDevice;
        }
        this.selectDevice = this.kobitonDevices.get(selectedDeviceIndex);
        return this.selectDevice;
    }

    public KobitonApplication getSelectedKobitonApplication() {
        int selectedAppIndex = this.cbbKobitonApps.getSelectionIndex();
        if (selectedAppIndex < 0 || selectedAppIndex >= this.kobitonApps.size()) {
            return null;
        }
        return this.kobitonApps.get(selectedAppIndex);
    }

    public boolean startKobitonApp(final IMobileInspectorController inspectorController, final ProgressMonitorDialogWithThread progressDlg) throws InvocationTargetException, InterruptedException {
        final KobitonDevice selectDevice = this.getSelectedKobitonDevice();
        if (selectDevice == null) {
            return false;
        }
        final String selectedApplication = this.getSelectedKobitonApplication().buildAutomationKey();
        final String appId = this.txtAppId.getText();
        final int startType = this.cbbStartType.getSelectionIndex();
        IRunnableWithProgress processToRun = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(ComposerMobileObjectspyMessageConstants.DIA_LBL_STATUS_APP_STARTING, -1);
                progressDlg.runAndWait((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        switch (startType) {
                            case 0: {
                                inspectorController.startMobileApp(selectDevice, selectedApplication);
                                break;
                            }
                            case 1: {
                                inspectorController.startMobileApp(selectDevice, appId);
                            }
                        }
                        return null;
                    }
                });
                KobitonAppComposite.this.checkMonitorCanceled(monitor);
                monitor.done();
            }
        };
        progressDlg.run(true, true, processToRun);
        return true;
    }

    private void checkMonitorCanceled(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException(ComposerMobileObjectspyMessageConstants.DIA_ERROR_MSG_OPERATION_CANCELED);
        }
    }

    @Override
    public String getAppName() {
        return this.cbbKobitonApps.getText();
    }

    private void updateKobitonDevices() throws InvocationTargetException, InterruptedException {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(ComposerMobileObjectspyMessageConstants.DIA_JOB_TASK_LOADING_DEVICES, -1);
                try {
                    KobitonAppComposite.this.updateKobitonDeviceList();
                }
                catch (KobitonApiException e) {
                    throw new InvocationTargetException(e);
                }
                final List<String> devices = KobitonAppComposite.this.getAllKobitonDevicesName();
                KobitonAppComposite.this.checkMonitorCanceled(monitor);
                UISynchronizeService.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!devices.isEmpty()) {
                            (this).KobitonAppComposite.this.cbbKobitonDevices.setItems(devices.toArray(new String[0]));
                            (this).KobitonAppComposite.this.cbbKobitonDevices.select(Math.max(0, devices.indexOf((this).KobitonAppComposite.this.cbbKobitonDevices.getText())));
                        }
                        KobitonAppComposite.this.setLinkLabelVisible(devices.isEmpty());
                    }
                });
                monitor.done();
            }
        };
        new ProgressMonitorDialogWithThread(Display.getDefault().getActiveShell()).run(true, true, runnable);
    }

    private void updateKobitonApps() throws InvocationTargetException, InterruptedException {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(ComposerMobileObjectspyMessageConstants.DIA_JOB_TASK_LOADING_KOBITON_APPS, -1);
                try {
                    KobitonAppComposite.this.updateKobitonAppList();
                }
                catch (KobitonApiException e) {
                    throw new InvocationTargetException(e);
                }
                final List<String> apps = KobitonAppComposite.this.getAllKobitonAppsName();
                KobitonAppComposite.this.checkMonitorCanceled(monitor);
                UISynchronizeService.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (apps.isEmpty()) {
                            return;
                        }
                        (this).KobitonAppComposite.this.cbbKobitonApps.setItems(apps.toArray(new String[0]));
                        (this).KobitonAppComposite.this.cbbKobitonApps.select(Math.max(0, apps.indexOf((this).KobitonAppComposite.this.cbbKobitonApps.getText())));
                    }
                });
                monitor.done();
            }
        };
        new ProgressMonitorDialogWithThread(Display.getDefault().getActiveShell()).run(true, true, runnable);
    }

    private void setLinkLabelVisible(boolean visible) {
        this.linkLabel.setVisible(visible);
        ((GridData)this.linkLabel.getLayoutData()).exclude = !visible;
        this.linkLabel.pack();
        this.linkLabel.getParent().layout(true, true);
    }

    @Override
    public Composite render(Composite parent, int type, final MobileAppDialog parentDialog) {
        this.parentDialog = parentDialog;
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.composite.setLayout((Layout)layout);
        Composite deviceNameCompposite = new Composite(this.composite, 0);
        GridLayout deviceNameComppositeLayout = new GridLayout(3, false);
        deviceNameComppositeLayout.marginHeight = 0;
        deviceNameComppositeLayout.marginWidth = 0;
        deviceNameCompposite.setLayout((Layout)deviceNameComppositeLayout);
        deviceNameCompposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblDeviceName = new Label(deviceNameCompposite, 0);
        lblDeviceName.setText(ComposerMobileObjectspyMessageConstants.DIA_LBL_DEVICE_NAME);
        GridData gdDeviceNameLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        lblDeviceName.setLayoutData((Object)gdDeviceNameLabel);
        this.cbbKobitonDevices = new Combo(deviceNameCompposite, 8);
        this.cbbKobitonDevices.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cbbKobitonDevices.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                parentDialog.refreshButtonsState();
            }
        });
        this.btnRefreshKobitonDevice = new Button(deviceNameCompposite, 8);
        this.btnRefreshKobitonDevice.setText(GlobalStringConstants.REFRESH);
        this.btnRefreshKobitonDevice.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                parentDialog.updateDeviceNames();
            }
        });
        Composite startTypeComposite = new Composite(this.composite, 0);
        GridLayout glStartTypeComposite = new GridLayout(2, false);
        glStartTypeComposite.marginHeight = 0;
        glStartTypeComposite.marginWidth = 0;
        startTypeComposite.setLayout((Layout)glStartTypeComposite);
        Label lblStartType = new Label(startTypeComposite, 0);
        GridData gdStartWithLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        lblStartType.setLayoutData((Object)gdStartWithLabel);
        lblStartType.setText(ComposerMobileObjectspyMessageConstants.DIA_LBL_START_WITH);
        this.cbbStartType = new Combo(startTypeComposite, 8);
        this.cbbStartType.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cbbStartType.setItems(new String[]{ComposerMobileObjectspyMessageConstants.DIA_LBL_APP_FILE, ComposerMobileObjectspyMessageConstants.DIA_LBL_APP_ID});
        this.cbbStartType.select(0);
        this.cbbStartType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                switch (KobitonAppComposite.this.cbbStartType.getSelectionIndex()) {
                    case 0: {
                        KobitonAppComposite.this.slAppComposite.topControl = KobitonAppComposite.this.appFileChooserComposite;
                        KobitonAppComposite.this.appComposite.layout();
                        parentDialog.refreshButtonsState();
                        break;
                    }
                    case 1: {
                        KobitonAppComposite.this.slAppComposite.topControl = KobitonAppComposite.this.appIdComposite;
                        KobitonAppComposite.this.appComposite.layout();
                        parentDialog.refreshButtonsState();
                    }
                }
            }
        });
        this.linkLabel = new Link(this.composite, 0);
        this.linkLabel.setText(ComposerMobileObjectspyMessageConstants.MSG_NO_DEVICES + " <a href=\"" + ComposerMobileObjectspyMessageConstants.NO_DEVICES_TROUBLESHOOTING_GUIDE_LINK + "\">" + ComposerMobileObjectspyMessageConstants.MSG_WRAPPED_NO_DEVICES_TROUBLESHOOTING_GUIDE + "</a>");
        this.linkLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)e.text);
            }
        });
        this.createAppSelectionComposite(gdDeviceNameLabel, gdStartWithLabel);
        return this.composite;
    }

    private void createAppSelectionComposite(final GridData gdDeviceNameLabel, final GridData gdStartWithLabel) {
        this.appComposite = new Composite(this.composite, 0);
        this.appComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.slAppComposite = new StackLayout();
        this.appComposite.setLayout((Layout)this.slAppComposite);
        this.appFileChooserComposite = new Composite(this.appComposite, 0);
        this.appFileChooserComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout glAppFileChooserComposite = new GridLayout(2, false);
        glAppFileChooserComposite.marginHeight = 0;
        glAppFileChooserComposite.marginWidth = 0;
        this.appFileChooserComposite.setLayout((Layout)glAppFileChooserComposite);
        final Label appFileLabel = new Label(this.appFileChooserComposite, 0);
        appFileLabel.setText(ComposerMobileObjectspyMessageConstants.DIA_LBL_APP_FILE);
        GridData gdAppFileLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        appFileLabel.setLayoutData((Object)gdAppFileLabel);
        this.cbbKobitonApps = new Combo(this.appFileChooserComposite, 8);
        this.cbbKobitonApps.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cbbKobitonApps.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KobitonAppComposite.this.parentDialog.refreshButtonsState();
            }
        });
        this.appIdComposite = new Composite(this.appComposite, 0);
        this.appIdComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout glAppIdComposite = new GridLayout(2, false);
        glAppIdComposite.marginHeight = OSUtil.isWindows() ? 1 : 2;
        glAppIdComposite.marginWidth = 0;
        this.appIdComposite.setLayout((Layout)glAppIdComposite);
        Label appIdLabel = new Label(this.appIdComposite, 0);
        appIdLabel.setText(ComposerMobileObjectspyMessageConstants.DIA_LBL_APP_ID);
        final GridData gdAppIdLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        appIdLabel.setLayoutData((Object)gdAppIdLabel);
        this.txtAppId = new Text(this.appIdComposite, 2048);
        final GridData gdAppId = new GridData(4, 0x1000000, true, false, 1, 1);
        this.txtAppId.setLayoutData((Object)gdAppId);
        this.txtAppId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                KobitonAppComposite.this.parentDialog.refreshButtonsState();
            }
        });
        this.txtAppId.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                gdAppId.widthHint = 150;
            }
        });
        appFileLabel.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                int appFileLabelWidth = appFileLabel.getBounds().width;
                if (appFileLabelWidth == 0) {
                    return;
                }
                gdDeviceNameLabel.widthHint = appFileLabelWidth;
                gdStartWithLabel.widthHint = appFileLabelWidth;
                gdAppIdLabel.widthHint = appFileLabelWidth;
                KobitonAppComposite.this.composite.layout(true, true);
            }
        });
        this.slAppComposite.topControl = this.appFileChooserComposite;
    }

    @Override
    public boolean validateSetting() {
        return this.validateKobitonAppSetting();
    }

    @Override
    public MobileDriverType getSelectedDriverType() {
        return MobileInspectorController.getMobileDriverType(this.selectDevice);
    }

    @Override
    public boolean startApp(IMobileInspectorController controller, AppiumMonitorDialog progressDialog) throws InvocationTargetException, InterruptedException {
        return this.startKobitonApp(controller, (ProgressMonitorDialogWithThread)progressDialog);
    }

    @Override
    public void setInput() throws InvocationTargetException, InterruptedException {
        this.loadDevices();
    }

    @Override
    public String getAppFile() {
        return this.kobitonApps.get(this.cbbKobitonApps.getSelectionIndex()).getName();
    }

    @Override
    public void loadDevices() throws InvocationTargetException, InterruptedException {
        this.updateKobitonDevices();
        this.updateKobitonApps();
    }

    @Override
    public MobileActionMapping buildStartAppActionMapping() {
        int startType = this.cbbStartType.getSelectionIndex();
        switch (startType) {
            case 0: {
                MobileActionMapping startAppAction = new MobileActionMapping(MobileAction.StartApplication, null);
                String appValue = this.kobitonApps.get(this.cbbKobitonApps.getSelectionIndex()).buildAutomationKey();
                startAppAction.getData()[0].setValue(new ConstantExpressionWrapper((Object)appValue));
                return startAppAction;
            }
            case 1: {
                MobileActionMapping startAppAction = new MobileActionMapping(MobileAction.StartExistingApplication, null);
                String appValue = this.txtAppId.getText();
                startAppAction.getData()[0].setValue(new ConstantExpressionWrapper((Object)appValue));
                return startAppAction;
            }
        }
        return null;
    }

    @Override
    public String getDialogConfigurationsLabel() {
        return ComposerMobileObjectspyMessageConstants.DIA_LBL_CONFIGURATIONS;
    }

    @Override
    public MobileDeviceOption getMobileDeviceOption() {
        return MobileDeviceOption.KOBITON_DEVICE;
    }
}

