/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.components;

import com.kms.katalon.composer.components.controls.HelpComposite;
import com.kms.katalon.composer.mobile.objectspy.actions.MobileAction;
import com.kms.katalon.composer.mobile.objectspy.actions.MobileActionMapping;
import com.kms.katalon.composer.mobile.objectspy.constant.ComposerMobileObjectspyMessageConstants;
import com.kms.katalon.composer.mobile.objectspy.dialog.AppiumMonitorDialog;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileAppDialog;
import com.kms.katalon.composer.mobile.objectspy.interfaces.IMobileInspectorController;
import com.kms.katalon.composer.mobile.objectspy.interfaces.MobileAppComposite;
import com.kms.katalon.composer.project.handlers.SettingHandler;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.execution.webui.configuration.RemoteWebRunConfiguration;
import com.kms.katalon.execution.webui.driver.RemoteWebDriverConnector;
import com.kms.katalon.tracking.model.MobileDeviceOption;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RemoteAppComposite
implements MobileAppComposite {
    private static final String CLOUD_APPLICATION_ID_DOCUMENT_URL = "https://docs.katalon.com/katalon-studio/manage-projects/set-up-projects/mobile-testing/mobile-app-testing-with-remote-devices#enter-a-cloud-application-id";
    protected IRunConfiguration runConfiguration;
    private Label lblConfigurationDetails;
    private Text txtApplicationId;
    private Button btnEditConfigurationDetails;
    private MobileAppDialog parentDialog;
    private String settingPage;

    public RemoteAppComposite() throws IOException {
        this((IRunConfiguration)new RemoteWebRunConfiguration(ProjectController.getInstance().getCurrentProject().getFolderLocation()));
    }

    public RemoteAppComposite(IRunConfiguration runConfiguration) {
        this.runConfiguration = runConfiguration;
        this.setSettingPage("com.katalon.composer.capability.settings.default.4");
    }

    public void setSettingPage(String settingPage) {
        this.settingPage = settingPage;
    }

    public String getSettingPage() {
        return this.settingPage;
    }

    @Override
    public Composite render(Composite parent, int type, MobileAppDialog parentDialog) {
        this.parentDialog = parentDialog;
        Composite container = new Composite(parent, type);
        GridLayout glContainer = new GridLayout(2, false);
        glContainer.horizontalSpacing = 15;
        container.setLayout((Layout)glContainer);
        Label lblConfigurationData = new Label(container, 0);
        lblConfigurationData.setText("Configuration");
        Composite compositeConfigurationData = new Composite(container, 0);
        compositeConfigurationData.setLayoutData((Object)new GridData(768));
        GridLayout glCompositeConfigurationData = new GridLayout(2, false);
        glCompositeConfigurationData.marginWidth = 0;
        glCompositeConfigurationData.marginHeight = 0;
        compositeConfigurationData.setLayout((Layout)glCompositeConfigurationData);
        this.lblConfigurationDetails = new Label(compositeConfigurationData, 0);
        this.lblConfigurationDetails.setLayoutData((Object)new GridData(768));
        this.btnEditConfigurationDetails = new Button(compositeConfigurationData, 8);
        this.btnEditConfigurationDetails.setText("Edit");
        Composite applicationIdComposite = new Composite(container, 0);
        GridLayout glApplicationId = new GridLayout(2, false);
        glApplicationId.marginWidth = 0;
        glApplicationId.marginRight = 0;
        applicationIdComposite.setLayout((Layout)glApplicationId);
        Label lblApplicationId = new Label(applicationIdComposite, 0);
        lblApplicationId.setText(ComposerMobileObjectspyMessageConstants.LBL_APPLICATION_ID);
        new HelpComposite(applicationIdComposite, CLOUD_APPLICATION_ID_DOCUMENT_URL);
        this.txtApplicationId = new Text(container, 2048);
        this.txtApplicationId.setLayoutData((Object)new GridData(768));
        return container;
    }

    @Override
    public boolean validateSetting() {
        return true;
    }

    @Override
    public MobileDriverType getSelectedDriverType() {
        if (this.runConfiguration == null || ((RemoteWebRunConfiguration)this.runConfiguration).getRemoteDriverConnector() == null) {
            return MobileDriverType.ANDROID_DRIVER;
        }
        return ((RemoteWebRunConfiguration)this.runConfiguration).getRemoteDriverConnector().getMobileDriverType();
    }

    @Override
    public boolean startApp(final IMobileInspectorController inspectorController, final AppiumMonitorDialog progressDialog) throws InvocationTargetException, InterruptedException {
        final String applicationId = this.txtApplicationId.getText();
        IRunnableWithProgress processToRun = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(ComposerMobileObjectspyMessageConstants.DIA_LBL_STATUS_APP_STARTING, -1);
                progressDialog.runAndWait(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        inspectorController.startMobileAppOnCloudDevices((RemoteWebRunConfiguration)(this).RemoteAppComposite.this.runConfiguration, applicationId);
                        return null;
                    }
                });
                RemoteAppComposite.this.checkMonitorCanceled(monitor);
                monitor.done();
            }
        };
        progressDialog.run(true, true, processToRun);
        return true;
    }

    private void checkMonitorCanceled(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException(ComposerMobileObjectspyMessageConstants.DIA_ERROR_MSG_OPERATION_CANCELED);
        }
    }

    @Override
    public void setInput() throws InvocationTargetException, InterruptedException {
        if (this.lblConfigurationDetails != null) {
            this.lblConfigurationDetails.setText(this.runConfiguration.getName());
        }
        this.btnEditConfigurationDetails.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SettingHandler settingHander = SettingHandler.getInstance();
                settingHander.openSettingsPage((Object)RemoteAppComposite.this.getSettingPage());
                if (RemoteAppComposite.this.lblConfigurationDetails != null) {
                    RemoteAppComposite.this.lblConfigurationDetails.setText(RemoteAppComposite.this.runConfiguration.getName());
                }
                if (RemoteAppComposite.this.parentDialog != null) {
                    RemoteAppComposite.this.parentDialog.refreshButtonsState();
                }
            }
        });
        this.txtApplicationId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RemoteAppComposite.this.parentDialog.refreshButtonsState();
                RemoteAppComposite.this.parentDialog.getPreferencesHelper().setLastRemoteAppId(RemoteAppComposite.this.txtApplicationId.getText());
            }
        });
        this.txtApplicationId.setText(StringUtils.defaultString((String)this.parentDialog.getPreferencesHelper().getLastRemoteAppId()));
    }

    @Override
    public String getAppFile() {
        return this.txtApplicationId.getText();
    }

    @Override
    public String getAppName() {
        return this.txtApplicationId.getText();
    }

    @Override
    public MobileActionMapping buildStartAppActionMapping() {
        MobileActionMapping startAppAction = new MobileActionMapping(MobileAction.StartApplication, null);
        String appValue = this.getAppFile();
        if (StringUtils.isEmpty((CharSequence)appValue)) {
            appValue = this.readAppValueFromRemoteDesiredCaps();
        }
        startAppAction.getData()[0].setValue(new ConstantExpressionWrapper((Object)appValue));
        return startAppAction;
    }

    @Override
    public boolean isAbleToStart() {
        return true;
    }

    @Override
    public void loadDevices() throws InvocationTargetException, InterruptedException {
    }

    private String readAppValueFromRemoteDesiredCaps() {
        String value = "";
        try {
            Object desiredCapValue;
            RemoteWebDriverConnector remoteDriverConnector = ((RemoteWebRunConfiguration)this.runConfiguration).getRemoteDriverConnector();
            if (remoteDriverConnector != null && (desiredCapValue = remoteDriverConnector.getUserConfigProperties().get("app")) != null) {
                value = (String)desiredCapValue;
            }
        }
        catch (NullPointerException nullPointerException) {}
        return value;
    }

    @Override
    public String getDialogConfigurationsLabel() {
        return ComposerMobileObjectspyMessageConstants.DIA_LBL_CONFIGURATIONS;
    }

    @Override
    public MobileDeviceOption getMobileDeviceOption() {
        return MobileDeviceOption.REMOTE_DEVICE;
    }
}

