/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.components;

import com.kms.katalon.composer.components.ComponentBundleActivator;
import com.kms.katalon.composer.components.controls.SelectableInformationComposite;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.mobile.objectspy.constant.ComposerMobileObjectspyMessageConstants;
import com.kms.katalon.composer.mobile.objectspy.interfaces.ITestCloudApplicationSelectorComposite;
import com.kms.katalon.composer.mobile.objectspy.viewmodel.TestCloudApplicationViewModel;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.discovery.core.model.ServerType;
import com.kms.katalon.discovery.core.services.IDiscoveryController;
import com.kms.katalon.testcloud.core.event.TestCloudUploadApplicationLinkSelected;
import com.kms.katalon.testcloud.core.model.TestCloudApplication;
import com.kms.katalon.testcloud.core.model.TestCloudMobilePlatformName;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

@Creatable
public class TestCloudApplicationSelectorComposite
implements ITestCloudApplicationSelectorComposite {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IDiscoveryController discoveryController;
    private String INFORMATION_MESSAGE = ComposerMobileObjectspyMessageConstants.TESTCLOUD_MOBILE_APPLICATION_INFORMATION + "\n<a href=\"" + ComposerMobileObjectspyMessageConstants.TESTCLOUD_MOBILE_APPLICATION_DOCUMENTATION_URL + "\">" + ComposerMobileObjectspyMessageConstants.TESTCLOUD_MOBILE_APPLICATION_DOCUMENTATION_ACTION_MESSAGE + "</a>.";
    private static final String TESTCLOUD_UPLOAD_APPLICATION_PATH_TEMPLATE = "/team/{0}/project/{1}/native-apps";
    private Combo applicationNameCombo;
    private Button btnRefresh;
    private Link uploadApplicationLink;
    private List<TestCloudApplicationViewModel> applicationList = new ArrayList<TestCloudApplicationViewModel>();
    private List<TestCloudApplication> testCloudApplications = new ArrayList<TestCloudApplication>();
    private TestCloudMobilePlatformName selectedPlatform = TestCloudMobilePlatformName.ANDROID;

    private void addListeners() {
        this.btnRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCloudApplicationSelectorComposite.this.eventBroker.send("ON_APPLICATION_REFRESH_BUTTON_PRESSED", null);
            }
        });
        this.uploadApplicationLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCloudApplicationSelectorComposite.this.onUploadApplicationLinkSelected(e);
            }
        });
    }

    private void onUploadApplicationLinkSelected(SelectionEvent e) {
        this.eventBroker.send("ON_UPLOAD_APPLICATION_LINK_SELECTED", (Object)new TestCloudUploadApplicationLinkSelected(e.text));
    }

    private void bindingApplication() {
        this.clearApplicationNameCombo();
        this.applicationNameCombo.setItems((String[])this.applicationList.stream().map(a -> a.getDisplayString()).toArray(String[]::new));
        if (!ComponentBundleActivator.isDarkTheme((Display)this.applicationNameCombo.getDisplay())) {
            this.applicationNameCombo.setForeground(ColorUtil.BLACK_COLOR);
        } else {
            this.applicationNameCombo.setForeground(ColorUtil.getTextWhiteColor());
        }
        this.applicationNameCombo.select(0);
    }

    private void clearApplicationNameCombo() {
        this.applicationNameCombo.clearSelection();
        this.applicationNameCombo.removeAll();
    }

    private void createApplicationSelectionComposite(Composite parent) {
        Composite appFileChooserComposite = new Composite(parent, 0);
        appFileChooserComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout glAppFileChooserComposite = new GridLayout(2, false);
        glAppFileChooserComposite.marginHeight = 0;
        glAppFileChooserComposite.marginWidth = 0;
        appFileChooserComposite.setLayout((Layout)glAppFileChooserComposite);
        this.applicationNameCombo = new Combo(appFileChooserComposite, 8);
        this.applicationNameCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.applicationNameCombo.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                TestCloudApplicationViewModel viewModel;
                int index = TestCloudApplicationSelectorComposite.this.applicationNameCombo.getItemHeight();
                if (index != -1 && (viewModel = TestCloudApplicationSelectorComposite.this.getSelectingApplicationViewModel()) != null) {
                    String tooltip = viewModel.getDisplayStringOnTooltip();
                    TestCloudApplicationSelectorComposite.this.applicationNameCombo.setToolTipText(tooltip);
                }
            }
        });
        this.btnRefresh = new Button(appFileChooserComposite, 8);
        this.btnRefresh.setText(GlobalStringConstants.REFRESH);
        String uploadUrl = this.discoveryController.getServerUrl(ServerType.PLATFORM) + TESTCLOUD_UPLOAD_APPLICATION_PATH_TEMPLATE;
        String uploadMessage = ComposerMobileObjectspyMessageConstants.MSG_TESTCLOUD_DONT_SEE_APPLICATION + " <a href=\"" + uploadUrl + "\">" + ComposerMobileObjectspyMessageConstants.MSG_UPLOAD_APPLICATION + "</a>";
        this.uploadApplicationLink = new Link(parent, 0);
        this.uploadApplicationLink.setText(uploadMessage);
        this.reset();
    }

    private void createLabelComposite(Composite parent) {
        Composite appFileChooserComposite = new Composite(parent, 0);
        GridLayout glAppFileChooserComposite = new GridLayout(2, false);
        glAppFileChooserComposite.marginHeight = 0;
        glAppFileChooserComposite.marginWidth = 0;
        glAppFileChooserComposite.marginRight = 0;
        appFileChooserComposite.setLayout((Layout)glAppFileChooserComposite);
        Label appFileLabel = new Label(appFileChooserComposite, 0);
        appFileLabel.setText(ComposerMobileObjectspyMessageConstants.DIA_LBL_APP_NAME);
        GridData gdAppFileLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        appFileLabel.setLayoutData((Object)gdAppFileLabel);
        new SelectableInformationComposite(appFileChooserComposite, this.INFORMATION_MESSAGE);
    }

    @Override
    public TestCloudApplication getSelectionApplication() {
        Optional<TestCloudApplication> firstTestCloudApp;
        TestCloudApplication testCloudApplication = null;
        TestCloudApplicationViewModel applicationViewModel = this.getSelectingApplicationViewModel();
        if (applicationViewModel != null && (firstTestCloudApp = this.testCloudApplications.stream().filter(application -> application.getId().equals(applicationViewModel.getId())).findFirst()).isPresent()) {
            testCloudApplication = firstTestCloudApp.get();
        }
        return testCloudApplication;
    }

    @Override
    public Composite render(Composite parent, int type) {
        return this.render(parent, type, true);
    }

    @Override
    public Composite render(Composite parent, int type, boolean isRenderLabel) {
        if (isRenderLabel) {
            this.createLabelComposite(parent);
        }
        this.createApplicationSelectionComposite(parent);
        this.addListeners();
        return parent;
    }

    @Override
    public void reset() {
        this.clearApplicationNameCombo();
        this.applicationNameCombo.setForeground(ColorUtil.TESTCLOUD_EMPTY_TEXT_ON_COMBO_COLOR);
        this.applicationNameCombo.setItems(new String[]{"Application Name"});
        this.applicationNameCombo.select(0);
    }

    @Override
    public void setEnableComposite(boolean isEnable) {
        this.applicationNameCombo.setEnabled(isEnable);
        this.btnRefresh.setEnabled(isEnable);
        if (isEnable) {
            this.applicationNameCombo.setForeground(ColorUtil.getTextColor());
        }
    }

    @Override
    public void setSelectionApplication(String applicationId) {
        TestCloudApplicationViewModel selectingApplication;
        int index;
        Optional<TestCloudApplicationViewModel> firstApp = this.applicationList.stream().filter(a -> a.getId().equals(applicationId)).findFirst();
        if (firstApp.isPresent() && (index = this.applicationList.indexOf(selectingApplication = firstApp.get())) >= 0 && index < this.applicationNameCombo.getItemCount()) {
            this.applicationNameCombo.select(index);
        }
    }

    @Override
    public void setTestCloudApplications(List<TestCloudApplication> testCloudApplications, TestCloudMobilePlatformName platform) {
        this.testCloudApplications = testCloudApplications;
        this.setTestCloudDevicePlatform(platform);
    }

    @Override
    public void setTestCloudDevicePlatform(TestCloudMobilePlatformName platform) {
        this.selectedPlatform = platform;
        List<TestCloudApplicationViewModel> applications = this.testCloudApplications.stream().filter(a -> this.selectedPlatform.equals((Object)a.getPlatform())).map(a -> TestCloudApplicationViewModel.fromDomainModel(a)).toList();
        this.applicationList.clear();
        this.applicationList.addAll(applications);
        if (this.applicationList.isEmpty()) {
            this.reset();
        } else {
            this.bindingApplication();
        }
    }

    private TestCloudApplicationViewModel getSelectingApplicationViewModel() {
        int selectionIndex = this.applicationNameCombo.getSelectionIndex();
        if (selectionIndex >= 0 && selectionIndex < this.applicationList.size()) {
            return this.applicationList.get(selectionIndex);
        }
        return null;
    }
}

