/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.composites;

import com.kms.katalon.composer.components.ComponentBundleActivator;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.mobile.objectspy.constant.ComposerMobileObjectspyMessageConstants;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileElementInspectorDialog;
import com.kms.katalon.composer.mobile.objectspy.element.impl.CapturedMobileElement;
import com.kms.katalon.composer.mobile.objectspy.element.provider.CapturedElementLabelProvider;
import com.kms.katalon.composer.mobile.objectspy.viewer.CapturedObjectTableViewer;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.constants.GlobalStringConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class MobileCapturedObjectsComposite
extends Composite {
    private MobileElementInspectorDialog parentDialog;
    private CapturedObjectTableViewer capturedObjectsTableViewer;
    private Table capturedObjectsTable;
    private Composite innerTableComposite;

    public CapturedObjectTableViewer getCapturedObjectsTableViewer() {
        return this.capturedObjectsTableViewer;
    }

    public MobileCapturedObjectsComposite(MobileElementInspectorDialog parentDialog, Composite parent, int style) {
        super(parent, style);
        this.parentDialog = parentDialog;
        this.createComposite();
    }

    public MobileCapturedObjectsComposite(MobileElementInspectorDialog parentDialog, Composite parent) {
        this(parentDialog, parent, 0);
    }

    private void createComposite() {
        this.setLayout((Layout)new GridLayout());
        this.createCompositeLabel();
        this.createInnerTableComposite();
        this.createCapturedObjectsTableViewer();
        this.buildCapturedObjectsTable();
        this.createTableViewerColumns();
        this.setupTableEventListeners();
    }

    private void createCompositeLabel() {
        Label lblCapturedObjects = new Label((Composite)this, 0);
        lblCapturedObjects.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblCapturedObjects.setText(ComposerMobileObjectspyMessageConstants.DIA_LBL_CAPTURED_OBJECTS);
        ControlUtils.setFontToBeBold((Control)lblCapturedObjects);
        Composite composite = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        layout.verticalSpacing = 10;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Label locatorCaptureNoteLabel = new Label(composite, 0);
        locatorCaptureNoteLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        locatorCaptureNoteLabel.setText(ComposerMobileObjectspyMessageConstants.MSG_LOCATOR_CAPTURE_NOTES);
        final Label tooltipsButton = new Label(composite, 0);
        tooltipsButton.setImage(ImageManager.getImage((String)"info_16.png"));
        if ("linux".equals(Platform.getOS())) {
            tooltipsButton.setToolTipText(ComposerMobileObjectspyMessageConstants.MSG_LOCATOR_CAPTURE_NOTES_TOOLTIP);
        } else {
            tooltipsButton.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    Program.launch((String)ComposerMobileObjectspyMessageConstants.MSG_LOCATOR_CAPTURE_NOTES_URL);
                }
            });
            tooltipsButton.addMouseTrackListener(new MouseTrackListener(){
                private Shell popup;
                private Shell chevron;
                private boolean isDarkMode = ComponentBundleActivator.isDarkTheme((Display)Display.getCurrent());

                public void mouseEnter(MouseEvent e) {
                    if (this.chevron != null) {
                        this.chevron.setVisible(true);
                    }
                    if (this.popup != null) {
                        this.popup.setVisible(true);
                        return;
                    }
                    this.chevron = new Shell(tooltipsButton.getShell(), 16392);
                    this.chevron.setLayout((Layout)new FillLayout());
                    Label chevronLabel = new Label((Composite)this.chevron, 0);
                    if (!this.isDarkMode) {
                        chevronLabel.setImage(ImageManager.getImage((String)"chevron_down_comment.png"));
                    }
                    this.chevron.setSize(chevronLabel.computeSize(-1, -1));
                    this.chevron.setLocation(tooltipsButton.toDisplay((int)2, (int)18).x, tooltipsButton.toDisplay((int)2, (int)18).y);
                    this.popup = new Shell(tooltipsButton.getShell(), 16392);
                    this.popup.setLayout((Layout)new FillLayout());
                    Composite mainComposite = new Composite((Composite)this.popup, 2048);
                    mainComposite.setLayoutData((Object)new GridData(1808));
                    mainComposite.setLayout((Layout)new GridLayout());
                    mainComposite.setBackground(Display.getCurrent().getSystemColor(1));
                    MobileCapturedObjectsComposite.this.createStyledTooltip(mainComposite, ComposerMobileObjectspyMessageConstants.MSG_LOCATOR_CAPTURE_NOTES_TOOLTIP);
                    this.popup.setSize(mainComposite.computeSize(280, -1));
                    this.popup.setLocation(this.chevron.toDisplay((int)-10, (int)0).x, this.chevron.toDisplay((int)-10, (int)5).y);
                    this.chevron.moveAbove((Control)this.popup);
                    this.chevron.setVisible(true);
                    this.popup.setVisible(true);
                }

                public void mouseExit(MouseEvent e) {
                    if (this.chevron != null && this.chevron.isVisible()) {
                        this.chevron.setVisible(false);
                    }
                    if (this.popup != null && this.popup.isVisible()) {
                        this.popup.setVisible(false);
                    }
                }

                public void mouseHover(MouseEvent e) {
                    if (this.chevron != null && !this.chevron.isVisible()) {
                        this.chevron.setVisible(true);
                    }
                    if (this.popup != null && !this.popup.isVisible()) {
                        this.popup.setVisible(true);
                    }
                }
            });
        }
    }

    private Matcher getUrlMatcher(String text) {
        Pattern urlPattern = Pattern.compile("https?://[\\w\\.-]+(?:\\.[a-zA-Z]{2,})+(?:[/\\w\\.-]*)*/?");
        return urlPattern.matcher(text);
    }

    private boolean containsUrl(String text) {
        return this.getUrlMatcher(text).find();
    }

    private void createStyledTooltip(Composite parent, String text) {
        StyledText styledText = new StyledText(parent, 72);
        styledText.setBackground(Display.getCurrent().getSystemColor(1));
        styledText.setEditable(false);
        String wrappedText = this.wrapMessage(text);
        styledText.setText(wrappedText);
        if (this.containsUrl(text)) {
            Matcher urlMatcher = this.getUrlMatcher(wrappedText);
            while (urlMatcher.find()) {
                StyleRange styleRange = new StyleRange();
                styleRange.start = urlMatcher.start();
                styleRange.length = urlMatcher.end() - urlMatcher.start();
                styleRange.foreground = Display.getCurrent().getSystemColor(9);
                styledText.setStyleRange(styleRange);
            }
        }
    }

    private String wrapMessage(String message) {
        int maxCharacters = 50;
        if (message.length() <= maxCharacters) {
            return message;
        }
        int positionToBreak = this.findBreakBefore(message, maxCharacters);
        if (positionToBreak == -1) {
            positionToBreak = maxCharacters;
        }
        return message.substring(0, positionToBreak).trim() + "\n" + this.wrapMessage(message.substring(positionToBreak).trim());
    }

    private int findBreakBefore(String line, int start) {
        int i = start;
        while (i >= 0) {
            char c = line.charAt(i);
            if (Character.isWhitespace(c) || c == '-') {
                return i;
            }
            --i;
        }
        return -1;
    }

    private void createInnerTableComposite() {
        this.innerTableComposite = new Composite((Composite)this, 0);
        this.innerTableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
    }

    private void createCapturedObjectsTableViewer() {
        this.capturedObjectsTableViewer = new CapturedObjectTableViewer(this.innerTableComposite, 68354, this.parentDialog);
        this.capturedObjectsTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.capturedObjectsTableViewer);
        this.capturedObjectsTableViewer.setCapturedElements(new ArrayList<CapturedMobileElement>());
    }

    private void buildCapturedObjectsTable() {
        this.capturedObjectsTable = this.capturedObjectsTableViewer.getTable();
        this.capturedObjectsTable.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.capturedObjectsTable.setHeaderVisible(true);
        this.capturedObjectsTable.setLinesVisible(ControlUtils.shouldLineVisble((Display)this.capturedObjectsTable.getDisplay()));
        this.capturedObjectsTable.setToolTipText("");
    }

    private void createTableViewerColumns() {
        TableViewerColumn tableViewerNameColumn = new TableViewerColumn((TableViewer)this.capturedObjectsTableViewer, 0);
        tableViewerNameColumn.setLabelProvider((CellLabelProvider)new CapturedElementLabelProvider(0));
        TableColumn tableNameColumn = tableViewerNameColumn.getColumn();
        tableNameColumn.setText(GlobalStringConstants.NAME);
        TableColumnLayout tbclCapturedObjects = new TableColumnLayout();
        int selectionColMinWidth = "macosx".equals(Platform.getOS()) ? 21 : 30;
        tbclCapturedObjects.setColumnData((Widget)tableNameColumn, (ColumnLayoutData)new ColumnWeightData(60, 250 - selectionColMinWidth));
        this.innerTableComposite.setLayout((Layout)tbclCapturedObjects);
    }

    private void setupTableEventListeners() {
        this.capturedObjectsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                CapturedMobileElement firstElement = (CapturedMobileElement)selection.getFirstElement();
                if (firstElement == null) {
                    return;
                }
                MobileCapturedObjectsComposite.this.parentDialog.setEdittingElement(firstElement);
            }
        });
        this.capturedObjectsTableViewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                Point pt = new Point(e.x, e.y);
                TableItem item = MobileCapturedObjectsComposite.this.capturedObjectsTableViewer.getTable().getItem(pt);
                if (item != null) {
                    MobileCapturedObjectsComposite.this.parentDialog.highlightElement((CapturedMobileElement)item.getData());
                }
            }
        });
        this.capturedObjectsTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CapturedMobileElement mobileElement = MobileCapturedObjectsComposite.this.capturedObjectsTableViewer.getSelectedElement();
                MobileCapturedObjectsComposite.this.parentDialog.setSelectedElement(mobileElement);
            }
        });
        this.capturedObjectsTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                CapturedMobileElement[] elements = MobileCapturedObjectsComposite.this.capturedObjectsTableViewer.getSelectedElements();
                if (elements == null || elements.length == 0) {
                    return;
                }
                switch (e.keyCode) {
                    case 127: {
                        MobileCapturedObjectsComposite.this.parentDialog.removeSelectedCapturedElements(elements);
                        break;
                    }
                    case 0x100000E: {
                        MobileCapturedObjectsComposite.this.parentDialog.verifyCapturedElementsStates(elements);
                        break;
                    }
                    case 0x100000B: {
                        if (elements.length != 1) break;
                        MobileCapturedObjectsComposite.this.parentDialog.focusAndEditCapturedElementName();
                    }
                }
            }
        });
    }

    public boolean isAnyElementChecked() {
        return this.capturedObjectsTableViewer.isAnyElementChecked();
    }

    public boolean hasAnyElement() {
        return !this.capturedObjectsTableViewer.getCapturedElements().isEmpty();
    }

    public void refresh() {
        this.capturedObjectsTableViewer.refresh();
    }

    public void refresh(Object element, boolean updateLabels) {
        this.capturedObjectsTableViewer.refresh(element, updateLabels);
    }

    public void addElement(CapturedMobileElement element) {
        ArrayList<CapturedMobileElement> elements = new ArrayList<CapturedMobileElement>();
        elements.add(element);
        this.capturedObjectsTableViewer.addMobileElements(elements);
    }

    public void addElements(List<CapturedMobileElement> elements) {
        this.capturedObjectsTableViewer.addMobileElements(elements);
    }

    public void removeElement(CapturedMobileElement element) {
        this.capturedObjectsTableViewer.removeCapturedElement(element);
    }

    public void removeElements(List<CapturedMobileElement> elements) {
        this.capturedObjectsTableViewer.removeCapturedElements(elements);
    }

    public boolean containsElement(CapturedMobileElement element) {
        return this.capturedObjectsTableViewer.contains(element);
    }

    public List<CapturedMobileElement> getAllCheckedElements() {
        return this.capturedObjectsTableViewer.getAllCheckedElements();
    }

    public List<CapturedMobileElement> getCapturedElements() {
        return this.capturedObjectsTableViewer.getCapturedElements();
    }

    public CapturedMobileElement[] getSelectedElements() {
        return this.capturedObjectsTableViewer.getSelectedElements();
    }

    public void setSelection(CapturedMobileElement element) {
        IStructuredSelection selection = (IStructuredSelection)this.capturedObjectsTableViewer.getSelection();
        CapturedMobileElement firstElement = (CapturedMobileElement)selection.getFirstElement();
        if (element == firstElement) {
            return;
        }
        this.capturedObjectsTableViewer.setSelection((ISelection)(element != null ? new StructuredSelection((Object)element) : StructuredSelection.EMPTY));
    }

    public void setSelections(List<CapturedMobileElement> elements) {
        this.capturedObjectsTableViewer.setSelection((ISelection)(elements != null ? new StructuredSelection(elements) : StructuredSelection.EMPTY));
    }

    public Map<Integer, CapturedMobileElement> getHashCapturedElements() {
        return this.capturedObjectsTableViewer.getCapturedElementsWithHash();
    }
}

