/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.dialog;

import com.kms.katalon.composer.components.impl.dialogs.TreeEntitySelectionDialog;
import com.kms.katalon.composer.components.impl.providers.AbstractEntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.EntityLabelProvider;
import com.kms.katalon.composer.components.impl.providers.EntityProvider;
import com.kms.katalon.composer.components.impl.providers.EntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ControlUtil;
import com.kms.katalon.composer.explorer.providers.FolderProvider;
import com.kms.katalon.composer.folder.dialogs.NewFolderDialog;
import com.kms.katalon.composer.mobile.objectspy.constant.ComposerMobileObjectspyMessageConstants;
import com.kms.katalon.composer.mobile.objectspy.element.impl.CapturedMobileElement;
import com.kms.katalon.composer.mobile.objectspy.element.tree.MobileCapturedElementLabelProvider;
import com.kms.katalon.composer.mobile.objectspy.element.tree.MobileCapturedElementTreeContentProvider;
import com.kms.katalon.composer.mobile.objectspy.element.tree.MobileCheckboxTreeSelectionHelper;
import com.kms.katalon.composer.mobile.objectspy.util.MobileElementHelper;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.MobileElementEntity;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class AddElementToObjectRepositoryDialogV2
extends TreeEntitySelectionDialog {
    private int fWidth = 60;
    private int fHeight = 18;
    private TreeViewer treeViewer;
    private boolean isCheckable;
    private TreeViewer mobileElementTreeViewer;
    private FolderEntity rootFolderEntity;
    private FolderTreeEntity rootFolderTreeEntity;
    private ScopedPreferenceStore store;
    private boolean modified;
    private Button btnAddNewObject;
    private Button btnReplaceObject;
    private Button btnMergeObject;
    private Button btnSelectAll;
    private StyledText conflictDesciptionLabel;
    private SashForm form;
    private Composite radioGroup;
    private boolean selectAll;
    private ConflictOptions selectedConflictOptions;
    private MobileCapturedElementTreeContentProvider leftTreeContentProvider;
    private MobileCheckboxTreeSelectionHelper checkboxSelectionHelper = null;
    private final int HIGHLIGHTED_LENGTH = "Highlighted".length();
    private int selectedElementCount = 0;
    private List<MobileElementEntity> allConflictedElementEntities = new LinkedList<MobileElementEntity>();
    private int duplicatedByHashedAttributes;
    private List<CapturedMobileElement> capturedElements;

    public AddElementToObjectRepositoryDialogV2(Shell parentShell, List<CapturedMobileElement> capturedElement, boolean isCheckable) {
        super(parentShell, (IEntityLabelProvider)new EntityLabelProvider(), (ITreeContentProvider)new FolderProvider(), (AbstractEntityViewerFilter)new EntityViewerFilter((EntityProvider)new FolderProvider()));
        this.capturedElements = new ArrayList<CapturedMobileElement>(capturedElement);
        this.isCheckable = isCheckable;
        this.store = PreferenceStoreManager.getPreferenceStore(((Object)((Object)this)).getClass());
        this.leftTreeContentProvider = new MobileCapturedElementTreeContentProvider();
        this.setShellStyle(67696);
        this.setTitle("Add Element to Object Repository");
        this.setAllowMultiple(false);
        this.refresh();
    }

    private void refresh() {
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        if (currentProject != null) {
            try {
                this.rootFolderEntity = FolderController.getInstance().getObjectRepositoryRoot(currentProject);
                this.rootFolderTreeEntity = new FolderTreeEntity(this.rootFolderEntity, null);
                this.setInput(new Object[]{this.rootFolderTreeEntity});
                this.setInitialSelection(this.rootFolderTreeEntity);
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
                MessageDialog.openError((Shell)this.getParentShell(), (String)GlobalStringConstants.ERROR, (String)e.getMessage());
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = this.createMainDialogArea(parent);
        this.form = new SashForm(composite, 256);
        this.form.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createLeftPanel((Composite)this.form);
        this.createRightPanel((Composite)this.form);
        this.createConflictOptionsPanel(composite);
        this.registerConflictOptionsPanelListeners();
        this.updateInput();
        return composite;
    }

    private Composite createMainDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        AddElementToObjectRepositoryDialogV2.applyDialogFont((Control)composite);
        return composite;
    }

    private void updateInput() {
        this.btnSelectAll.setSelection(true);
        this.modified = false;
        String conflictOptions = this.store.getString("conflictObjectDialog.selectedConflictOption");
        if (!StringUtils.isBlank((CharSequence)conflictOptions)) {
            this.selectedConflictOptions = Enum.valueOf(ConflictOptions.class, conflictOptions);
            this.btnAddNewObject.setSelection(this.selectedConflictOptions == ConflictOptions.CREATE_NEW_OBJECT);
            this.btnMergeObject.setSelection(this.selectedConflictOptions == ConflictOptions.MERGE_CHANGE_TO_EXISTING_OBJECT);
            this.btnReplaceObject.setSelection(this.selectedConflictOptions == ConflictOptions.REPLACE_EXISTING_OBJECT);
        } else {
            this.btnMergeObject.setSelection(true);
            this.store.setValue("conflictObjectDialog.selectedConflictOption", ConflictOptions.MERGE_CHANGE_TO_EXISTING_OBJECT.toString());
        }
    }

    private void createRightPanel(Composite parent) {
        Composite objectRepositoryComposite = new Composite(parent, 0);
        Label label = new Label(objectRepositoryComposite, 0);
        label.setText("Select a destination folder");
        label.setLayoutData((Object)new GridData(256));
        this.treeViewer = this.createTreeViewer(objectRepositoryComposite);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddElementToObjectRepositoryDialogV2.this.reloadStatusCheckboxViewTree();
            }
        });
        this.treeViewer.expandToLevel((Object)this.rootFolderTreeEntity, 1);
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
        data.heightHint = this.convertHeightInCharsToPixels(this.fHeight);
        Tree treeWidget = this.treeViewer.getTree();
        treeWidget.setLayoutData((Object)data);
        treeWidget.setFont(parent.getFont());
        treeWidget.setEnabled(true);
    }

    private void reloadStatusCheckboxViewTree() {
        CheckboxTreeViewer checkboxViewer = (CheckboxTreeViewer)this.mobileElementTreeViewer;
        Object[] checkedlst = checkboxViewer.getCheckedElements();
        this.checkConflictObjects(this.capturedElements);
        this.mobileElementTreeViewer.setInput(this.capturedElements);
        checkboxViewer.setCheckedElements(checkedlst);
        this.mobileElementTreeViewer.expandAll();
    }

    private void createLeftPanel(Composite parent) {
        Composite mobileObjectTreeComposite = new Composite(parent, 0);
        GridLayout glMobileObjectComposite = new GridLayout();
        glMobileObjectComposite.marginTop = 5;
        glMobileObjectComposite.marginBottom = 5;
        glMobileObjectComposite.horizontalSpacing = 0;
        glMobileObjectComposite.marginWidth = 0;
        glMobileObjectComposite.marginHeight = 0;
        mobileObjectTreeComposite.setLayout((Layout)glMobileObjectComposite);
        this.btnSelectAll = new Button(mobileObjectTreeComposite, 32);
        this.btnSelectAll.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnSelectAll.setText("Select all");
        if (this.isCheckable) {
            this.mobileElementTreeViewer = new CheckboxTreeViewer(mobileObjectTreeComposite, 2050);
            this.checkboxSelectionHelper = MobileCheckboxTreeSelectionHelper.attach((CheckboxTreeViewer)this.mobileElementTreeViewer, this.leftTreeContentProvider);
            this.checkboxSelectionHelper.setBtnSelectAll(this.btnSelectAll);
        } else {
            this.mobileElementTreeViewer = new TreeViewer(mobileObjectTreeComposite, 2050);
        }
        Menu menu = new Menu((Control)this.mobileElementTreeViewer.getTree());
        this.mobileElementTreeViewer.getTree().setMenu(menu);
        this.mobileElementTreeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.mobileElementTreeViewer.setContentProvider((IContentProvider)this.leftTreeContentProvider);
        this.mobileElementTreeViewer.setLabelProvider((IBaseLabelProvider)new MobileCapturedElementLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.mobileElementTreeViewer, (int)2);
        this.mobileElementTreeViewer.setInput(this.capturedElements);
        this.mobileElementTreeViewer.expandAll();
        if (this.checkboxSelectionHelper != null) {
            this.checkboxSelectionHelper.setCheckAllItems(true);
        }
    }

    private void refreshTreeEntity(Object object) {
        this.treeViewer.getControl().setRedraw(false);
        Object[] expandedElements = this.treeViewer.getExpandedElements();
        if (object == null) {
            this.treeViewer.refresh();
        } else {
            this.treeViewer.refresh(object);
        }
        Object[] objectArray = expandedElements;
        int n = expandedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.treeViewer.setExpandedState(element, true);
            ++n2;
        }
        this.treeViewer.getControl().setRedraw(true);
    }

    private void createConflictOptionsPanel(Composite parent) {
        parent.setBackgroundMode(2);
        this.conflictDesciptionLabel = new StyledText(parent, 0);
        this.conflictDesciptionLabel.setText("Highlighted object(s) already exist(s) in selected folder. Please choose an option below:");
        this.conflictDesciptionLabel.setLayoutData((Object)new GridData(256));
        Color red = Display.getCurrent().getSystemColor(3);
        StyleRange styleRange = new StyleRange();
        styleRange.start = 0;
        styleRange.length = this.HIGHLIGHTED_LENGTH;
        styleRange.foreground = red;
        this.conflictDesciptionLabel.setStyleRange(styleRange);
        this.conflictDesciptionLabel.setBackground(this.conflictDesciptionLabel.getParent().getBackground());
        this.radioGroup = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginLeft = 20;
        this.radioGroup.setLayout((Layout)gridLayout);
        this.btnMergeObject = new Button(this.radioGroup, 16);
        this.btnMergeObject.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.btnMergeObject.setText("Merge changes into existing objects");
        this.btnAddNewObject = new Button(this.radioGroup, 16);
        this.btnAddNewObject.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.btnAddNewObject.setText("Create duplicate objects");
        this.btnReplaceObject = new Button(this.radioGroup, 16);
        this.btnReplaceObject.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.btnReplaceObject.setText("Replace existing objects");
    }

    private void setConflictOptionPanelEnable(boolean enabled) {
        this.btnMergeObject.setEnabled(enabled);
        this.btnAddNewObject.setEnabled(enabled);
        this.btnReplaceObject.setEnabled(enabled);
        if (!enabled) {
            Color textColor = ColorUtil.getTextColor();
            StyleRange styleRange = new StyleRange();
            styleRange.start = 0;
            styleRange.length = this.conflictDesciptionLabel.getText().length();
            styleRange.foreground = textColor;
            this.conflictDesciptionLabel.setBackground(this.conflictDesciptionLabel.getParent().getBackground());
            this.conflictDesciptionLabel.setStyleRange(styleRange);
        } else {
            Color red = Display.getCurrent().getSystemColor(3);
            StyleRange styleRange = new StyleRange();
            styleRange.start = 0;
            styleRange.length = this.HIGHLIGHTED_LENGTH;
            styleRange.foreground = red;
            this.conflictDesciptionLabel.setStyleRange(styleRange);
            this.conflictDesciptionLabel.setBackground(this.conflictDesciptionLabel.getParent().getBackground());
        }
    }

    private void registerConflictOptionsPanelListeners() {
        this.btnSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddElementToObjectRepositoryDialogV2.this.selectAll = AddElementToObjectRepositoryDialogV2.this.btnSelectAll.getSelection();
                AddElementToObjectRepositoryDialogV2.this.checkboxSelectionHelper.setCheckAllItems(AddElementToObjectRepositoryDialogV2.this.btnSelectAll.getSelection());
                AddElementToObjectRepositoryDialogV2.this.reloadStatusCheckboxViewTree();
                AddElementToObjectRepositoryDialogV2.this.modified = true;
            }
        });
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddElementToObjectRepositoryDialogV2.this.btnAddNewObject.setSelection(e.widget == AddElementToObjectRepositoryDialogV2.this.btnAddNewObject);
                AddElementToObjectRepositoryDialogV2.this.btnMergeObject.setSelection(e.widget == AddElementToObjectRepositoryDialogV2.this.btnMergeObject);
                AddElementToObjectRepositoryDialogV2.this.btnReplaceObject.setSelection(e.widget == AddElementToObjectRepositoryDialogV2.this.btnReplaceObject);
                AddElementToObjectRepositoryDialogV2.this.selectedConflictOptions = AddElementToObjectRepositoryDialogV2.this.getSelectedConflictOption();
                AddElementToObjectRepositoryDialogV2.this.store.setValue("conflictObjectDialog.selectedConflictOption", AddElementToObjectRepositoryDialogV2.this.selectedConflictOptions.toString());
                AddElementToObjectRepositoryDialogV2.this.modified = true;
            }
        };
        this.btnAddNewObject.addSelectionListener((SelectionListener)selectionListener);
        this.btnReplaceObject.addSelectionListener((SelectionListener)selectionListener);
        this.btnMergeObject.addSelectionListener((SelectionListener)selectionListener);
    }

    private ConflictOptions getSelectedConflictOption() {
        return this.btnAddNewObject.getSelection() ? ConflictOptions.CREATE_NEW_OBJECT : (this.btnMergeObject.getSelection() ? ConflictOptions.MERGE_CHANGE_TO_EXISTING_OBJECT : ConflictOptions.REPLACE_EXISTING_OBJECT);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button btnNewFolder = this.createButton(parent, 22, ComposerMobileObjectspyMessageConstants.DIA_BTN_NEW_FOLDER, false);
        btnNewFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selectedObject = AddElementToObjectRepositoryDialogV2.this.getFirstResult();
                if (selectedObject == null) {
                    selectedObject = AddElementToObjectRepositoryDialogV2.this.rootFolderTreeEntity;
                }
                try {
                    FolderEntity newEntity;
                    FolderEntity parentFolder = ((FolderTreeEntity)selectedObject).getObject();
                    String suggestedName = FolderController.getInstance().getAvailableFolderName(parentFolder, "New Folder");
                    NewFolderDialog newFolderDialog = new NewFolderDialog(AddElementToObjectRepositoryDialogV2.this.getParentShell(), parentFolder);
                    newFolderDialog.setName(suggestedName);
                    newFolderDialog.open();
                    if (newFolderDialog.getReturnCode() == 0 && (newEntity = FolderController.getInstance().addNewFolder(parentFolder, newFolderDialog.getName())) != null) {
                        FolderTreeEntity newFolderTreeEntity = TreeEntityUtil.createSelectedTreeEntityHierachy((FolderEntity)newEntity, (FolderEntity)AddElementToObjectRepositoryDialogV2.this.rootFolderEntity);
                        AddElementToObjectRepositoryDialogV2.this.refreshTreeEntity(selectedObject);
                        AddElementToObjectRepositoryDialogV2.this.treeViewer.expandToLevel(selectedObject, 1);
                        AddElementToObjectRepositoryDialogV2.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)newFolderTreeEntity));
                    }
                }
                catch (Exception exception) {
                    LoggerSingleton.logError((Throwable)exception);
                    MessageDialog.openError((Shell)AddElementToObjectRepositoryDialogV2.this.getParentShell(), (String)GlobalStringConstants.ERROR, (String)exception.getMessage());
                }
            }
        });
        Button okButton = this.createButton(parent, 55, IDialogConstants.OK_LABEL, false);
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget.isDisposed()) {
                    return;
                }
                if (!(AddElementToObjectRepositoryDialogV2.this.getFirstResult() instanceof FolderTreeEntity)) {
                    MessageDialog.openWarning((Shell)AddElementToObjectRepositoryDialogV2.this.getParentShell(), (String)GlobalStringConstants.WARN, (String)"Please select a target folder");
                    return;
                }
                if (AddElementToObjectRepositoryDialogV2.this.isCheckable) {
                    Object[] checkedMobileElements;
                    Control tree = ((CheckboxTreeViewer)AddElementToObjectRepositoryDialogV2.this.mobileElementTreeViewer).getControl();
                    Object[] objectArray = checkedMobileElements = !ControlUtil.isDisposed((Widget)tree) ? ((CheckboxTreeViewer)AddElementToObjectRepositoryDialogV2.this.mobileElementTreeViewer).getCheckedElements() : null;
                    if (checkedMobileElements == null || checkedMobileElements.length <= 0) {
                        MessageDialog.openWarning((Shell)AddElementToObjectRepositoryDialogV2.this.getParentShell(), (String)GlobalStringConstants.WARN, (String)"Please select elements to add to object repository");
                        return;
                    }
                    AddElementToObjectRepositoryDialogV2.this.selectedElementCount = checkedMobileElements.length;
                    AddElementToObjectRepositoryDialogV2.this.removeUncheckedElements(AddElementToObjectRepositoryDialogV2.this.capturedElements);
                }
                AddElementToObjectRepositoryDialogV2.this.setReturnCode(0);
                AddElementToObjectRepositoryDialogV2.this.close();
            }
        });
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private boolean checkConflictObjects(List<CapturedMobileElement> children) {
        boolean foundConflict = false;
        try {
            FolderTreeEntity selectedParentFolder = (FolderTreeEntity)this.getFirstResult();
            if (selectedParentFolder == null) {
                return foundConflict;
            }
            FolderEntity parentEntity = FolderController.getInstance().getFolder(selectedParentFolder.getObject().getLocation());
            List allMobileEntities = ObjectRepositoryController.getInstance().getAllChildren(parentEntity);
            int duplicatedByHashedAttributes = 0;
            for (CapturedMobileElement mobileElement : children) {
                if (!(mobileElement instanceof CapturedMobileElement)) continue;
                boolean isHashValueMatched = false;
                MobileElementHelper helper = new MobileElementHelper();
                int targetHash = helper.calculateHashValue(mobileElement);
                for (Object entity : allMobileEntities) {
                    MobileElementEntity mobileElementEntity;
                    int entityHash;
                    if (!(entity instanceof MobileElementEntity) || !helper.isTheSameHashValue(entityHash = helper.calculateHashValue(mobileElementEntity = (MobileElementEntity)entity), targetHash)) continue;
                    if (!this.allConflictedElementEntities.contains(mobileElementEntity)) {
                        this.allConflictedElementEntities.add(mobileElementEntity);
                        ++duplicatedByHashedAttributes;
                    }
                    isHashValueMatched = true;
                    foundConflict = true;
                    break;
                }
                mobileElement.setConflicted(isHashValueMatched);
            }
            this.setConflictOptionPanelEnable(foundConflict);
            this.setDuplicatedByHashedAttributes(duplicatedByHashedAttributes);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)this.getParentShell(), (String)GlobalStringConstants.ERROR, (String)e.getMessage());
        }
        return foundConflict;
    }

    private void updatePreferenceStore() {
        if (this.modified) {
            try {
                this.store.save();
            }
            catch (IOException ex) {
                LoggerSingleton.logError((Throwable)ex);
            }
        }
    }

    public boolean close() {
        this.updatePreferenceStore();
        return super.close();
    }

    public int open() {
        return super.open();
    }

    protected Point getInitialSize() {
        return new Point(600, 600);
    }

    private void removeUncheckedElements(List<CapturedMobileElement> elementList) {
        Iterator<CapturedMobileElement> iterator = elementList.iterator();
        while (iterator.hasNext()) {
            CapturedMobileElement childElement = iterator.next();
            if (((CheckboxTreeViewer)this.mobileElementTreeViewer).getChecked((Object)childElement) || ((CheckboxTreeViewer)this.mobileElementTreeViewer).getGrayed((Object)childElement)) continue;
            iterator.remove();
        }
    }

    public AddToObjectRepositoryDialogResult getDialogResult() throws Exception {
        AddToObjectRepositoryDialogResult dialogResult = new AddToObjectRepositoryDialogResult(this.selectAll, this.capturedElements, (FolderTreeEntity)this.getFirstResult(), this.selectedConflictOptions, this.selectedElementCount, this.allConflictedElementEntities);
        return dialogResult;
    }

    public FolderTreeEntity getSelectedParentFolderResult() {
        return (FolderTreeEntity)this.getFirstResult();
    }

    public int getDuplicatedByHashedAttributes() {
        return this.duplicatedByHashedAttributes;
    }

    public void setDuplicatedByHashedAttributes(int duplicatedByHashedAttributes) {
        this.duplicatedByHashedAttributes = duplicatedByHashedAttributes;
    }

    public static class AddToObjectRepositoryDialogResult {
        private final boolean isSelectAll;
        private final List<CapturedMobileElement> allSelectedElements;
        private final FolderTreeEntity selectedParentFolder;
        private ConflictOptions selectedConflictOption;
        private int selectedElementCount;
        private List<MobileElementEntity> allConflictedElementEntities;

        public AddToObjectRepositoryDialogResult(boolean isSelectAll, List<CapturedMobileElement> selectedElements, FolderTreeEntity selectedParentFolder, ConflictOptions selectedConflictOption, int selectedElementCount) {
            this.isSelectAll = isSelectAll;
            this.selectedParentFolder = selectedParentFolder;
            this.allSelectedElements = selectedElements;
            this.selectedConflictOption = selectedConflictOption;
            this.selectedElementCount = selectedElementCount;
            this.allConflictedElementEntities = new LinkedList<MobileElementEntity>();
        }

        public AddToObjectRepositoryDialogResult(boolean isSelectAll, List<CapturedMobileElement> selectedElements, FolderTreeEntity selectedParentFolder, ConflictOptions selectedConflictOption, int selectedElementCount, List<MobileElementEntity> allConflictedElementEntities) {
            this.isSelectAll = isSelectAll;
            this.selectedParentFolder = selectedParentFolder;
            this.allSelectedElements = selectedElements;
            this.selectedConflictOption = selectedConflictOption;
            this.selectedElementCount = selectedElementCount;
            this.allConflictedElementEntities = allConflictedElementEntities;
        }

        public boolean isSelectAll() {
            return this.isSelectAll;
        }

        public List<CapturedMobileElement> getAllSelectedElement() {
            return this.allSelectedElements;
        }

        public FolderTreeEntity getSelectedParentFolder() {
            return this.selectedParentFolder;
        }

        public ConflictOptions getSelectedConflictOption() {
            return this.selectedConflictOption;
        }

        public int getSelectedElementCount() {
            return this.selectedElementCount;
        }

        public List<MobileElementEntity> getAllConflictedElementEntities() {
            return this.allConflictedElementEntities;
        }
    }

    public static enum ConflictOptions {
        CREATE_NEW_OBJECT,
        REPLACE_EXISTING_OBJECT,
        MERGE_CHANGE_TO_EXISTING_OBJECT;

    }
}

