/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.util;

import java.util.Arrays;

public class IOSIssueDetective {
    private static final String[] WEBDRIVERAGENT_ERROR_SYMPTOMS = new String[]{"xcodebuild", "webdriveragent"};
    private static final String[] DEPENDENCIES_ERROR_SYMPTOMS = new String[]{"dependency", "upgrade to version", "architecture is unsupported", "please verify your appium installation", "cannot find appium executable file"};

    public static StartIOSErrorType detectIssueFromMessage(String message) {
        message = message.toLowerCase();
        if (Arrays.stream(DEPENDENCIES_ERROR_SYMPTOMS).anyMatch(message::contains)) {
            return StartIOSErrorType.DEPENDENCIES;
        }
        if (Arrays.stream(WEBDRIVERAGENT_ERROR_SYMPTOMS).anyMatch(message::contains)) {
            return StartIOSErrorType.WEB_DRIVER_AGENT;
        }
        return StartIOSErrorType.UNDEFINED;
    }

    public static enum StartIOSErrorType {
        DEPENDENCIES,
        WEB_DRIVER_AGENT,
        UNDEFINED;

    }
}

