/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.objectrepository.provider;

import com.kms.katalon.composer.objectrepository.view.ObjectXpathTableRow;
import com.kms.katalon.entity.repository.WebElementXpathEntity;
import java.util.List;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public class ObjectXpathsTableViewer
extends TableViewer {
    private IEventBroker eventBroker;
    private List<WebElementXpathEntity> data;
    private Table xpathTable = this.getTable();

    public ObjectXpathsTableViewer(Composite parent, int style, IEventBroker eventBroker) {
        super(parent, style);
        this.eventBroker = eventBroker;
    }

    public void setInput(List<WebElementXpathEntity> data) {
        this.data = data;
        super.setInput(data);
        this.eventBroker.post("OBJECT/UPDATE_IS_SELECTED_COLUMN_HEADER", (Object)this);
    }

    public void addRow(WebElementXpathEntity xpath) {
        this.data.add(xpath);
        this.update(xpath, null);
        this.refresh();
        this.xpathTable.setSelection(this.data.size() - 1);
        this.eventBroker.post("OBJECT/UPDATE_DIRTY", (Object)this);
    }

    public void addRows(List<WebElementXpathEntity> xpaths) {
        int lastIndex = this.data.size();
        this.data.addAll(xpaths);
        this.update(xpaths, null);
        this.refresh();
        this.xpathTable.setSelection(lastIndex, this.data.size() - 1);
        this.eventBroker.post("OBJECT/UPDATE_DIRTY", (Object)this);
    }

    public void addRowsWithPosition(List<ObjectXpathTableRow> xpaths) {
        for (ObjectXpathTableRow row : xpaths) {
            this.data.add(row.getPosition(), row.getWebElementXpathEntity());
        }
        this.refresh();
        this.xpathTable.deselectAll();
        for (ObjectXpathTableRow row : xpaths) {
            this.xpathTable.select(row.getPosition());
        }
        this.eventBroker.post("OBJECT/UPDATE_DIRTY", (Object)this);
    }

    public void deleteRows(List<WebElementXpathEntity> properties) {
        this.data.removeAll(properties);
        this.refresh();
        this.xpathTable.deselectAll();
        this.eventBroker.post("OBJECT/UPDATE_DIRTY", (Object)this);
    }

    public void deleteRow(WebElementXpathEntity property) {
        this.data.remove(property);
        this.refresh();
        this.xpathTable.deselectAll();
        this.eventBroker.post("OBJECT/UPDATE_DIRTY", (Object)this);
    }

    public void clear() {
        this.data.clear();
        this.refresh();
        this.eventBroker.post("OBJECT/UPDATE_DIRTY", (Object)this);
    }

    public List<WebElementXpathEntity> getInput() {
        return this.data;
    }
}

