/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.objectrepository.support;

import com.kms.katalon.composer.objectrepository.part.TestObjectPart;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;

public class PropertyConditionEditingSupport
extends EditingSupport {
    private TableViewer viewer;
    private IEventBroker eventBroker;
    private TestObjectPart testObjectPart;

    public PropertyConditionEditingSupport(TableViewer viewer, IEventBroker eventBroker, TestObjectPart testObjectPart) {
        super((ColumnViewer)viewer);
        this.viewer = viewer;
        this.eventBroker = eventBroker;
        this.testObjectPart = testObjectPart;
    }

    protected CellEditor getCellEditor(Object element) {
        if (element != null && element instanceof WebElementPropertyEntity) {
            return new CustomComboBoxCellEditor((Composite)this.viewer.getTable(), WebElementPropertyEntity.MATCH_CONDITION.getTextValues(), 0);
        }
        return null;
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected Object getValue(Object element) {
        if (element != null && element instanceof WebElementPropertyEntity) {
            WebElementPropertyEntity webProperty = (WebElementPropertyEntity)element;
            return WebElementPropertyEntity.MATCH_CONDITION.indexOf((String)webProperty.getMatchCondition());
        }
        return -1;
    }

    protected void setValue(Object element, Object value) {
        if (element instanceof WebElementPropertyEntity && value instanceof Integer) {
            int index = (Integer)value;
            if (index < 0) {
                return;
            }
            this.testObjectPart.executeOperation((IUndoableOperation)new PropertyConditionChangeOperation((WebElementPropertyEntity)element, WebElementPropertyEntity.MATCH_CONDITION.values()[index].getText()));
        }
    }

    private class CustomComboBoxCellEditor
    extends ComboBoxCellEditor {
        public CustomComboBoxCellEditor(Composite parent, String[] items, int style) {
            super(parent, items, style);
        }

        public CellEditor.LayoutData getLayoutData() {
            CellEditor.LayoutData layoutData = super.getLayoutData();
            layoutData.minimumHeight = PropertyConditionEditingSupport.this.viewer.getTable().getItemHeight();
            return layoutData;
        }
    }

    private class PropertyConditionChangeOperation
    extends AbstractOperation {
        private WebElementPropertyEntity property;
        private String newValue;
        private String oldValue;

        public PropertyConditionChangeOperation(WebElementPropertyEntity property, String value) {
            super(PropertyConditionChangeOperation.class.getName());
            this.property = property;
            this.oldValue = property.getMatchCondition();
            this.newValue = value;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.newValue.equals(this.oldValue)) {
                return Status.CANCEL_STATUS;
            }
            return this.doSetItemValue(this.newValue);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.doSetItemValue(this.newValue);
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.doSetItemValue(this.oldValue);
        }

        protected IStatus doSetItemValue(String itemValue) {
            this.property.setMatchCondition(itemValue);
            PropertyConditionEditingSupport.this.viewer.update((Object)this.property, null);
            PropertyConditionEditingSupport.this.eventBroker.post("OBJECT/UPDATE_DIRTY", (Object)PropertyConditionEditingSupport.this.viewer);
            return Status.OK_STATUS;
        }
    }
}

