/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.objectrepository.support;

import com.kms.katalon.composer.objectrepository.part.TestObjectPart;
import com.kms.katalon.composer.objectrepository.provider.ObjectPropetiesTableViewer;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.swt.widgets.Composite;

public class PropertySelectedEditingSupport
extends EditingSupport {
    private ObjectPropetiesTableViewer viewer;
    private IEventBroker eventBroker;
    private TestObjectPart testObjectPart;

    public PropertySelectedEditingSupport(ObjectPropetiesTableViewer viewer, IEventBroker eventBroker, TestObjectPart testObjectPart) {
        super((ColumnViewer)viewer);
        this.viewer = viewer;
        this.eventBroker = eventBroker;
        this.testObjectPart = testObjectPart;
    }

    protected CellEditor getCellEditor(Object element) {
        return new CheckboxCellEditor((Composite)this.viewer.getTable());
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected Object getValue(Object element) {
        if (element instanceof WebElementPropertyEntity) {
            WebElementPropertyEntity property = (WebElementPropertyEntity)element;
            return property.getIsSelected();
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        if (element instanceof WebElementPropertyEntity && value instanceof Boolean) {
            this.testObjectPart.executeOperation((IUndoableOperation)new PropertySelectChangeOperation((WebElementPropertyEntity)element, (Boolean)value));
        }
    }

    private class PropertySelectChangeOperation
    extends AbstractOperation {
        private WebElementPropertyEntity property;
        private boolean value;

        public PropertySelectChangeOperation(WebElementPropertyEntity property, boolean value) {
            super(PropertySelectChangeOperation.class.getName());
            this.property = property;
            this.value = value;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.value == this.property.getIsSelected()) {
                return Status.CANCEL_STATUS;
            }
            return this.doSetItemValue(this.value);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.doSetItemValue(this.value);
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.doSetItemValue(!this.value);
        }

        protected IStatus doSetItemValue(boolean itemValue) {
            this.property.setIsSelected(Boolean.valueOf(itemValue));
            PropertySelectedEditingSupport.this.viewer.refreshIsSelected();
            PropertySelectedEditingSupport.this.viewer.update(this.property, null);
            PropertySelectedEditingSupport.this.eventBroker.post("OBJECT/UPDATE_DIRTY", (Object)PropertySelectedEditingSupport.this.viewer);
            return Status.OK_STATUS;
        }
    }
}

