/*
 * Decompiled with CFR 0.152.
 */
package atu.testrecorder.media.avi;

import atu.testrecorder.media.AbstractVideoCodec;
import atu.testrecorder.media.Buffer;
import atu.testrecorder.media.Format;
import atu.testrecorder.media.VideoFormat;
import atu.testrecorder.media.io.SeekableByteArrayOutputStream;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;

public class DIBCodec
extends AbstractVideoCodec {
    @Override
    public Format setInputFormat(Format f) {
        if (f instanceof VideoFormat) {
            VideoFormat vf = (VideoFormat)f;
            int depth = vf.getDepth();
            depth = depth <= 4 ? 4 : (depth <= 8 ? 8 : 24);
            if (BufferedImage.class.isAssignableFrom(vf.getDataClass())) {
                return super.setInputFormat(new VideoFormat("image", vf.getDataClass(), vf.getWidth(), vf.getHeight(), depth));
            }
        }
        return super.setInputFormat(null);
    }

    @Override
    public Format setOutputFormat(Format f) {
        if (f instanceof VideoFormat) {
            VideoFormat vf = (VideoFormat)f;
            int depth = vf.getDepth();
            depth = depth <= 4 ? 4 : (depth <= 8 ? 8 : 24);
            return super.setOutputFormat(new VideoFormat("DIB ", byte[].class, vf.getWidth(), vf.getHeight(), depth));
        }
        return super.setOutputFormat(null);
    }

    @Override
    public void process(Buffer in, Buffer out) {
        Rectangle r;
        int scanlineStride;
        if ((in.flags & 2) != 0) {
            out.flags = 2;
            return;
        }
        out.format = this.outputFormat;
        SeekableByteArrayOutputStream tmp = out.data instanceof byte[] ? new SeekableByteArrayOutputStream((byte[])out.data) : new SeekableByteArrayOutputStream();
        VideoFormat vf = (VideoFormat)this.outputFormat;
        if (in.data instanceof BufferedImage) {
            BufferedImage image = (BufferedImage)in.data;
            WritableRaster raster = image.getRaster();
            scanlineStride = raster.getSampleModel().getWidth();
            r = raster.getBounds();
            r.x -= raster.getSampleModelTranslateX();
            r.y -= raster.getSampleModelTranslateY();
        } else {
            r = new Rectangle(0, 0, vf.getWidth(), vf.getHeight());
            scanlineStride = vf.getWidth();
        }
        try {
            switch (vf.getDepth()) {
                case 4: {
                    Object[] pixels = this.getIndexed8(in);
                    if (pixels == null) {
                        out.flags = 2;
                        return;
                    }
                    this.writeKey4(tmp, (byte[])pixels, r.width, r.height, r.x + r.y * scanlineStride, scanlineStride);
                    break;
                }
                case 8: {
                    Object[] pixels = this.getIndexed8(in);
                    if (pixels == null) {
                        out.flags = 2;
                        return;
                    }
                    this.writeKey8(tmp, (byte[])pixels, r.width, r.height, r.x + r.y * scanlineStride, scanlineStride);
                    break;
                }
                case 24: {
                    Object[] pixels = this.getRGB24(in);
                    if (pixels == null) {
                        out.flags = 2;
                        return;
                    }
                    this.writeKey24(tmp, (int[])pixels, r.width, r.height, r.x + r.y * scanlineStride, scanlineStride);
                    break;
                }
                default: {
                    out.flags = 2;
                    return;
                }
            }
            out.flags = 16;
            out.data = tmp.getBuffer();
            out.offset = 0;
            out.length = (int)tmp.getStreamPosition();
            return;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            out.flags = 2;
            return;
        }
    }

    public void writeKey4(OutputStream out, byte[] pixels, int width, int height, int offset, int scanlineStride) throws IOException {
        byte[] bytes = new byte[width];
        int y = (height - 1) * scanlineStride;
        while (y >= 0) {
            int x = offset;
            int xx = 0;
            int n = offset + width;
            while (x < n) {
                bytes[xx] = (byte)((pixels[y + x] & 0xF) << 4 | pixels[y + x + 1] & 0xF);
                x += 2;
                ++xx;
            }
            out.write(bytes);
            y -= scanlineStride;
        }
    }

    public void writeKey8(OutputStream out, byte[] pixels, int width, int height, int offset, int scanlineStride) throws IOException {
        int y = (height - 1) * scanlineStride;
        while (y >= 0) {
            out.write(pixels, y + offset, width);
            y -= scanlineStride;
        }
    }

    public void writeKey24(OutputStream out, int[] pixels, int width, int height, int offset, int scanlineStride) throws IOException {
        int w3 = width * 3;
        byte[] bytes = new byte[w3];
        int xy = (height - 1) * scanlineStride + offset;
        while (xy >= offset) {
            int x = 0;
            int xp = 0;
            while (x < w3) {
                int p = pixels[xy + xp];
                bytes[x] = (byte)p;
                bytes[x + 1] = (byte)(p >> 8);
                bytes[x + 2] = (byte)(p >> 16);
                x += 3;
                ++xp;
            }
            out.write(bytes);
            xy -= scanlineStride;
        }
    }
}

