/*
 * Decompiled with CFR 0.152.
 */
package atu.testrecorder.media.avi;

import atu.testrecorder.media.AbstractVideoCodec;
import atu.testrecorder.media.Buffer;
import atu.testrecorder.media.Format;
import atu.testrecorder.media.VideoFormat;
import atu.testrecorder.media.io.ByteArrayImageOutputStream;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageOutputStream;

public class RunLengthCodec
extends AbstractVideoCodec {
    private byte[] previousPixels;

    @Override
    public Format setInputFormat(Format f) {
        VideoFormat vf;
        if (f instanceof VideoFormat && BufferedImage.class.isAssignableFrom((vf = (VideoFormat)f).getDataClass())) {
            return super.setInputFormat(new VideoFormat("image", vf.getDataClass(), vf.getWidth(), vf.getHeight(), 8));
        }
        return super.setInputFormat(null);
    }

    @Override
    public Format setOutputFormat(Format f) {
        if (f instanceof VideoFormat) {
            VideoFormat vf = (VideoFormat)f;
            return super.setOutputFormat(new VideoFormat("RLE ", byte[].class, vf.getWidth(), vf.getHeight(), 8));
        }
        return super.setOutputFormat(null);
    }

    @Override
    public void process(Buffer in, Buffer out) {
        Rectangle r;
        int scanlineStride;
        if ((in.flags & 2) != 0) {
            out.flags = 2;
            return;
        }
        out.format = this.outputFormat;
        ByteArrayImageOutputStream tmp = out.data instanceof byte[] ? new ByteArrayImageOutputStream((byte[])out.data) : new ByteArrayImageOutputStream();
        VideoFormat vf = (VideoFormat)this.outputFormat;
        if (in.data instanceof BufferedImage) {
            BufferedImage image = (BufferedImage)in.data;
            WritableRaster raster = image.getRaster();
            scanlineStride = raster.getSampleModel().getWidth();
            r = raster.getBounds();
            r.x -= raster.getSampleModelTranslateX();
            r.y -= raster.getSampleModelTranslateY();
        } else {
            r = new Rectangle(0, 0, vf.getWidth(), vf.getHeight());
            scanlineStride = vf.getWidth();
        }
        int offset = r.x + r.y * scanlineStride;
        try {
            byte[] pixels = this.getIndexed8(in);
            if (pixels == null) {
                throw new UnsupportedOperationException("Can not process buffer " + in);
            }
            if ((in.flags & 0x10) != 0 || this.previousPixels == null) {
                this.writeKey8(tmp, pixels, r.width, r.height, offset, scanlineStride);
                out.flags = 16;
            } else {
                this.writeDelta8(tmp, pixels, this.previousPixels, r.width, r.height, offset, scanlineStride);
                out.flags = 0;
            }
            out.data = tmp.getBuffer();
            out.offset = 0;
            out.length = (int)tmp.getStreamPosition();
            if (this.previousPixels == null) {
                this.previousPixels = (byte[])pixels.clone();
            } else {
                System.arraycopy(pixels, 0, this.previousPixels, 0, pixels.length);
            }
            return;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            out.flags = 2;
            return;
        }
    }

    public void writeKey8(OutputStream out, byte[] data, int width, int height, int offset, int scanlineStride) throws IOException {
        ByteArrayImageOutputStream buf = new ByteArrayImageOutputStream(data.length);
        this.writeKey8(buf, data, width, height, offset, scanlineStride);
        buf.toOutputStream(out);
    }

    public void writeKey8(ImageOutputStream out, byte[] data, int width, int height, int offset, int scanlineStride) throws IOException {
        out.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        int ymax = offset + height * scanlineStride;
        int upsideDown = ymax - scanlineStride + offset;
        int y = offset;
        while (y < ymax) {
            int xy = upsideDown - y;
            int xymax = xy + width;
            int literalCount = 0;
            int repeatCount = 0;
            while (xy < xymax) {
                byte v = data[xy];
                repeatCount = 0;
                while (xy < xymax && repeatCount < 255) {
                    if (data[xy] != v) break;
                    ++xy;
                    ++repeatCount;
                }
                xy -= repeatCount;
                if (repeatCount < 3) {
                    if (++literalCount == 254) {
                        out.write(0);
                        out.write(literalCount);
                        out.write(data, xy - literalCount + 1, literalCount);
                        literalCount = 0;
                    }
                } else {
                    if (literalCount > 0) {
                        if (literalCount < 3) {
                            while (literalCount > 0) {
                                out.write(1);
                                out.write(data[xy - literalCount]);
                                --literalCount;
                            }
                        } else {
                            out.write(0);
                            out.write(literalCount);
                            out.write(data, xy - literalCount, literalCount);
                            if (literalCount % 2 == 1) {
                                out.write(0);
                            }
                            literalCount = 0;
                        }
                    }
                    out.write(repeatCount);
                    out.write(v);
                    xy += repeatCount - 1;
                }
                ++xy;
            }
            if (literalCount > 0) {
                if (literalCount < 3) {
                    while (literalCount > 0) {
                        out.write(1);
                        out.write(data[xy - literalCount]);
                        --literalCount;
                    }
                } else {
                    out.write(0);
                    out.write(literalCount);
                    out.write(data, xy - literalCount, literalCount);
                    if (literalCount % 2 == 1) {
                        out.write(0);
                    }
                }
                literalCount = 0;
            }
            out.write(0);
            out.write(0);
            y += scanlineStride;
        }
        out.write(0);
        out.write(1);
    }

    public void writeDelta8(OutputStream out, byte[] data, byte[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        ByteArrayImageOutputStream buf = new ByteArrayImageOutputStream(data.length);
        this.writeDelta8(buf, data, prev, width, height, offset, scanlineStride);
        buf.toOutputStream(out);
    }

    /*
     * Unable to fully structure code
     */
    public void writeDelta8(ImageOutputStream out, byte[] data, byte[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        out.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        ymax = offset + height * scanlineStride;
        upsideDown = ymax - scanlineStride + offset;
        verticalOffset = 0;
        y = offset;
        while (y < ymax) {
            block18: {
                xy = upsideDown - y;
                xymax = xy + width;
                skipCount = 0;
                while (xy < xymax) {
                    if (data[xy] != prev[xy]) break;
                    ++xy;
                    ++skipCount;
                }
                if (skipCount != width) ** GOTO lbl29
                ++verticalOffset;
                break block18;
lbl-1000:
                // 1 sources

                {
                    if (verticalOffset == 1 && skipCount == 0) {
                        out.write(0);
                        out.write(0);
                        verticalOffset = 0;
                        continue;
                    }
                    out.write(0);
                    out.write(2);
                    out.write(Math.min(255, skipCount));
                    out.write(Math.min(255, verticalOffset));
                    skipCount -= Math.min(255, skipCount);
                    verticalOffset -= Math.min(255, verticalOffset);
lbl29:
                    // 3 sources

                    ** while (verticalOffset > 0 || skipCount > 0)
                }
lbl30:
                // 1 sources

                literalCount = 0;
                repeatCount = 0;
                while (xy < xymax) {
                    block19: {
                        skipCount = 0;
                        while (xy < xymax) {
                            if (data[xy] != prev[xy]) break;
                            ++xy;
                            ++skipCount;
                        }
                        v = data[xy -= skipCount];
                        repeatCount = 0;
                        while (xy < xymax && repeatCount < 255) {
                            if (data[xy] != v) break;
                            ++xy;
                            ++repeatCount;
                        }
                        if (skipCount >= 4 || (xy -= repeatCount) + skipCount >= xymax || repeatCount >= 3) ** GOTO lbl61
                        ++literalCount;
                        break block19;
lbl-1000:
                        // 1 sources

                        {
                            if (literalCount < 3) {
                                out.write(1);
                                out.write(data[xy - literalCount]);
                                --literalCount;
                                continue;
                            }
                            literalRun = Math.min(254, literalCount);
                            out.write(0);
                            out.write(literalRun);
                            out.write(data, xy - literalCount, literalRun);
                            if (literalRun % 2 == 1) {
                                out.write(0);
                            }
                            literalCount -= literalRun;
lbl61:
                            // 3 sources

                            ** while (literalCount > 0)
                        }
lbl62:
                        // 1 sources

                        if (xy + skipCount == xymax) {
                            xy += skipCount - 1;
                        } else if (skipCount >= repeatCount) {
                            while (skipCount > 0) {
                                out.write(0);
                                out.write(2);
                                out.write(Math.min(255, skipCount));
                                out.write(0);
                                xy += Math.min(255, skipCount);
                                skipCount -= Math.min(255, skipCount);
                            }
                            --xy;
                        } else {
                            out.write(repeatCount);
                            out.write(v);
                            xy += repeatCount - 1;
                        }
                    }
                    ++xy;
                }
                while (literalCount > 0) {
                    if (literalCount < 3) {
                        out.write(1);
                        out.write(data[xy - literalCount]);
                        --literalCount;
                        continue;
                    }
                    literalRun = Math.min(254, literalCount);
                    out.write(0);
                    out.write(literalRun);
                    out.write(data, xy - literalCount, literalRun);
                    if (literalRun % 2 == 1) {
                        out.write(0);
                    }
                    literalCount -= literalRun;
                }
                out.write(0);
                out.write(0);
            }
            y += scanlineStride;
        }
        out.write(0);
        out.write(1);
    }
}

