/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.builder;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.GroovyCoreActivator;
import org.codehaus.groovy.eclipse.core.compiler.CompilerUtils;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class GroovyClasspathContainer
implements IClasspathContainer {
    public static final String ID = "GROOVY_SUPPORT";
    public static final String NAME = "Groovy Libraries";
    private final IPath containerPath;
    private IClasspathEntry[] entries;

    public GroovyClasspathContainer(IPath containerPath) {
        this.containerPath = containerPath;
    }

    public synchronized IClasspathEntry[] getClasspathEntries() {
        if (this.entries == null) {
            this.entries = GroovyClasspathContainer.resolveEntries(this.containerPath);
        }
        return this.entries;
    }

    public String getDescription() {
        return NAME;
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.containerPath;
    }

    public synchronized void reset() {
        this.entries = null;
    }

    private static IClasspathEntry[] resolveEntries(IPath containerPath) {
        try {
            boolean minimalLibraries = containerPath.lastSegment().equals("minimal");
            LinkedHashSet<IPath> libraries = new LinkedHashSet<IPath>();
            libraries.add(CompilerUtils.getExportedGroovyAllJar());
            if (!minimalLibraries) {
                libraries.addAll(CompilerUtils.getExtraJarsForClasspath());
            }
            ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>(libraries.size());
            for (IPath jarPath : libraries) {
                IPath srcPath = CompilerUtils.getJarInGroovyLib(jarPath.removeFileExtension().lastSegment().replace("-indy", "") + "-sources.jar");
                IPath docPath = CompilerUtils.getJarInGroovyLib(jarPath.removeFileExtension().lastSegment().replace("-indy", "") + "-javadoc.jar");
                ArrayList<IClasspathAttribute> attrs = new ArrayList<IClasspathAttribute>();
                if (jarPath.lastSegment().startsWith("groovy-test")) {
                    attrs.add(JavaCore.newClasspathAttribute((String)"test", (String)"true"));
                }
                if (docPath != null) {
                    attrs.add(GroovyClasspathContainer.newJavadocLocationClasspathAttribute(docPath));
                }
                cpEntries.add(JavaCore.newLibraryEntry((IPath)jarPath, (IPath)srcPath, null, null, (IClasspathAttribute[])attrs.toArray(new IClasspathAttribute[attrs.size()]), (boolean)true));
            }
            if (!minimalLibraries && GroovyClasspathContainer.useGroovyLibs(containerPath)) {
                cpEntries.addAll(GroovyClasspathContainer.getJarsInDotGroovyLib());
            }
            return cpEntries.toArray(new IClasspathEntry[cpEntries.size()]);
        }
        catch (Exception e) {
            GroovyCore.logException("Failed to populate Groovy Libraries", e);
            return new IClasspathEntry[0];
        }
    }

    private static boolean useGroovyLibs(IPath containerPath) {
        if (containerPath.lastSegment().equals("user-libs=false")) {
            return false;
        }
        if (containerPath.lastSegment().equals("user-libs=true")) {
            return true;
        }
        return GroovyCoreActivator.getDefault().getPreference("groovy.classpath.use.groovy.lib.global", true);
    }

    private static Collection<IClasspathEntry> getJarsInDotGroovyLib() {
        File[] jars = CompilerUtils.findJarsInDotGroovyLocation();
        Predicate<File> isSources = file -> file.getName().endsWith("-sources.jar");
        Predicate<File> isJavadoc = file -> file.getName().endsWith("-javadoc.jar");
        return Arrays.stream(jars).filter(isSources.or(isJavadoc).negate()).map(file -> {
            IClasspathAttribute[] iClasspathAttributeArray;
            Path jarPath = new Path(file.getAbsolutePath());
            String srcName = jarPath.removeFileExtension().lastSegment().replace("-indy", "") + "-sources.jar";
            String docName = jarPath.removeFileExtension().lastSegment().replace("-indy", "") + "-javadoc.jar";
            IPath srcPath = Arrays.stream(jars).filter(isSources.and(srcFile -> srcFile.getName().equals(srcName))).findFirst().map(srcFile -> new Path(srcFile.getAbsolutePath())).orElse(null);
            IPath docPath = Arrays.stream(jars).filter(isJavadoc.and(docFile -> docFile.getName().equals(docName))).findFirst().map(docFile -> new Path(docFile.getAbsolutePath())).orElse(null);
            if (docPath == null) {
                iClasspathAttributeArray = null;
            } else {
                IClasspathAttribute[] iClasspathAttributeArray2 = new IClasspathAttribute[1];
                iClasspathAttributeArray = iClasspathAttributeArray2;
                iClasspathAttributeArray2[0] = GroovyClasspathContainer.newJavadocLocationClasspathAttribute(docPath);
            }
            IClasspathAttribute[] icas = iClasspathAttributeArray;
            return JavaCore.newLibraryEntry((IPath)jarPath, (IPath)srcPath, null, null, (IClasspathAttribute[])icas, (boolean)true);
        }).collect(Collectors.toList());
    }

    public static String getLegacyUserLibsPreference(IJavaProject project) {
        return new ProjectScope(project.getProject()).getNode("org.codehaus.groovy.eclipse.core").get("groovy.classpath.use.groovy,lib", "default");
    }

    public static boolean hasLegacyMinimalAttribute(IClasspathEntry entry) {
        IClasspathAttribute[] iClasspathAttributeArray = entry.getExtraAttributes();
        int n = iClasspathAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathAttribute attribute = iClasspathAttributeArray[n2];
            if (attribute.getName().equals("minimal")) {
                return Boolean.parseBoolean(attribute.getValue());
            }
            ++n2;
        }
        return false;
    }

    public static boolean hasMinimalAttribute(IClasspathEntry entry) {
        if (entry != null) {
            if (entry.getPath().lastSegment().equals("minimal")) {
                return true;
            }
            return GroovyClasspathContainer.hasLegacyMinimalAttribute(entry);
        }
        return false;
    }

    private static IClasspathAttribute newJavadocLocationClasspathAttribute(IPath docPath) {
        try {
            String name = "javadoc_location";
            String path = docPath.toFile().toURI().toURL().toString();
            return JavaCore.newClasspathAttribute((String)name, (String)("jar:" + path + "!/"));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

