/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.CaptureGroupTransformer;
import io.cucumber.cucumberexpressions.CucumberExpressionException;
import io.cucumber.cucumberexpressions.Transformer;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;

public final class ParameterType<T>
implements Comparable<ParameterType<?>> {
    private final String name;
    private final Type type;
    private final List<String> regexps;
    private final boolean preferForRegexpMatch;
    private final boolean useForSnippets;
    private final CaptureGroupTransformer<T> transformer;

    public ParameterType(String name, List<String> regexps, Type type, CaptureGroupTransformer<T> transformer, boolean useForSnippets, boolean preferForRegexpMatch) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        if (regexps == null) {
            throw new NullPointerException("regexps cannot be null");
        }
        if (type == null) {
            throw new NullPointerException("type cannot be null");
        }
        if (transformer == null) {
            throw new NullPointerException("transformer cannot be null");
        }
        this.name = name;
        this.regexps = regexps;
        this.type = type;
        this.transformer = transformer;
        this.useForSnippets = useForSnippets;
        this.preferForRegexpMatch = preferForRegexpMatch;
    }

    public ParameterType(String name, List<String> regexps, Class<T> type, CaptureGroupTransformer<T> transformer, boolean useForSnippets, boolean preferForRegexpMatch) {
        this(name, regexps, (Type)type, transformer, useForSnippets, preferForRegexpMatch);
    }

    public ParameterType(String name, String regexp, Class<T> type, CaptureGroupTransformer<T> transformer, boolean useForSnippets, boolean preferForRegexpMatch) {
        this(name, Collections.singletonList(regexp), type, transformer, useForSnippets, preferForRegexpMatch);
    }

    public ParameterType(String name, List<String> regexps, Class<T> type, CaptureGroupTransformer<T> transformer) {
        this(name, regexps, type, transformer, true, false);
    }

    public ParameterType(String name, String regexp, Class<T> type, CaptureGroupTransformer<T> transformer) {
        this(name, Collections.singletonList(regexp), type, transformer, true, false);
    }

    public ParameterType(String name, List<String> regexps, Type type, Transformer<T> transformer, boolean useForSnippets, boolean preferForRegexpMatch) {
        this(name, regexps, type, new TransformerAdaptor(transformer), useForSnippets, preferForRegexpMatch);
    }

    public ParameterType(String name, List<String> regexps, Class<T> type, Transformer<T> transformer, boolean useForSnippets, boolean preferForRegexpMatch) {
        this(name, regexps, (Type)type, transformer, useForSnippets, preferForRegexpMatch);
    }

    public ParameterType(String name, String regexp, Class<T> type, Transformer<T> transformer, boolean useForSnippets, boolean preferForRegexpMatch) {
        this(name, Collections.singletonList(regexp), type, transformer, useForSnippets, preferForRegexpMatch);
    }

    public ParameterType(String name, List<String> regexps, Class<T> type, Transformer<T> transformer) {
        this(name, regexps, type, transformer, true, false);
    }

    public ParameterType(String name, String regexp, Class<T> type, Transformer<T> transformer) {
        this(name, Collections.singletonList(regexp), type, transformer, true, false);
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public List<String> getRegexps() {
        return this.regexps;
    }

    public boolean preferForRegexpMatch() {
        return this.preferForRegexpMatch;
    }

    public boolean useForSnippets() {
        return this.useForSnippets;
    }

    T transform(List<String> groupValues) {
        if (this.transformer instanceof TransformerAdaptor && groupValues.size() > 1) {
            throw new CucumberExpressionException(String.format("ParameterType {%s} was registered with a Transformer but has multiple capture groups %s. Did you mean to use a CaptureGroupTransformer?", this.name, this.regexps));
        }
        try {
            String[] groupValueArray = groupValues.toArray(new String[groupValues.size()]);
            return this.transformer.transform(groupValueArray);
        }
        catch (Throwable throwable) {
            throw new CucumberExpressionException(String.format("ParameterType {%s} failed to transform %s to %s", this.name, groupValues, this.type), throwable);
        }
    }

    @Override
    public int compareTo(ParameterType<?> o) {
        if (this.preferForRegexpMatch() && !o.preferForRegexpMatch()) {
            return -1;
        }
        if (o.preferForRegexpMatch() && !this.preferForRegexpMatch()) {
            return 1;
        }
        return this.getName().compareTo(o.getName());
    }

    private static final class TransformerAdaptor<T>
    implements CaptureGroupTransformer<T> {
        private final Transformer<T> transformer;

        private TransformerAdaptor(Transformer<T> transformer) {
            if (transformer == null) {
                throw new NullPointerException("transformer cannot be null");
            }
            this.transformer = transformer;
        }

        @Override
        public T transform(String[] args) throws Throwable {
            return this.transformer.transform(args.length == 0 ? null : args[0]);
        }
    }
}

