/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v138.network.model;

import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v138.network.model.InterceptionStage;
import org.openqa.selenium.devtools.v138.network.model.ResourceType;
import org.openqa.selenium.json.JsonInput;

@Beta
public class RequestPattern {
    private final Optional<String> urlPattern;
    private final Optional<ResourceType> resourceType;
    private final Optional<InterceptionStage> interceptionStage;

    public RequestPattern(Optional<String> urlPattern, Optional<ResourceType> resourceType, Optional<InterceptionStage> interceptionStage) {
        this.urlPattern = urlPattern;
        this.resourceType = resourceType;
        this.interceptionStage = interceptionStage;
    }

    public Optional<String> getUrlPattern() {
        return this.urlPattern;
    }

    public Optional<ResourceType> getResourceType() {
        return this.resourceType;
    }

    public Optional<InterceptionStage> getInterceptionStage() {
        return this.interceptionStage;
    }

    private static RequestPattern fromJson(JsonInput input) {
        Optional<String> urlPattern = Optional.empty();
        Optional<ResourceType> resourceType = Optional.empty();
        Optional<InterceptionStage> interceptionStage = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "urlPattern": {
                    urlPattern = Optional.ofNullable(input.nextString());
                    continue block10;
                }
                case "resourceType": {
                    resourceType = Optional.ofNullable((ResourceType)((Object)input.read(ResourceType.class)));
                    continue block10;
                }
                case "interceptionStage": {
                    interceptionStage = Optional.ofNullable((InterceptionStage)((Object)input.read(InterceptionStage.class)));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new RequestPattern(urlPattern, resourceType, interceptionStage);
    }
}

