/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v138.storage.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v138.network.model.TimeSinceEpoch;
import org.openqa.selenium.devtools.v138.storage.model.AttributionReportingAggregatableDebugReportingConfig;
import org.openqa.selenium.devtools.v138.storage.model.AttributionReportingAggregationKeysEntry;
import org.openqa.selenium.devtools.v138.storage.model.AttributionReportingEventReportWindows;
import org.openqa.selenium.devtools.v138.storage.model.AttributionReportingFilterDataEntry;
import org.openqa.selenium.devtools.v138.storage.model.AttributionReportingNamedBudgetDef;
import org.openqa.selenium.devtools.v138.storage.model.AttributionReportingSourceType;
import org.openqa.selenium.devtools.v138.storage.model.AttributionReportingTriggerDataMatching;
import org.openqa.selenium.devtools.v138.storage.model.AttributionScopesData;
import org.openqa.selenium.devtools.v138.storage.model.SignedInt64AsBase10;
import org.openqa.selenium.devtools.v138.storage.model.UnsignedInt64AsBase10;
import org.openqa.selenium.json.JsonInput;

@Beta
public class AttributionReportingSourceRegistration {
    private final TimeSinceEpoch time;
    private final Integer expiry;
    private final List<Number> triggerData;
    private final AttributionReportingEventReportWindows eventReportWindows;
    private final Integer aggregatableReportWindow;
    private final AttributionReportingSourceType type;
    private final String sourceOrigin;
    private final String reportingOrigin;
    private final List<String> destinationSites;
    private final UnsignedInt64AsBase10 eventId;
    private final SignedInt64AsBase10 priority;
    private final List<AttributionReportingFilterDataEntry> filterData;
    private final List<AttributionReportingAggregationKeysEntry> aggregationKeys;
    private final Optional<UnsignedInt64AsBase10> debugKey;
    private final AttributionReportingTriggerDataMatching triggerDataMatching;
    private final SignedInt64AsBase10 destinationLimitPriority;
    private final AttributionReportingAggregatableDebugReportingConfig aggregatableDebugReportingConfig;
    private final Optional<AttributionScopesData> scopesData;
    private final Integer maxEventLevelReports;
    private final List<AttributionReportingNamedBudgetDef> namedBudgets;
    private final Boolean debugReporting;
    private final Number eventLevelEpsilon;

    public AttributionReportingSourceRegistration(TimeSinceEpoch time, Integer expiry, List<Number> triggerData, AttributionReportingEventReportWindows eventReportWindows, Integer aggregatableReportWindow, AttributionReportingSourceType type, String sourceOrigin, String reportingOrigin, List<String> destinationSites, UnsignedInt64AsBase10 eventId, SignedInt64AsBase10 priority, List<AttributionReportingFilterDataEntry> filterData, List<AttributionReportingAggregationKeysEntry> aggregationKeys, Optional<UnsignedInt64AsBase10> debugKey, AttributionReportingTriggerDataMatching triggerDataMatching, SignedInt64AsBase10 destinationLimitPriority, AttributionReportingAggregatableDebugReportingConfig aggregatableDebugReportingConfig, Optional<AttributionScopesData> scopesData, Integer maxEventLevelReports, List<AttributionReportingNamedBudgetDef> namedBudgets, Boolean debugReporting, Number eventLevelEpsilon) {
        this.time = Objects.requireNonNull(time, "time is required");
        this.expiry = Objects.requireNonNull(expiry, "expiry is required");
        this.triggerData = Objects.requireNonNull(triggerData, "triggerData is required");
        this.eventReportWindows = Objects.requireNonNull(eventReportWindows, "eventReportWindows is required");
        this.aggregatableReportWindow = Objects.requireNonNull(aggregatableReportWindow, "aggregatableReportWindow is required");
        this.type = Objects.requireNonNull(type, "type is required");
        this.sourceOrigin = Objects.requireNonNull(sourceOrigin, "sourceOrigin is required");
        this.reportingOrigin = Objects.requireNonNull(reportingOrigin, "reportingOrigin is required");
        this.destinationSites = Objects.requireNonNull(destinationSites, "destinationSites is required");
        this.eventId = Objects.requireNonNull(eventId, "eventId is required");
        this.priority = Objects.requireNonNull(priority, "priority is required");
        this.filterData = Objects.requireNonNull(filterData, "filterData is required");
        this.aggregationKeys = Objects.requireNonNull(aggregationKeys, "aggregationKeys is required");
        this.debugKey = debugKey;
        this.triggerDataMatching = Objects.requireNonNull(triggerDataMatching, "triggerDataMatching is required");
        this.destinationLimitPriority = Objects.requireNonNull(destinationLimitPriority, "destinationLimitPriority is required");
        this.aggregatableDebugReportingConfig = Objects.requireNonNull(aggregatableDebugReportingConfig, "aggregatableDebugReportingConfig is required");
        this.scopesData = scopesData;
        this.maxEventLevelReports = Objects.requireNonNull(maxEventLevelReports, "maxEventLevelReports is required");
        this.namedBudgets = Objects.requireNonNull(namedBudgets, "namedBudgets is required");
        this.debugReporting = Objects.requireNonNull(debugReporting, "debugReporting is required");
        this.eventLevelEpsilon = Objects.requireNonNull(eventLevelEpsilon, "eventLevelEpsilon is required");
    }

    public TimeSinceEpoch getTime() {
        return this.time;
    }

    public Integer getExpiry() {
        return this.expiry;
    }

    public List<Number> getTriggerData() {
        return this.triggerData;
    }

    public AttributionReportingEventReportWindows getEventReportWindows() {
        return this.eventReportWindows;
    }

    public Integer getAggregatableReportWindow() {
        return this.aggregatableReportWindow;
    }

    public AttributionReportingSourceType getType() {
        return this.type;
    }

    public String getSourceOrigin() {
        return this.sourceOrigin;
    }

    public String getReportingOrigin() {
        return this.reportingOrigin;
    }

    public List<String> getDestinationSites() {
        return this.destinationSites;
    }

    public UnsignedInt64AsBase10 getEventId() {
        return this.eventId;
    }

    public SignedInt64AsBase10 getPriority() {
        return this.priority;
    }

    public List<AttributionReportingFilterDataEntry> getFilterData() {
        return this.filterData;
    }

    public List<AttributionReportingAggregationKeysEntry> getAggregationKeys() {
        return this.aggregationKeys;
    }

    public Optional<UnsignedInt64AsBase10> getDebugKey() {
        return this.debugKey;
    }

    public AttributionReportingTriggerDataMatching getTriggerDataMatching() {
        return this.triggerDataMatching;
    }

    public SignedInt64AsBase10 getDestinationLimitPriority() {
        return this.destinationLimitPriority;
    }

    public AttributionReportingAggregatableDebugReportingConfig getAggregatableDebugReportingConfig() {
        return this.aggregatableDebugReportingConfig;
    }

    public Optional<AttributionScopesData> getScopesData() {
        return this.scopesData;
    }

    public Integer getMaxEventLevelReports() {
        return this.maxEventLevelReports;
    }

    public List<AttributionReportingNamedBudgetDef> getNamedBudgets() {
        return this.namedBudgets;
    }

    public Boolean getDebugReporting() {
        return this.debugReporting;
    }

    public Number getEventLevelEpsilon() {
        return this.eventLevelEpsilon;
    }

    private static AttributionReportingSourceRegistration fromJson(JsonInput input) {
        TimeSinceEpoch time = null;
        Integer expiry = 0;
        List triggerData = null;
        AttributionReportingEventReportWindows eventReportWindows = null;
        Integer aggregatableReportWindow = 0;
        AttributionReportingSourceType type = null;
        String sourceOrigin = null;
        String reportingOrigin = null;
        List destinationSites = null;
        UnsignedInt64AsBase10 eventId = null;
        SignedInt64AsBase10 priority = null;
        List filterData = null;
        List aggregationKeys = null;
        Optional<UnsignedInt64AsBase10> debugKey = Optional.empty();
        AttributionReportingTriggerDataMatching triggerDataMatching = null;
        SignedInt64AsBase10 destinationLimitPriority = null;
        AttributionReportingAggregatableDebugReportingConfig aggregatableDebugReportingConfig = null;
        Optional<AttributionScopesData> scopesData = Optional.empty();
        Integer maxEventLevelReports = 0;
        List namedBudgets = null;
        Boolean debugReporting = false;
        Number eventLevelEpsilon = 0;
        input.beginObject();
        block48: while (input.hasNext()) {
            switch (input.nextName()) {
                case "time": {
                    time = (TimeSinceEpoch)input.read(TimeSinceEpoch.class);
                    continue block48;
                }
                case "expiry": {
                    expiry = input.nextNumber().intValue();
                    continue block48;
                }
                case "triggerData": {
                    triggerData = input.readArray(Number.class);
                    continue block48;
                }
                case "eventReportWindows": {
                    eventReportWindows = (AttributionReportingEventReportWindows)input.read(AttributionReportingEventReportWindows.class);
                    continue block48;
                }
                case "aggregatableReportWindow": {
                    aggregatableReportWindow = input.nextNumber().intValue();
                    continue block48;
                }
                case "type": {
                    type = (AttributionReportingSourceType)((Object)input.read(AttributionReportingSourceType.class));
                    continue block48;
                }
                case "sourceOrigin": {
                    sourceOrigin = input.nextString();
                    continue block48;
                }
                case "reportingOrigin": {
                    reportingOrigin = input.nextString();
                    continue block48;
                }
                case "destinationSites": {
                    destinationSites = input.readArray(String.class);
                    continue block48;
                }
                case "eventId": {
                    eventId = (UnsignedInt64AsBase10)input.read(UnsignedInt64AsBase10.class);
                    continue block48;
                }
                case "priority": {
                    priority = (SignedInt64AsBase10)input.read(SignedInt64AsBase10.class);
                    continue block48;
                }
                case "filterData": {
                    filterData = input.readArray(AttributionReportingFilterDataEntry.class);
                    continue block48;
                }
                case "aggregationKeys": {
                    aggregationKeys = input.readArray(AttributionReportingAggregationKeysEntry.class);
                    continue block48;
                }
                case "debugKey": {
                    debugKey = Optional.ofNullable((UnsignedInt64AsBase10)input.read(UnsignedInt64AsBase10.class));
                    continue block48;
                }
                case "triggerDataMatching": {
                    triggerDataMatching = (AttributionReportingTriggerDataMatching)((Object)input.read(AttributionReportingTriggerDataMatching.class));
                    continue block48;
                }
                case "destinationLimitPriority": {
                    destinationLimitPriority = (SignedInt64AsBase10)input.read(SignedInt64AsBase10.class);
                    continue block48;
                }
                case "aggregatableDebugReportingConfig": {
                    aggregatableDebugReportingConfig = (AttributionReportingAggregatableDebugReportingConfig)input.read(AttributionReportingAggregatableDebugReportingConfig.class);
                    continue block48;
                }
                case "scopesData": {
                    scopesData = Optional.ofNullable((AttributionScopesData)input.read(AttributionScopesData.class));
                    continue block48;
                }
                case "maxEventLevelReports": {
                    maxEventLevelReports = input.nextNumber().intValue();
                    continue block48;
                }
                case "namedBudgets": {
                    namedBudgets = input.readArray(AttributionReportingNamedBudgetDef.class);
                    continue block48;
                }
                case "debugReporting": {
                    debugReporting = input.nextBoolean();
                    continue block48;
                }
                case "eventLevelEpsilon": {
                    eventLevelEpsilon = input.nextNumber();
                    continue block48;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AttributionReportingSourceRegistration(time, expiry, triggerData, eventReportWindows, aggregatableReportWindow, type, sourceOrigin, reportingOrigin, destinationSites, eventId, priority, filterData, aggregationKeys, debugKey, triggerDataMatching, destinationLimitPriority, aggregatableDebugReportingConfig, scopesData, maxEventLevelReports, namedBudgets, debugReporting, eventLevelEpsilon);
    }
}

