/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.groovy.util;

import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class GroovyRefreshUtil {
    public static void refreshFolder(String folderRelativePath, ProjectEntity projectEntity, IProgressMonitor monitor) throws CoreException {
        IProject project = GroovyUtil.getGroovyProject(projectEntity);
        IFolder resource = project.getFolder(folderRelativePath.replace(File.separator, "/"));
        resource.refreshLocal(2, monitor);
    }

    public static void refreshFile(String fileRelativePath, ProjectEntity projectEntity) throws CoreException {
        IProject project = GroovyUtil.getGroovyProject(projectEntity);
        IFile resource = project.getFile(fileRelativePath.replace(File.separator, "/"));
        resource.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void updateScriptReferencesInTestCaseAndCustomScripts(String oldScript, String newScript, ProjectEntity projectEntity) throws CoreException, IOException {
        GroovyRefreshUtil.updateScriptReferencesInTestCaseScripts(oldScript, newScript, projectEntity);
        GroovyRefreshUtil.updateScriptReferencesInCustomKeywordScripts(oldScript, newScript, projectEntity);
    }

    private static void updateScriptFile(String oldScript, String newScript, IFile scriptFile) throws CoreException, IOException {
        InputStream scriptFileStreamContent = scriptFile.getContents();
        InputStream newScriptFileInputStream = null;
        try {
            String testCaseContent = IOUtils.toString((InputStream)scriptFileStreamContent, (String)"UTF-8");
            scriptFileStreamContent.close();
            scriptFileStreamContent = null;
            if (testCaseContent.contains(oldScript)) {
                String newTestCaseContent = testCaseContent.replace(oldScript, newScript);
                newScriptFileInputStream = IOUtils.toInputStream((String)newTestCaseContent, (String)"UTF-8");
                scriptFile.setContents(newScriptFileInputStream, true, false, (IProgressMonitor)new NullProgressMonitor());
                scriptFile.getParent().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        finally {
            if (scriptFileStreamContent != null) {
                scriptFileStreamContent.close();
            }
            if (newScriptFileInputStream != null) {
                newScriptFileInputStream.close();
            }
        }
    }

    private static void updateScriptReferencesInTestCaseScripts(String oldScript, String newScript, ProjectEntity projectEntity) throws CoreException, IOException {
        List<IFile> testCaseFiles = GroovyUtil.getAllTestCaseScripts(projectEntity);
        for (IFile scriptFile : testCaseFiles) {
            GroovyRefreshUtil.updateScriptFile(oldScript, newScript, scriptFile);
        }
    }

    private static void updateScriptReferencesInCustomKeywordScripts(String oldScript, String newScript, ProjectEntity projectEntity) throws CoreException, IOException {
        List<IFile> customKeywordFiles = GroovyUtil.getAllCustomKeywordsScripts(projectEntity);
        for (IFile scriptFile : customKeywordFiles) {
            GroovyRefreshUtil.updateScriptFile(oldScript, newScript, scriptFile);
        }
    }
}

