/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.steps.jdt;

import cucumber.eclipse.steps.integration.AbstractStepDefinitionsProvider;
import cucumber.eclipse.steps.integration.ExpressionDefinition;
import cucumber.eclipse.steps.integration.StepDefinition;
import cucumber.eclipse.steps.integration.marker.MarkerFactory;
import cucumber.eclipse.steps.jdt.CucumberAnnotation;
import cucumber.eclipse.steps.jdt.JavaParser;
import cucumber.eclipse.steps.jdt.MethodDefinition;
import cucumber.eclipse.steps.jdt.filter.CompilationUnitStepDefinitionsPreferencesFilter;
import cucumber.eclipse.steps.jdt.filter.MethodStepDefinitionsPreferencesFilter;
import cucumber.eclipse.steps.jdt.ui.CucumberJavaPreferences;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;

public class JavaStepDefinitionsProvider
extends AbstractStepDefinitionsProvider {
    protected static JavaStepDefinitionsProvider INSTANCE = new JavaStepDefinitionsProvider();
    private final Pattern cukeAnnotationMatcher = Pattern.compile("cucumber\\.api\\.java\\.([a-z_]+)\\.(.*)$");
    private static final String CUCUMBER_API_JAVA = "cucumber.api.java.";
    private static final String CUCUMBER_API_JAVA8 = "cucumber.api.java8.";
    private static final String REGEX_JAVA8_CUKEAPI = "cucumber\\.api\\.java8\\.(.*)";

    private JavaStepDefinitionsProvider() {
    }

    protected static JavaStepDefinitionsProvider getInstance() {
        return INSTANCE;
    }

    private List<StepDefinition> getCukeSteps(ICompilationUnit iCompUnit, MarkerFactory markerFactory, IProgressMonitor progressMonitor) throws JavaModelException, CoreException {
        long start = System.currentTimeMillis();
        ArrayList<StepDefinition> steps = new ArrayList<StepDefinition>();
        try {
            Object object;
            IImportDeclaration[] allimports;
            ArrayList<CucumberAnnotation> importedAnnotations = new ArrayList<CucumberAnnotation>();
            IImportDeclaration[] iImportDeclarationArray = allimports = iCompUnit.getImports();
            int n = allimports.length;
            int n2 = 0;
            while (n2 < n) {
                IImportDeclaration decl = iImportDeclarationArray[n2];
                Matcher m = this.cukeAnnotationMatcher.matcher(decl.getElementName());
                if (m.find()) {
                    if ("*".equals(m.group(2))) {
                        importedAnnotations.addAll(this.getAllAnnotationsInPackage(iCompUnit.getJavaProject(), CUCUMBER_API_JAVA + m.group(1), m.group(1)));
                    } else {
                        importedAnnotations.add(new CucumberAnnotation(m.group(2), m.group(1)));
                    }
                }
                if (decl.getElementName().matches(REGEX_JAVA8_CUKEAPI)) {
                    object = decl.getElementName();
                }
                ++n2;
            }
            List<MethodDeclaration> methodDeclList = null;
            JavaParser javaParser = null;
            object = iCompUnit.getTypes();
            int n3 = ((IType[])object).length;
            int n4 = 0;
            while (n4 < n3) {
                int n5;
                IType t = object[n4];
                IResource resource = iCompUnit.getResource();
                IType[] iTypeArray = t.newTypeHierarchy(progressMonitor).getAllInterfaces();
                int n6 = iTypeArray.length;
                int n7 = 0;
                while (n7 < n6) {
                    IType ifType = iTypeArray[n7];
                    if (ifType.isInterface() && ifType.getFullyQualifiedName().startsWith(CUCUMBER_API_JAVA8)) {
                        String[] superInterfaceNames;
                        String[] stringArray = superInterfaceNames = ifType.getSuperInterfaceNames();
                        int n8 = superInterfaceNames.length;
                        n5 = 0;
                        while (n5 < n8) {
                            String superIfName = stringArray[n5];
                            if (superIfName.endsWith(".LambdaGlueBase")) {
                                if (javaParser == null) {
                                    javaParser = new JavaParser(iCompUnit, progressMonitor);
                                }
                                if (methodDeclList == null) {
                                    methodDeclList = javaParser.getAllMethods();
                                }
                                HashSet<String> keyWords = new HashSet<String>();
                                IMethod[] iMethodArray = ifType.getMethods();
                                int n9 = iMethodArray.length;
                                int n10 = 0;
                                while (n10 < n9) {
                                    IMethod method = iMethodArray[n10];
                                    keyWords.add(method.getElementName());
                                    ++n10;
                                }
                                ArrayList<MethodDefinition> methodDefList = new ArrayList<MethodDefinition>();
                                for (MethodDeclaration method : methodDeclList) {
                                    List statementList;
                                    if (!this.isCukeLambdaExpr(method, keyWords) || (statementList = method.getBody().statements()).isEmpty()) continue;
                                    MethodDefinition definition = new MethodDefinition(method.getName(), method.getReturnType2(), statementList);
                                    methodDefList.add(definition);
                                }
                                for (MethodDefinition method : methodDefList) {
                                    for (Statement statement : method.getMethodBodyList()) {
                                        String lambdaStep = method.getLambdaStep(statement, keyWords);
                                        if (lambdaStep == null) continue;
                                        int lineNumber = javaParser.getLineNumber(statement);
                                        ExpressionDefinition expression = new ExpressionDefinition(lambdaStep, method.getCukeLang());
                                        StepDefinition step = new StepDefinition(ifType.getHandleIdentifier(), StepDefinition.NO_LABEL, expression, resource, lineNumber, method.getMethodName(), t.getPackageFragment().getElementName());
                                        steps.add(step);
                                    }
                                }
                            }
                            ++n5;
                        }
                    }
                    ++n7;
                }
                iTypeArray = t.getMethods();
                n6 = iTypeArray.length;
                n7 = 0;
                while (n7 < n6) {
                    IType method = iTypeArray[n7];
                    IAnnotation[] iAnnotationArray = method.getAnnotations();
                    n5 = iAnnotationArray.length;
                    int n11 = 0;
                    while (n11 < n5) {
                        IAnnotation annotation = iAnnotationArray[n11];
                        CucumberAnnotation cukeAnnotation = this.getCukeAnnotation(importedAnnotations, annotation);
                        if (cukeAnnotation != null) {
                            int lineNumber = this.getLineNumber(iCompUnit, annotation);
                            String text = this.getAnnotationText(annotation).replace("\\\\", "\\");
                            ExpressionDefinition expression = new ExpressionDefinition(text, cukeAnnotation.getLang());
                            StepDefinition step = new StepDefinition(method.getHandleIdentifier(), StepDefinition.NO_LABEL, expression, resource, lineNumber, method.getElementName(), t.getPackageFragment().getElementName());
                            steps.add(step);
                        }
                        ++n11;
                    }
                    ++n7;
                }
                ++n4;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return steps;
    }

    private boolean isCukeLambdaExpr(MethodDeclaration method, Set<String> keywords) {
        List statements = method.getBody().statements();
        for (Statement statement : statements) {
            String identifier;
            ExpressionStatement expressionStatement;
            Expression expression;
            if (!(statement instanceof ExpressionStatement) || !((expression = (expressionStatement = (ExpressionStatement)statement).getExpression()) instanceof MethodInvocation) || !keywords.contains(identifier = ((MethodInvocation)expression).getName().getIdentifier())) continue;
            return true;
        }
        return false;
    }

    private int getLineNumber(ICompilationUnit compUnit, IAnnotation annotation) throws JavaModelException {
        Document document = new Document(compUnit.getBuffer().getContents());
        try {
            return document.getLineOfOffset(annotation.getSourceRange().getOffset()) + 1;
        }
        catch (BadLocationException e) {
            return 0;
        }
    }

    private List<CucumberAnnotation> getAllAnnotationsInPackage(IJavaProject javaProject, String packageFrag, final String lang) throws CoreException, JavaModelException {
        SearchPattern pattern = SearchPattern.createPattern((String)packageFrag, (int)2, (int)0, (int)10);
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])javaProject.getPackageFragments());
        final ArrayList<CucumberAnnotation> annotations = new ArrayList<CucumberAnnotation>();
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) {
                try {
                    if (match.getAccuracy() == 0) {
                        IPackageFragment frag = (IPackageFragment)match.getElement();
                        IClassFile[] iClassFileArray = frag.getClassFiles();
                        int n = iClassFileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IClassFile cls = iClassFileArray[n2];
                            IType t = cls.findPrimaryType();
                            if (t.isAnnotation()) {
                                annotations.add(new CucumberAnnotation(t.getElementName(), lang));
                            }
                            ++n2;
                        }
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
        };
        SearchEngine engine = new SearchEngine();
        this.jdtSearch(engine, pattern, scope, requestor);
        return annotations;
    }

    private void jdtSearch(SearchEngine engine, SearchPattern pattern, IJavaSearchScope scope, SearchRequestor requestor) throws CoreException {
        try {
            engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private CucumberAnnotation getCukeAnnotation(List<CucumberAnnotation> importedAnnotations, IAnnotation annotation) throws JavaModelException {
        Matcher m = this.cukeAnnotationMatcher.matcher(annotation.getElementName());
        if (m.find()) {
            return new CucumberAnnotation(m.group(2), m.group(1));
        }
        for (CucumberAnnotation cuke : importedAnnotations) {
            if (!cuke.getAnnotation().equals(annotation.getElementName())) continue;
            return cuke;
        }
        return null;
    }

    private String getAnnotationText(IAnnotation annotation) throws JavaModelException {
        IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
        int n = iMemberValuePairArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemberValuePair mvp = iMemberValuePairArray[n2];
            if (mvp.getValueKind() == 9) {
                return (String)mvp.getValue();
            }
            ++n2;
        }
        return "";
    }

    protected Set<StepDefinition> findStepDefinitionsFromSupportedResource(IResource stepDefinitionResource, MarkerFactory markerFactory, IProgressMonitor monitor) throws CoreException {
        String[] filters;
        CompilationUnitStepDefinitionsPreferencesFilter filter;
        IProject project;
        boolean isJavaProject;
        if (stepDefinitionResource instanceof IProject && (isJavaProject = this.support(project = (IProject)stepDefinitionResource))) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            return this.findStepDefinitionsInClasspath(javaProject, markerFactory, monitor);
        }
        project = stepDefinitionResource.getProject();
        isJavaProject = this.support(project);
        if (!isJavaProject) {
            return new HashSet<StepDefinition>();
        }
        IJavaElement javaElement = JavaCore.create((IResource)stepDefinitionResource);
        boolean isCompilationUnit = javaElement instanceof ICompilationUnit;
        if (!isCompilationUnit) {
            return new HashSet<StepDefinition>();
        }
        ICompilationUnit compilationUnit = (ICompilationUnit)javaElement;
        if (CucumberJavaPreferences.isUseStepDefinitionsFilters() && !(filter = new CompilationUnitStepDefinitionsPreferencesFilter(filters = CucumberJavaPreferences.getStepDefinitionsFilters())).accept(compilationUnit)) {
            return new HashSet<StepDefinition>();
        }
        List<StepDefinition> stepDefinitions = this.getCukeSteps(compilationUnit, markerFactory, monitor);
        return new HashSet<StepDefinition>(stepDefinitions);
    }

    public boolean support(IProject project) throws CoreException {
        return project.isOpen() && project.hasNature("org.eclipse.jdt.core.javanature");
    }

    public boolean support(IResource resource) throws CoreException {
        IJavaElement javaElement = JavaCore.create((IResource)resource);
        return javaElement != null;
    }

    private Set<StepDefinition> findStepDefinitionsInClasspath(IJavaProject javaProject, final MarkerFactory markerFactory, IProgressMonitor monitor) throws CoreException {
        SearchPattern searchPattern = SearchPattern.createPattern((String)"cucumber.api.java.*.*", (int)0, (int)32768, (int)10);
        try {
            SearchEngine engine = new SearchEngine();
            IJavaSearchScope[] scopes = this.computeScope(engine, javaProject, monitor);
            final HashSet<StepDefinition> stepDefinitions = new HashSet<StepDefinition>();
            SearchRequestor requestor = new SearchRequestor(){
                private long start;
                private long end;

                public void beginReporting() {
                    super.beginReporting();
                    this.start = System.currentTimeMillis();
                }

                public void endReporting() {
                    super.endReporting();
                }

                public void acceptSearchMatch(SearchMatch match) {
                    try {
                        if (match.getAccuracy() == 0) {
                            if (match.getElement() instanceof IMethod) {
                                IMethod method = (IMethod)match.getElement();
                                Set<StepDefinition> methodStepDefinitions = JavaStepDefinitionsProvider.this.getCukeSteps(method, markerFactory);
                                if (methodStepDefinitions != null) {
                                    stepDefinitions.addAll(methodStepDefinitions);
                                }
                            } else if (match.getElement() instanceof IType) {
                                IMethod[] methods;
                                IType resolvedType = (IType)match.getElement();
                                IMethod[] iMethodArray = methods = resolvedType.getMethods();
                                int n = methods.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IMethod method = iMethodArray[n2];
                                    Set<StepDefinition> methodStepDefinitions = JavaStepDefinitionsProvider.this.getCukeSteps(method, markerFactory);
                                    if (methodStepDefinitions != null) {
                                        stepDefinitions.addAll(methodStepDefinitions);
                                    }
                                    ++n2;
                                }
                            }
                        }
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                    }
                }
            };
            IJavaSearchScope[] iJavaSearchScopeArray = scopes;
            int n = scopes.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaSearchScope scope = iJavaSearchScopeArray[n2];
                this.jdtSearch(engine, searchPattern, scope, requestor);
                ++n2;
            }
            return stepDefinitions;
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            throw new CoreException((IStatus)new Status(4, "cucumber.eclipse.steps.jdt", e.getMessage(), (Throwable)e));
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw new CoreException((IStatus)new Status(4, "cucumber.eclipse.steps.jdt", e.getMessage(), (Throwable)e));
        }
    }

    private IJavaSearchScope[] computeScope(SearchEngine searchEngine, IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
        ArrayList<IJavaSearchScope> scope = new ArrayList<IJavaSearchScope>();
        if (CucumberJavaPreferences.isUseStepDefinitionsFilters()) {
            String[] filters = CucumberJavaPreferences.getStepDefinitionsFilters();
            final ArrayList pkgScope = new ArrayList();
            final ArrayList typeScope = new ArrayList();
            IJavaSearchScope projectScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject});
            SearchRequestor requestor = new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    if (match.getAccuracy() == 0) {
                        if (match.getElement() instanceof IPackageFragment) {
                            pkgScope.add((IJavaElement)match.getElement());
                        } else if (match.getElement() instanceof IType) {
                            typeScope.add((IJavaElement)match.getElement());
                        }
                    }
                }
            };
            String[] stringArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                String filter = stringArray[n2];
                if (filter.endsWith(".*")) {
                    String filterWithoutStar = filter.substring(0, filter.length() - 2);
                    SearchPattern searchPattern = SearchPattern.createPattern((String)filterWithoutStar, (int)2, (int)0, (int)8);
                    searchEngine.search(searchPattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, projectScope, requestor, monitor);
                } else {
                    SearchPattern searchPattern = SearchPattern.createPattern((String)filter, (int)0, (int)0, (int)8);
                    searchEngine.search(searchPattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, projectScope, requestor, monitor);
                }
                ++n2;
            }
            if (!pkgScope.isEmpty()) {
                scope.add(SearchEngine.createJavaSearchScope((IJavaElement[])pkgScope.toArray(new IJavaElement[pkgScope.size()]), (int)2));
            }
            if (!typeScope.isEmpty()) {
                scope.add(SearchEngine.createJavaSearchScope((IJavaElement[])typeScope.toArray(new IJavaElement[typeScope.size()]), (int)2));
            }
        } else {
            scope.add(SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject}, (int)2));
        }
        return scope.toArray(new IJavaSearchScope[scope.size()]);
    }

    private Set<StepDefinition> getCukeSteps(IMethod method, MarkerFactory markerFactory) throws JavaModelException {
        IAnnotation[] annotations;
        String[] filters;
        MethodStepDefinitionsPreferencesFilter filter;
        HashSet<StepDefinition> stepDefinitions = new HashSet<StepDefinition>();
        if (CucumberJavaPreferences.isUseStepDefinitionsFilters() && !(filter = new MethodStepDefinitionsPreferencesFilter(filters = CucumberJavaPreferences.getStepDefinitionsFilters())).accept(method)) {
            return null;
        }
        IAnnotation[] iAnnotationArray = annotations = method.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            CucumberAnnotation cukeAnnotation = this.getCukeAnnotation(new ArrayList<CucumberAnnotation>(), annotation);
            if (cukeAnnotation != null) {
                IClassFile classFile = method.getClassFile();
                IJavaElement pkg = classFile.getParent();
                IJavaElement jar = pkg.getParent();
                ExpressionDefinition expression = new ExpressionDefinition(this.getAnnotationText(annotation), cukeAnnotation.getLang());
                String classFileName = classFile.getElementName();
                String packageName = pkg.getElementName();
                String jarName = jar.getElementName();
                String label = String.format("%s > %s.%s#%s%s", jarName, packageName, classFileName, method.getElementName(), method.getSignature());
                StepDefinition step = new StepDefinition(method.getHandleIdentifier(), label, expression, jar.getResource(), -1, method.getElementName(), packageName);
                stepDefinitions.add(step);
            }
            ++n2;
        }
        return stepDefinitions;
    }
}

