/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.steps.jdt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;

public class MethodDefinition {
    private SimpleName methodName;
    private Type returnType;
    public static final String REGEX_JAVA8_CUKEAPI = "cucumber\\.api\\.java8\\.(.*)";
    public static final String CONTAINS_JAVA8_CUKEAPI = "(.*)cucumber\\.api\\.java8\\.(.*)";
    private List<Statement> methodBodyList = new ArrayList<Statement>();
    private String lang;
    public String[] java8CukeImport = null;

    public MethodDefinition() {
    }

    public MethodDefinition(SimpleName methodName, Type returnType, List<Statement> methodBodyList) {
        this.methodName = methodName;
        this.returnType = returnType;
        this.methodBodyList = methodBodyList;
    }

    public void setJava8CukeLang(String importDeclaration) {
        this.lang = importDeclaration.substring(importDeclaration.lastIndexOf(".") + 1).toLowerCase();
    }

    public String getCukeLang() {
        return this.lang;
    }

    public String getMethodName() {
        return String.valueOf(this.methodName.getFullyQualifiedName()) + "()";
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public List<Statement> getMethodBodyList() {
        return this.methodBodyList;
    }

    public String getLambdaStep(Statement statement, Set<String> keywords) {
        ExpressionStatement expressionStatement;
        Expression expression;
        if (statement instanceof ExpressionStatement && (expression = (expressionStatement = (ExpressionStatement)statement).getExpression()) instanceof MethodInvocation) {
            Object object;
            List arguments;
            Iterator iterator;
            MethodInvocation methodInvocation = (MethodInvocation)expression;
            String identifier = ((MethodInvocation)expression).getName().getIdentifier();
            if (keywords.contains(identifier) && (iterator = (arguments = methodInvocation.arguments()).iterator()).hasNext() && (object = iterator.next()) instanceof StringLiteral) {
                String string = ((StringLiteral)object).getLiteralValue();
                return string;
            }
        }
        return null;
    }

    public boolean isCukeLambdaExpr(MethodDeclaration method, Set<String> keywords) {
        List statements = method.getBody().statements();
        for (Statement statement : statements) {
            String identifier;
            ExpressionStatement expressionStatement;
            Expression expression;
            if (!(statement instanceof ExpressionStatement) || !((expression = (expressionStatement = (ExpressionStatement)statement).getExpression()) instanceof MethodInvocation) || !keywords.contains(identifier = ((MethodInvocation)expression).getName().getIdentifier())) continue;
            return true;
        }
        return false;
    }

    public boolean isJava8CukeAPI(IImportDeclaration[] allimports) {
        return Arrays.asList(allimports).toString().matches(CONTAINS_JAVA8_CUKEAPI);
    }

    public String toString() {
        return "Method-Details [ MethodName = " + this.methodName + "\n MethodReturnType = " + this.returnType + "\n MethodBodyList = " + this.methodBodyList + "\n Language = " + this.lang + "]";
    }
}

