/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.steps.jdt;

import cucumber.eclipse.steps.integration.IStepDefinitionGenerator;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.java.JavaBackend;
import cucumber.runtime.java.ObjectFactory;
import cucumber.runtime.snippets.CamelCaseConcatenator;
import cucumber.runtime.snippets.Concatenator;
import cucumber.runtime.snippets.FunctionNameGenerator;
import gherkin.formatter.model.Step;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class StepGenerator
implements IStepDefinitionGenerator {
    public boolean supports(IFile file) {
        return file.getName().endsWith(".java");
    }

    public TextEdit createStepSnippet(Step step, IDocument targetDocument) throws IOException, CoreException {
        JavaBackend backend = new JavaBackend((ObjectFactory)new EmptyObjectFactory(), (ClassFinder)new EmptyClassFinder());
        String snippetText = backend.getSnippet(step, new FunctionNameGenerator((Concatenator)new CamelCaseConcatenator()));
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(targetDocument.get().toCharArray());
        CompilationUnit target = (CompilationUnit)parser.createAST(null);
        target.recordModifications();
        TypeDeclaration targetType = (TypeDeclaration)target.types().get(0);
        parser.setKind(4);
        parser.setSource(snippetText.toCharArray());
        TypeDeclaration fragmentContainer = (TypeDeclaration)parser.createAST(null);
        for (Object fragmentObject : fragmentContainer.bodyDeclarations()) {
            BodyDeclaration fragmentNode = (BodyDeclaration)fragmentObject;
            fragmentNode = (BodyDeclaration)ASTNode.copySubtree((AST)target.getAST(), (ASTNode)fragmentNode);
            List bodyDeclarations = targetType.bodyDeclarations();
            bodyDeclarations.add(StepGenerator.getInsertionPoint(targetType, fragmentNode), fragmentNode);
        }
        return target.rewrite(targetDocument, null);
    }

    private static int getInsertionPoint(TypeDeclaration source, BodyDeclaration fragment) {
        if (source.bodyDeclarations().isEmpty()) {
            return 0;
        }
        if (fragment.getNodeType() == 31) {
            int last = StepGenerator.getLastFragmentOfTypePosition(source, fragment.getNodeType(), fragment.getModifiers());
            if (last >= 0) {
                return last + 1;
            }
            int afterFields = StepGenerator.getLastFragmentOfTypePosition(source, 23);
            return afterFields >= 0 ? afterFields + 1 : 0;
        }
        return 0;
    }

    private static int getLastFragmentOfTypePosition(TypeDeclaration source, int nodeType) {
        return StepGenerator.getLastFragmentOfTypePosition(source, nodeType, -1);
    }

    private static int getLastFragmentOfTypePosition(TypeDeclaration source, int nodeType, int modifiers) {
        int i = source.bodyDeclarations().size() - 1;
        while (i >= 0) {
            BodyDeclaration bodyDecl = (BodyDeclaration)source.bodyDeclarations().get(i);
            if (bodyDecl.getNodeType() == nodeType && (modifiers == -1 || bodyDecl.getModifiers() == modifiers)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    private static class EmptyClassFinder
    implements ClassFinder {
        private EmptyClassFinder() {
        }

        public <T> Collection<Class<? extends T>> getDescendants(Class<T> parentType, String packageName) {
            return new ArrayList<Class<? extends T>>();
        }

        public <T> Class<? extends T> loadClass(String arg0) throws ClassNotFoundException {
            return null;
        }
    }

    private static class EmptyObjectFactory
    implements ObjectFactory {
        private EmptyObjectFactory() {
        }

        public void start() {
        }

        public void stop() {
        }

        public void addClass(Class<?> glueClass) {
        }

        public <T> T getInstance(Class<T> glueClass) {
            return null;
        }
    }
}

