/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.steps.jdt.filter;

import cucumber.eclipse.steps.integration.filter.Filter;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;

public class MethodStepDefinitionsPreferencesFilter
implements Filter<IMethod> {
    private String[] filters;

    public MethodStepDefinitionsPreferencesFilter(String[] filters) {
        this.filters = filters;
    }

    public boolean accept(IMethod method) {
        IClassFile classFile = method.getClassFile();
        IJavaElement pkg = classFile.getParent();
        String packageName = pkg.getElementName();
        if (packageName == null) {
            packageName = "";
        }
        String typeName = String.valueOf(pkg.getElementName()) + "." + classFile.getElementName();
        String[] stringArray = this.filters;
        int n = this.filters.length;
        int n2 = 0;
        while (n2 < n) {
            String filter = stringArray[n2];
            if (typeName.equals(filter) || Pattern.matches(filter, packageName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

