/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.convert;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class ConvertToMethodRefactoring {
    private final FieldNode targetField;

    public ConvertToMethodRefactoring(GroovyCompilationUnit unit, int offset) {
        this.targetField = this.getTargetField(unit, offset);
    }

    private FieldNode getTargetField(GroovyCompilationUnit unit, int offset) {
        if (unit.exists() && unit.isOnBuildPath()) {
            try {
                IJavaElement maybeField = unit.getElementAt(offset);
                if (maybeField instanceof IField && maybeField.exists() && ((IField)maybeField).getNameRange().getOffset() > 0) {
                    String fieldName = maybeField.getElementName();
                    for (ClassNode clazz : unit.getModuleNode().getClasses()) {
                        FieldNode targetField;
                        if (!clazz.getNameWithoutPackage().equals(maybeField.getParent().getElementName()) || (targetField = clazz.getDeclaredField(fieldName)) == null || !(targetField.getInitialExpression() instanceof ClosureExpression)) continue;
                        return targetField;
                    }
                }
            }
            catch (JavaModelException e) {
                GroovyCore.logException((String)"Oops", (Throwable)e);
            }
        }
        return null;
    }

    public boolean isApplicable() {
        return this.targetField != null;
    }

    public void applyRefactoring(IDocument document) {
        if (this.isApplicable()) {
            try {
                TextEdit thisEdit = this.createEdit(document);
                if (thisEdit != null) {
                    thisEdit.apply(document);
                }
            }
            catch (Exception e) {
                GroovyCore.logException((String)"Oops.", (Throwable)e);
            }
        }
    }

    public TextEdit createEdit(IDocument doc) throws BadLocationException {
        MultiTextEdit edit;
        int afterName = this.targetField.getNameEnd() + 1;
        int openingBracket = ConvertToMethodRefactoring.findOpenBracket(doc, this.targetField, afterName);
        int afterLastParam = ConvertToMethodRefactoring.findAfterLastParam(this.targetField);
        int afterArrow = ConvertToMethodRefactoring.findAfterArrow(doc, Math.max(openingBracket, afterLastParam));
        if (!(openingBracket < doc.getLength() && doc.getChar(openingBracket) == '{' || Character.isWhitespace(doc.getChar(openingBracket)))) {
            return null;
        }
        if (afterLastParam > -1 && afterArrow == -1) {
            return null;
        }
        if (afterLastParam > -1) {
            edit = new MultiTextEdit();
            edit.addChild((TextEdit)new ReplaceEdit(afterName, openingBracket - afterName + 1, "("));
            edit.addChild((TextEdit)new ReplaceEdit(afterLastParam, afterArrow - afterLastParam + 1, ") {"));
        } else {
            edit = new ReplaceEdit(afterName, Math.max(openingBracket, afterArrow) - afterName + 1, "() {");
        }
        return edit;
    }

    private static int findOpenBracket(IDocument doc, FieldNode targetField, int afterName) throws BadLocationException {
        int offset = afterName;
        while (offset < doc.getLength() && doc.getChar(offset) != '{') {
            ++offset;
        }
        Parameter[] parameters = ConvertToMethodRefactoring.getClosureParameters(targetField);
        if (parameters != null && parameters.length > 0) {
            int firstParameterStart = parameters[0].getStart();
            ++offset;
            while (offset < firstParameterStart && Character.isWhitespace(doc.getChar(offset))) {
                ++offset;
            }
            --offset;
        }
        return offset;
    }

    private static int findAfterLastParam(FieldNode targetField) {
        Parameter[] parameters = ConvertToMethodRefactoring.getClosureParameters(targetField);
        if (parameters != null && parameters.length > 0) {
            return parameters[parameters.length - 1].getEnd();
        }
        return -1;
    }

    private static Parameter[] getClosureParameters(FieldNode targetField) {
        return ((ClosureExpression)targetField.getInitialExpression()).getParameters();
    }

    private static int findAfterArrow(IDocument doc, int afterLastParam) throws BadLocationException {
        if (afterLastParam >= 0) {
            int offset = afterLastParam;
            while (offset < doc.getLength() - 1) {
                if (doc.getChar(offset) == '-' && doc.getChar(offset + 1) == '>') {
                    return offset + 1;
                }
                ++offset;
            }
        }
        return -1;
    }
}

