/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.rename.renameLocal;

import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.ASTNodeFinder;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.Region;
import org.codehaus.groovy.eclipse.refactoring.core.rename.renameLocal.LocalVariableNameCheckerRequestor;
import org.codehaus.groovy.eclipse.refactoring.core.utils.StatusHelper;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.LocalVariableReferenceRequestor;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorFactory;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorWithRequestor;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.LocalVariable;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class GroovyRenameLocalVariableProcessor
extends JavaRenameProcessor {
    Variable variable;
    GroovyCompilationUnit unit;
    CompilationUnitChange change;
    ILocalVariable localVariable;

    GroovyRenameLocalVariableProcessor(ILocalVariable localVariable, String newName, RefactoringStatus status) {
        this.initialize(localVariable, newName, status);
    }

    private void initialize(ILocalVariable localVariable, String newName, RefactoringStatus status) {
        this.localVariable = localVariable;
        ICompilationUnit unit = (ICompilationUnit)localVariable.getAncestor(5);
        if (unit instanceof GroovyCompilationUnit) {
            this.unit = (GroovyCompilationUnit)unit;
        } else {
            status.merge(RefactoringStatus.createErrorStatus((String)("Expecting a Groovy compilation unit, but instead found " + unit.getElementName())));
        }
        if (newName != null && newName.length() > 0) {
            if (newName.equals(localVariable.getElementName())) {
                status.merge(RefactoringStatus.createErrorStatus((String)"New name is the same as the old name"));
            }
            this.setNewElementName(newName);
        } else {
            status.merge(RefactoringStatus.createErrorStatus((String)"Invalid new name"));
        }
    }

    protected RenameModifications computeRenameModifications() throws CoreException {
        RenameModifications mods = new RenameModifications();
        mods.rename(this.localVariable, new RenameArguments(this.getNewElementName(), true));
        return mods;
    }

    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        boolean wasWorkingCopy = true;
        try {
            RefactoringStatus result;
            if (!this.unit.isWorkingCopy()) {
                this.unit.becomeWorkingCopy((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor).split(10));
                wasWorkingCopy = false;
            }
            List<IRegion> references = this.findReferences();
            this.change = this.createEdits(references);
            RefactoringStatus refactoringStatus = result = this.checkShadowing();
            return refactoringStatus;
        }
        catch (Exception e) {
            RefactoringStatus refactoringStatus = RefactoringStatus.create((IStatus)new Status(4, "org.codehaus.groovy.eclipse.refactoring", "Exception creating edits for rename refactoring", (Throwable)e));
            return refactoringStatus;
        }
        finally {
            if (!wasWorkingCopy) {
                this.unit.discardWorkingCopy();
            }
        }
    }

    private RefactoringStatus checkShadowing() {
        IField maybeShadows;
        IType type = (IType)this.localVariable.getAncestor(7);
        if (type != null && (maybeShadows = type.getField(this.getNewElementName())).exists()) {
            return RefactoringStatus.createWarningStatus((String)("Warning: new variable name " + this.getNewElementName() + " shadows a field in " + type.getElementName()));
        }
        LocalVariableNameCheckerRequestor requestor = new LocalVariableNameCheckerRequestor(this.variable, this.getNewElementName());
        TypeInferencingVisitorWithRequestor visitor = new TypeInferencingVisitorFactory().createVisitor(this.unit);
        visitor.visitCompilationUnit((ITypeRequestor)requestor);
        if (requestor.isShadowing()) {
            IJavaElement parent = this.localVariable.getParent();
            if (parent instanceof IMethod) {
                return RefactoringStatus.createWarningStatus((String)("Warning: new variable name " + this.getNewElementName() + " shadows a variable in " + this.localVariable.getParent().getElementName()), (RefactoringStatusContext)StatusHelper.createContext((IMember)((IMethod)parent)));
            }
            return RefactoringStatus.createWarningStatus((String)("Warning: new variable name " + this.getNewElementName() + " shadows a variable in " + this.localVariable.getParent().getElementName()));
        }
        return new RefactoringStatus();
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.jdt.groovy.core.groovyNature"};
    }

    protected IFile[] getChangedFiles() throws CoreException {
        return new IFile[]{ResourceUtil.getFile((ICompilationUnit)this.unit)};
    }

    public int getSaveMode() {
        return 3;
    }

    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        if (this.localVariable.getElementName().equals(newName)) {
            return RefactoringStatus.createErrorStatus((String)"New name must be different from old name");
        }
        return RefactoringStatus.create((IStatus)JavaConventions.validateFieldName((String)newName, (String)"1.6", (String)"1.6"));
    }

    public String getCurrentElementName() {
        return this.localVariable.getElementName();
    }

    public Object getNewElement() throws CoreException {
        int start = this.localVariable.getNameRange().getOffset();
        int until = this.localVariable.getNameRange().getOffset() + this.getNewElementName().length() - 1;
        return new LocalVariable((JavaElement)this.localVariable.getParent(), this.getNewElementName(), start, until, start, until, this.localVariable.getTypeSignature(), null, 0, false);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        Variable variable = this.findVariable();
        if (variable == null) {
            return RefactoringStatus.createErrorStatus((String)("Cannot find local variable " + this.localVariable.getElementName()));
        }
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.change;
    }

    public Object[] getElements() {
        return new Object[]{this.localVariable};
    }

    public String getIdentifier() {
        return "org.codehaus.groovy.eclipse.refactoring.renameLocal";
    }

    public String getProcessorName() {
        return "Rename Local Variable (Groovy)";
    }

    public boolean isApplicable() throws CoreException {
        return this.unit != null;
    }

    private List<IRegion> findReferences() {
        if (this.variable == null) {
            try {
                this.variable = this.findVariable();
            }
            catch (JavaModelException e) {
                throw new RuntimeException(e);
            }
        }
        LocalVariableReferenceRequestor requestor = new LocalVariableReferenceRequestor(this.variable, this.localVariable.getParent());
        TypeInferencingVisitorWithRequestor visitor = new TypeInferencingVisitorFactory().createVisitor(this.unit);
        visitor.visitCompilationUnit((ITypeRequestor)requestor);
        return requestor.getReferences();
    }

    private Variable findVariable() throws JavaModelException {
        ISourceRange sourceRange = this.localVariable.getSourceRange();
        ASTNodeFinder findLocalVar = new ASTNodeFinder(new Region(sourceRange.getOffset(), sourceRange.getLength()));
        ASTNode node = findLocalVar.doVisit(this.unit.getModuleNode());
        return node instanceof Variable ? (Variable)node : null;
    }

    private CompilationUnitChange createEdits(List<IRegion> references) {
        TextEdit[] allEdits = new TextEdit[references.size()];
        int index = 0;
        for (IRegion region : references) {
            allEdits[index] = new ReplaceEdit(region.getOffset(), region.getLength(), this.getNewElementName());
            ++index;
        }
        CompilationUnitChange change = new CompilationUnitChange(RefactoringCoreMessages.RenameTempRefactoring_rename, (ICompilationUnit)this.unit);
        MultiTextEdit rootEdit = new MultiTextEdit();
        change.setEdit((TextEdit)rootEdit);
        change.setKeepPreviewEdits(true);
        TextEdit[] textEditArray = allEdits;
        int n = allEdits.length;
        int n2 = 0;
        while (n2 < n) {
            TextEdit edit = textEditArray[n2];
            rootEdit.addChild(edit);
            change.addTextEditGroup(new TextEditGroup(RefactoringCoreMessages.RenameTempRefactoring_changeName, edit));
            ++n2;
        }
        return change;
    }
}

