/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.formatter;

import groovyjarjarantlr.Token;
import groovyjarjarantlr.TokenStream;
import groovyjarjarantlr.TokenStreamException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.antlr.GroovyTokenTypeBridge;
import org.codehaus.groovy.antlr.parser.GroovyLexer;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.refactoring.formatter.GroovyDocumentScanner;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class KlenkDocumentScanner
extends GroovyDocumentScanner {
    private List<List<Token>> tokenLines;

    public KlenkDocumentScanner(IDocument doc) {
        super(doc);
    }

    @Override
    protected void ensureScanned(int end) {
        if (this.tokens != null) {
            return;
        }
        StringReader input = new StringReader(this.getDocument().get());
        GroovyLexer lexer = new GroovyLexer((Reader)input);
        lexer.setWhitespaceIncluded(true);
        TokenStream stream = lexer.plumb();
        Token token = null;
        this.tokens = new ArrayList();
        this.tokenLines = new ArrayList<List<Token>>();
        ArrayList<Token> line = new ArrayList<Token>();
        try {
            while ((token = stream.nextToken()).getType() != GroovyTokenTypeBridge.EOF) {
                if (token.getType() == GroovyTokenTypeBridge.WS) continue;
                if (token.getType() == GroovyTokenTypeBridge.STRING_CTOR_START) {
                    this.tokens.add(token);
                    Token prevToken = token;
                    while ((token = stream.nextToken()).getType() != GroovyTokenTypeBridge.STRING_CTOR_END) {
                        if (this.equalTokens(prevToken, token)) break;
                        prevToken = token;
                    }
                }
                this.tokens.add(token);
                line.add(token);
                if (token.getType() != GroovyTokenTypeBridge.NLS) continue;
                this.tokenLines.add(line);
                line = new ArrayList();
            }
        }
        catch (TokenStreamException e) {
            GroovyCore.logException((String)"Scanning tokens threw an exception", (Throwable)e);
        }
        this.tokens.add(token);
        line.add(token);
        this.tokenLines.add(line);
    }

    private boolean equalTokens(Token t1, Token t2) {
        return t1.getType() == t2.getType() && t1.getColumn() == t2.getColumn() && t1.getLine() == t2.getLine() && this.nullEquals(t1.getFilename(), t2.getFilename()) && this.nullEquals(t1.getText(), t2.getText());
    }

    private boolean nullEquals(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    @Deprecated
    public List<List<Token>> getLineTokensVector() {
        this.ensureScanned(Integer.MAX_VALUE);
        return this.tokenLines;
    }

    @Deprecated
    public Token get(int i) {
        this.ensureScanned(Integer.MAX_VALUE);
        if (i < this.tokens.size()) {
            return (Token)this.tokens.get(i);
        }
        return null;
    }

    @Deprecated
    public int size() {
        this.ensureScanned(Integer.MAX_VALUE);
        return this.tokens.size();
    }

    @Deprecated
    public int indexOf(Token token) throws BadLocationException {
        int pos = this.findTokenFrom(this.getOffset(token));
        Assert.isTrue((token == this.tokens.get(pos) ? 1 : 0) != 0);
        return pos;
    }
}

