/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.worker;

import com.kms.katalon.ai.core.model.StudioAssistChatAnswerMessageFuture;
import com.kms.katalon.ai.core.model.agent.AgentMessage;
import com.kms.katalon.ai.core.model.chat.ResponseMessage;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatAnswerMessage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StudioAssistChatAnswerManageWorker
extends Thread
implements AutoCloseable {
    private final Logger logger = LoggerFactory.getLogger(StudioAssistChatAnswerManageWorker.class);
    public static final int MAX_DURATION_WAITING_FOR_ANSWER = 120;
    private BiConsumer<StudioAssistChatAnswerMessage, Exception> evaluateScriptConsumer;
    private AtomicReference<StudioAssistChatAnswerMessageFuture> answerFuture;
    private boolean closed;
    private boolean cancelled;

    public StudioAssistChatAnswerManageWorker(BiConsumer<StudioAssistChatAnswerMessage, Exception> evaluateScriptConsumer, StudioAssistChatAnswerMessageFuture answerFuture) {
        this.evaluateScriptConsumer = evaluateScriptConsumer;
        this.answerFuture = new AtomicReference<StudioAssistChatAnswerMessageFuture>(answerFuture);
    }

    @Override
    public void run() {
        try {
            ResponseMessage responseMessage = this.answerFuture.get().get(120L, TimeUnit.SECONDS);
            StudioAssistChatAnswerMessage finalAnswerMessage = null;
            if (responseMessage instanceof StudioAssistChatAnswerMessage) {
                finalAnswerMessage = (StudioAssistChatAnswerMessage)responseMessage;
            } else if (responseMessage instanceof AgentMessage) {
                AgentMessage agentMessage = (AgentMessage)responseMessage;
                finalAnswerMessage = agentMessage.getFinalAnswer();
            }
            this.evaluateScript(finalAnswerMessage, null);
        }
        catch (InterruptedException e) {
            if (this.cancelled) {
                this.logger.debug("Question message has been cancelled | id = %s".formatted(this.answerFuture.get().getMessageId()));
            } else if (this.closed) {
                this.logger.debug("StudioAssistChatAnswerManageWorker has been closed | id = %s".formatted(this.answerFuture.get().getMessageId()));
            } else {
                this.logger.error("Exception while processing StudioAssistChatAnswerManageThread | id = %s".formatted(this.answerFuture.get().getMessageId()), (Throwable)e);
                this.evaluateScript(null, e);
            }
        }
        catch (TimeoutException e) {
            this.logger.error("TimeoutException while processing StudioAssistChatAnswerManageThread | id = %s".formatted(this.answerFuture.get().getMessageId()), (Throwable)e);
            this.evaluateScript(null, e);
        }
        catch (Exception e) {
            this.logger.error("Exception while processing StudioAssistChatAnswerManageThread | id = %s".formatted(this.answerFuture.get().getMessageId(), e));
            this.evaluateScript(null, e);
        }
    }

    private void evaluateScript(StudioAssistChatAnswerMessage answerMessage, Exception exception) {
        this.evaluateScriptConsumer.accept(answerMessage, exception);
    }

    @Override
    public void close() throws Exception {
        this.closed = true;
        if (this.answerFuture != null) {
            this.answerFuture.get().interrupt();
        }
        this.interrupt();
    }

    public boolean isWorkingOnConversationAndQuestionId(String conversationId, String questionMessageId) {
        return StringUtils.equals((CharSequence)this.answerFuture.get().getConversationId(), (CharSequence)conversationId) && StringUtils.equals((CharSequence)this.answerFuture.get().getMessageId(), (CharSequence)questionMessageId);
    }

    public void cancel() throws Exception {
        this.cancelled = true;
        this.close();
    }
}

