/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.generation.dialogs;

import com.kms.katalon.ai.core.model.apigen.ApiEndpoint;
import com.kms.katalon.ai.core.model.apigen.TestArtifactGenerationEndpoint;
import com.kms.katalon.ai.core.model.apigen.TestArtifactGenerationTask;
import com.kms.katalon.ai.core.model.apigen.TestArtifactGenerationTestObjectMap;
import com.kms.katalon.ai.core.model.exception.TestArtifactGenerationException;
import com.kms.katalon.ai.core.services.ITestArtifactGenerationController;
import com.kms.katalon.ai.core.services.ITestArtifactGenerationTrackingController;
import com.kms.katalon.composer.ai.component.ConnectivityStatus;
import com.kms.katalon.composer.ai.component.TestArtifactEndpointSelectionComponent;
import com.kms.katalon.composer.ai.component.TestArtifactGenerationMonitoringJob;
import com.kms.katalon.composer.ai.component.TestArtifactGenerationStepListComponent;
import com.kms.katalon.composer.ai.component.TestArtifactGenerationTaskProgressComponent;
import com.kms.katalon.composer.ai.component.TestArtifactTestCaseSelectionComponent;
import com.kms.katalon.composer.ai.generation.dialogs.TestArtifactGenerateTestCaseFailedMessageDialog;
import com.kms.katalon.composer.ai.generation.dialogs.TestArtifactGenerateTestCaseSuccessMessageDialog;
import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.composer.util.groovy.GroovyGuiUtil;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.IProgressConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class TestArtifactGenerationDialog
extends AbstractDialog {
    private static final Logger logger = LoggerFactory.getLogger(TestArtifactGenerationDialog.class);
    @Inject
    private IEclipseContext eclipseContext;
    private Composite parentContainer;
    private TestArtifactGenerationStepListComponent stepListComponent;
    private TestArtifactEndpointSelectionComponent endpointSelectionComponent;
    private TestArtifactGenerationTaskProgressComponent generationProgressComponent;
    private TestArtifactTestCaseSelectionComponent testCaseSelectionComponent;
    private static final String SELECT_ENDPOINTS_SCREEN = "Select endpoints";
    private static final String GENERATE_TEST_CASES_SCREEN = "Generate test cases";
    private static final String SELECT_TEST_CASES_SCREEN = "Select test cases";
    private File openAPIFile;
    private List<WebServiceRequestEntity> availableEndpoints;
    private Map<String, TestArtifactGenerationEndpoint> completedEndpoints = new HashMap<String, TestArtifactGenerationEndpoint>();
    private TestArtifactGenerationMonitoringJob monitoringJob;
    private TestArtifactGenerationTask generationTask;
    private List<WebServiceRequestEntity> generatingEntities = new ArrayList<WebServiceRequestEntity>();
    private Map<String, TestArtifactGenerationEndpoint> generatedEndpoints = new HashMap<String, TestArtifactGenerationEndpoint>();
    @Inject
    private ITestArtifactGenerationController controller;
    @Inject
    private ITestArtifactGenerationTrackingController trackingController;
    @Inject
    private IEventBroker eventBroker;
    private boolean closingConfirmed = false;
    private final int DIALOG_WIDTH = SystemUtils.IS_OS_WINDOWS ? 680 : 860;
    private JobChangeAdapter jobChangeApdater = null;

    @Inject
    public TestArtifactGenerationDialog(@Named(value="activeShell") Shell parentShell) {
        super(parentShell);
    }

    public void setOpenAPIFile(File file) {
        this.openAPIFile = file;
    }

    public void setEndpoints(List<WebServiceRequestEntity> endpoints) {
        this.availableEndpoints = endpoints;
    }

    public void setGenerationTask(TestArtifactGenerationTask task) {
        if (this.monitoringJob == null) {
            return;
        }
        this.generationTask = task;
        this.generationProgressComponent.setEndpoints(this.generationTask.getEndpoints(), this.endpointSelectionComponent.getSelectedEndpoints(), this.completedEndpoints);
    }

    public void setConnectivityStatus(ConnectivityStatus status) {
        if (this.monitoringJob == null) {
            return;
        }
        this.generationProgressComponent.setConnectivitystatus(status);
    }

    public void setGenerationFailedStatus() {
        if (this.monitoringJob == null) {
            return;
        }
        this.generationProgressComponent.setGenerationFailedStatus();
    }

    public void updateEndpointStatus(TestArtifactGenerationTask task, TestArtifactGenerationEndpoint endpoint) {
        if (this.generationTask == null) {
            return;
        }
        if (!this.generationTask.getId().equals(task.getId())) {
            return;
        }
        this.generatedEndpoints.put(endpoint.getId(), endpoint);
        if (!endpoint.isFailed()) {
            this.completedEndpoints.put(endpoint.getId(), endpoint);
        }
        this.generationProgressComponent.updateEndpointStatus(endpoint);
        if (this.generatedEndpoints.size() == this.generatingEntities.size()) {
            this.generationTask = null;
            this.monitoringJob = null;
            List<TestArtifactGenerationEndpoint> failedEndpoints = this.generatedEndpoints.values().stream().filter(e -> e.isFailed()).toList();
            if (failedEndpoints.size() == 0) {
                this.continueSavingTests();
            }
        }
    }

    public void show() {
        if (this.monitoringJob != null) {
            this.monitoringJob.setProperty(IProgressConstants.PROPERTY_IN_DIALOG, Boolean.TRUE);
        }
        this.getShell().setVisible(true);
        ProjectController.getInstance().setClosingHook(null);
    }

    public boolean close() {
        if (this.closingConfirmed) {
            return super.close();
        }
        int result = 0;
        if (this.getDialogTitle().equals(GENERATE_TEST_CASES_SCREEN)) {
            result = this.generationProgressComponent.confirmClosing();
        } else if (this.getDialogTitle().equals(SELECT_TEST_CASES_SCREEN)) {
            result = this.testCaseSelectionComponent.confirmClosing();
        } else {
            return super.close();
        }
        if (result == 1) {
            this.cancelGeneration();
            return super.close();
        }
        if (result == 16) {
            this.continueSavingTests();
            return false;
        }
        return false;
    }

    public boolean close(boolean confirmed) {
        this.closingConfirmed = confirmed;
        return this.close();
    }

    public void setDialogTitle(String dialogTitle) {
        super.setDialogTitle(dialogTitle);
        this.getShell().setText(dialogTitle);
    }

    protected Point getInitialSize() {
        return new Point(ComponentUtil.applyZoom((int)this.DIALOG_WIDTH), ComponentUtil.applyZoom((int)600));
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogContainer(Composite parent) {
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        this.parentContainer = parent;
        this.stepListComponent = new TestArtifactGenerationStepListComponent(this.parentContainer);
        Composite container = (Composite)ComponentBuilder.fillContainer((Composite)this.parentContainer).height(475).fill().build();
        this.endpointSelectionComponent = (TestArtifactEndpointSelectionComponent)((Object)ContextInjectionFactory.make(TestArtifactEndpointSelectionComponent.class, (IEclipseContext)this.eclipseContext));
        this.endpointSelectionComponent.setDialog(this);
        this.endpointSelectionComponent.setAvailableEndpoints(this.availableEndpoints);
        this.endpointSelectionComponent.createSelectEndpointArea(container);
        this.setDialogTitle(SELECT_ENDPOINTS_SCREEN);
        return this.parentContainer;
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    protected boolean canHandleShellCloseEvent() {
        return true;
    }

    protected void handleShellCloseEvent() {
        if (!DialogUtil.getCanClose((Shell)this.getShell())) {
            return;
        }
        super.handleShellCloseEvent();
    }

    protected void registerControlModifyListeners() {
    }

    protected void setInput() {
    }

    public void generateTests() {
        this.trackingEvent(SELECT_ENDPOINTS_SCREEN, "Generate tests");
        this.doGenerateTests(this.endpointSelectionComponent.getSelectedEndpoints());
    }

    public void cancelEndpointSelection() {
        this.close(true);
    }

    private void doGenerateTests(List<WebServiceRequestEntity> selectedEntities) {
        this.endpointSelectionComponent.hide();
        Composite container = (Composite)ComponentBuilder.fillContainer((Composite)this.parentContainer).height(475).fill().build();
        this.generationProgressComponent = (TestArtifactGenerationTaskProgressComponent)ContextInjectionFactory.make(TestArtifactGenerationTaskProgressComponent.class, (IEclipseContext)this.eclipseContext);
        this.generationProgressComponent.setDialog(this);
        this.generationProgressComponent.createContent(container);
        this.generationProgressComponent.setEndpoints(List.of(), this.endpointSelectionComponent.getSelectedEndpoints(), this.completedEndpoints);
        this.stepListComponent.handleProgressBarAndImage(GENERATE_TEST_CASES_SCREEN);
        this.setDialogTitle(GENERATE_TEST_CASES_SCREEN);
        this.generatingEntities = selectedEntities;
        this.generatedEndpoints = new HashMap<String, TestArtifactGenerationEndpoint>();
        String openApiPayload = null;
        try {
            openApiPayload = FileUtils.readFileToString((File)this.openAPIFile, (Charset)Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            LogUtil.logInfo((String)("Error reading OpenAPI file: " + e.getMessage()));
            return;
        }
        List<ApiEndpoint> selectionEndpoints = this.generatingEntities.stream().map(entity -> this.mapRequestEntityToApiEndpoint((WebServiceRequestEntity)entity)).collect(Collectors.toList());
        List<TestArtifactGenerationTestObjectMap> testObjectMaps = this.availableEndpoints.stream().map(entity -> this.mapRequestEntityToTestObjectMap((WebServiceRequestEntity)entity)).collect(Collectors.toList());
        this.jobChangeApdater = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().getSeverity() == 8) {
                    ProjectController.getInstance().setClosingHook(null);
                    TestArtifactGenerationDialog.this.cancelGeneration();
                } else {
                    BooleanSupplier hook = ProjectController.getInstance().getClosingHook();
                    if (hook != null) {
                        ProjectController.getInstance().setClosingHook(null);
                        UISynchronizeService.syncExec(() -> TestArtifactGenerationDialog.this.show());
                    }
                }
            }
        };
        this.monitoringJob = new TestArtifactGenerationMonitoringJob("Generate tests using AI...");
        ContextInjectionFactory.inject((Object)((Object)this.monitoringJob), (IEclipseContext)this.eclipseContext);
        this.monitoringJob.setPayload(openApiPayload);
        this.monitoringJob.setSelectedApiEndPoints(selectionEndpoints);
        this.monitoringJob.setTestObjectMaps(testObjectMaps);
        this.monitoringJob.setDialog(this);
        this.monitoringJob.addJobChangeListener((IJobChangeListener)this.jobChangeApdater);
        this.monitoringJob.schedule();
    }

    public void hideDialog() {
        this.getShell().setVisible(false);
        ProjectController.getInstance().setClosingHook(this::confirmClosing);
        if (this.monitoringJob != null) {
            this.monitoringJob.setProperty(IProgressConstants.PROPERTY_IN_DIALOG, Boolean.FALSE);
        }
        Trackings.trackAiAPITestGenerationHideScreen((String)GENERATE_TEST_CASES_SCREEN, (String)"Hide");
    }

    public void continueSavingTests() {
        if (this.testCaseSelectionComponent != null) {
            return;
        }
        this.stopGeneration();
        this.trackingEvent(GENERATE_TEST_CASES_SCREEN, "Continue anyway");
        this.testCaseSelectionComponent = (TestArtifactTestCaseSelectionComponent)((Object)ContextInjectionFactory.make(TestArtifactTestCaseSelectionComponent.class, (IEclipseContext)this.eclipseContext));
        this.testCaseSelectionComponent.setDialog(this);
        Composite container = (Composite)ComponentBuilder.fillContainer((Composite)this.parentContainer).height(475).fill().build();
        this.testCaseSelectionComponent.createSelectTestCaseArea(container);
        this.testCaseSelectionComponent.setAvailableEndpoints(this.completedEndpoints.values().stream().toList(), this.availableEndpoints);
        this.stepListComponent.handleProgressBarAndImage(SELECT_TEST_CASES_SCREEN);
        this.setDialogTitle(SELECT_TEST_CASES_SCREEN);
        this.generationProgressComponent.hide();
    }

    public void retryGeneration() {
        this.trackingEvent(GENERATE_TEST_CASES_SCREEN, "Retry");
        this.generationProgressComponent.dispose();
        this.generationProgressComponent = null;
        HashMap completedMap = new HashMap();
        this.completedEndpoints.values().forEach(e -> {
            String id = MessageFormat.format("{0} {1}", e.getMethod(), e.getPath());
            completedMap.put(id, e);
        });
        List<WebServiceRequestEntity> remainingEntities = this.endpointSelectionComponent.getSelectedEndpoints().stream().filter(e -> {
            String id = MessageFormat.format("{0} {1}", e.getRestRequestMethod(), e.getPath());
            return !completedMap.containsKey(id);
        }).toList();
        this.doGenerateTests(remainingEntities);
    }

    public void cancelGeneration() {
        this.trackingEvent(GENERATE_TEST_CASES_SCREEN, "Cancel");
        this.stopGeneration();
        UISynchronizeService.asyncExec(() -> this.close(true));
    }

    public void saveTestCases() {
        this.trackingEvent(SELECT_TEST_CASES_SCREEN, "Add");
        boolean isSuccess = true;
        List<TestCaseEntity> testCaseEntities = this.testCaseSelectionComponent.getSelectedTestCases();
        FolderEntity aiGeneratedFolder = this.testCaseSelectionComponent.getAIGeneratedFolder();
        for (TestCaseEntity tc : testCaseEntities) {
            try {
                this.saveFolder(tc.getParentFolder());
                TestCaseController.getInstance().saveNewTestCase(tc);
                tc.getParentFolder().getChildrenEntities().add(tc);
                GroovyGuiUtil.addContentToTestCase((TestCaseEntity)tc, (String)new String(tc.getScriptContents(), StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                isSuccess = false;
            }
        }
        this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", (Object)TreeEntityUtil.getFolderTreeEntity((FolderEntity)aiGeneratedFolder));
        this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)TreeEntityUtil.getFolderTreeEntity((FolderEntity)aiGeneratedFolder));
        if (isSuccess) {
            this.close(true);
            TestArtifactGenerateTestCaseSuccessMessageDialog.open(this.getParentShell(), testCaseEntities.size());
        } else {
            int status = TestArtifactGenerateTestCaseFailedMessageDialog.open(this.getParentShell());
            if (status == 0) {
                this.close(true);
            }
        }
    }

    private void saveFolder(FolderEntity entity) throws Exception {
        File parentFolder = new File(entity.getParentFolder().getLocation());
        if (!parentFolder.exists() || !parentFolder.isDirectory()) {
            this.saveFolder(entity.getParentFolder());
        }
        FolderController.getInstance().saveFolder(entity);
    }

    public void cancelTestCaseSelection() {
        this.trackingEvent(SELECT_TEST_CASES_SCREEN, "Cancel");
        this.close(true);
    }

    private ApiEndpoint mapRequestEntityToApiEndpoint(WebServiceRequestEntity entity) {
        ApiEndpoint apiEndpoint = new ApiEndpoint();
        apiEndpoint.setMethod(entity.getRestRequestMethod());
        apiEndpoint.setPath(entity.getPath());
        return apiEndpoint;
    }

    private TestArtifactGenerationTestObjectMap mapRequestEntityToTestObjectMap(WebServiceRequestEntity entity) {
        ApiEndpoint apiEndpoint = new ApiEndpoint();
        apiEndpoint.setMethod(entity.getRestRequestMethod());
        apiEndpoint.setPath(entity.getPath());
        TestArtifactGenerationTestObjectMap testObjectMap = new TestArtifactGenerationTestObjectMap();
        testObjectMap.setTestObjectName(FilenameUtils.removeExtension((String)entity.getRelativePath()));
        testObjectMap.setAssociatedEndpoint(apiEndpoint);
        return testObjectMap;
    }

    private void trackingEvent(String screenName, String clickAction) {
        switch (screenName) {
            case "Select endpoints": {
                int totalAvailableEndpoint = this.availableEndpoints.size();
                int totalSelectedEndpoint = this.endpointSelectionComponent.getSelectedEndpoints().size();
                this.trackingController.endpointSelectionTracking(totalAvailableEndpoint, totalSelectedEndpoint, clickAction);
                break;
            }
            case "Generate test cases": {
                String result;
                int totalAiApiTestCaseGenerated = this.completedEndpoints.values().stream().mapToInt(ep -> ep.getTestCases().size()).reduce(0, Integer::sum);
                int percentage = this.completedEndpoints.size() * 100 / this.endpointSelectionComponent.getSelectedEndpoints().size();
                String string = percentage == 100 ? "succeed" : (result = clickAction.equals("Cancel") ? "terminated" : "fail");
                if (percentage == 100) {
                    clickAction = "completed";
                }
                this.trackingController.generationTestTracking(totalAiApiTestCaseGenerated, percentage, result, clickAction);
                break;
            }
            case "Select test cases": {
                int totalAiApiTestCaseGenerated = this.completedEndpoints.values().stream().mapToInt(ep -> ep.getTestCases().size()).reduce(0, Integer::sum);
                int totalSelectedTestCase = this.testCaseSelectionComponent.getSelectedTestCases().size();
                int totalRenamedTestCase = this.testCaseSelectionComponent.getRenamedSelectTestCases().size();
                this.trackingController.testcaseSelectionTracking(totalAiApiTestCaseGenerated, totalSelectedTestCase, totalRenamedTestCase, clickAction);
            }
        }
    }

    private boolean confirmClosing() {
        this.show();
        return this.close();
    }

    private void stopGeneration() {
        if (this.monitoringJob != null) {
            if (this.jobChangeApdater != null) {
                this.monitoringJob.removeJobChangeListener((IJobChangeListener)this.jobChangeApdater);
                this.jobChangeApdater = null;
            }
            this.monitoringJob.cancel();
            this.monitoringJob = null;
        }
        if (this.generationTask != null) {
            try {
                try {
                    this.controller.cancelTask(this.generationTask.getId());
                }
                catch (TestArtifactGenerationException e) {
                    logger.error("Cannot cancel generation task: " + this.generationTask.getId() + ", error: " + e.toString());
                    this.generationTask = null;
                }
            }
            finally {
                this.generationTask = null;
            }
        }
    }
}

