/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.studioassist.part;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.katalon.network.oauth.core.model.AuthorizationRequest;
import com.kms.katalon.ai.core.constant.StudioAssistAttachmentSource;
import com.kms.katalon.ai.core.constant.StudioAssistErrorEnum;
import com.kms.katalon.ai.core.constant.StudioAssistFileType;
import com.kms.katalon.ai.core.constant.StudioAssistTrackingKeyEnum;
import com.kms.katalon.ai.core.constant.StudioAssistTrackingValueEnum;
import com.kms.katalon.ai.core.context.IAgentSessionContext;
import com.kms.katalon.ai.core.controller.IAgentController;
import com.kms.katalon.ai.core.controller.IStudioAssistChatController;
import com.kms.katalon.ai.core.dto.StudioAssistAcceptAnswerRequest;
import com.kms.katalon.ai.core.dto.StudioAssistAgentSettingTrackingRequest;
import com.kms.katalon.ai.core.dto.StudioAssistChangeChatModeRequest;
import com.kms.katalon.ai.core.dto.StudioAssistChatAskQuestionRequest;
import com.kms.katalon.ai.core.dto.StudioAssistChatAttachFileRequest;
import com.kms.katalon.ai.core.dto.StudioAssistChatCancelQuestionRequest;
import com.kms.katalon.ai.core.dto.StudioAssistChatClearConversationRequest;
import com.kms.katalon.ai.core.dto.StudioAssistChatRateConversationRequest;
import com.kms.katalon.ai.core.dto.StudioAssistChatToggleIncludeFocusingFileRequest;
import com.kms.katalon.ai.core.dto.StudioAssistRejectAnswerRequest;
import com.kms.katalon.ai.core.dto.StudioAssistSettingRequest;
import com.kms.katalon.ai.core.dto.StudioAssistToolCallRequest;
import com.kms.katalon.ai.core.model.StudioAssistChatAnswerMessageFuture;
import com.kms.katalon.ai.core.model.agent.AgentConversation;
import com.kms.katalon.ai.core.model.agent.AgentMessage;
import com.kms.katalon.ai.core.model.agent.AgentMessageStatus;
import com.kms.katalon.ai.core.model.agent.AgentSetting;
import com.kms.katalon.ai.core.model.agent.MaxedToolCallStatus;
import com.kms.katalon.ai.core.model.agent.McpClient;
import com.kms.katalon.ai.core.model.agent.McpServerConnectionStatus;
import com.kms.katalon.ai.core.model.agent.config.McpHttpServerDefinition;
import com.kms.katalon.ai.core.model.agent.config.McpServerDefinition;
import com.kms.katalon.ai.core.model.agent.config.McpSetting;
import com.kms.katalon.ai.core.model.agent.config.McpSseServerDefinition;
import com.kms.katalon.ai.core.model.agent.event.AgentMessageUpdatedEvent;
import com.kms.katalon.ai.core.model.agent.event.McpClientAuthorizedEvent;
import com.kms.katalon.ai.core.model.agent.event.McpClientUpdatedEvent;
import com.kms.katalon.ai.core.model.chat.ChatConversationAnswerWarning;
import com.kms.katalon.ai.core.model.chat.ChatMode;
import com.kms.katalon.ai.core.model.chat.ResponseMessage;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatAnswerMessage;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatAttachment;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatQuestionMessage;
import com.kms.katalon.ai.core.model.chat.StudioAssistConversation;
import com.kms.katalon.ai.core.model.chat.StudioAssistFunctionAvailability;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.config.StudioAssistConfigType;
import com.kms.katalon.ai.core.model.exception.StudioAssistBaseException;
import com.kms.katalon.ai.core.model.exception.StudioAssistConfigUnavailableException;
import com.kms.katalon.ai.core.model.exception.StudioAssistDisabledException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiAiSettingDisabledException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiAuthenticationException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiClientException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiIncompatibleModelException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiNoInternetException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiResourceExhaustedException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiServerContentViolatedException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiServerNoAnswerException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiServerTokenExceededException;
import com.kms.katalon.ai.core.model.prompt.PromptType;
import com.kms.katalon.ai.core.services.IAgentPreferences;
import com.kms.katalon.ai.core.services.IStudioAssistController;
import com.kms.katalon.ai.core.util.AttachmentUtil;
import com.kms.katalon.ai.worker.StudioAssistChatAnswerManageWorker;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.composer.ai.constants.ComposerStudioAssistConstants;
import com.kms.katalon.composer.ai.studioassist.dialog.McpServerAddingDialog;
import com.kms.katalon.composer.ai.studioassist.dialog.McpToolApprovalResetDialog;
import com.kms.katalon.composer.ai.studioassist.dialog.ProjectFileSelectionDialog;
import com.kms.katalon.composer.ai.studioassist.part.ProcessStatus;
import com.kms.katalon.composer.ai.studioassist.part.StudioAssistPartListener;
import com.kms.katalon.composer.components.impl.tree.AbstractTreeEntity;
import com.kms.katalon.composer.components.impl.tree.KeywordTreeEntity;
import com.kms.katalon.composer.components.impl.tree.ProfileTreeEntity;
import com.kms.katalon.composer.components.impl.tree.SystemFileTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestListenerTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestSuiteTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.constant.StudioAssistChatOpenOperationEnum;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.setting.StudioAssistSetting;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.session.core.model.Account;
import com.kms.katalon.session.core.model.Session;
import com.kms.katalon.session.core.services.ISessionController;
import com.kms.katalon.webserver.WebViewController;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.File;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public abstract class StudioAssistChatNavigator
extends StudioAssistPartListener {
    private final Logger logger = LoggerFactory.getLogger(StudioAssistChatNavigator.class);
    private static final String UPDATE_EXECUTING_STATUS_SCRIPT_STRUCTURE = "updateExecutingStatus('%s');";
    private static final String POPULATE_ERROR_SCRIPT_STRUCTURE = "%s({error:{errorCode:%s, errorMessage: %s, type: %s, retryEnabled: %s}});";
    private static final String POPULATE_NORMAL_SCRIPT_STRUCTURE = "%s({questionMsgId: %s, answerContent: %s, isFinished: %b, toolCalls: %s, maxedToolCallStatus: %s, status: %s});";
    private static final String POPULATE_ANSWER_METHOD_NAME = "populateAnswer";
    private static final String POPULATE_UPDATE_FOLLOW_UP_QUESTIONS = "updateFollowUpQuestions(%s);";
    private static final String UPDATE_CONVERSATION_ID_SCRIPT_STRUCTURE = "updateConversationId('%s');";
    private static final String UPDATE_MCP_SETTING_STATUS_SCRIPT_STRUCTURE = "updateMcpSettingStatus(%b);";
    private static final String UPDATE_FUNCTION_AVAILABILITY_SCRIPT_STRUCTURE = "updateFunctionAvailability('%s');";
    private static final String UPDATE_PROJECT_CONTEXT = "updateProjectContext(%b, %b, %b);";
    private static final String UPDATE_STUDIO_ASSIST_CONFIG = "updateStudioAssistConfig('%s');";
    private static final String ADD_ATTACHMENTS = "addAttachments(%s)";
    private static final String UPDATE_ATTACHMENTS_ON_CHANGING_PROJECT = "updateAttachmentsOnChangingProject('%s')";
    private static final String UPDATE_AGENT_MODE_BADGE_STATUS_SCRIPT_STRUCTURE = "updateAgentModeBadgeStatus(%b);";
    protected StudioAssistChatAnswerManageWorker answerWorker;
    @Inject
    protected IStudioAssistChatController studioAssistChatController;
    @Inject
    private ISessionController sessionController;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    protected IStudioAssistController studioAssistController;
    @Inject
    private IAgentController agentController;
    @Inject
    private IAgentPreferences agentPreferences;
    protected IAgentSessionContext sessionContext;
    private ChatMode currentChatMode = ChatMode.ASK;

    protected abstract Composite getMainComposite();

    @PostConstruct
    public void initializeSession() {
        this.sessionContext = this.agentController.createSession();
    }

    @Inject
    @Optional
    private void onAskQuestion(@UIEventTopic(value="ON_CHAT_ASK_QUESTION") StudioAssistChatAskQuestionRequest request) {
        try {
            String conversationId = request.getConversationId();
            String questionId = request.getQuestionId();
            String questionContent = request.getQuestionContent();
            this.logger.info("Received question: " + questionContent + " | conversationId: " + conversationId + " | questionId: " + questionId);
            this.browser.evaluate(this.prepareEvaluationUpdateProcessingStatusScript(ProcessStatus.SYNC_CONTEXT));
            ChatMode chatMode = request.getChatMode();
            List contexts = this.referenceContextController.getContext(conversationId, questionId, PromptType.CHATBOT, chatMode);
            this.browser.evaluate(this.prepareEvaluationUpdateProcessingStatusScript(ProcessStatus.ANALYZE_FILE));
            List submittedAttachments = request.getAttachments();
            List<StudioAssistChatAttachment> attachments = this.loadAttachmentContents(submittedAttachments);
            this.studioAssistChatController.trackUsingAttachment(conversationId, questionId, attachments, this.currentChatMode.name().toLowerCase());
            this.browser.evaluate(this.prepareEvaluationUpdateProcessingStatusScript(ProcessStatus.GENERATE_RESPONSE));
            if (chatMode == ChatMode.AGENT) {
                StudioAssistChatQuestionMessage questionMessage = new StudioAssistChatQuestionMessage(this.sessionContext.getCurrentConversationId(), questionId, questionContent, attachments);
                if (request.isRetrying()) {
                    this.sessionContext.retryMessage(questionMessage);
                } else {
                    this.sessionContext.sendMessage(questionMessage);
                }
            } else {
                StudioAssistChatQuestionMessage questionMessage = new StudioAssistChatQuestionMessage(conversationId, questionId, questionContent, attachments);
                StudioAssistChatAnswerMessageFuture answerFuture = request.isRetrying() ? this.studioAssistChatController.retryQuestion(contexts, questionMessage) : this.studioAssistChatController.askQuestion(contexts, questionMessage);
                this.answerWorker = new StudioAssistChatAnswerManageWorker(this::evaluateScriptConsumer, answerFuture);
                this.answerWorker.start();
            }
        }
        catch (Exception e) {
            this.logger.error("Exception while handle ON_ASK_QUESTION event", (Throwable)e);
            LogUtil.logError((Throwable)e, (String)"Exception while handle event studio assist ask question");
            this.evaluatePopulateMessageScript(null, e);
        }
    }

    @Inject
    @Optional
    private void onChatRequestAiAccess(@UIEventTopic(value="ON_CHAT_REQUEST_AI_ACCESS") Object data) {
        try {
            String myServerUrl = ApplicationInfo.getMyServerUrl();
            Session session = this.sessionController.getSession();
            Account account = session.getAccount();
            String accountId = String.valueOf(account.getId());
            String url = "%s/enable-ai-settings?accountId=%s".formatted(myServerUrl, accountId);
            this.browser.setUrl(url);
        }
        catch (Exception e) {
            this.logger.error("Exception while handle ON_CHAT_REQUEST_AI_ACCESS event", (Throwable)e);
            LogUtil.logError((Throwable)e, (String)"Exception while handle event studio assist request ai ");
        }
    }

    @Inject
    @Optional
    private void onChatOpenAiSetting(@UIEventTopic(value="ON_CHAT_OPEN_AI_SETTING") Object data) {
        try {
            this.eventBroker.post("KATALON/PREFERENCES", (Object)"com.kms.katalon.composer.preferences.GeneralPreferencePage/com.kms.katalon.composer.ai");
        }
        catch (Exception e) {
            this.logger.error("Exception while handle ON_CHAT_OPEN_AI_SETTING event", (Throwable)e);
            LogUtil.logError((Throwable)e, (String)"Exception while handle event studio assist open ai setting");
        }
    }

    @Inject
    @Optional
    private void onChatCancelRequest(@UIEventTopic(value="ON_CHAT_CANCEL_QUESTION") StudioAssistChatCancelQuestionRequest cancelQuestionRequest) {
        try {
            String conversationId = cancelQuestionRequest.getConversationId();
            String questionMsgId = cancelQuestionRequest.getQuestionMsgId();
            ChatMode chatMode = cancelQuestionRequest.getChatMode();
            switch (chatMode) {
                case AGENT: {
                    AgentMessage agentMessage = this.sessionContext.findAgentMessageById(questionMsgId);
                    if (agentMessage == null || agentMessage.isFinished()) break;
                    this.sessionContext.stopGeneration(agentMessage);
                    break;
                }
            }
            if (this.answerWorker != null && this.answerWorker.isWorkingOnConversationAndQuestionId(conversationId, questionMsgId)) {
                this.answerWorker.cancel();
            }
        }
        catch (Exception e) {
            this.logger.error("Exception while handle ON_CHAT_CANCEL_QUESTION event", (Throwable)e);
            LogUtil.logError((Throwable)e, (String)"Exception while handle event studio assist cancel question");
        }
    }

    @Inject
    @Optional
    private void onChatAcceptAnswer(@UIEventTopic(value="ON_CHAT_ACCEPT_ANSWER") StudioAssistAcceptAnswerRequest acceptAnswerRequest) {
        try {
            String conversationId = acceptAnswerRequest.getConversationId();
            String questionMsgId = acceptAnswerRequest.getQuestionMsgId();
            String questionContent = acceptAnswerRequest.getQuestionContent();
            String answerContent = acceptAnswerRequest.getAnswerContent();
            ChatMode chatMode = acceptAnswerRequest.getChatMode();
            ArrayList attachments = new ArrayList();
            java.util.Optional.ofNullable(acceptAnswerRequest.getAttachments()).orElse(Collections.emptyList()).stream().forEach(item -> {
                try {
                    StudioAssistChatAttachment attachmentFromCache = this.referenceContextController.loadAttachmentContent(item);
                    if (attachmentFromCache != null) {
                        attachments.add(attachmentFromCache);
                    }
                }
                catch (Exception e) {
                    this.logger.warn("Exception while loadAttachmentContent", (Throwable)e);
                }
            });
            switch (chatMode) {
                case AGENT: {
                    this.followUpQuestions(chatMode, this.sessionContext.getCurrentConversationId(), questionMsgId);
                    break;
                }
                default: {
                    this.studioAssistChatController.appendToConversation(new StudioAssistChatQuestionMessage(conversationId, questionMsgId, questionContent, attachments), new StudioAssistChatAnswerMessage(conversationId, questionMsgId, answerContent, null), true);
                    this.followUpQuestions(chatMode, conversationId, questionMsgId);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Exception while handle ON_CHAT_ACCEPT_ANSWER event", (Throwable)e);
            LogUtil.logError((Throwable)e, (String)"Exception while handle event studio assist accept answer");
        }
    }

    @Inject
    @Optional
    private void onChatRejectAnswer(@UIEventTopic(value="ON_CHAT_REJECT_ANSWER") StudioAssistRejectAnswerRequest rejectAnswerRequest) {
        try {
            String conversationId = rejectAnswerRequest.getConversationId();
            String questionMsgId = rejectAnswerRequest.getQuestionMsgId();
            String questionContent = rejectAnswerRequest.getQuestionContent();
            String answerContent = rejectAnswerRequest.getAnswerContent();
            ChatMode chatMode = rejectAnswerRequest.getChatMode();
            switch (chatMode) {
                case AGENT: {
                    this.followUpQuestions(chatMode, this.sessionContext.getCurrentConversationId(), questionMsgId);
                    break;
                }
                default: {
                    this.studioAssistChatController.appendToConversation(new StudioAssistChatQuestionMessage(conversationId, questionMsgId, questionContent), new StudioAssistChatAnswerMessage(conversationId, questionMsgId, answerContent, null), false);
                    this.followUpQuestions(chatMode, conversationId, questionMsgId);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Exception while handle ON_CHAT_REJECT_ANSWER event", (Throwable)e);
            LogUtil.logError((Throwable)e, (String)"Exception while handle event studio assist reject answer");
        }
    }

    @Inject
    @Optional
    private void onChatClearConversation(@UIEventTopic(value="ON_CHAT_CLEAR_CONVERSATION") StudioAssistChatClearConversationRequest clearConversationRequest) {
        try {
            this.referenceContextController.clear();
            String conversationId = clearConversationRequest.getConversationId();
            ChatMode chatMode = clearConversationRequest.getChatMode();
            switch (chatMode) {
                case AGENT: {
                    this.sessionContext.clearConversation();
                    break;
                }
                case ASK: {
                    this.studioAssistChatController.cleanUpConversation(conversationId);
                    break;
                }
            }
            this.updateCurrentConversationIdByChatMode(chatMode);
        }
        catch (Exception e) {
            this.logger.error("Exception while handle ON_CHAT_CLEAR_CONVERSATION event", (Throwable)e);
            LogUtil.logError((Throwable)e, (String)"Exception while handle event studio assist clear conversation");
        }
    }

    @Inject
    @Optional
    private void onTrackingOpenChatWindow(final @UIEventTopic(value="ON_TRACKING_OPEN_CHAT_WINDOW") StudioAssistChatOpenOperationEnum operation) {
        Thread trackingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                StudioAssistFunctionAvailability validateFunctionAvailability = StudioAssistChatNavigator.this.studioAssistChatController.validateFunctionAvailability();
                String operationStr = operation.toString();
                String availabilityStr = validateFunctionAvailability.toString();
                StudioAssistChatNavigator.this.studioAssistChatController.trackOpenStudioAssistChat(operationStr, availabilityStr, StudioAssistChatNavigator.this.currentChatMode.name().toLowerCase());
                StudioAssistChatNavigator.this.logger.trace("onTrackingOpenChatWindow -> %s | %s".formatted(operationStr, availabilityStr));
            }
        });
        trackingThread.start();
    }

    @Inject
    @Optional
    private void onChatPageLoadCompleted(@UIEventTopic(value="ON_CHAT_PAGE_LOAD_COMPLETED") Object object) {
        CompletableFuture.runAsync(() -> {
            try {
                boolean hasOpenedProject;
                UISynchronizeService.syncExec(() -> {
                    Object object = this.browser.evaluate(UPDATE_AGENT_MODE_BADGE_STATUS_SCRIPT_STRUCTURE.formatted(StudioAssistSetting.shouldDisplayAgentModeBadge()), true);
                });
                boolean bl = hasOpenedProject = ProjectController.getInstance().getCurrentProject() != null;
                if (hasOpenedProject) {
                    UISynchronizeService.syncExec(() -> this.checkFocusingFile(null));
                }
                List mcpClients = this.sessionContext.getMcpClients();
                boolean hasError = mcpClients.stream().anyMatch(client -> client.getStatus() == McpServerConnectionStatus.ERROR);
                UISynchronizeService.syncExec(() -> {
                    Object object = this.browser.evaluate(UPDATE_MCP_SETTING_STATUS_SCRIPT_STRUCTURE.formatted(hasError), true);
                });
                StudioAssistFunctionAvailability availability = this.studioAssistChatController.validateFunctionAvailability();
                UISynchronizeService.syncExec(() -> {
                    Object object = this.browser.evaluate(UPDATE_FUNCTION_AVAILABILITY_SCRIPT_STRUCTURE.formatted(availability), true);
                });
                StudioAssistConfig config = this.studioAssistController.getConfig();
                if (config != null) {
                    StudioAssistConfigType type = config.getType();
                    UISynchronizeService.syncExec(() -> {
                        Object object = this.browser.evaluate(this.prepareEvaluationUpdateStudioConfig(type.getDisplayName()));
                    });
                }
                UISynchronizeService.syncExec(() -> this.updateCurrentConversationIdByChatMode(this.currentChatMode));
            }
            catch (Exception e) {
                this.logger.error("Exception while handle ON_CHAT_PAGE_LOAD_COMPLETED event", (Throwable)e);
                LogUtil.logError((Throwable)e, (String)"Exception while handle event studio assist page load completed");
            }
        });
    }

    @Inject
    @Optional
    private void onSaUpdateAttachment(@UIEventTopic(value="STUDIOASSIST/UPDATE_ATTACHMENT") Object object) {
        MStackElement mStackElement;
        MPartStack composerStack = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
        if (composerStack == null) {
            return;
        }
        if (composerStack.isVisible() && (mStackElement = (MStackElement)composerStack.getSelectedElement()) instanceof MPart) {
            MPart part = (MPart)mStackElement;
            this.partBroughtToTop(part);
        }
    }

    @Inject
    @Optional
    private void checkFocusingFile(@UIEventTopic(value="EXPLORER/SET_SELECTED_ITEM") Object object) {
        this.onSaUpdateAttachment(object);
    }

    @Inject
    @Optional
    private void onOpenedProject(@UIEventTopic(value="PROJECT/OPENED") Object object) {
        boolean objectRepositoryProjectContextEnabled = StudioAssistSetting.isProjectContextObjectRepositoriesEnabled();
        boolean customKeywordsProjectContextEnabled = false;
        this.browser.evaluate(this.prepareEvaluationUpdateProjectContextDescriptionScript(objectRepositoryProjectContextEnabled, customKeywordsProjectContextEnabled, true));
        this.browser.evaluate(this.prepareEvaluationUpdateAttachmentsOnChangingProject(ProjectController.getInstance().getCurrentProject().getFolderLocation()));
    }

    @Inject
    @Optional
    private void onClosedProject(@UIEventTopic(value="PROJECT/CLOSED") Object object) {
        boolean objectRepositoryProjectContextEnabled = false;
        boolean customKeywordsProjectContextEnabled = false;
        this.browser.evaluate(this.prepareEvaluationUpdateProjectContextDescriptionScript(objectRepositoryProjectContextEnabled, customKeywordsProjectContextEnabled, false));
        this.browser.evaluate(this.prepareEvaluationUpdateAttachmentsOnChangingProject(null));
    }

    @Inject
    @Optional
    private void onToggleIncludingCurrentFile(@UIEventTopic(value="ON_CHAT_TOGGLE_INCLUDE_FOCUSING_FILE") Object object) {
        if (object instanceof StudioAssistChatToggleIncludeFocusingFileRequest) {
            StudioAssistChatToggleIncludeFocusingFileRequest toggleRequest = (StudioAssistChatToggleIncludeFocusingFileRequest)object;
            StudioAssistSetting.toggleIncludeCurrentFile((boolean)toggleRequest.isIncludeFocusingFile());
        }
    }

    @Inject
    @Optional
    private void onSaSettingChange(@UIEventTopic(value="ON_SA_SETTING_CHANGE") Object object) {
        try {
            ProjectEntity currentProject;
            StudioAssistConfig config = this.studioAssistController.getConfig();
            if (config != null) {
                StudioAssistConfigType type = config.getType();
                this.browser.evaluate(this.prepareEvaluationUpdateStudioConfig(type.getDisplayName()));
            }
            if ((currentProject = ProjectController.getInstance().getCurrentProject()) == null) {
                return;
            }
            boolean objectRepositoryProjectContextEnabled = StudioAssistSetting.isProjectContextObjectRepositoriesEnabled();
            boolean customKeywordsProjectContextEnabled = StudioAssistSetting.isProjectContextCustomKeywordsEnabled();
            this.browser.evaluate(this.prepareEvaluationUpdateProjectContextDescriptionScript(objectRepositoryProjectContextEnabled, customKeywordsProjectContextEnabled, true));
            this.onChatPageLoadCompleted(object);
        }
        catch (Exception e) {
            this.logger.error("Exception while handle ON_SA_SETTING_CHANGE event", (Throwable)e);
            LogUtil.logError((Throwable)e, (String)"Exception while handle event studio assist setting change");
        }
    }

    @Inject
    @Optional
    private void onAttachFileFromProject(@UIEventTopic(value="ON_CHAT_ATTACH_FILE_FROM_PROJECT") Object object) {
        if (StudioAssistSetting.shouldDisplayAttachmentBadge()) {
            StudioAssistSetting.setToHideAttachmentBadge();
        }
        try {
            ProjectFileSelectionDialog dialog = new ProjectFileSelectionDialog(null);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                ArrayList<StudioAssistChatAttachment> selectedAttachments = new ArrayList<StudioAssistChatAttachment>();
                List<ITreeEntity> objectList = dialog.getSelectedItems();
                for (ITreeEntity each : objectList) {
                    StudioAssistFileType fileType = StudioAssistFileType.OTHER;
                    String filePath = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{each.getPropertyValue("id"), each.getPropertyValue("name")});
                    if (each instanceof AbstractTreeEntity) {
                        AbstractTreeEntity abstractTreeEntity = (AbstractTreeEntity)each;
                        FileEntity fileEntity = (FileEntity)abstractTreeEntity.getObject();
                        filePath = fileEntity.getId();
                    }
                    if (each instanceof TestCaseTreeEntity) {
                        fileType = StudioAssistFileType.TEST_CASE;
                    } else if (each instanceof TestSuiteTreeEntity) {
                        fileType = StudioAssistFileType.TEST_SUITE;
                    } else if (each instanceof ProfileTreeEntity) {
                        fileType = StudioAssistFileType.PROFILE;
                    } else if (each instanceof WebElementTreeEntity) {
                        fileType = StudioAssistFileType.WEB_SERVICE_OBJECT;
                    } else if (each instanceof TestListenerTreeEntity) {
                        fileType = StudioAssistFileType.LISTENER;
                    } else if (each instanceof KeywordTreeEntity) {
                        boolean isJavaFile;
                        KeywordTreeEntity keywordTreeEntity = (KeywordTreeEntity)each;
                        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
                        String projectPath = currentProject.getFolderLocation();
                        ICompilationUnit keywordFile = (ICompilationUnit)keywordTreeEntity.getObject();
                        Object[] segments = keywordFile.getPath().segments();
                        if (segments.length > 0) {
                            segments[0] = projectPath;
                            filePath = StringUtils.join((Object[])segments, (String)System.getProperty("file.separator"));
                        }
                        fileType = (isJavaFile = filePath.toLowerCase().endsWith(".java")) ? StudioAssistFileType.JAVA : StudioAssistFileType.GROOVY;
                    } else if (each instanceof SystemFileTreeEntity && filePath.toLowerCase().endsWith(".feature")) {
                        fileType = StudioAssistFileType.FEATURE_FILE;
                    }
                    selectedAttachments.add(new StudioAssistChatAttachment(fileType, filePath, this.referenceContextController.validateAttachment(filePath, fileType), StudioAssistAttachmentSource.ATTACHMENT));
                }
                if (selectedAttachments != null && selectedAttachments.size() > 0) {
                    this.browser.evaluate(this.prepareEvaluationAddAttachments(selectedAttachments));
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Exception while trying to open File(s) browsered from Project ", (Throwable)e);
        }
    }

    @Inject
    @Optional
    private void onAttachFileFromComputer(@UIEventTopic(value="ON_CHAT_ATTACH_FILE_FROM_COMPUTER") StudioAssistChatAttachFileRequest request) {
        if (StudioAssistSetting.shouldDisplayAttachmentBadge()) {
            StudioAssistSetting.setToHideAttachmentBadge();
        }
        FileDialog dialog = new FileDialog(this.getMainComposite().getShell(), 2);
        dialog.open();
        if (dialog.getFileNames() == null) {
            return;
        }
        ArrayList<StudioAssistChatAttachment> selectedAttachments = new ArrayList<StudioAssistChatAttachment>();
        Path currentPath = Path.of(dialog.getFilterPath(), new String[0]);
        String[] stringArray = dialog.getFileNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName;
            String filePath = fileName = stringArray[n2];
            if (!new File(fileName).exists()) {
                Path pathToFile = currentPath.resolve(fileName);
                filePath = pathToFile.toString();
            }
            StudioAssistChatAttachment attachment = new StudioAssistChatAttachment(StudioAssistFileType.OTHER, filePath, AttachmentUtil.checkAttachmentStatus((String)filePath), StudioAssistAttachmentSource.ATTACHMENT);
            selectedAttachments.add(attachment);
            ++n2;
        }
        if (selectedAttachments != null && selectedAttachments.size() > 0) {
            this.browser.evaluate(this.prepareEvaluationAddAttachments(selectedAttachments));
        }
    }

    @Inject
    @Optional
    private void onAgentMessageUpdated(@UIEventTopic(value="STUDIOASSIST_AGENT_MESSAGE_UPDATED") AgentMessageUpdatedEvent event) {
        this.evaluateScriptConsumer((ResponseMessage)event.getMessage(), null);
    }

    @Inject
    @Optional
    private void onAddMcpServer(@UIEventTopic(value="ON_STUDIO_ASSIST_ADD_MCP_SERVER") StudioAssistSettingRequest request) {
        try {
            this.trackStudioAssistAgentSettingAction(StudioAssistTrackingValueEnum.ADD_MCP_SERVER.getValue());
            BundleContext bundleContext = FrameworkUtil.getBundle(McpServerAddingDialog.class).getBundleContext();
            IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
            McpServerAddingDialog dialog = new McpServerAddingDialog(this.getMainComposite().getShell());
            ContextInjectionFactory.inject((Object)((Object)dialog), (IEclipseContext)context);
            int result = dialog.open();
            if (result == 0) {
                McpServerDefinition server = dialog.getServer();
                this.sessionContext.addServer(server);
            }
        }
        catch (Exception e) {
            this.logger.error("Exception while handle ON_STUDIO_ASSIST_ADD_MCP_SERVER event", (Throwable)e);
            LogUtil.logError((Throwable)e, (String)"Exception while handle event studio assist add mcp server");
        }
    }

    @Inject
    @Optional
    private void openMcpSetting(@UIEventTopic(value="ON_STUDIO_ASSIST_OPEN_MCP_SETTING") StudioAssistSettingRequest request) {
        try {
            this.trackStudioAssistAgentSettingAction(StudioAssistTrackingValueEnum.CLICK_TOOL_SETTING.getValue());
            URIBuilder uriBuilder = WebViewController.getInstance().buildURIBuilder("StudioAssistSetting.html");
            String url = uriBuilder.toString();
            this.browser.setUrl(url);
        }
        catch (Exception e) {
            this.logger.error("Exception while handle ON_STUDIO_ASSIST_OPEN_MCP_SETTING event", (Throwable)e);
            LogUtil.logError((Throwable)e, (String)"Exception while handle event studio assist open mcp setting");
        }
    }

    @Inject
    @Optional
    private void updateMcpClients(@UIEventTopic(value="ON_STUDIO_ASSIST_SETTING_OPENED") StudioAssistSettingRequest request) {
        this.updateMcpClients();
    }

    @Inject
    @Optional
    private void toolSelected(@UIEventTopic(value="ON_STUDIO_ASSIST_SELECT_TOOL") StudioAssistSettingRequest request) {
        try {
            String serverName = request.getServerName();
            String toolId = request.getToolName();
            this.sessionContext.selectTool(serverName, toolId);
        }
        catch (Exception e) {
            this.logger.error("Exception while handle ON_STUDIO_ASSIST_SELECT_TOOL event", (Throwable)e);
            LogUtil.logError((Throwable)e, (String)"Exception while handle event studio assist select tool");
        }
    }

    @Inject
    @Optional
    private void toolDeselected(@UIEventTopic(value="ON_STUDIO_ASSIST_DESELECT_TOOL") StudioAssistSettingRequest request) {
        try {
            String serverName = request.getServerName();
            String toolId = request.getToolName();
            this.sessionContext.deselectTool(serverName, toolId);
        }
        catch (Exception e) {
            this.logger.error("Exception while handle ON_STUDIO_ASSIST_DESELECT_TOOL event", (Throwable)e);
            LogUtil.logError((Throwable)e, (String)"Exception while handle event studio assist deselect tool");
        }
    }

    @Inject
    @Optional
    private void allToolsSelected(@UIEventTopic(value="ON_STUDIO_ASSIST_SELECT_ALL_TOOLS") StudioAssistSettingRequest request) {
        try {
            String serverName = request.getServerName();
            this.sessionContext.selectAllTools(serverName);
        }
        catch (Exception e) {
            this.logger.error("Exception while handle ON_STUDIO_ASSIST_SELECT_ALL_TOOLS event", (Throwable)e);
            LogUtil.logError((Throwable)e, (String)"Exception while handle event studio assist select all tools");
        }
    }

    @Inject
    @Optional
    private void allToolsDeselected(@UIEventTopic(value="ON_STUDIO_ASSIST_DESELECT_ALL_TOOLS") StudioAssistSettingRequest request) {
        try {
            String serverName = request.getServerName();
            this.sessionContext.deselectAllTools(serverName);
        }
        catch (Exception e) {
            this.logger.error("Exception while handle ON_STUDIO_ASSIST_DESELECT_ALL_TOOLS event", (Throwable)e);
            LogUtil.logError((Throwable)e, (String)"Exception while handle event studio assist deselect all tools");
        }
    }

    @Inject
    @Optional
    private void maxToolCallRequested(@UIEventTopic(value="ON_STUDIO_ASSIST_MAX_TOOL_CALL") StudioAssistSettingRequest request) {
        try {
            String value = request.getValue();
            AgentSetting agentSetting = this.agentPreferences.loadAgentSetting();
            agentSetting.setMaxToolCalls(Integer.parseInt(value));
            this.agentPreferences.saveAgentSetting(agentSetting);
        }
        catch (Exception e) {
            this.logger.error("Exception while handle ON_STUDIO_ASSIST_MAX_TOOL_CALL event", (Throwable)e);
            LogUtil.logError((Throwable)e, (String)"Exception while handle event studio assist max tool call");
        }
    }

    @Inject
    @Optional
    private void autoToolApprovalRequested(@UIEventTopic(value="ON_STUDIO_ASSIST_AUTO_TOOL_APPROVAL") StudioAssistSettingRequest request) {
        try {
            String value = request.getValue();
            AgentSetting agentSetting = this.agentPreferences.loadAgentSetting();
            agentSetting.setAutoToolApproval(Boolean.parseBoolean(value));
            this.agentPreferences.saveAgentSetting(agentSetting);
        }
        catch (Exception e) {
            this.logger.error("Exception while handle ON_STUDIO_ASSIST_AUTO_TOOL_APPROVAL event", (Throwable)e);
            LogUtil.logError((Throwable)e, (String)"Exception while handle event studio assist auto tool approval");
        }
    }

    @Inject
    @Optional
    private void openMcpToolApprovalReset(@UIEventTopic(value="ON_STUDIO_ASSIST_RESET_TOOL_APPROVAL") StudioAssistSettingRequest request) {
        try {
            this.trackStudioAssistAgentSettingAction(StudioAssistTrackingValueEnum.RESET_TOOL_APPROVAL.getValue());
            BundleContext bundleContext = FrameworkUtil.getBundle(McpToolApprovalResetDialog.class).getBundleContext();
            IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
            McpSetting mcpSetting = this.sessionContext.getMcpSetting();
            McpToolApprovalResetDialog dialog = new McpToolApprovalResetDialog(this.getMainComposite().getShell(), mcpSetting);
            ContextInjectionFactory.inject((Object)((Object)dialog), (IEclipseContext)context);
            int result = dialog.open();
            if (result == 0) {
                AgentSetting agentSetting = dialog.getAgentSetting();
                List mcpServerSettings = agentSetting.getMcpServerSettings();
                this.sessionContext.resetApprovedTools(mcpServerSettings);
                this.updateMcpClients();
                this.trackMcpToolApprovalReset(dialog.getNoOfResetTools());
            }
        }
        catch (Exception e) {
            this.logger.error("Exception while handle ON_STUDIO_ASSIST_RESET_TOOL_APPROVAL event", (Throwable)e);
            this.showErrorDialog(GlobalStringConstants.ERROR, ComposerStudioAssistConstants.DIALOG_MCP_RESET_APPROVED_TOOL_FAILED_TO_OPEN_THE_DIALOG);
        }
    }

    private void trackMcpToolApprovalReset(int noOfResetTools) {
        HashMap<String, Object> trackingData = new HashMap<String, Object>();
        trackingData.put(StudioAssistTrackingKeyEnum.NUMBER_OF_SUCCESSFUL_TOOL_RESET.getValue(), noOfResetTools);
        this.trackStudioAssistAgentSetting(trackingData);
    }

    @Inject
    @Optional
    private void onMcpClientAdded(@UIEventTopic(value="ON_MCP_CLIENT_ADDED") McpServerDefinition server) {
        this.updateMcpClients();
    }

    @Inject
    @Optional
    private void onMcpClientStatusChanged(@UIEventTopic(value="STUDIOASSIST_MCP_CLIENT_UPDATED") McpClientUpdatedEvent event) {
        String mcpClientJson = this.mcpClientToJson(event.getClient());
        try {
            this.browser.evaluate(this.prepareEvaluationUpdateMcpClientScript(mcpClientJson));
        }
        catch (SWTException sWTException) {}
    }

    @Inject
    @Optional
    private void onServerRefreshed(@UIEventTopic(value="ON_STUDIO_ASSIST_AUTO_REFRESH_SERVER") StudioAssistSettingRequest request) {
        this.trackStudioAssistAgentSettingAction(StudioAssistTrackingValueEnum.RELOAD_MCP_SERVER.getValue());
        String serverName = request.getServerName();
        this.sessionContext.refreshClient(serverName);
    }

    @Inject
    @Optional
    private void onServerDeleted(@UIEventTopic(value="ON_STUDIO_ASSIST_AUTO_DELETE_SERVER") StudioAssistSettingRequest request) {
        this.trackStudioAssistAgentSettingAction(StudioAssistTrackingValueEnum.DELETE_MCP_SERVER.getValue());
        String serverName = request.getServerName();
        McpSetting mcpSetting = this.agentPreferences.loadMcpSetting();
        McpServerDefinition serverDefinition = mcpSetting.getServers().stream().filter(server -> serverName.equals(server.getName())).findFirst().orElse(null);
        String serverTitle = serverDefinition != null ? serverDefinition.getTitle() : "";
        String serverUrl = "";
        if (serverDefinition instanceof McpHttpServerDefinition) {
            McpHttpServerDefinition httpServer = (McpHttpServerDefinition)serverDefinition;
            serverUrl = httpServer.getUrl();
        } else if (serverDefinition instanceof McpSseServerDefinition) {
            McpSseServerDefinition sseServer = (McpSseServerDefinition)serverDefinition;
            serverUrl = sseServer.getUrl();
        }
        boolean hasTitle = StringUtils.isNotBlank((CharSequence)serverTitle);
        String detailedMessage = MessageFormat.format(ComposerStudioAssistConstants.DIALOG_MCP_SERVER_DELETE_MESSAGE, hasTitle ? serverTitle : serverName);
        String serverDisplayName = hasTitle ? String.format("%s: %s (%s)", serverName, serverTitle, serverUrl) : String.format("%s (%s)", serverName, serverUrl);
        String warningQuestion = MessageFormat.format(ComposerStudioAssistConstants.DIALOG_MCP_SERVER_DELETE_WARNING, serverDisplayName);
        String fullMessage = detailedMessage + "\n" + warningQuestion;
        MessageDialog dialog = new MessageDialog(this.getMainComposite().getShell(), ComposerStudioAssistConstants.DIALOG_MCP_SERVER_DELETE_TITLE, null, fullMessage, 3, new String[]{ComposerStudioAssistConstants.DIALOG_MCP_SERVER_CANCEL_BUTTON_LABEL, ComposerStudioAssistConstants.DIALOG_MCP_SERVER_REMOVE_BUTTON_LABEL}, 1){

            protected void createButtonsForButtonBar(Composite parent) {
                super.createButtonsForButtonBar(parent);
                Button removeButton = this.getButton(1);
                if (removeButton != null) {
                    removeButton.setBackground(ColorUtil.REMOVE_BUTTON_COLOR);
                    removeButton.setForeground(ColorUtil.WHITE_COLOR);
                }
            }
        };
        if (dialog.open() == 1) {
            this.sessionContext.removeServer(serverName);
            this.updateMcpClients();
            this.logger.info("MCP server '{}' has been successfully removed", (Object)serverName);
        } else {
            this.logger.debug("MCP server deletion cancelled by user for server: {}", (Object)serverName);
        }
    }

    @Inject
    @Optional
    private void onServerEnabled(@UIEventTopic(value="ON_STUDIO_ASSIST_ENABLE_SERVER") StudioAssistSettingRequest request) {
        try {
            String serverName = request.getServerName();
            this.sessionContext.enableServer(serverName);
            this.updateMcpClients();
            this.logger.info("MCP server '{}' has been enabled", (Object)serverName);
        }
        catch (Exception e) {
            this.logger.error("Exception while handle ON_STUDIO_ASSIST_ENABLE_SERVER event", (Throwable)e);
            LogUtil.logError((Throwable)e, (String)"Exception while handle event studio assist enable server");
        }
    }

    @Inject
    @Optional
    private void onServerDisabled(@UIEventTopic(value="ON_STUDIO_ASSIST_DISABLE_SERVER") StudioAssistSettingRequest request) {
        try {
            String serverName = request.getServerName();
            this.sessionContext.disableServer(serverName);
            this.updateMcpClients();
            this.logger.info("MCP server '{}' has been disabled", (Object)serverName);
        }
        catch (Exception e) {
            this.logger.error("Exception while handle ON_STUDIO_ASSIST_DISABLE_SERVER event", (Throwable)e);
            LogUtil.logError((Throwable)e, (String)"Exception while handle event studio assist disable server");
        }
    }

    @Inject
    @Optional
    private void onServerAuthorizationRequested(@UIEventTopic(value="ON_STUDIO_ASSIST_AUTHORIZE_SERVER") StudioAssistSettingRequest request) {
        try {
            String serverName = request.getServerName();
            AuthorizationRequest authRequest = this.sessionContext.requestServerAuthorization(serverName);
            if (authRequest != null) {
                Program.launch((String)authRequest.getUri().toString());
            }
        }
        catch (Exception e) {
            this.logger.error("Exception while handle ON_STUDIO_ASSIST_AUTHORIZE_SERVER event", (Throwable)e);
        }
    }

    @Inject
    @Optional
    private void onServerAuthorized(@UIEventTopic(value="STUDIOASSIST_MCP_CLIENT_AUTHORIZED") McpClientAuthorizedEvent event) {
        try {
            this.sessionContext.authorizeClient(event.getState(), event.getAuthorizationCode());
        }
        catch (Exception e) {
            this.logger.error("Exception while handle ON_STUDIO_ASSIST_AUTHORIZE_SERVER event", (Throwable)e);
        }
    }

    private void updateMcpClients() {
        List mcpClients = this.sessionContext.getMcpClients();
        McpSetting mcpSetting = this.sessionContext.getMcpSetting();
        AgentSetting agentSetting = this.agentPreferences.loadAgentSetting();
        String mcpClientsJson = this.mcpClientstoJson(mcpClients);
        String mcpSettingJson = mcpSetting.toJson();
        String agentSettingJson = agentSetting.toJson();
        this.browser.evaluate(this.prepareEvaluationUpdateMcpClientsScript(mcpClientsJson, mcpSettingJson, agentSettingJson));
    }

    @Inject
    @Optional
    private void approveToolCall(@UIEventTopic(value="ON_STUDIO_ASSIST_APPROVE_TOOL_CALL") StudioAssistToolCallRequest request) {
        try {
            AgentMessage agentMessage = this.sessionContext.findAgentMessageById(request.getMessageId());
            if (agentMessage == null) {
                this.logger.error("AgentMessage not found for messageId: " + request.getMessageId());
                return;
            }
            this.sessionContext.approveToolCall(agentMessage, request.getApproval());
        }
        catch (Exception e) {
            this.logger.error("Exception while handle ON_STUDIO_ASSIST_APPROVE_TOOL_CALL event", (Throwable)e);
        }
    }

    @Inject
    @Optional
    private void denyToolCall(@UIEventTopic(value="ON_STUDIO_ASSIST_DENY_TOOL_CALL") StudioAssistToolCallRequest request) {
        try {
            AgentMessage agentMessage = this.sessionContext.findAgentMessageById(request.getMessageId());
            if (agentMessage == null) {
                this.logger.error("AgentMessage not found for messageId: " + request.getMessageId());
                return;
            }
            this.sessionContext.denyToolCall(agentMessage);
        }
        catch (Exception e) {
            this.logger.error("Exception while handle ON_STUDIO_ASSIST_DENY_TOOL_CALL event", (Throwable)e);
        }
    }

    @Inject
    @Optional
    private void acknowledgeMaxedToolCall(@UIEventTopic(value="ON_STUDIO_ASSIST_ACKNOWLEDGE_MAXED_TOOL_CALL") StudioAssistToolCallRequest request) {
        try {
            AgentMessage agentMessage = this.sessionContext.findAgentMessageById(request.getMessageId());
            if (agentMessage == null) {
                this.logger.error("AgentMessage not found for messageId: " + request.getMessageId());
                return;
            }
            this.sessionContext.acknowledgeMaxedToolCall(agentMessage);
        }
        catch (Exception e) {
            this.logger.error("Exception while handle ON_STUDIO_ASSIST_ACKNOWLEDGE_MAXED_TOOL_CALL event", (Throwable)e);
        }
    }

    @Inject
    @Optional
    private void rejectMaxedToolCall(@UIEventTopic(value="ON_STUDIO_ASSIST_REJECT_MAXED_TOOL_CALL") StudioAssistToolCallRequest request) {
        try {
            AgentMessage agentMessage = this.sessionContext.findAgentMessageById(request.getMessageId());
            if (agentMessage == null) {
                this.logger.error("AgentMessage not found for messageId: " + request.getMessageId());
                return;
            }
            this.sessionContext.rejectMaxedToolCall(agentMessage);
        }
        catch (Exception e) {
            this.logger.error("Exception while handle ON_STUDIO_ASSIST_REJECT_MAXED_TOOL_CALL event", (Throwable)e);
        }
    }

    @Inject
    @Optional
    private void onChangeChatMode(@UIEventTopic(value="ON_STUDIO_ASSIST_CHANGE_CHAT_MODE") StudioAssistChangeChatModeRequest request) {
        try {
            ChatMode chatMode = request.getChatMode();
            if (chatMode == null) {
                return;
            }
            this.currentChatMode = chatMode;
            StudioAssistSetting.setCurrentChatMode((String)chatMode.getName());
            this.updateCurrentConversationIdByChatMode(chatMode);
            boolean shouldDisplayAgentModeBadge = StudioAssistSetting.shouldDisplayAgentModeBadge();
            if (chatMode == ChatMode.AGENT && shouldDisplayAgentModeBadge) {
                StudioAssistSetting.setToHideAgentModeBadge();
                this.browser.evaluate(UPDATE_AGENT_MODE_BADGE_STATUS_SCRIPT_STRUCTURE.formatted(!shouldDisplayAgentModeBadge), true);
            }
            this.trackStudioAssistAction(String.format(StudioAssistTrackingValueEnum.SWITCH_MODE.getValue(), chatMode.getName().toLowerCase()));
        }
        catch (Exception e) {
            this.logger.error("Exception while handle ON_CHAT_CHANGE_MODE event", (Throwable)e);
        }
    }

    @Inject
    @Optional
    private void onCloseStudioAssistChat(@UIEventTopic(value="ON_STUDIO_ASSIST_CLOSE_CHAT") Object data) {
        try {
            AgentConversation conversation = null;
            switch (this.currentChatMode) {
                case AGENT: {
                    conversation = this.sessionContext.getConversation();
                    break;
                }
                case ASK: {
                    conversation = this.studioAssistChatController.getCurrentConversation();
                    break;
                }
            }
            this.studioAssistChatController.trackCloseStudioAssistChat((StudioAssistConversation)conversation, this.currentChatMode.name().toLowerCase());
        }
        catch (Exception e) {
            this.logger.error("Failed to track close chat event", (Throwable)e);
        }
    }

    @Inject
    @Optional
    private void onStudioAssistTracking(@UIEventTopic(value="ON_STUDIO_ASSIST_TRACKING") List<Object> trackingData) {
        if (this.isAgentModeTracking(trackingData)) {
            this.studioAssistChatController.addAgentModeTrackingData(trackingData, this.sessionContext);
        }
        trackingData.add(StudioAssistTrackingKeyEnum.CHAT_MODE.getValue());
        trackingData.add(this.currentChatMode.name().toLowerCase());
        this.studioAssistChatController.trackStudioAssistChat(trackingData);
    }

    @Inject
    @Optional
    private void handleRatingConversationEvent(@UIEventTopic(value="ON_STUDIO_ASSIST_RATING_CONVERSATION") StudioAssistChatRateConversationRequest request) {
        if (StringUtils.isBlank((CharSequence)request.getConversationId()) || StringUtils.isBlank((CharSequence)request.getLatestQuestionId())) {
            this.logger.warn("Invalid rating request received: {}", (Object)request);
            return;
        }
        try {
            StudioAssistConversation conversation = this.retrieveConversationByMode();
            if (conversation == null) {
                this.logger.warn("No active conversation found for rating in mode: {}", (Object)this.currentChatMode);
                return;
            }
            this.studioAssistChatController.trackRateConversation(request, conversation, this.currentChatMode);
        }
        catch (Exception e) {
            this.logger.error("Failed to process rating conversation", (Throwable)e);
        }
    }

    @Inject
    @Optional
    private void handleTrackAgentSetting(@UIEventTopic(value="ON_STUDIO_ASSIST_AGENT_SETTING_TRACKING") StudioAssistAgentSettingTrackingRequest request) {
        try {
            if (Objects.isNull(request) || Objects.isNull(request.getTrackingData())) {
                return;
            }
            this.trackStudioAssistAgentSetting(request.getTrackingData());
        }
        catch (Exception e) {
            this.logger.error("Failed to process tracking agent setting", (Throwable)e);
        }
    }

    private boolean isAgentModeTracking(List<Object> trackingData) {
        int index = trackingData.indexOf(StudioAssistTrackingKeyEnum.CHAT_MODE.getValue());
        if (index < 0) {
            return false;
        }
        if (index + 1 < trackingData.size()) {
            Object chatMode = trackingData.get(index + 1);
            return chatMode != null && chatMode instanceof String && String.valueOf(chatMode).equalsIgnoreCase(ChatMode.AGENT.name());
        }
        return false;
    }

    private void updateCurrentConversationIdByChatMode(ChatMode chatMode) {
        String currentConversationId = null;
        switch (chatMode) {
            case AGENT: {
                currentConversationId = this.sessionContext.getCurrentConversationId();
                break;
            }
            case ASK: {
                currentConversationId = this.studioAssistChatController.getCurrentConversationId();
            }
        }
        this.browser.evaluate(UPDATE_CONVERSATION_ID_SCRIPT_STRUCTURE.formatted(currentConversationId), true);
    }

    private String prepareEvaluationUpdateProcessingStatusScript(ProcessStatus status) {
        String script = UPDATE_EXECUTING_STATUS_SCRIPT_STRUCTURE.formatted(new Object[]{status});
        this.logger.trace("prepareEvaluationUpdateProcessingStatusScript -> " + script);
        return script;
    }

    private List<StudioAssistChatAttachment> loadAttachmentContents(List<StudioAssistChatAttachment> attachments) {
        long startTime = System.currentTimeMillis();
        if (attachments == null || attachments.size() <= 0) {
            this.logger.debug("No attachment to analyze");
            return null;
        }
        HashSet<String> usedFileClientIds = new HashSet<String>();
        ArrayList<StudioAssistChatAttachment> result = new ArrayList<StudioAssistChatAttachment>();
        for (StudioAssistChatAttachment each : attachments) {
            StudioAssistChatAttachment loadedEach = null;
            try {
                loadedEach = this.referenceContextController.loadAttachmentContent(each);
            }
            catch (StudioAssistBaseException studioAssistBaseException) {
                String eachName = loadedEach == null ? null : loadedEach.getFilePath();
                this.logger.warn("Error while loading attachment: " + eachName);
            }
            if (loadedEach == null || usedFileClientIds.contains(loadedEach.getFileClientId())) continue;
            usedFileClientIds.add(loadedEach.getFileClientId());
            result.add(loadedEach);
        }
        long totalTime = System.currentTimeMillis() - startTime;
        this.logger.debug("Total time to analyze attachments (ms): " + totalTime);
        return result;
    }

    private void evaluateScriptConsumer(final ResponseMessage msg, final Exception e) {
        StudioAssistChatAnswerMessage answerMessage = null;
        if (msg instanceof StudioAssistChatAnswerMessage) {
            answerMessage = (StudioAssistChatAnswerMessage)msg;
        } else if (msg instanceof AgentMessage) {
            AgentMessage agentMessage = (AgentMessage)msg;
            answerMessage = agentMessage.getFinalAnswer();
        }
        if (answerMessage != null) {
            this.referenceContextController.updateFileIdIntoCache(answerMessage.getUploadedFileMap());
        }
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                StudioAssistChatNavigator.this.evaluatePopulateMessageScript(msg, e);
            }
        });
    }

    private void evaluatePopulateMessageScript(ResponseMessage response, Exception exception) {
        block31: {
            StudioAssistChatAnswerMessage answerMessage;
            block33: {
                ChatConversationAnswerWarning warning;
                block32: {
                    block30: {
                        this.logger.trace("StudioAssistChatAnswerMessage -> " + JsonUtil.toJson((Object)response));
                        if (exception == null) break block30;
                        this.logger.error("evaluatePopulateMessageScript with exception", (Throwable)exception);
                        if (exception instanceof StudioAssistConfigUnavailableException || exception instanceof StudioAssistDisabledException || exception instanceof StudioAssistLlmApiAiSettingDisabledException) {
                            this.browser.evaluate(this.prepareEvaluationPopulateErrorMessageScript(StudioAssistErrorEnum.COMPONENT_FEATURE_DISABLED_ERROR, null, true));
                        } else if (exception instanceof StudioAssistLlmApiNoInternetException) {
                            this.browser.evaluate(this.prepareEvaluationPopulateErrorMessageScript(StudioAssistErrorEnum.COMPONENT_NO_INTERNET_ERROR, null, true));
                        } else if (exception instanceof StudioAssistLlmApiAuthenticationException) {
                            this.browser.evaluate(this.prepareEvaluationPopulateErrorMessageScript(StudioAssistErrorEnum.INLINE_AUTHENTICATION_ERROR, exception.getMessage(), false));
                        } else if (exception instanceof TimeoutException) {
                            this.browser.evaluate(this.prepareEvaluationPopulateErrorMessageScript(StudioAssistErrorEnum.INLINE_TIMEOUT_ERROR, null, true));
                        } else if (exception instanceof StudioAssistLlmApiServerTokenExceededException) {
                            this.browser.evaluate(this.prepareEvaluationPopulateErrorMessageScript(StudioAssistErrorEnum.INLINE_TOKEN_EXCEEDED_ERROR, null, false));
                        } else if (exception instanceof StudioAssistLlmApiServerContentViolatedException) {
                            this.browser.evaluate(this.prepareEvaluationPopulateErrorMessageScript(StudioAssistErrorEnum.INLINE_VIOLATION_ERROR, null, false));
                        } else if (exception instanceof StudioAssistLlmApiIncompatibleModelException) {
                            this.browser.evaluate(this.prepareEvaluationPopulateErrorMessageScript(StudioAssistErrorEnum.COMPONENT_INCOMPATIBLE_AI_MODEL_ERROR, null, false));
                        } else if (exception instanceof StudioAssistLlmApiServerNoAnswerException) {
                            this.browser.evaluate(this.prepareEvaluationPopulateErrorMessageScript(StudioAssistErrorEnum.INLINE_NO_ANSWER_FROM_LLM_ERROR, null, true));
                        } else if (StringUtils.startsWith((CharSequence)exception.getMessage(), (CharSequence)"java.lang.IllegalArgumentException: Invalid JSON syntax.")) {
                            this.browser.evaluate(this.prepareEvaluationPopulateErrorMessageScript(StudioAssistErrorEnum.INLINE_JSON_PARSE_ERROR, null, true));
                        } else if (exception instanceof StudioAssistLlmApiResourceExhaustedException) {
                            StudioAssistLlmApiResourceExhaustedException ex = (StudioAssistLlmApiResourceExhaustedException)exception;
                            this.browser.evaluate(this.prepareEvaluationPopulateErrorMessageScript(StudioAssistErrorEnum.INLINE_GENERAL_ERROR, ex.getMessage(), false));
                        } else if (exception instanceof StudioAssistLlmApiClientException) {
                            StudioAssistLlmApiClientException ex = (StudioAssistLlmApiClientException)exception;
                            this.browser.evaluate(this.prepareEvaluationPopulateErrorMessageScript(StudioAssistErrorEnum.INLINE_GENERAL_ERROR, ex.getMessage(), false));
                        } else {
                            this.browser.evaluate(this.prepareEvaluationPopulateErrorMessageScript(StudioAssistErrorEnum.INLINE_GENERAL_ERROR, exception.getMessage(), true));
                        }
                        break block31;
                    }
                    String questionId = response.getMessageId();
                    answerMessage = null;
                    if (response instanceof StudioAssistChatAnswerMessage) {
                        answerMessage = (StudioAssistChatAnswerMessage)response;
                    } else if (response instanceof AgentMessage) {
                        AgentMessage agentMessage = (AgentMessage)response;
                        answerMessage = agentMessage.getFinalAnswer();
                    }
                    ChatConversationAnswerWarning chatConversationAnswerWarning = warning = answerMessage != null ? answerMessage.getWarning() : null;
                    if (!(response instanceof AgentMessage) && !StringUtils.isNotBlank((CharSequence)(answerMessage != null ? answerMessage.getFinalAnswer() : ""))) break block32;
                    this.browser.evaluate(this.prepareEvaluationPopulateNormalMessageScript(questionId, response));
                    break block31;
                }
                if (warning == null) break block33;
                String msg = StringUtils.isNotBlank((CharSequence)warning.getExplanation()) ? warning.getExplanation() : null;
                switch (warning.getShortSummary()) {
                    case NOT_SOFTWARE_TESTING_DOMAIN: {
                        this.browser.evaluate(this.prepareEvaluationPopulateErrorMessageScript(StudioAssistErrorEnum.INLINE_VIOLATION_ERROR, msg, false));
                        break block31;
                    }
                    case NOT_KATALON: {
                        this.browser.evaluate(this.prepareEvaluationPopulateErrorMessageScript(StudioAssistErrorEnum.INLINE_VIOLATION_ERROR, msg, false));
                        break block31;
                    }
                    default: {
                        this.browser.evaluate(this.prepareEvaluationPopulateErrorMessageScript(StudioAssistErrorEnum.INLINE_VIOLATION_ERROR, msg, false));
                        throw new IllegalArgumentException("Unexpected value: " + String.valueOf(warning.getShortSummary()));
                    }
                }
            }
            if (answerMessage instanceof StudioAssistChatAnswerMessage) {
                this.logger.error("The answer message does not contain final answer nor warning");
                throw new IllegalArgumentException("The answer message does not contain final answer nor warning");
            }
        }
    }

    private String prepareEvaluationPopulateErrorMessageScript(StudioAssistErrorEnum error, String errorMsg, boolean retryEnabled) {
        String script = POPULATE_ERROR_SCRIPT_STRUCTURE.formatted(POPULATE_ANSWER_METHOD_NAME, "'%s'".formatted(error.getCode()), StringUtils.isBlank((CharSequence)errorMsg) ? "'%s'".formatted(error.getMessage()) : "'%s'".formatted(StringEscapeUtils.escapeEcmaScript((String)errorMsg)), "'%s'".formatted(error.getUiType()), retryEnabled);
        this.logger.trace("evaluationPopulateErrorMessageScript -> " + script);
        return script;
    }

    private String prepareEvaluationPopulateNormalMessageScript(String questionId, ResponseMessage responseMessage) {
        String answerContent = "";
        boolean isFinished = false;
        List toolCalls = new ArrayList();
        String script = null;
        if (responseMessage instanceof StudioAssistChatAnswerMessage) {
            answerContent = ((StudioAssistChatAnswerMessage)responseMessage).getFinalAnswer();
            isFinished = true;
            script = POPULATE_NORMAL_SCRIPT_STRUCTURE.formatted(POPULATE_ANSWER_METHOD_NAME, StringUtils.isBlank((CharSequence)questionId) ? "null" : "'%s'".formatted(questionId), StringUtils.isBlank((CharSequence)answerContent) ? "null" : "'%s'".formatted(StringEscapeUtils.escapeEcmaScript((String)answerContent)), isFinished, "null", "null", "null");
        } else if (responseMessage instanceof AgentMessage) {
            AgentMessage agentMessage = (AgentMessage)responseMessage;
            answerContent = agentMessage.getFinalAnswer() == null ? "" : agentMessage.getFinalAnswer().getFinalAnswer();
            isFinished = agentMessage.isFinished();
            toolCalls = agentMessage.getToolCalls();
            MaxedToolCallStatus maxedToolCallStatus = agentMessage.getMaxedToolCallStatus();
            AgentMessageStatus status = agentMessage.getStatus();
            ObjectMapper mapper = new ObjectMapper();
            try {
                String toolCallsJson = mapper.writeValueAsString(toolCalls);
                script = POPULATE_NORMAL_SCRIPT_STRUCTURE.formatted(POPULATE_ANSWER_METHOD_NAME, StringUtils.isBlank((CharSequence)questionId) ? "null" : "'%s'".formatted(questionId), StringUtils.isBlank((CharSequence)answerContent) ? "null" : "'%s'".formatted(StringEscapeUtils.escapeEcmaScript((String)answerContent)), isFinished, toolCallsJson, maxedToolCallStatus == null ? "null" : "'%s'".formatted(maxedToolCallStatus.name()), "'%s'".formatted(status.name()));
            }
            catch (JsonProcessingException exception) {
                this.logger.error("Error while converting tool calls to JSON", (Throwable)exception);
                script = POPULATE_NORMAL_SCRIPT_STRUCTURE.formatted(POPULATE_ANSWER_METHOD_NAME, StringUtils.isBlank((CharSequence)questionId) ? "null" : "'%s'".formatted(questionId), StringUtils.isBlank((CharSequence)answerContent) ? "null" : "'%s'".formatted(StringEscapeUtils.escapeEcmaScript((String)answerContent)), isFinished, "null", "null", "null");
            }
        }
        this.logger.trace("evaluationPopulateNormalScript -> " + script);
        return script;
    }

    private String prepareEvaluationUpdateProjectContextDescriptionScript(boolean objectRepositoryProjectContextEnabled, boolean customKeywordsProjectContextEnabled, boolean allowAttachFromProject) {
        String script = UPDATE_PROJECT_CONTEXT.formatted(objectRepositoryProjectContextEnabled, customKeywordsProjectContextEnabled, allowAttachFromProject);
        this.logger.trace("prepareEvaluationUpdateProjectContextDescriptionScript -> " + script);
        return script;
    }

    private String prepareEvaluationAddAttachments(List<StudioAssistChatAttachment> attachments) {
        if (attachments == null || attachments.size() <= 0) {
            this.logger.warn("evaluateAddAttachments -> No attachment to add");
            return null;
        }
        String script = ADD_ATTACHMENTS.formatted(JsonUtil.toJson(attachments));
        this.logger.trace("evaluateAddAttachments -> " + JsonUtil.toJson(attachments));
        return script;
    }

    private String prepareEvaluationUpdateStudioConfig(String configType) {
        String script = UPDATE_STUDIO_ASSIST_CONFIG.formatted(configType);
        this.logger.trace("evaluateUpdateStudioAssistConfig -> " + configType);
        return script;
    }

    private String prepareEvaluationUpdateAttachmentsOnChangingProject(String absoluteProjectPath) {
        String script = UPDATE_ATTACHMENTS_ON_CHANGING_PROJECT.formatted(StringUtils.isBlank((CharSequence)absoluteProjectPath) ? "" : absoluteProjectPath);
        this.logger.trace("evaluateUpdateAttachmentsOnChangingProject -> ", (Object)absoluteProjectPath);
        return script;
    }

    private String prepareEvaluationUpdateMcpClientsScript(String mcpClientsJson, String mcpSettingJson, String agentSettingJson) {
        String script = "updateMcpClients('%s', '%s', '%s');".formatted(StringEscapeUtils.escapeEcmaScript((String)mcpClientsJson), StringEscapeUtils.escapeEcmaScript((String)mcpSettingJson), StringEscapeUtils.escapeEcmaScript((String)agentSettingJson));
        this.logger.trace("prepareEvaluationUpdateMcpClientsScript -> " + script);
        return script;
    }

    private String prepareEvaluationUpdateMcpClientScript(String mcpClientJson) {
        String script = "updateMcpClient('%s');".formatted(StringEscapeUtils.escapeEcmaScript((String)mcpClientJson));
        this.logger.trace("prepareEvaluationUpdateMcpClientScript -> " + script);
        return script;
    }

    private void followUpQuestions(ChatMode chatMode, String conversationId, String questionMsgId) {
        try {
            if (!StudioAssistSetting.isFollowUpQuestionEnabled()) {
                return;
            }
            switch (chatMode) {
                case AGENT: {
                    this.sessionContext.getFollowUpQuestions(conversationId, questionMsgId);
                    break;
                }
                default: {
                    StudioAssistChatAnswerMessageFuture answerFuture = this.studioAssistChatController.getFollowUpQuestions(conversationId, questionMsgId);
                    this.answerWorker = new StudioAssistChatAnswerManageWorker(this::evaluateScriptConsumerFollowUpQuestions, answerFuture);
                    this.answerWorker.start();
                    this.studioAssistChatController.appendToConversation(new StudioAssistChatQuestionMessage(conversationId, questionMsgId, "Based on your last answer, list out 2 follow up questions relating to Katalon to deep dive into it. Output them in the \"suggestedQuestions\" field without explaining into \"finalAnswer\"."), new StudioAssistChatAnswerMessage(conversationId, questionMsgId, null, null), false);
                    break;
                }
            }
        }
        catch (StudioAssistBaseException e) {
            this.logger.warn("Exception while getting follow-up questions event", (Throwable)e);
            LogUtil.logError((Throwable)e, (String)"Exception while handle event studio assist get follow-up questions");
        }
    }

    private void evaluatePopulateFollowUpQuestions(StudioAssistChatAnswerMessage answerMessage, Exception exception) {
        this.logger.trace("evaluatePopulateFollowUpQuestions -> " + JsonUtil.toJson((Object)answerMessage));
        if (exception != null) {
            this.logger.error("Exception has been thrown while getting follow-up questions.", (Throwable)exception);
            return;
        }
        List followUpQuestions = answerMessage.getSuggestedQuestions();
        if (followUpQuestions != null && followUpQuestions.size() > 0) {
            this.browser.evaluate(this.prepareEvaluationLoadFollowUpQuestionsScript(followUpQuestions));
        }
    }

    private String prepareEvaluationLoadFollowUpQuestionsScript(List<String> followUpQuestions) {
        try {
            String followUpQuestionsInString = new ObjectMapper().writeValueAsString(followUpQuestions);
            String script = POPULATE_UPDATE_FOLLOW_UP_QUESTIONS.formatted(followUpQuestionsInString);
            this.logger.trace("evaluationLoadFollowUpQuestionsScript -> " + script);
            return script;
        }
        catch (JsonProcessingException jsonProcessingException) {
            this.logger.error("Something went wrong while preparing evaluationLoadFollowUpQuestionsScript -> " + String.valueOf(followUpQuestions));
            return null;
        }
    }

    private void evaluateScriptConsumerFollowUpQuestions(final StudioAssistChatAnswerMessage msg, final Exception e) {
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                StudioAssistChatNavigator.this.evaluatePopulateFollowUpQuestions(msg, e);
            }
        });
    }

    private void showErrorDialog(String title, String message) {
        UISynchronizeService.asyncExec(() -> MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message));
    }

    private String mcpClientToJson(McpClient mcpClient) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString((Object)mcpClient);
        }
        catch (Exception exception) {
            return "{}";
        }
    }

    private String mcpClientstoJson(List<McpClient> mcpClients) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString(mcpClients);
        }
        catch (Exception exception) {
            return "[]";
        }
    }

    private void trackStudioAssistAction(Object data) {
        ArrayList<Object> trackingData = new ArrayList<Object>();
        trackingData.add(StudioAssistTrackingKeyEnum.STUDIOASSIST_CHAT_ACTION.getValue());
        trackingData.add(data);
        trackingData.add(StudioAssistTrackingKeyEnum.CHAT_MODE.getValue());
        trackingData.add(this.currentChatMode.name().toLowerCase());
        this.studioAssistChatController.trackStudioAssistChat(trackingData);
    }

    private void trackStudioAssistAgentSettingAction(Object data) {
        HashMap<String, Object> trackingData = new HashMap<String, Object>();
        trackingData.put(StudioAssistTrackingKeyEnum.STUDIOASSIST_MCP_SETTING_ACTION.getValue(), data);
        this.trackStudioAssistAgentSetting(trackingData);
    }

    private void trackStudioAssistAgentSetting(Map<String, Object> trackingData) {
        this.studioAssistChatController.trackStudioAssistAgentSetting(trackingData);
    }

    private StudioAssistConversation retrieveConversationByMode() {
        switch (this.currentChatMode) {
            case AGENT: {
                return this.sessionContext.getConversation();
            }
            case ASK: {
                return this.studioAssistChatController.getCurrentConversation();
            }
        }
        return null;
    }
}

