/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.discovery.services;

import com.kms.katalon.discovery.core.model.ServerType;
import com.kms.katalon.discovery.core.services.IDiscoveryController;
import com.kms.katalon.discovery.core.services.IDiscoveryManager;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Objects;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

@Creatable
@Singleton
public class DiscoveryController
implements IDiscoveryController {
    private static IDiscoveryController instance;
    @Inject
    IDiscoveryManager discoveryManager;

    public static IDiscoveryController getInstance() {
        if (Objects.isNull(instance)) {
            BundleContext bundleContext = FrameworkUtil.getBundle(DiscoveryController.class).getBundleContext();
            IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
            instance = (IDiscoveryController)ContextInjectionFactory.make(DiscoveryController.class, (IEclipseContext)context);
        }
        return instance;
    }

    public boolean discover() {
        return this.discoveryManager.discover(null);
    }

    public boolean discover(String serverUrl) {
        return this.discoveryManager.discover(serverUrl);
    }

    public String getServerUrl(ServerType serverType) {
        return this.discoveryManager.getServerUrl(serverType);
    }

    public boolean isDiscovered() {
        return this.discoveryManager.isDiscovered();
    }

    public void setServerUrl(ServerType serverType, String serverUrl) {
        this.discoveryManager.setServerUrl(serverType, serverUrl);
    }

    public String getDiscoveryServerUrl() {
        return this.discoveryManager.getDiscoveryServerUrl();
    }

    public void setDiscoveryServerUrl(String serverUrl) {
        this.discoveryManager.setDiscoveryServerUrl(serverUrl);
    }

    public boolean isOnline() {
        return this.discoveryManager.isOnline();
    }

    public boolean isOnline(String serverUrl) {
        return this.discoveryManager.isOnline(serverUrl);
    }
}

