/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.controller;

import com.kms.katalon.ai.core.constant.StudioAssistAttachmentStatus;
import com.kms.katalon.ai.core.constant.StudioAssistFileType;
import com.kms.katalon.ai.core.constant.StudioAssistTrackingContextTypeEnum;
import com.kms.katalon.ai.core.constant.StudioAssistTrackingKeyEnum;
import com.kms.katalon.ai.core.controller.IStudioAssistReferenceContextController;
import com.kms.katalon.ai.core.model.chat.ChatMode;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatAttachment;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatReferenceContextMessage;
import com.kms.katalon.ai.core.model.chat.StudioAssistUploadedFileHistory;
import com.kms.katalon.ai.core.model.exception.StudioAssistAttachmentValidationException;
import com.kms.katalon.ai.core.model.exception.StudioAssistBaseException;
import com.kms.katalon.ai.core.model.exception.StudioAssistException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadAttachmentException;
import com.kms.katalon.ai.core.model.prompt.PromptType;
import com.kms.katalon.ai.core.services.IStudioAssistReferenceContextService;
import com.kms.katalon.ai.core.services.IStudioAssistTrackingService;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.setting.StudioAssistSetting;
import com.kms.katalon.entity.project.ProjectEntity;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StudioAssistReferenceContextController
implements IStudioAssistReferenceContextController {
    private final Logger logger = LoggerFactory.getLogger(StudioAssistReferenceContextController.class);
    private String lastProjectId = "";
    private HashMap<String, StudioAssistChatAttachment> cachedClientAIAttachments = new HashMap();
    @Inject
    private IStudioAssistReferenceContextService refContextService;
    @Inject
    private IStudioAssistTrackingService studioAssistTrackingService;

    public List<StudioAssistChatReferenceContextMessage> getContext(String conversationId, String questionId, PromptType promptType, ChatMode chatMode) throws StudioAssistException {
        try {
            List<StudioAssistChatReferenceContextMessage> projectContext = this.getProjectContext(conversationId, questionId, promptType, chatMode);
            return projectContext;
        }
        catch (Exception e) {
            throw new StudioAssistException(e.getMessage());
        }
    }

    private List<StudioAssistChatReferenceContextMessage> getProjectContext(String conversationId, String questionId, PromptType promptType, ChatMode chatMode) throws Exception {
        long startTime;
        if (chatMode == ChatMode.AGENT) {
            return null;
        }
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (Objects.isNull(project)) {
            return null;
        }
        String currentProjectId = project.getId();
        if (promptType == PromptType.CHATBOT && this.lastProjectId.equals(currentProjectId)) {
            return null;
        }
        this.lastProjectId = currentProjectId;
        ArrayList<StudioAssistChatReferenceContextMessage> result = new ArrayList<StudioAssistChatReferenceContextMessage>();
        if (StudioAssistSetting.isProjectContextObjectRepositoriesEnabled()) {
            startTime = System.currentTimeMillis();
            StudioAssistChatReferenceContextMessage objectRepositoryContext = this.refContextService.getObjectRepository(project, conversationId);
            if (objectRepositoryContext != null) {
                result.add(objectRepositoryContext);
                this.trackUsingObjectRepository(currentProjectId, conversationId, questionId, chatMode);
            }
            this.logger.debug("Total time to get Object Repositories context (ms): " + (System.currentTimeMillis() - startTime));
        }
        if (StudioAssistSetting.isProjectContextCustomKeywordsEnabled()) {
            startTime = System.currentTimeMillis();
            StudioAssistChatReferenceContextMessage customKeywordContext = this.refContextService.getCustomKeywordsFromCurrentProject(project, conversationId);
            if (customKeywordContext != null) {
                result.add(customKeywordContext);
                this.trackUsingCustomKeyword(currentProjectId, conversationId, questionId, chatMode);
            }
            this.logger.debug("Total time to get Custom keywords context (ms): " + (System.currentTimeMillis() - startTime));
        }
        return result;
    }

    private void trackUsingObjectRepository(String projectId, String conversationId, String questionId, ChatMode chatMode) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        byte[] digest = messageDigest.digest(projectId.getBytes());
        String hashProjectId = Base64.getEncoder().encodeToString(digest);
        ArrayList<String> trackingData = new ArrayList<String>();
        trackingData.add(StudioAssistTrackingKeyEnum.CONVERSATION_ID.getValue());
        trackingData.add(conversationId);
        trackingData.add(StudioAssistTrackingKeyEnum.QUESTION_ID.getValue());
        trackingData.add(questionId);
        trackingData.add(StudioAssistTrackingKeyEnum.CONTEXT_TYPE.getValue());
        trackingData.add(StudioAssistTrackingContextTypeEnum.OBJECT_REPOSITORY.getValue());
        trackingData.add(StudioAssistTrackingKeyEnum.CONTEXT_ID.getValue());
        trackingData.add(hashProjectId);
        trackingData.add(StudioAssistTrackingKeyEnum.CHAT_MODE.getValue());
        trackingData.add(chatMode.name().toLowerCase());
        this.studioAssistTrackingService.trackStudioAssistChat(trackingData);
    }

    private void trackUsingCustomKeyword(String projectId, String conversationId, String questionId, ChatMode chatMode) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        byte[] digest = messageDigest.digest(projectId.getBytes());
        String hashProjectId = Base64.getEncoder().encodeToString(digest);
        ArrayList<String> trackingData = new ArrayList<String>();
        trackingData.add(StudioAssistTrackingKeyEnum.CONVERSATION_ID.getValue());
        trackingData.add(conversationId);
        trackingData.add(StudioAssistTrackingKeyEnum.QUESTION_ID.getValue());
        trackingData.add(questionId);
        trackingData.add(StudioAssistTrackingKeyEnum.CONTEXT_TYPE.getValue());
        trackingData.add(StudioAssistTrackingContextTypeEnum.CUSTOM_KEYWORD.getValue());
        trackingData.add(StudioAssistTrackingKeyEnum.CONTEXT_ID.getValue());
        trackingData.add(hashProjectId);
        trackingData.add(StudioAssistTrackingKeyEnum.CHAT_MODE.getValue());
        trackingData.add(chatMode.name().toLowerCase());
        this.studioAssistTrackingService.trackStudioAssistChat(trackingData);
    }

    public void clear() {
        this.lastProjectId = "";
        this.cachedClientAIAttachments.clear();
    }

    private Date getDateModified(StudioAssistChatAttachment attachment) throws Exception {
        File file = new File(attachment.getFilePath());
        return new Date(file.lastModified());
    }

    public StudioAssistChatAttachment loadAttachmentContent(StudioAssistChatAttachment attachment) throws StudioAssistLoadAttachmentException {
        String cachedKey = attachment.getFilePath();
        StudioAssistChatAttachment cachedAttachment = this.cachedClientAIAttachments.get(cachedKey);
        try {
            attachment.setDateModified(this.getDateModified(attachment));
        }
        catch (Exception exception) {
            throw new StudioAssistLoadAttachmentException("Error while getting date modified from attachment. " + exception.getMessage());
        }
        if (cachedAttachment != null && attachment.getDateModified() != null && cachedAttachment.getDateModified().equals(attachment.getDateModified())) {
            cachedAttachment.setFileSource(attachment.getFileSource());
            return cachedAttachment;
        }
        try {
            StudioAssistChatAttachment fulfillAttachment = this.refContextService.fulfillAttachmentContent(attachment);
            if (fulfillAttachment != null) {
                this.cachedClientAIAttachments.put(fulfillAttachment.getFilePath(), fulfillAttachment);
            }
            return fulfillAttachment;
        }
        catch (IOException ioException) {
            throw new StudioAssistLoadAttachmentException("Error while getting file content from function fulfillAttachmentContent. " + ioException.getMessage());
        }
    }

    public void updateFileIdIntoCache(Map<String, StudioAssistUploadedFileHistory> uploadedFileMap) {
        if (uploadedFileMap == null || uploadedFileMap.isEmpty()) {
            return;
        }
        Map cacheByFileClientId = this.cachedClientAIAttachments.values().stream().collect(Collectors.toMap(StudioAssistChatAttachment::getFileClientId, Function.identity()));
        for (String fileClientId : uploadedFileMap.keySet()) {
            if (!cacheByFileClientId.containsKey(fileClientId)) continue;
            StudioAssistChatAttachment attachment = (StudioAssistChatAttachment)cacheByFileClientId.get(fileClientId);
            attachment.setFileId(uploadedFileMap.get(fileClientId).getFileId());
        }
    }

    public StudioAssistAttachmentStatus validateAttachment(String attachmentFilePath, StudioAssistFileType attachmentFileType) throws StudioAssistBaseException {
        try {
            return this.refContextService.validateAttachment(attachmentFilePath, attachmentFileType);
        }
        catch (Exception e) {
            throw new StudioAssistAttachmentValidationException((Throwable)e);
        }
    }
}

