/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.mcp.jsonschema.builder;

import com.kms.katalon.ai.mcp.jsonschema.builder.Builder;
import com.kms.katalon.ai.mcp.jsonschema.builder.ObjectSchemaBuilder;
import com.kms.katalon.ai.mcp.jsonschema.builder.StringSchemaBuilder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ArraySchemaBuilder
extends Builder {
    private String description;
    private Builder items;
    private final List<Builder> prefixItems = new ArrayList<Builder>();
    private Builder additionalItems;
    private Long minItems;
    private Long maxItems;
    private Boolean uniqueItems;

    private ArraySchemaBuilder() {
    }

    public static ArraySchemaBuilder create() {
        return new ArraySchemaBuilder();
    }

    public ArraySchemaBuilder description(String description) {
        this.description = description;
        return this;
    }

    public ArraySchemaBuilder items(Builder items) {
        this.items = items;
        return this;
    }

    public ArraySchemaBuilder stringItems() {
        return this.items(StringSchemaBuilder.create());
    }

    public ArraySchemaBuilder objectItems(ObjectSchemaBuilder objectBuilder) {
        return this.items(objectBuilder);
    }

    public ArraySchemaBuilder addPrefixItem(Builder itemBuilder) {
        this.prefixItems.add(itemBuilder);
        return this;
    }

    public ArraySchemaBuilder additionalItems(Builder additionalItems) {
        this.additionalItems = additionalItems;
        return this;
    }

    public ArraySchemaBuilder minItems(long minItems) {
        this.minItems = minItems;
        return this;
    }

    public ArraySchemaBuilder maxItems(long maxItems) {
        this.maxItems = maxItems;
        return this;
    }

    public ArraySchemaBuilder uniqueItems(boolean uniqueItems) {
        this.uniqueItems = uniqueItems;
        return this;
    }

    @Override
    public String getType() {
        return "array";
    }

    @Override
    public Map<String, Object> build() {
        LinkedHashMap<String, Object> schema = new LinkedHashMap<String, Object>();
        schema.put("type", this.getType());
        if (this.description != null) {
            schema.put("description", this.description);
        }
        if (this.items != null) {
            schema.put("items", this.items.build());
        }
        if (!this.prefixItems.isEmpty()) {
            ArrayList<Map<String, Object>> prefixItemsSchema = new ArrayList<Map<String, Object>>();
            for (Builder item : this.prefixItems) {
                prefixItemsSchema.add(item.build());
            }
            schema.put("prefixItems", prefixItemsSchema);
        }
        if (this.additionalItems != null) {
            schema.put("additionalItems", this.additionalItems.build());
        }
        if (this.minItems != null) {
            schema.put("minItems", this.minItems);
        }
        if (this.maxItems != null) {
            schema.put("maxItems", this.maxItems);
        }
        if (this.uniqueItems != null) {
            schema.put("uniqueItems", this.uniqueItems);
        }
        return schema;
    }
}

