/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.mcp.jsonschema.builder;

import com.kms.katalon.ai.mcp.jsonschema.builder.Builder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class IntegerSchemaBuilder
extends Builder {
    private String description;
    private Long minimum;
    private Long maximum;
    private Long exclusiveMinimum;
    private Long exclusiveMaximum;
    private Long multipleOf;
    private final List<Long> enumValues = new ArrayList<Long>();

    private IntegerSchemaBuilder() {
    }

    public static IntegerSchemaBuilder create() {
        return new IntegerSchemaBuilder();
    }

    public IntegerSchemaBuilder description(String description) {
        this.description = description;
        return this;
    }

    public IntegerSchemaBuilder minimum(long minimum) {
        this.minimum = minimum;
        return this;
    }

    public IntegerSchemaBuilder maximum(long maximum) {
        this.maximum = maximum;
        return this;
    }

    public IntegerSchemaBuilder exclusiveMinimum(long exclusiveMinimum) {
        this.exclusiveMinimum = exclusiveMinimum;
        return this;
    }

    public IntegerSchemaBuilder exclusiveMaximum(long exclusiveMaximum) {
        this.exclusiveMaximum = exclusiveMaximum;
        return this;
    }

    public IntegerSchemaBuilder multipleOf(long multipleOf) {
        this.multipleOf = multipleOf;
        return this;
    }

    public IntegerSchemaBuilder enumValue(long value) {
        this.enumValues.add(value);
        return this;
    }

    public IntegerSchemaBuilder enumValues(Long ... values) {
        this.enumValues.clear();
        Arrays.stream(values).forEach(this.enumValues::add);
        return this;
    }

    @Override
    public String getType() {
        return "integer";
    }

    @Override
    public Map<String, Object> build() {
        LinkedHashMap<String, Object> schema = new LinkedHashMap<String, Object>();
        schema.put("type", this.getType());
        if (this.description != null) {
            schema.put("description", this.description);
        }
        if (this.minimum != null) {
            schema.put("minimum", this.minimum);
        }
        if (this.maximum != null) {
            schema.put("maximum", this.maximum);
        }
        if (this.exclusiveMinimum != null) {
            schema.put("exclusiveMinimum", this.exclusiveMinimum);
        }
        if (this.exclusiveMaximum != null) {
            schema.put("exclusiveMaximum", this.exclusiveMaximum);
        }
        if (this.multipleOf != null) {
            schema.put("multipleOf", this.multipleOf);
        }
        if (!this.enumValues.isEmpty()) {
            schema.put("enum", new ArrayList<Long>(this.enumValues));
        }
        return schema;
    }
}

