/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.mcp.jsonschema.builder;

import com.kms.katalon.ai.mcp.jsonschema.builder.Builder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class StringSchemaBuilder
extends Builder {
    private String description;
    private Long minLength;
    private Long maxLength;
    private String pattern;
    private final List<String> enumValues = new ArrayList<String>();

    private StringSchemaBuilder() {
    }

    public static StringSchemaBuilder create() {
        return new StringSchemaBuilder();
    }

    public StringSchemaBuilder description(String description) {
        this.description = description;
        return this;
    }

    public StringSchemaBuilder minLength(long minLength) {
        this.minLength = minLength;
        return this;
    }

    public StringSchemaBuilder maxLength(long maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public StringSchemaBuilder pattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public StringSchemaBuilder enumValue(String value) {
        this.enumValues.add(value);
        return this;
    }

    public StringSchemaBuilder enumValues(String ... values) {
        this.enumValues.clear();
        Arrays.stream(values).forEach(this.enumValues::add);
        return this;
    }

    @Override
    public String getType() {
        return "string";
    }

    @Override
    public Map<String, Object> build() {
        LinkedHashMap<String, Object> schema = new LinkedHashMap<String, Object>();
        schema.put("type", this.getType());
        if (this.description != null) {
            schema.put("description", this.description);
        }
        if (this.minLength != null) {
            schema.put("minLength", this.minLength);
        }
        if (this.maxLength != null) {
            schema.put("maxLength", this.maxLength);
        }
        if (this.pattern != null) {
            schema.put("pattern", this.pattern);
        }
        if (!this.enumValues.isEmpty()) {
            schema.put("enum", new ArrayList<String>(this.enumValues));
        }
        return schema;
    }
}

