/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.mcp.tools;

import com.kms.katalon.ai.core.util.McpToolsUtil;
import com.kms.katalon.ai.mcp.enums.TestObjectType;
import com.kms.katalon.ai.mcp.tools.model.MobileTestObjectDataModel;
import com.kms.katalon.ai.mcp.tools.model.WebServiceRestfulTestObjectDataModel;
import com.kms.katalon.ai.mcp.tools.model.WebServiceSoapTestObjectDataModel;
import com.kms.katalon.ai.mcp.tools.model.WebServiceTestObjectDataModel;
import com.kms.katalon.ai.mcp.tools.model.WebTestObjectAttributesMethodDataModel;
import com.kms.katalon.ai.mcp.tools.model.WebTestObjectCssMethodDataModel;
import com.kms.katalon.ai.mcp.tools.model.WebTestObjectDataModel;
import com.kms.katalon.ai.mcp.tools.model.WebTestObjectImageMethodDataModel;
import com.kms.katalon.ai.mcp.tools.model.WebTestObjectSmartLocatorMethodDataModel;
import com.kms.katalon.ai.mcp.tools.model.WebTestObjectXPathMethodDataModel;
import com.kms.katalon.ai.mcp.tools.model.WindowsTestObjectDataModel;
import com.kms.katalon.ai.mcp.tools.schema.TestObjectInputSchema;
import com.kms.katalon.ai.mcp.tools.schema.TestObjectOutputSchema;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WindowsElementTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.WindowsElementController;
import com.kms.katalon.core.enums.mobile.LocatorStrategy;
import com.kms.katalon.core.enums.mobile.MobilePlatform;
import com.kms.katalon.core.testobject.authorization.BasicRequestAuthorization;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.core.webservice.common.VerificationScriptSnippetFactory;
import com.kms.katalon.dal.fileservice.EntityService;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.MobileElementEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebElementSelectorMethod;
import com.kms.katalon.entity.repository.WebElementXpathEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.repository.WindowsElementEntity;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import jakarta.inject.Inject;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestObjectTools {
    @Inject
    IEventBroker eventBroker;
    private final Logger logger = LoggerFactory.getLogger(TestObjectTools.class);
    private static final String TEST_OBJECT_FOLDER_ROOT = "Object Repository";

    public McpServerFeatures.SyncToolSpecification getTestObjectTool() {
        McpSchema.Tool tool = new McpSchema.Tool("getTestObject", "Get Test Object Details", "Retrieves detailed information about a test object from the Object Repository based on its ID in the current Katalon Studio project", TestObjectInputSchema.createSchemaForGetTestObjectTool(), TestObjectOutputSchema.createSchemaForGetTestObjectTool(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.getTestObjectToolCallHandler((McpSchema.CallToolRequest)request)).build();
    }

    private McpSchema.CallToolResult getTestObjectToolCallHandler(McpSchema.CallToolRequest request) {
        boolean isError = false;
        Object resultContent = "";
        Object testObjectDetails = null;
        try {
            String testObjectId;
            HashMap arguments = request.arguments();
            if (arguments == null) {
                arguments = new HashMap();
            }
            if (StringUtils.isBlank((CharSequence)(testObjectId = (String)arguments.get("testObjectId")))) {
                isError = true;
                resultContent = "testObjectId parameter is required";
            } else {
                testObjectDetails = this.getTestObjectDetails(testObjectId.trim());
                if (testObjectDetails == null) {
                    isError = true;
                    resultContent = "Test object with ID '" + testObjectId + "' not found.";
                }
            }
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Error retrieving test object details: " + e.getMessage();
        }
        Map<String, Object> structuredContent = this.createStructuredContentResultForGetTestObjectTool(testObjectDetails);
        if (!isError) {
            resultContent = JsonUtil.toJson(structuredContent);
        }
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    private Object getTestObjectDetails(String testObjectId) throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project == null) {
            throw new Exception("No project is currently opened.");
        }
        String normalizedTestObjectId = McpToolsUtil.normalizeData((String)testObjectId, (String)TEST_OBJECT_FOLDER_ROOT);
        WebElementEntity webTestObject = ObjectRepositoryController.getInstance().getWebElementByDisplayPk(normalizedTestObjectId);
        if (webTestObject != null) {
            return webTestObject;
        }
        WindowsElementEntity windowsTestObject = WindowsElementController.getInstance().getWindowsElementByDisplayId(normalizedTestObjectId);
        if (windowsTestObject != null) {
            return windowsTestObject;
        }
        return null;
    }

    private Map<String, Object> createStructuredContentResultForGetTestObjectTool(Object testObject) {
        Object contentResult;
        Map<Object, Object> testObjectResult = new HashMap();
        if (testObject != null && (contentResult = this.createTestObjectContentResult(testObject)) != null) {
            if (contentResult instanceof WebTestObjectDataModel) {
                testObjectResult = ((WebTestObjectDataModel)contentResult).toDataMap();
            } else if (contentResult instanceof MobileTestObjectDataModel) {
                testObjectResult = ((MobileTestObjectDataModel)contentResult).toDataMap();
            } else if (contentResult instanceof WindowsTestObjectDataModel) {
                testObjectResult = ((WindowsTestObjectDataModel)contentResult).toDataMap();
            } else if (contentResult instanceof WebServiceTestObjectDataModel) {
                testObjectResult = ((WebServiceTestObjectDataModel)contentResult).toDataMap();
            }
        }
        return Map.of("result", testObjectResult);
    }

    private Object createTestObjectContentResult(Object testObject) {
        if (testObject instanceof WindowsElementEntity) {
            return this.createWindowsTestObjectContentResult((WindowsElementEntity)testObject);
        }
        if (testObject instanceof WebServiceRequestEntity) {
            return this.createWebServiceTestObjectContentResult((WebServiceRequestEntity)testObject);
        }
        if (testObject instanceof MobileElementEntity) {
            return this.createMobileTestObjectContentResult((MobileElementEntity)testObject);
        }
        if (testObject instanceof WebElementEntity) {
            return this.createWebTestObjectContentResult((WebElementEntity)testObject);
        }
        return null;
    }

    private WebTestObjectDataModel createWebTestObjectContentResult(WebElementEntity testObject) {
        String testObjectId = testObject.getIdForDisplay() != null ? testObject.getIdForDisplay() : "";
        String name = testObject.getName() != null ? testObject.getName() : "";
        String description = testObject.getDescription() != null ? testObject.getDescription() : "";
        String fileLocation = testObject.getId() != null ? testObject.getId() : "";
        String parentElementId = testObject.getPropertyValue("ref_element");
        if (parentElementId == null) {
            parentElementId = "";
        }
        boolean isParentShadowRoot = Boolean.parseBoolean(testObject.getPropertyValue("ref_element_is_shadow_root"));
        switch (testObject.getGenericSelectorMethod()) {
            case BASIC: {
                String basicLocator = (String)testObject.getSelectorCollection().get(WebElementSelectorMethod.BASIC);
                List<Map<String, Object>> objectProperties = this.extractElementObjectProperties(testObject.getWebElementProperties(), true, true);
                WebTestObjectAttributesMethodDataModel attributesContentResult = new WebTestObjectAttributesMethodDataModel();
                attributesContentResult.setTestObjectId(testObjectId);
                attributesContentResult.setName(name);
                attributesContentResult.setDescription(description);
                attributesContentResult.setFileLocation(fileLocation);
                attributesContentResult.setParentElementId(parentElementId);
                attributesContentResult.setParentShadowRoot(isParentShadowRoot);
                attributesContentResult.setSelectedLocator(basicLocator != null ? basicLocator : "");
                attributesContentResult.setElementObjectProperties(objectProperties);
                return attributesContentResult;
            }
            case XPATH: {
                String xpathLocator = (String)testObject.getSelectorCollection().get(WebElementSelectorMethod.XPATH);
                List<Map<String, Object>> xpathProperties = this.extractXpaths(testObject.getWebElementXpaths());
                WebTestObjectXPathMethodDataModel xpathContentResult = new WebTestObjectXPathMethodDataModel();
                xpathContentResult.setTestObjectId(testObjectId);
                xpathContentResult.setName(name);
                xpathContentResult.setDescription(description);
                xpathContentResult.setFileLocation(fileLocation);
                xpathContentResult.setParentElementId(parentElementId);
                xpathContentResult.setParentShadowRoot(isParentShadowRoot);
                xpathContentResult.setSelectedLocator(xpathLocator != null ? xpathLocator : "");
                xpathContentResult.setXpathProperties(xpathProperties);
                return xpathContentResult;
            }
            case CSS: {
                String cssLocator = (String)testObject.getSelectorCollection().get(WebElementSelectorMethod.CSS);
                WebTestObjectCssMethodDataModel cssContentResult = new WebTestObjectCssMethodDataModel();
                cssContentResult.setTestObjectId(testObjectId);
                cssContentResult.setName(name);
                cssContentResult.setDescription(description);
                cssContentResult.setFileLocation(fileLocation);
                cssContentResult.setParentElementId(parentElementId);
                cssContentResult.setParentShadowRoot(isParentShadowRoot);
                cssContentResult.setSelectedLocator(cssLocator != null ? cssLocator : "");
                return cssContentResult;
            }
            case IMAGE: {
                String imagePath = testObject.getImagePath() != null ? testObject.getImagePath() : "";
                boolean useRelativeImagePath = testObject.getUseRalativeImagePath();
                WebTestObjectImageMethodDataModel imageContentResult = new WebTestObjectImageMethodDataModel();
                imageContentResult.setTestObjectId(testObjectId);
                imageContentResult.setName(name);
                imageContentResult.setDescription(description);
                imageContentResult.setFileLocation(fileLocation);
                imageContentResult.setParentElementId(parentElementId);
                imageContentResult.setParentShadowRoot(isParentShadowRoot);
                imageContentResult.setImagePath(imagePath);
                imageContentResult.setUseRelativeImagePath(useRelativeImagePath);
                return imageContentResult;
            }
            case SMART_LOCATOR: {
                String smartLocator = (String)testObject.getSmartLocatorCollection().get(WebElementSelectorMethod.SMART_LOCATOR);
                WebTestObjectSmartLocatorMethodDataModel smartLocatorContentResult = new WebTestObjectSmartLocatorMethodDataModel();
                smartLocatorContentResult.setTestObjectId(testObjectId);
                smartLocatorContentResult.setName(name);
                smartLocatorContentResult.setDescription(description);
                smartLocatorContentResult.setFileLocation(fileLocation);
                smartLocatorContentResult.setParentElementId(parentElementId);
                smartLocatorContentResult.setParentShadowRoot(isParentShadowRoot);
                smartLocatorContentResult.setSelectedLocator(smartLocator != null ? smartLocator : "");
                return smartLocatorContentResult;
            }
        }
        return null;
    }

    private Object createMobileTestObjectContentResult(MobileElementEntity testObject) {
        String testObjectId = testObject.getIdForDisplay() != null ? testObject.getIdForDisplay() : "";
        String name = testObject.getName() != null ? testObject.getName() : "";
        String description = testObject.getDescription() != null ? testObject.getDescription() : "";
        String fileLocation = testObject.getId() != null ? testObject.getId() : "";
        String locator = testObject.getLocator() != null ? testObject.getLocator() : "";
        String locatorStrategy = testObject.getLocatorStrategy() != null ? testObject.getLocatorStrategy().getName() : "";
        List<Map<String, Object>> objectProperties = this.extractElementObjectProperties(testObject.getWebElementProperties(), true, true);
        MobileTestObjectDataModel contentResult = new MobileTestObjectDataModel();
        contentResult.setTestObjectId(testObjectId);
        contentResult.setName(name);
        contentResult.setDescription(description);
        contentResult.setFileLocation(fileLocation);
        contentResult.setLocator(locator);
        contentResult.setLocatorStrategy(locatorStrategy);
        contentResult.setObjectProperties(objectProperties);
        return contentResult;
    }

    private Object createWindowsTestObjectContentResult(WindowsElementEntity testObject) {
        String testObjectId = testObject.getIdForDisplay() != null ? testObject.getIdForDisplay() : "";
        String name = testObject.getName() != null ? testObject.getName() : "";
        String description = testObject.getDescription() != null ? testObject.getDescription() : "";
        String fileLocation = testObject.getId() != null ? testObject.getId() : "";
        String locator = testObject.getLocator() != null ? testObject.getLocator() : "";
        String locatorStrategy = testObject.getLocatorStrategy() != null ? testObject.getLocatorStrategy().toString() : "";
        List<Map<String, Object>> objectProperties = this.extractElementObjectProperties(testObject.getProperties(), false, false);
        WindowsTestObjectDataModel contentResult = new WindowsTestObjectDataModel();
        contentResult.setTestObjectId(testObjectId);
        contentResult.setName(name);
        contentResult.setDescription(description);
        contentResult.setFileLocation(fileLocation);
        contentResult.setLocator(locator);
        contentResult.setLocatorStrategy(locatorStrategy);
        contentResult.setObjectProperties(objectProperties);
        return contentResult;
    }

    private WebServiceTestObjectDataModel createWebServiceTestObjectContentResult(WebServiceRequestEntity testObject) {
        String verificationScript;
        String testObjectId = testObject.getIdForDisplay() != null ? testObject.getIdForDisplay() : "";
        String name = testObject.getName() != null ? testObject.getName() : "";
        String description = testObject.getDescription() != null ? testObject.getDescription() : "";
        String fileLocation = testObject.getId() != null ? testObject.getId() : "";
        String serviceType = testObject.getServiceType() != null ? testObject.getServiceType() : "";
        String string = verificationScript = testObject.getVerificationScript() != null ? testObject.getVerificationScript() : "";
        if (StringUtils.isBlank((CharSequence)verificationScript)) {
            verificationScript = VerificationScriptSnippetFactory.getCommonScriptSnippet().getScript();
        }
        Map<String, Object> authorizationRequest = this.extractAuthorizationDetails(testObject.getAuthorizationRequest());
        List<Map<String, Object>> httpHeaders = this.extractElementObjectProperties(testObject.getHttpHeaderProperties(), false, false);
        if ("SOAP".equals(serviceType)) {
            String requestMethod = testObject.getSoapRequestMethod() != null ? testObject.getSoapRequestMethod() : "";
            String soapServiceEndpoint = testObject.getSoapServiceEndpoint() != null ? testObject.getSoapServiceEndpoint() : "";
            String soapServiceFunction = testObject.getSoapServiceFunction() != null ? testObject.getSoapServiceFunction() : "";
            String soapBody = testObject.getSoapBody() != null ? testObject.getSoapBody() : "";
            String wsdlAddress = testObject.getWsdlAddress() != null ? testObject.getWsdlAddress() : "";
            WebServiceSoapTestObjectDataModel contentResult = new WebServiceSoapTestObjectDataModel();
            contentResult.setTestObjectId(testObjectId);
            contentResult.setName(name);
            contentResult.setDescription(description);
            contentResult.setFileLocation(fileLocation);
            contentResult.setVerificationScript(verificationScript);
            contentResult.setHttpHeaders(httpHeaders);
            contentResult.setAuthorizationRequest(authorizationRequest);
            contentResult.setRequestMethod(requestMethod);
            contentResult.setSoapServiceEndpoint(soapServiceEndpoint);
            contentResult.setSoapServiceFunction(soapServiceFunction);
            contentResult.setWsdlAddress(wsdlAddress);
            contentResult.setSoapBody(soapBody);
            return contentResult;
        }
        if ("RESTful".equals(serviceType)) {
            String requestMethod = testObject.getRestRequestMethod() != null ? testObject.getRestRequestMethod() : "";
            String httpBodyType = testObject.getHttpBodyType() != null ? testObject.getHttpBodyType() : "";
            String httpBodyContent = testObject.getHttpBodyContent() != null ? testObject.getHttpBodyContent() : "";
            String restUrl = testObject.getRestUrl() != null ? testObject.getRestUrl() : "";
            WebServiceRestfulTestObjectDataModel contentResult = new WebServiceRestfulTestObjectDataModel();
            contentResult.setTestObjectId(testObjectId);
            contentResult.setName(name);
            contentResult.setDescription(description);
            contentResult.setFileLocation(fileLocation);
            contentResult.setVerificationScript(verificationScript);
            contentResult.setHttpHeaders(httpHeaders);
            contentResult.setAuthorizationRequest(authorizationRequest);
            contentResult.setRequestMethod(requestMethod);
            contentResult.setRestUrl(restUrl);
            contentResult.setQueryParameters(this.extractQueryParametersFromUrl(restUrl));
            contentResult.setHttpBodyType(httpBodyType);
            contentResult.setHttpBodyContent(httpBodyContent);
            return contentResult;
        }
        throw new IllegalArgumentException("Unsupported service type: " + serviceType);
    }

    private List<Map<String, Object>> extractElementObjectProperties(List<WebElementPropertyEntity> properties, boolean includeMatchConditionProperty, boolean includeIsDetectedProperty) {
        if (properties == null || properties.isEmpty()) {
            return List.of();
        }
        ArrayList<Map<String, Object>> objectProperties = new ArrayList<Map<String, Object>>();
        for (WebElementPropertyEntity prop : properties) {
            HashMap<String, Object> propMap = new HashMap<String, Object>();
            propMap.put("name", prop.getName() != null ? prop.getName() : "");
            propMap.put("value", prop.getValue() != null ? prop.getValue() : "");
            if (includeMatchConditionProperty) {
                propMap.put("matchCondition", prop.getMatchCondition() != null ? prop.getMatchCondition() : "");
            }
            if (includeIsDetectedProperty) {
                Boolean isSelected = prop.getIsSelected();
                propMap.put("isDetected", isSelected != null ? isSelected : false);
            }
            objectProperties.add(propMap);
        }
        return objectProperties;
    }

    private List<Map<String, Object>> extractXpaths(List<WebElementXpathEntity> xpaths) {
        if (xpaths == null || xpaths.isEmpty()) {
            return List.of();
        }
        ArrayList<Map<String, Object>> xpathProperties = new ArrayList<Map<String, Object>>();
        for (WebElementXpathEntity xpath : xpaths) {
            HashMap<String, String> xpathMap = new HashMap<String, String>();
            xpathMap.put("name", xpath.getName() != null ? xpath.getName() : "");
            xpathMap.put("value", xpath.getValue() != null ? xpath.getValue() : "");
            xpathProperties.add(xpathMap);
        }
        return xpathProperties;
    }

    private List<Map<String, Object>> extractQueryParametersFromUrl(String url) {
        ArrayList<Map<String, Object>> queryParams = new ArrayList<Map<String, Object>>();
        if (StringUtils.isBlank((CharSequence)url)) {
            return queryParams;
        }
        try {
            String[] paramPairs;
            int queryIndex = url.indexOf(63);
            if (queryIndex == -1) {
                return queryParams;
            }
            String queryString = url.substring(queryIndex + 1);
            if (StringUtils.isBlank((CharSequence)queryString)) {
                return queryParams;
            }
            String[] stringArray = paramPairs = queryString.split("&");
            int n = paramPairs.length;
            int n2 = 0;
            while (n2 < n) {
                String paramPair = stringArray[n2];
                if (StringUtils.isNotBlank((CharSequence)paramPair)) {
                    String[] nameValue = paramPair.split("=", 2);
                    String paramName = nameValue[0];
                    String paramValue = nameValue.length > 1 ? nameValue[1] : "";
                    try {
                        paramName = URLDecoder.decode(paramName, "UTF-8");
                        paramValue = URLDecoder.decode(paramValue, "UTF-8");
                    }
                    catch (Exception exception) {}
                    HashMap<String, String> paramMap = new HashMap<String, String>();
                    paramMap.put("name", paramName);
                    paramMap.put("value", paramValue);
                    queryParams.add(paramMap);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            this.logger.error("Error extracting query parameters from url", (Throwable)e);
        }
        return queryParams;
    }

    private Map<String, Object> extractAuthorizationDetails(BasicRequestAuthorization authRequest) {
        HashMap<String, Object> authDetails = new HashMap<String, Object>();
        if (authRequest == null) {
            return authDetails;
        }
        try {
            String authType = authRequest.getAuthorizationType();
            if (StringUtils.isNotBlank((CharSequence)authType)) {
                authDetails.put("authorizationType", authType);
            }
            return authDetails;
        }
        catch (Exception e) {
            this.logger.error("Error extracting authorization details", (Throwable)e);
            return authDetails;
        }
    }

    public McpServerFeatures.SyncToolSpecification createTestObjectTool() {
        McpSchema.Tool tool = new McpSchema.Tool("createTestObject", "Create Test Object", "Creates a new test object in the Object Repository with a suggested locator strategy based on locator information. Supports Web, Mobile, Windows, and Web Service test object.", TestObjectInputSchema.createSchemaForCreateOrUpdateTestObjectTool(false), TestObjectOutputSchema.createSchemaForCreateOrUpdateTestObjectTool(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.createTestObjectToolCallHandler((McpSchema.CallToolRequest)request)).build();
    }

    private McpSchema.CallToolResult createTestObjectToolCallHandler(McpSchema.CallToolRequest request) {
        boolean isError = false;
        Object resultContent = "";
        String testObjectId = "";
        Map<Object, Object> structuredContent = new HashMap();
        try {
            HashMap arguments = request.arguments();
            if (arguments == null) {
                arguments = new HashMap();
            }
            String testObjectType = (String)arguments.get("testObjectType");
            String testObjectName = (String)arguments.get("testObjectName");
            String folderPath = (String)arguments.get("folderPath");
            String description = (String)arguments.get("description");
            HashMap<String, Object> typeSpecificConfiguration = (HashMap<String, Object>)arguments.get("testObject");
            if (typeSpecificConfiguration == null) {
                typeSpecificConfiguration = new HashMap<String, Object>();
            }
            if (StringUtils.isBlank((CharSequence)testObjectType)) {
                isError = true;
                resultContent = "testObjectType parameter is required";
            } else if (StringUtils.isBlank((CharSequence)testObjectName)) {
                isError = true;
                resultContent = "testObjectName parameter is required";
            } else {
                testObjectId = this.createOrUpdateTestObject(null, testObjectType, testObjectName, folderPath, description, typeSpecificConfiguration);
            }
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Error creating test object: " + e.getMessage();
        }
        structuredContent = this.createStructuredContentResultForCreateNewOrUpdateTestObject(testObjectId);
        if (!isError) {
            resultContent = JsonUtil.toJson(structuredContent);
        }
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    public McpServerFeatures.SyncToolSpecification updateTestObjectTool() {
        McpSchema.Tool tool = new McpSchema.Tool("updateTestObject", "Updates an existing test object", "Updates an existing test object in the Object Repository based on its ID in the current Katalon Studio project. Supports Web, Mobile, Windows, and Web Service test object.", TestObjectInputSchema.createSchemaForCreateOrUpdateTestObjectTool(true), TestObjectOutputSchema.createSchemaForCreateOrUpdateTestObjectTool(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.updateTestObjectToolCallHandler((McpSchema.CallToolRequest)request)).build();
    }

    private McpSchema.CallToolResult updateTestObjectToolCallHandler(McpSchema.CallToolRequest request) {
        boolean isError = false;
        String updatedTestObjectId = "";
        Object resultContent = "";
        Map<Object, Object> structuredContent = new HashMap();
        try {
            HashMap arguments = request.arguments();
            if (arguments == null) {
                arguments = new HashMap();
            }
            String testObjectType = (String)arguments.get("testObjectType");
            String testObjectId = (String)arguments.get("testObjectId");
            String description = (String)arguments.get("description");
            HashMap<String, Object> typeSpecificConfiguration = (HashMap<String, Object>)arguments.get("testObject");
            if (typeSpecificConfiguration == null) {
                typeSpecificConfiguration = new HashMap<String, Object>();
            }
            if (StringUtils.isBlank((CharSequence)testObjectType)) {
                isError = true;
                resultContent = "testObjectType parameter is required";
            } else if (StringUtils.isBlank((CharSequence)testObjectId)) {
                isError = true;
                resultContent = "testObjectId parameter is required";
            } else {
                Object existingTestObject = this.getTestObjectDetails(testObjectId.trim());
                if (existingTestObject == null) {
                    isError = true;
                    resultContent = "Test Object not found: " + testObjectId;
                } else {
                    updatedTestObjectId = this.createOrUpdateTestObject(existingTestObject, testObjectType, null, null, description, typeSpecificConfiguration);
                }
            }
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Error updating test object: " + e.getMessage();
        }
        structuredContent = this.createStructuredContentResultForCreateNewOrUpdateTestObject(updatedTestObjectId);
        if (!isError) {
            resultContent = JsonUtil.toJson(structuredContent);
        }
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    private Map<String, Object> createStructuredContentResultForCreateNewOrUpdateTestObject(String testObjectId) {
        HashMap<String, Object> structuredContent = new HashMap<String, Object>();
        structuredContent.put("testObjectId", testObjectId != null ? testObjectId : "");
        return structuredContent;
    }

    private String createOrUpdateTestObject(Object existingTestObject, String testObjectType, String testObjectName, String folderPath, String description, Map<String, Object> typeSpecificConfiguration) throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project == null) {
            throw new Exception("No project is currently opened.");
        }
        TestObjectType testObjectTypeValue = this.parseTestObjectType(testObjectType);
        if (testObjectTypeValue == null) {
            throw new Exception("Unsupported test object type: " + testObjectType);
        }
        if (testObjectName != null) {
            this.validateTestObjectName(testObjectName);
        }
        FolderEntity folderToCreateTestObject = null;
        if (existingTestObject == null) {
            String normalizedFolderPath = McpToolsUtil.normalizeData((String)folderPath, (String)TEST_OBJECT_FOLDER_ROOT);
            String fullTestObjectId = normalizedFolderPath + "/" + testObjectName;
            Object currentTestObject = this.getTestObjectDetails(fullTestObjectId);
            if (currentTestObject != null) {
                throw new Exception("Test Object already exists: " + fullTestObjectId);
            }
            folderToCreateTestObject = McpToolsUtil.getOrCreateFolder((ProjectEntity)project, (String)normalizedFolderPath);
        }
        switch (testObjectTypeValue) {
            case WEB: {
                return this.createOrUpdateWebTestObject((WebElementEntity)existingTestObject, testObjectName, description, folderToCreateTestObject, typeSpecificConfiguration);
            }
            case MOBILE: {
                return this.createOrUpdateMobileTestObject((MobileElementEntity)existingTestObject, testObjectName, description, folderToCreateTestObject, typeSpecificConfiguration);
            }
            case WINDOWS: {
                return this.createOrUpdateWindowsTestObject((WindowsElementEntity)existingTestObject, testObjectName, description, folderToCreateTestObject, typeSpecificConfiguration);
            }
            case WEB_SERVICE: {
                return this.createOrUpdateWebServiceTestObject((WebServiceRequestEntity)existingTestObject, testObjectName, description, folderToCreateTestObject, typeSpecificConfiguration);
            }
        }
        throw new Exception("Unsupported test object type: " + testObjectType);
    }

    private String createOrUpdateWebTestObject(WebElementEntity existingTestObject, String testObjectName, String description, FolderEntity folderEntity, Map<String, Object> typeSpecificConfiguration) throws Exception {
        boolean isNewTestObject = existingTestObject == null;
        ObjectRepositoryController objectRepoController = ObjectRepositoryController.getInstance();
        if (existingTestObject == null) {
            existingTestObject = new WebElementEntity();
            existingTestObject.setElementGuidId(UUID.randomUUID().toString());
            existingTestObject.setName(testObjectName);
            existingTestObject.setParentFolder(folderEntity);
            existingTestObject.setProject(folderEntity.getProject());
        }
        if (description != null) {
            existingTestObject.setDescription(description);
        }
        String locatorStrategy = (String)typeSpecificConfiguration.get("locatorStrategy");
        String locatorValue = (String)typeSpecificConfiguration.get("locatorValue");
        String imagePath = (String)typeSpecificConfiguration.get("imagePath");
        Boolean useRelativeImagePath = (Boolean)typeSpecificConfiguration.get("useRelativeImagePath");
        List elementObjectProperties = (List)typeSpecificConfiguration.get("elementObjectProperties");
        this.configWebElementLocator(existingTestObject, locatorStrategy, locatorValue, imagePath, useRelativeImagePath, elementObjectProperties);
        if (isNewTestObject) {
            objectRepoController.saveNewTestObject(existingTestObject);
            this.refreshTestObjectInExplorer(existingTestObject);
            this.openTestObjectInEditor(existingTestObject);
        } else {
            objectRepoController.updateTestObject(existingTestObject);
            this.refreshTestObjectInExplorer(existingTestObject);
        }
        return existingTestObject.getIdForDisplay();
    }

    private void configWebElementLocator(WebElementEntity elementEntity, String locatorStrategy, String locatorValue, String imagePath, Boolean useRelativeImagePath, List<Map<String, Object>> elementObjectProperties) throws Exception {
        WebElementSelectorMethod method = this.parseWebSelectorMethod(locatorStrategy);
        if (method == null) {
            throw new Exception("Unknown web selector method: " + locatorStrategy);
        }
        elementEntity.setSelectorMethod(method);
        if (method == WebElementSelectorMethod.IMAGE) {
            if (imagePath != null) {
                elementEntity.setImagePath(imagePath);
            }
            if (useRelativeImagePath != null) {
                elementEntity.setUseRalativeImagePath(useRelativeImagePath.booleanValue());
            }
        } else if (method == WebElementSelectorMethod.BASIC) {
            ArrayList<WebElementPropertyEntity> properties = new ArrayList<WebElementPropertyEntity>();
            if (elementObjectProperties != null && !elementObjectProperties.isEmpty()) {
                for (Map<String, Object> propertyMap : elementObjectProperties) {
                    String name = (String)propertyMap.get("name");
                    String value = (String)propertyMap.get("value");
                    String matchCondition = (String)propertyMap.get("matchCondition");
                    if (StringUtils.isBlank((CharSequence)name)) {
                        throw new IllegalArgumentException("Element property name cannot be blank");
                    }
                    String validatedMatchCondition = "equals";
                    if (StringUtils.isNotBlank((CharSequence)matchCondition)) {
                        if (this.isValidMatchCondition(matchCondition)) {
                            validatedMatchCondition = matchCondition;
                        } else {
                            throw new IllegalArgumentException("Invalid matchCondition '" + matchCondition + "' for property '" + name + "'");
                        }
                    }
                    WebElementPropertyEntity property = new WebElementPropertyEntity();
                    property.setName(name.trim());
                    property.setValue(value instanceof String ? value : String.valueOf(value));
                    property.setMatchCondition(validatedMatchCondition);
                    property.setIsSelected(Boolean.valueOf(true));
                    properties.add(property);
                }
            }
            elementEntity.setWebElementProperties(properties);
        } else if (locatorValue != null) {
            elementEntity.setSelectorValue(method, locatorValue);
        }
    }

    private String createOrUpdateMobileTestObject(MobileElementEntity existingTestObject, String testObjectName, String description, FolderEntity folderEntity, Map<String, Object> typeSpecificConfiguration) throws Exception {
        boolean isNewTestObject = existingTestObject == null;
        ObjectRepositoryController objectRepoController = ObjectRepositoryController.getInstance();
        if (existingTestObject == null) {
            existingTestObject = new MobileElementEntity();
            existingTestObject.setElementGuidId(UUID.randomUUID().toString());
            existingTestObject.setName(testObjectName);
            existingTestObject.setParentFolder(folderEntity);
            existingTestObject.setProject(folderEntity.getProject());
            existingTestObject.setPlatform(MobilePlatform.ANDROID);
        }
        if (description != null) {
            existingTestObject.setDescription(description);
        }
        String locatorStrategy = (String)typeSpecificConfiguration.get("locatorStrategy");
        String locatorValue = (String)typeSpecificConfiguration.get("locatorValue");
        this.configMobileElementLocator(existingTestObject, locatorStrategy, locatorValue);
        if (isNewTestObject) {
            objectRepoController.saveNewTestObject((WebElementEntity)existingTestObject);
            this.refreshTestObjectInExplorer(existingTestObject);
            this.openTestObjectInEditor(existingTestObject);
        } else {
            objectRepoController.updateTestObject((WebElementEntity)existingTestObject);
        }
        return existingTestObject.getIdForDisplay();
    }

    private void configMobileElementLocator(MobileElementEntity elementEntity, String locatorStrategy, String locatorValue) throws Exception {
        LocatorStrategy locatorStrategyValue = this.parseMobileLocatorStrategy(locatorStrategy);
        if (locatorStrategyValue == null) {
            throw new Exception("Unknown Mobile locator strategy: " + locatorStrategy);
        }
        if (locatorStrategyValue == LocatorStrategy.IOS_CLASS_CHAIN || locatorStrategyValue == LocatorStrategy.IOS_PREDICATE_STRING) {
            elementEntity.setPlatform(MobilePlatform.IOS);
        }
        elementEntity.setLocatorStrategy(locatorStrategyValue);
        if (locatorValue != null) {
            elementEntity.setLocator(locatorValue);
        }
    }

    private String createOrUpdateWindowsTestObject(WindowsElementEntity existingTestObject, String testObjectName, String description, FolderEntity folderEntity, Map<String, Object> typeSpecificConfiguration) throws Exception {
        boolean isNewTestObject = existingTestObject == null;
        WindowsElementController windowsElementController = WindowsElementController.getInstance();
        if (existingTestObject == null) {
            existingTestObject = windowsElementController.newWindowsElementEntity(folderEntity, testObjectName);
            existingTestObject.setParentFolder(folderEntity);
            existingTestObject.setProject(folderEntity.getProject());
        }
        if (description != null) {
            existingTestObject.setDescription(description);
        }
        String locatorStrategy = (String)typeSpecificConfiguration.get("locatorStrategy");
        String locatorValue = (String)typeSpecificConfiguration.get("locatorValue");
        this.configWindowsElementLocator(existingTestObject, locatorStrategy, locatorValue);
        windowsElementController.updateWindowsElementEntity(existingTestObject);
        if (isNewTestObject) {
            this.refreshTestObjectInExplorer(existingTestObject);
            this.openTestObjectInEditor(existingTestObject);
        }
        return existingTestObject.getIdForDisplay();
    }

    private void configWindowsElementLocator(WindowsElementEntity elementEntity, String locatorStrategy, String locatorValue) throws Exception {
        com.kms.katalon.core.enums.windows.LocatorStrategy locatorStrategyValue = this.parseWindowsLocatorStrategy(locatorStrategy);
        if (locatorStrategyValue == null) {
            throw new Exception("Unknown Windows locator strategy: " + locatorStrategy);
        }
        elementEntity.setLocatorStrategy(locatorStrategyValue);
        if (locatorValue != null) {
            elementEntity.setLocator(locatorValue);
        }
    }

    private String createOrUpdateWebServiceTestObject(WebServiceRequestEntity existingTestObject, String testObjectName, String description, FolderEntity folderEntity, Map<String, Object> typeSpecificConfiguration) throws Exception {
        boolean isNewTestObject = existingTestObject == null;
        ObjectRepositoryController objectRepoController = ObjectRepositoryController.getInstance();
        if (existingTestObject == null) {
            existingTestObject = new WebServiceRequestEntity();
            existingTestObject.setElementGuidId(UUID.randomUUID().toString());
            existingTestObject.setName(testObjectName);
            existingTestObject.setParentFolder(folderEntity);
            existingTestObject.setProject(folderEntity.getProject());
        }
        if (description != null) {
            existingTestObject.setDescription(description);
        }
        this.configWebServiceRequest(existingTestObject, typeSpecificConfiguration);
        if (isNewTestObject) {
            objectRepoController.saveNewTestObject((WebElementEntity)existingTestObject);
            this.refreshTestObjectInExplorer(existingTestObject);
            this.openTestObjectInEditor(existingTestObject);
        } else {
            objectRepoController.updateTestObject((WebElementEntity)existingTestObject);
        }
        return existingTestObject.getIdForDisplay();
    }

    private void configWebServiceRequest(WebServiceRequestEntity webServiceEntity, Map<String, Object> typeSpecificConfiguration) throws Exception {
        String serviceType = (String)typeSpecificConfiguration.get("serviceType");
        if (StringUtils.isBlank((CharSequence)serviceType)) {
            throw new Exception("serviceType is required for Web Service configuration");
        }
        if ("RESTful".equalsIgnoreCase(serviceType) || "REST".equalsIgnoreCase(serviceType)) {
            this.configRestWebService(webServiceEntity, typeSpecificConfiguration);
        } else if ("SOAP".equalsIgnoreCase(serviceType)) {
            this.configSoapWebService(webServiceEntity, typeSpecificConfiguration);
        } else {
            throw new Exception("Unknown service type: " + serviceType);
        }
    }

    private void configRestWebService(WebServiceRequestEntity webServiceEntity, Map<String, Object> config) throws Exception {
        webServiceEntity.setServiceType("RESTful");
        String verificationScript = (String)config.get("verificationScript");
        String restUrl = (String)config.get("restUrl");
        String restRequestMethod = (String)config.get("restRequestMethod");
        String httpBodyType = (String)config.get("httpBodyType");
        String httpBodyContent = (String)config.get("httpBodyContent");
        if (StringUtils.isNotBlank((CharSequence)restRequestMethod)) {
            String method = restRequestMethod.toUpperCase();
            if (!this.isValidRestRequestMethod(method)) {
                throw new Exception("Unknown HTTP method: " + restRequestMethod);
            }
            webServiceEntity.setRestRequestMethod(method);
        } else {
            webServiceEntity.setRestRequestMethod("GET");
        }
        if (verificationScript != null) {
            webServiceEntity.setVerificationScript(verificationScript);
        }
        if (restUrl != null) {
            webServiceEntity.setRestUrl(restUrl);
        }
        if (httpBodyType != null) {
            webServiceEntity.setHttpBodyType(httpBodyType);
        }
        if (httpBodyContent != null) {
            webServiceEntity.setHttpBodyContent(httpBodyContent);
        }
    }

    private void configSoapWebService(WebServiceRequestEntity webServiceEntity, Map<String, Object> config) throws Exception {
        webServiceEntity.setServiceType("SOAP");
        String verificationScript = (String)config.get("verificationScript");
        String soapRequestMethod = (String)config.get("soapRequestMethod");
        String soapServiceEndpoint = (String)config.get("soapServiceEndpoint");
        String soapServiceFunction = (String)config.get("soapServiceFunction");
        String wsdlAddress = (String)config.get("wsdlAddress");
        String soapBody = (String)config.get("soapBody");
        if (verificationScript != null) {
            webServiceEntity.setVerificationScript(verificationScript);
        }
        if (StringUtils.isNotBlank((CharSequence)soapRequestMethod)) {
            String method = soapRequestMethod.toUpperCase();
            if (!this.isValidSoapRequestMethod(method)) {
                throw new Exception("Unknown HTTP method: " + soapRequestMethod);
            }
            webServiceEntity.setSoapRequestMethod(method);
        } else {
            webServiceEntity.setSoapRequestMethod("SOAP");
        }
        if (soapServiceEndpoint != null) {
            webServiceEntity.setSoapServiceEndpoint(soapServiceEndpoint);
        }
        if (soapServiceFunction != null) {
            webServiceEntity.setSoapServiceFunction(soapServiceFunction);
        }
        if (wsdlAddress != null) {
            webServiceEntity.setWsdlAddress(wsdlAddress);
        }
        if (soapBody != null) {
            webServiceEntity.setSoapBody(soapBody);
        }
    }

    private boolean isValidRestRequestMethod(String method) {
        String[] stringArray = WebServiceRequestEntity.REST_REQUEST_METHODS;
        int n = WebServiceRequestEntity.REST_REQUEST_METHODS.length;
        int n2 = 0;
        while (n2 < n) {
            String validMethod = stringArray[n2];
            if (validMethod.equals(method)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isValidSoapRequestMethod(String method) {
        String[] stringArray = WebServiceRequestEntity.SOAP_REQUEST_METHODS;
        int n = WebServiceRequestEntity.SOAP_REQUEST_METHODS.length;
        int n2 = 0;
        while (n2 < n) {
            String validMethod = stringArray[n2];
            if (validMethod.equals(method)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isValidMatchCondition(String matchCondition) {
        if (StringUtils.isBlank((CharSequence)matchCondition)) {
            return false;
        }
        return WebElementPropertyEntity.MATCH_CONDITION.indexOf((String)matchCondition) >= 0;
    }

    private void validateTestObjectName(String testObjectName) throws Exception {
        try {
            EntityService.getInstance().validateName(testObjectName);
        }
        catch (Exception exception) {
            throw new Exception("Invalid test object name");
        }
    }

    private TestObjectType parseTestObjectType(String testObjectType) {
        if (StringUtils.isBlank((CharSequence)testObjectType)) {
            return null;
        }
        testObjectType = testObjectType.trim().toUpperCase();
        try {
            return TestObjectType.valueOf(testObjectType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private WebElementSelectorMethod parseWebSelectorMethod(String strategy) {
        if (StringUtils.isBlank((CharSequence)strategy)) {
            return null;
        }
        strategy = strategy.trim().toUpperCase().replace(" ", "_").replace("-", "_");
        try {
            return WebElementSelectorMethod.valueOf((String)strategy);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private LocatorStrategy parseMobileLocatorStrategy(String strategy) {
        if (StringUtils.isBlank((CharSequence)strategy)) {
            return null;
        }
        strategy = strategy.trim().toUpperCase().replace(" ", "_").replace("-", "_");
        try {
            return LocatorStrategy.valueOf((String)strategy);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private com.kms.katalon.core.enums.windows.LocatorStrategy parseWindowsLocatorStrategy(String strategy) {
        if (StringUtils.isBlank((CharSequence)strategy)) {
            return null;
        }
        strategy = strategy.trim().toUpperCase().replace(" ", "_").replace("-", "_");
        try {
            return com.kms.katalon.core.enums.windows.LocatorStrategy.valueOf((String)strategy);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private void openTestObjectInEditor(Object testObject) {
        try {
            if (testObject instanceof WindowsElementEntity) {
                this.eventBroker.send("WINDOWS_TEST_OBJECT/OPEN", (Object)((WindowsElementEntity)testObject));
            } else if (testObject instanceof WebServiceRequestEntity) {
                this.eventBroker.send("WSOBJECT/OPEN", (Object)((WebServiceRequestEntity)testObject));
            } else if (testObject instanceof MobileElementEntity) {
                this.eventBroker.send("MOBILE_TESTOBJECT/OPEN", (Object)((MobileElementEntity)testObject));
            } else if (testObject instanceof WebElementEntity) {
                this.eventBroker.send("TESTOBJECT/OPEN", (Object)((WebElementEntity)testObject));
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to open test object in editor", (Throwable)e);
        }
    }

    private void refreshTestObjectInExplorer(Object testObject) {
        try {
            FolderTreeEntity folderTreeEntity = null;
            if (testObject instanceof WindowsElementEntity) {
                folderTreeEntity = TreeEntityUtil.getFolderTreeEntity((FolderEntity)((WindowsElementEntity)testObject).getParentFolder());
                this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)new WindowsElementTreeEntity((WindowsElementEntity)testObject, folderTreeEntity));
            } else if (testObject instanceof WebServiceRequestEntity) {
                folderTreeEntity = TreeEntityUtil.getFolderTreeEntity((FolderEntity)((WebServiceRequestEntity)testObject).getParentFolder());
                this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)new WebElementTreeEntity((WebElementEntity)((WebServiceRequestEntity)testObject), (ITreeEntity)folderTreeEntity));
            } else if (testObject instanceof MobileElementEntity) {
                folderTreeEntity = TreeEntityUtil.getFolderTreeEntity((FolderEntity)((MobileElementEntity)testObject).getParentFolder());
                this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)new WebElementTreeEntity((WebElementEntity)((MobileElementEntity)testObject), (ITreeEntity)folderTreeEntity));
            } else if (testObject instanceof WebElementEntity) {
                folderTreeEntity = TreeEntityUtil.getFolderTreeEntity((FolderEntity)((WebElementEntity)testObject).getParentFolder());
                this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)new WebElementTreeEntity((WebElementEntity)testObject, (ITreeEntity)folderTreeEntity));
            }
            this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)folderTreeEntity);
        }
        catch (Exception e) {
            this.logger.error("Failed to refresh test object in explorer", (Throwable)e);
        }
    }
}

