/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.mcp.tools.schema;

import com.kms.katalon.ai.mcp.enums.TestObjectType;
import com.kms.katalon.ai.mcp.jsonschema.builder.ObjectSchemaBuilder;
import com.kms.katalon.ai.mcp.jsonschema.builder.SchemaBuilder;
import com.kms.katalon.core.enums.mobile.LocatorStrategy;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.core.testobject.impl.HttpBodyType;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import io.modelcontextprotocol.spec.McpSchema;

public class TestObjectInputSchema {
    public static McpSchema.JsonSchema createSchemaForGetTestObjectTool() {
        return SchemaBuilder.object().property("testObjectId", SchemaBuilder.string("The ID of the test object to retrieve details (e.g., 'Object Repository/Page_Login/btn_Submit')")).required("testObjectId").buildAsMcpJsonSchema();
    }

    public static McpSchema.JsonSchema createSchemaForCreateOrUpdateTestObjectTool(boolean isUpdate) {
        ObjectSchemaBuilder schemaBuilder = SchemaBuilder.object().property("description", SchemaBuilder.string("The description of the test object (optional)")).property("testObjectType", SchemaBuilder.string("The type of the test object to create or update. Must be one of: WEB (Web Test Object), MOBILE (Mobile Test Object), WINDOWS (Windows Test Object), WEB_SERVICE (Web Service Test Object)").enumValues(TestObjectType.WEB.toString(), TestObjectType.MOBILE.toString(), TestObjectType.WINDOWS.toString(), TestObjectType.WEB_SERVICE.toString())).property("testObject", SchemaBuilder.object("Type-specific configuration for the test object. Must conform to the schema corresponding to the specified testObjectType").addOneOf(TestObjectInputSchema.toWebTestObjectSchema()).addOneOf(TestObjectInputSchema.toMobileTestObjectSchema()).addOneOf(TestObjectInputSchema.toWindowsTestObjectSchema()).addOneOf(TestObjectInputSchema.toWebServiceTestObjectSchema())).required("testObjectType", "testObject");
        if (isUpdate) {
            schemaBuilder.property("testObjectId", SchemaBuilder.string("The ID of the test object to update (e.g., 'Object Repository/Page_Login/btn_Submit')"));
            schemaBuilder.required("testObjectId");
        } else {
            schemaBuilder.property("testObjectName", SchemaBuilder.string("The name of the test object to create (e.g., 'btn_Submit')"));
            schemaBuilder.property("folderPath", SchemaBuilder.string("The folder path where the test object will be created (e.g., 'Object Repository/Page_Login' or 'Page_Login'). If not provided, creates in root."));
            schemaBuilder.required("testObjectName");
        }
        return schemaBuilder.buildAsMcpJsonSchema();
    }

    private static ObjectSchemaBuilder toWebTestObjectSchema() {
        return SchemaBuilder.object().property("testObjectType", SchemaBuilder.constant((Object)TestObjectType.WEB, "Web Test Object type")).property("locatorStrategy", SchemaBuilder.string("The locator strategy for Web test objects").enumValues(SelectorMethod.XPATH.toString(), SelectorMethod.CSS.toString(), SelectorMethod.BASIC.toString(), SelectorMethod.IMAGE.toString(), SelectorMethod.SMART_LOCATOR.toString())).addOneOf(SchemaBuilder.object().property("locatorStrategy", SchemaBuilder.constant(SelectorMethod.IMAGE, "Must be 'IMAGE' for image-based locators")).property("imagePath", SchemaBuilder.string("The image path for the image-based locator")).property("useRelativeImagePath", SchemaBuilder.bool("Whether to use relative image path")).required("locatorStrategy", "imagePath", "useRelativeImagePath")).addOneOf(SchemaBuilder.object().property("locatorStrategy", SchemaBuilder.constant(SelectorMethod.BASIC, "Must be 'BASIC' for property-based locators")).property("elementObjectProperties", SchemaBuilder.array("List of web element object properties for BASIC locator strategy").items(TestObjectInputSchema.createWebElementPropertySchema())).required("locatorStrategy", "elementObjectProperties")).addOneOf(SchemaBuilder.object().property("locatorStrategy", SchemaBuilder.string("The locator strategy for Web Test Object").enumValues(SelectorMethod.XPATH.toString(), SelectorMethod.CSS.toString(), SelectorMethod.SMART_LOCATOR.toString())).property("locatorValue", SchemaBuilder.string("The locator value (e.g., '//button[@id=\"submit\"]' for XPATH, '#submit' for CSS)")).required("locatorStrategy", "locatorValue"));
    }

    private static ObjectSchemaBuilder toMobileTestObjectSchema() {
        return SchemaBuilder.object().property("testObjectType", SchemaBuilder.constant((Object)TestObjectType.MOBILE, "Mobile Test Object type")).property("locatorStrategy", SchemaBuilder.string("The locator strategy for Mobile Test Object").enumValues(LocatorStrategy.ATTRIBUTES.toString(), LocatorStrategy.ACCESSIBILITY.toString(), LocatorStrategy.CLASS_NAME.toString(), LocatorStrategy.ID.toString(), LocatorStrategy.NAME.toString(), LocatorStrategy.XPATH.toString(), LocatorStrategy.IMAGE.toString(), LocatorStrategy.ANDROID_VIEWTAG.toString(), LocatorStrategy.ANDROID_UI_AUTOMATOR.toString(), LocatorStrategy.IOS_PREDICATE_STRING.toString(), LocatorStrategy.IOS_CLASS_CHAIN.toString(), LocatorStrategy.CUSTOM.toString())).property("locatorValue", SchemaBuilder.string("The locator value (e.g., 'com.example:id/button' for ID, '//android.widget.Button' for XPATH)")).required("locatorStrategy", "locatorValue");
    }

    private static ObjectSchemaBuilder toWindowsTestObjectSchema() {
        return SchemaBuilder.object().property("testObjectType", SchemaBuilder.constant((Object)TestObjectType.WINDOWS, "Windows Test Object type")).property("locatorStrategy", SchemaBuilder.string("The locator strategy for Windows Test Object").enumValues(com.kms.katalon.core.enums.windows.LocatorStrategy.ACCESSIBILITY_ID.toString(), com.kms.katalon.core.enums.windows.LocatorStrategy.CLASS_NAME.toString(), com.kms.katalon.core.enums.windows.LocatorStrategy.NAME.toString(), com.kms.katalon.core.enums.windows.LocatorStrategy.TAG_NAME.toString(), com.kms.katalon.core.enums.windows.LocatorStrategy.XPATH.toString())).property("locatorValue", SchemaBuilder.string("The locator value (e.g., 'UsernameTextBox' for ACCESSIBILITY_ID, '//Edit[@Name=\"Username\"]' for XPATH")).required("locatorStrategy", "locatorValue");
    }

    private static ObjectSchemaBuilder toWebServiceTestObjectSchema() {
        return SchemaBuilder.object().property("testObjectType", SchemaBuilder.constant((Object)TestObjectType.WEB_SERVICE, "Web Service Test Object type")).property("serviceType", SchemaBuilder.string("The type of web service").enumValues("SOAP", "REST")).addOneOf(SchemaBuilder.object().property("serviceType", SchemaBuilder.constant("REST", "The RESTful web service type")).property("verificationScript", SchemaBuilder.string("The verification script to validate response (optional)")).property("restUrl", SchemaBuilder.string("The REST API URL")).property("restRequestMethod", SchemaBuilder.string("The HTTP request method for REST service").enumValues(WebServiceRequestEntity.REST_REQUEST_METHODS)).property("httpBodyType", SchemaBuilder.string("The HTTP body content type (optional)").enumValues(HttpBodyType.TEXT.toString(), HttpBodyType.URL_ENCODED.toString(), HttpBodyType.FORM_DATA.toString(), HttpBodyType.FILE.toString(), HttpBodyType.GRAPHQL.toString())).property("httpBodyContent", SchemaBuilder.string("The HTTP body content (optional)"))).addOneOf(SchemaBuilder.object().property("serviceType", SchemaBuilder.constant("SOAP", "The SOAP web service type")).property("verificationScript", SchemaBuilder.string("The verification script to validate response (optional)")).property("soapRequestMethod", SchemaBuilder.string("The HTTP request method for SOAP service").enumValues(WebServiceRequestEntity.SOAP_REQUEST_METHODS)).property("soapServiceEndpoint", SchemaBuilder.string("The SOAP service endpoint URL")).property("soapServiceFunction", SchemaBuilder.string("The SOAP service function/operation name")).property("wsdlAddress", SchemaBuilder.string("The WSDL address (optional)")).property("soapBody", SchemaBuilder.string("The SOAP request body content (optional)"))).required("serviceType");
    }

    private static ObjectSchemaBuilder createWebElementPropertySchema() {
        return SchemaBuilder.object().property("name", SchemaBuilder.string("The property name (e.g., 'id', 'class', 'tag')")).property("value", SchemaBuilder.string("The property value")).property("matchCondition", SchemaBuilder.string("The match condition for the property").enumValues(WebElementPropertyEntity.MATCH_CONDITION.EQUAL.toString(), WebElementPropertyEntity.MATCH_CONDITION.NOT_EQUAL.toString(), WebElementPropertyEntity.MATCH_CONDITION.CONTAINS.toString(), WebElementPropertyEntity.MATCH_CONDITION.NOT_CONTAIN.toString(), WebElementPropertyEntity.MATCH_CONDITION.STARTS_WITH.toString(), WebElementPropertyEntity.MATCH_CONDITION.ENDS_WITH.toString(), WebElementPropertyEntity.MATCH_CONDITION.MATCH_REGEX.toString(), WebElementPropertyEntity.MATCH_CONDITION.NOT_MATCH_REGEX.toString())).required("name", "value", "matchCondition");
    }
}

