/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.mcp.tools.schema;

import com.kms.katalon.ai.mcp.enums.TestObjectType;
import com.kms.katalon.ai.mcp.jsonschema.builder.ObjectSchemaBuilder;
import com.kms.katalon.ai.mcp.jsonschema.builder.SchemaBuilder;
import java.util.Map;

public class TestObjectOutputSchema {
    public static Map<String, Object> createSchemaForGetTestObjectTool() {
        ObjectSchemaBuilder schemaBuilder = SchemaBuilder.object().property("testObjectId", SchemaBuilder.string("The display ID of the test object")).property("testObjectName", SchemaBuilder.string("The name of the test object")).property("description", SchemaBuilder.string("The description of the test object")).property("fileLocation", SchemaBuilder.string("The file location of the test object")).property("testObjectType", SchemaBuilder.string("The type of the test object, including values: WEB (Web Test Object), MOBILE (Mobile Test Object), WINDOWS (Windows Test Object), WEB_SERVICE (Web Service Test Object).").enumValues(TestObjectType.WEB.toString(), TestObjectType.MOBILE.toString(), TestObjectType.WINDOWS.toString(), TestObjectType.WEB_SERVICE.toString())).required("testObjectId", "testObjectName", "description", "fileLocation", "testObjectType").addOneOf(TestObjectOutputSchema.toWebTestObjectSchema()).addOneOf(TestObjectOutputSchema.toMobileTestObjectSchema()).addOneOf(TestObjectOutputSchema.toWindowsTestObjectSchema()).addOneOf(TestObjectOutputSchema.toWebServiceTestObjectSchema());
        Map<String, Object> outputSchema = SchemaBuilder.object().property("result", schemaBuilder).required("result").build();
        return outputSchema;
    }

    private static ObjectSchemaBuilder toWebTestObjectSchema() {
        return SchemaBuilder.object().property("testObjectType", SchemaBuilder.constant((Object)TestObjectType.WEB, "The type of the test object")).property("selectedMethod", SchemaBuilder.string("The selected method for the test object")).property("parentElementId", SchemaBuilder.string("ID of parent element")).property("isParentShadowRoot", SchemaBuilder.bool("Whether the parent element is a shadow root")).addOneOf(TestObjectOutputSchema.toWebTestObjectAttributesMethodSchema()).addOneOf(TestObjectOutputSchema.toWebTestObjectCssMethodSchema()).addOneOf(TestObjectOutputSchema.toWebTestObjectImageMethodSchema()).addOneOf(TestObjectOutputSchema.toWebTestObjectSmartLocatorMethodSchema()).addOneOf(TestObjectOutputSchema.toWebTestObjectXPathMethodSchema());
    }

    private static ObjectSchemaBuilder toWebTestObjectSelectionMethodSchema(String selectedMethod) {
        return SchemaBuilder.object().property("selectedMethod", SchemaBuilder.constant(selectedMethod, "The selected method for the test object")).property("selectedLocator", SchemaBuilder.string("The selected locator value for the test object")).required("selectedLocator");
    }

    private static ObjectSchemaBuilder toWebTestObjectAttributesMethodSchema() {
        return TestObjectOutputSchema.toWebTestObjectSelectionMethodSchema("Attributes").property("elementObjectProperties", SchemaBuilder.array("Array of element object properties").items(TestObjectOutputSchema.setElementObjectPropertiesSchema())).required("elementObjectProperties");
    }

    private static ObjectSchemaBuilder toWebTestObjectCssMethodSchema() {
        return TestObjectOutputSchema.toWebTestObjectSelectionMethodSchema("CSS");
    }

    private static ObjectSchemaBuilder toWebTestObjectImageMethodSchema() {
        return SchemaBuilder.object().property("selectedMethod", SchemaBuilder.constant("Image", "The selected method for the test object")).property("imagePath", SchemaBuilder.string("The image path for the image-based locator")).property("useRelativeImagePath", SchemaBuilder.bool("Whether to use relative image path")).required("imagePath", "useRelativeImagePath");
    }

    private static ObjectSchemaBuilder toWebTestObjectSmartLocatorMethodSchema() {
        return TestObjectOutputSchema.toWebTestObjectSelectionMethodSchema("Smart Locator");
    }

    private static ObjectSchemaBuilder toWebTestObjectXPathMethodSchema() {
        return TestObjectOutputSchema.toWebTestObjectSelectionMethodSchema("XPath").property("xpathProperties", SchemaBuilder.array("Array of XPath expressions").items(SchemaBuilder.object().property("name", SchemaBuilder.string("XPath name")).property("value", SchemaBuilder.string("XPath expression")))).required("xpathProperties");
    }

    private static ObjectSchemaBuilder toMobileTestObjectSchema() {
        return SchemaBuilder.object().property("testObjectType", SchemaBuilder.constant((Object)TestObjectType.MOBILE, "The type of the test object")).property("locator", SchemaBuilder.string("The locator value for the selected strategy")).property("locatorStrategy", SchemaBuilder.string("The locator strategy (XPATH, ID, etc.)")).property("elementObjectProperties", SchemaBuilder.array("Array of element object properties").items(TestObjectOutputSchema.setElementObjectPropertiesSchema())).required("locator", "locatorStrategy", "elementObjectProperties");
    }

    private static ObjectSchemaBuilder toWindowsTestObjectSchema() {
        return SchemaBuilder.object().property("testObjectType", SchemaBuilder.constant((Object)TestObjectType.WINDOWS, "The type of the test object")).property("locator", SchemaBuilder.string("The locator value for the selected strategy")).property("locatorStrategy", SchemaBuilder.string("The locator strategy (XPATH, ID, etc.)")).property("elementObjectProperties", SchemaBuilder.array("Array of element object properties").items(TestObjectOutputSchema.setElementObjectPropertiesSchema())).required("locator", "locatorStrategy", "elementObjectProperties");
    }

    private static ObjectSchemaBuilder toWebServiceTestObjectSchema() {
        return SchemaBuilder.object().property("testObjectType", SchemaBuilder.constant((Object)TestObjectType.WEB_SERVICE, "The type of the test object")).property("serviceType", SchemaBuilder.string("The type of web service (SOAP, RESTful)")).property("verificationScript", SchemaBuilder.string("The verification script to validate response")).property("httpHeaders", SchemaBuilder.array("Array of HTTP headers").items(SchemaBuilder.object().property("name", SchemaBuilder.string("Header name")).property("value", SchemaBuilder.string("Header value")))).property("authorizationRequest", SchemaBuilder.object("The authorization request configuration object").property("authorizationType", SchemaBuilder.string("Authorization type (e.g., Bearer, Basic, OAuth 1.0)"))).required("serviceType", "verificationScript", "httpHeaders", "authorizationRequest").addOneOf(TestObjectOutputSchema.toWebServiceRestfulTestObjectSchema()).addOneOf(TestObjectOutputSchema.toWebServiceSoapTestObjectSchema());
    }

    private static ObjectSchemaBuilder toWebServiceRestfulTestObjectSchema() {
        return SchemaBuilder.object().property("serviceType", SchemaBuilder.constant("RESTful", "The type of Web Service Test Object")).property("requestMethod", SchemaBuilder.string("The HTTP request method (GET, POST, PUT, DELETE, etc.)")).property("restUrl", SchemaBuilder.string("The REST API URL")).property("httpBodyType", SchemaBuilder.string("The HTTP body type")).property("httpBodyContent", SchemaBuilder.string("The HTTP body content")).property("queryParameters", SchemaBuilder.array("Array of query parameters").items(SchemaBuilder.object().property("name", SchemaBuilder.string("Parameter name")).property("value", SchemaBuilder.string("Parameter value")))).required("requestMethod", "restUrl", "httpBodyType", "httpBodyContent", "queryParameters");
    }

    private static ObjectSchemaBuilder toWebServiceSoapTestObjectSchema() {
        return SchemaBuilder.object().property("serviceType", SchemaBuilder.constant("SOAP", "The type of Web Service Test Object")).property("requestMethod", SchemaBuilder.string("The SOAP request method")).property("soapServiceEndpoint", SchemaBuilder.string("The SOAP service endpoint")).property("soapServiceFunction", SchemaBuilder.string("The SOAP service function")).property("soapBody", SchemaBuilder.string("The SOAP request body content")).property("wsdlAddress", SchemaBuilder.string("The WSDL address")).required("requestMethod", "soapServiceEndpoint", "soapServiceFunction", "soapBody", "wsdlAddress");
    }

    private static ObjectSchemaBuilder setElementObjectPropertiesSchema() {
        return SchemaBuilder.object().property("name", SchemaBuilder.string("Property name")).property("value", SchemaBuilder.string("Property value")).property("matchCondition", SchemaBuilder.string("Match condition for the property")).property("isDetected", SchemaBuilder.bool("Whether the property is detected"));
    }

    public static Map<String, Object> createSchemaForCreateOrUpdateTestObjectTool() {
        return SchemaBuilder.object().property("testObjectId", SchemaBuilder.string("The ID of the test object created or updated")).required("testObjectId").build();
    }
}

