/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.preferences;

import com.kms.katalon.ai.core.model.config.AzureOpenAIConfig;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.config.StudioAssistConfigType;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistSavingConfigException;
import com.kms.katalon.ai.preferences.OpenAIPreferenceStore;
import com.kms.katalon.ai.preferences.StudioAssistPreferenceStore;
import java.io.IOException;
import java.security.GeneralSecurityException;

public class AzureOpenAIPreferenceStore
extends StudioAssistPreferenceStore {
    public static String AZURE_API_BASE_URL = "azure_api_base_url";
    public static String AZURE_API_DEPLOYMENT_NAME = "azure_api_deployment_name";
    public static String AZURE_API_API_KEY = "azure_api_api_key";
    public static String AZURE_API_MAX_TOKEN = "azure_api_max_token";
    public static String AZURE_API_API_VERSION = "azure_api_api_version";

    @Override
    public StudioAssistConfig getConfig() throws StudioAssistLoadingConfigException {
        try {
            String baseUrl = this.decode(this.store.getString(AZURE_API_BASE_URL));
            String deploymentName = this.decode(this.store.getString(AZURE_API_DEPLOYMENT_NAME));
            String apiKey = this.decode(this.store.getString(AZURE_API_API_KEY));
            int maxToken = this.store.getInt(AZURE_API_MAX_TOKEN);
            String apiVersion = this.decode(this.store.getString(AZURE_API_API_VERSION));
            return new AzureOpenAIConfig(baseUrl, deploymentName, apiKey, maxToken, apiVersion);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new StudioAssistLoadingConfigException((Throwable)e);
        }
    }

    @Override
    public void saveConfig(StudioAssistConfig credential) throws StudioAssistSavingConfigException {
        this.store.setValue(STUDIO_ASSIST_CONFIG_TYPE, StudioAssistConfigType.AZURE_OPENAI.toString());
        this.store.setValue(OpenAIPreferenceStore.OPENAI_SECRET_KEY, "");
        this.store.setValue(OpenAIPreferenceStore.OPENAI_MAX_TOKEN, 0L);
        this.store.setValue(OpenAIPreferenceStore.OPENAI_ORGANIZATION_ID, "");
        this.store.setValue(OpenAIPreferenceStore.OPENAI_MODEL_NAME, "");
        try {
            String baseUrl = ((AzureOpenAIConfig)credential).getBaseUrl();
            this.store.setValue(AZURE_API_BASE_URL, this.encode(baseUrl));
            String deploymentName = ((AzureOpenAIConfig)credential).getDeploymentName();
            this.store.setValue(AZURE_API_DEPLOYMENT_NAME, this.encode(deploymentName));
            String apiKey = ((AzureOpenAIConfig)credential).getApiKey();
            this.store.setValue(AZURE_API_API_KEY, this.encode(apiKey));
            this.store.setValue(AZURE_API_MAX_TOKEN, ((AzureOpenAIConfig)credential).getMaxToken());
            String apiVersion = ((AzureOpenAIConfig)credential).getApiVersion();
            this.store.setValue(AZURE_API_API_VERSION, this.encode(apiVersion));
            this.store.save();
        }
        catch (Exception e) {
            throw new StudioAssistSavingConfigException((Throwable)e);
        }
    }
}

