/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.preferences;

import com.kms.katalon.ai.core.model.config.AzureOpenAIConfig;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistSavingConfigException;
import com.kms.katalon.ai.preferences.StudioAssistPreferenceStore;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.session.core.model.ManagedAzureOpenAiConfig;

public class ManagedAzureOpenAiPreferenceStore
extends StudioAssistPreferenceStore {
    public static String ADMIN_AZURE_API_MAX_TOKEN = "admin_azure_api_max_token";
    private ApplicationContext applicationContext;

    public ManagedAzureOpenAiPreferenceStore(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public StudioAssistConfig getConfig() throws StudioAssistLoadingConfigException {
        try {
            ManagedAzureOpenAiConfig adminAzureOpenAiConfig = (ManagedAzureOpenAiConfig)this.applicationContext.getAiConfigPolicy().getManagedAzureOpenAi().orElseThrow(() -> new IllegalStateException("ManagedAzureOpenAiConfig is not available"));
            String baseUrl = adminAzureOpenAiConfig.getApiBase();
            String deploymentName = adminAzureOpenAiConfig.getDeploymentName();
            String apiKey = adminAzureOpenAiConfig.getApiKey();
            int maxToken = this.store.getInt(ADMIN_AZURE_API_MAX_TOKEN);
            if (maxToken < 1) {
                maxToken = 16000;
            }
            String apiVersion = adminAzureOpenAiConfig.getApiVersion();
            return new AzureOpenAIConfig(baseUrl, deploymentName, apiKey, maxToken, apiVersion);
        }
        catch (Exception e) {
            LoggerSingleton.logError((String)"Failed to get config in ManagedAzureOpenAIPreference, error: ");
            LoggerSingleton.logError((Throwable)e);
            throw new StudioAssistLoadingConfigException((Throwable)e);
        }
    }

    @Override
    public void saveConfig(StudioAssistConfig credential) throws StudioAssistSavingConfigException {
        try {
            this.store.setValue(ADMIN_AZURE_API_MAX_TOKEN, ((AzureOpenAIConfig)credential).getMaxToken());
            this.store.save();
        }
        catch (Exception e) {
            LoggerSingleton.logError((String)"Failed to save config in ManagedAzureOpenAIPreference, error: ");
            LoggerSingleton.logError((Throwable)e);
            throw new StudioAssistSavingConfigException((Throwable)e);
        }
    }
}

