/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.preferences;

import com.kms.katalon.ai.core.model.config.AiAutoTagConfig;
import com.kms.katalon.ai.core.model.exception.StudioAssistSavingConfigException;
import com.kms.katalon.core.setting.IStudioAssistAiAutoTagSetting;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class UserManagedAiAutoTagSetting
implements IStudioAssistAiAutoTagSetting {
    private ScopedPreferenceStore scopedPreferenceStore;
    private static final String GEN_AI_TAG = "GenAI";
    private static final String GEN_AI_TEST_CASE_TAG = "API_Test_Generation";

    public UserManagedAiAutoTagSetting() {
        this.scopedPreferenceStore = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.ai");
    }

    public UserManagedAiAutoTagSetting(ScopedPreferenceStore scopedPreferenceStore) {
        this.scopedPreferenceStore = scopedPreferenceStore;
    }

    public boolean isApiTestCaseGeneration() {
        return this.getStudioAssistTagSelectionPreference("apiTcGen.tag.enabled");
    }

    public boolean isApiTestCaseDefaultTag() {
        return this.getStudioAssistTagSelectionPreference("apiTcGen.tag.default.enabled");
    }

    public boolean isApiTestCaseCustomTag() {
        return this.getStudioAssistTagSelectionPreference("apiTcGen.tag.custom.enabled");
    }

    public String getApiTestCustomTag() {
        ScopedPreferenceStore scopedPreferenceStore = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.ai");
        return scopedPreferenceStore.getString("apiTcGen.tag.customName");
    }

    public boolean isCodeGeneration() {
        return this.getStudioAssistTagSelectionPreference("genCode.tag.enabled");
    }

    public boolean isCodeGenerationDefaultTag() {
        return this.getStudioAssistTagSelectionPreference("genCode.tag.default.enabled");
    }

    public boolean isCodeGenerationCustomTag() {
        return this.getStudioAssistTagSelectionPreference("genCode.tag.custom.enabled");
    }

    public String getGenerateCodeCustomTag() {
        ScopedPreferenceStore scopedPreferenceStore = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.ai");
        return scopedPreferenceStore.getString("genCode.tag.customName");
    }

    private boolean getStudioAssistTagSelectionPreference(String preferenceKey) {
        if (StringUtils.isBlank((CharSequence)preferenceKey)) {
            return false;
        }
        String defaultTag = this.scopedPreferenceStore.getString(preferenceKey);
        return StringUtils.isEmpty((CharSequence)defaultTag) || defaultTag.equals("true");
    }

    public void saveConfig(AiAutoTagConfig aiAutoTagConfig) throws StudioAssistSavingConfigException {
        this.scopedPreferenceStore.setValue("apiTcGen.tag.enabled", String.valueOf(aiAutoTagConfig.isApiTestCaseGeneration()));
        this.scopedPreferenceStore.setValue("apiTcGen.tag.default.enabled", String.valueOf(aiAutoTagConfig.isApiTestCaseDefaultTag()));
        this.scopedPreferenceStore.setValue("apiTcGen.tag.custom.enabled", String.valueOf(aiAutoTagConfig.isApiTestCaseCustomTag()));
        this.scopedPreferenceStore.setValue("apiTcGen.tag.customName", aiAutoTagConfig.getApiTestCustomTag().trim());
        this.scopedPreferenceStore.setValue("genCode.tag.enabled", String.valueOf(aiAutoTagConfig.isCodeGeneration()));
        this.scopedPreferenceStore.setValue("genCode.tag.default.enabled", String.valueOf(aiAutoTagConfig.isCodeGenerationDefaultTag()));
        this.scopedPreferenceStore.setValue("genCode.tag.custom.enabled", String.valueOf(aiAutoTagConfig.isCodeGenerationCustomTag()));
        this.scopedPreferenceStore.setValue("genCode.tag.customName", aiAutoTagConfig.getGenerateCodeCustomTag().trim());
        try {
            this.scopedPreferenceStore.save();
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e, (String)"Failed to save user managed AI auto tag settings");
            throw new StudioAssistSavingConfigException((Throwable)e);
        }
    }

    public List<String> getAiAutoTags() {
        ArrayList<String> aiTags = new ArrayList<String>(Arrays.asList(GEN_AI_TAG, GEN_AI_TEST_CASE_TAG));
        String apiTestCustomTagValue = this.getApiTestCustomTag();
        if (this.isApiTestCaseGeneration() && this.isApiTestCaseCustomTag()) {
            aiTags.add(apiTestCustomTagValue);
        }
        String generateCodeCustomTagValue = this.getGenerateCodeCustomTag();
        if (this.isCodeGeneration() && this.isCodeGenerationCustomTag()) {
            aiTags.add(generateCodeCustomTagValue);
        }
        return aiTags;
    }
}

