/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.services;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.kms.katalon.ai.constants.StudioAssistConstants;
import com.kms.katalon.ai.core.model.agent.AgentSetting;
import com.kms.katalon.ai.core.model.agent.config.McpHttpServerDefinition;
import com.kms.katalon.ai.core.model.agent.config.McpServerDefinition;
import com.kms.katalon.ai.core.model.agent.config.McpSetting;
import com.kms.katalon.ai.core.model.agent.config.McpSseServerDefinition;
import com.kms.katalon.ai.core.services.IAgentPreferences;
import com.kms.katalon.constants.GlobalStringConstants;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
@Singleton
public class AgentPreferences
implements IAgentPreferences {
    private static final Logger logger = LoggerFactory.getLogger(AgentPreferences.class);
    private static final String MCP_SETTING_FILE = GlobalStringConstants.STUDIO_ASSIST_FOLDER_PATH + File.separator + "mcp.json";
    private static final String AGENT_SETTING_FILE = GlobalStringConstants.STUDIO_ASSIST_FOLDER_PATH + File.separator + "agent.json";
    private static final ObjectMapper objectMapper = AgentPreferences.createObjectMapper();

    static {
        objectMapper.registerSubtypes(new Class[]{McpHttpServerDefinition.class, McpSseServerDefinition.class});
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        return mapper;
    }

    public McpSetting loadMcpSetting() {
        File file = new File(MCP_SETTING_FILE);
        if (!file.exists()) {
            return new McpSetting();
        }
        try {
            JsonNode root = objectMapper.readTree(file);
            McpSetting setting = new McpSetting();
            if (root.has("servers") && root.get("servers").isObject()) {
                JsonNode serversNode = root.get("servers");
                ArrayList<McpServerDefinition> servers = new ArrayList<McpServerDefinition>();
                Iterator fieldNames = serversNode.fieldNames();
                while (fieldNames.hasNext()) {
                    String name = (String)fieldNames.next();
                    JsonNode serverNode = serversNode.get(name);
                    McpServerDefinition server = (McpServerDefinition)objectMapper.treeToValue((TreeNode)serverNode, McpServerDefinition.class);
                    if (server == null) continue;
                    servers.add(server);
                }
                setting.setServers(servers);
            }
            return setting;
        }
        catch (IOException e) {
            logger.error(MessageFormat.format(StudioAssistConstants.ERROR_IO_EXCEPTION, e));
            return new McpSetting();
        }
    }

    public void saveMcpSetting(McpSetting setting) {
        File file = new File(MCP_SETTING_FILE);
        try {
            File parent = file.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            ObjectNode root = objectMapper.createObjectNode();
            ObjectNode serversNode = objectMapper.createObjectNode();
            List servers = setting.getServers();
            if (servers != null) {
                for (McpServerDefinition server : servers) {
                    String name = server.getName();
                    serversNode.set(name, objectMapper.valueToTree((Object)server));
                }
            }
            root.set("servers", (JsonNode)serversNode);
            objectMapper.writerWithDefaultPrettyPrinter().writeValue(file, (Object)root);
        }
        catch (IOException e) {
            logger.error(MessageFormat.format(StudioAssistConstants.ERROR_IO_EXCEPTION, e));
        }
    }

    public AgentSetting loadAgentSetting() {
        File file = new File(AGENT_SETTING_FILE);
        if (!file.exists()) {
            return new AgentSetting();
        }
        try {
            JsonNode root = objectMapper.readTree(file);
            AgentSetting setting = (AgentSetting)objectMapper.treeToValue((TreeNode)root, AgentSetting.class);
            return setting != null ? setting : new AgentSetting();
        }
        catch (IOException e) {
            logger.error(MessageFormat.format(StudioAssistConstants.ERROR_IO_EXCEPTION, e));
            return new AgentSetting();
        }
    }

    public void saveAgentSetting(AgentSetting setting) {
        File file = new File(AGENT_SETTING_FILE);
        try {
            File parent = file.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            objectMapper.writerWithDefaultPrettyPrinter().writeValue(file, (Object)setting);
        }
        catch (IOException e) {
            logger.error(MessageFormat.format(StudioAssistConstants.ERROR_IO_EXCEPTION, e));
        }
    }
}

