/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.services;

import com.azure.ai.openai.models.ChatChoice;
import com.azure.ai.openai.models.ChatCompletions;
import com.azure.ai.openai.models.ChatCompletionsFunctionToolCall;
import com.azure.ai.openai.models.ChatCompletionsJsonSchemaResponseFormat;
import com.azure.ai.openai.models.ChatCompletionsOptions;
import com.azure.ai.openai.models.ChatCompletionsResponseFormat;
import com.azure.ai.openai.models.ChatCompletionsToolCall;
import com.azure.ai.openai.models.ChatCompletionsToolDefinition;
import com.azure.ai.openai.models.ChatRequestAssistantMessage;
import com.azure.ai.openai.models.ChatRequestMessage;
import com.azure.ai.openai.models.ChatRequestSystemMessage;
import com.azure.ai.openai.models.ChatRequestToolMessage;
import com.azure.ai.openai.models.ChatRequestUserMessage;
import com.azure.ai.openai.models.ChatResponseMessage;
import com.azure.ai.openai.models.CompletionsFinishReason;
import com.azure.json.JsonOptions;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.json.implementation.DefaultJsonReader;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiAuthenticationException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiClientException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiIncompatibleModelException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiNoInternetException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiProxyException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiResourceExhaustedException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiRuntimeException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiServerContentViolatedException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiServerException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiServerTimeoutException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiServerTokenExceededException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLlmApiTimeoutException;
import com.kms.katalon.ai.core.model.llm.AssistantMessage;
import com.kms.katalon.ai.core.model.llm.CompletionOptions;
import com.kms.katalon.ai.core.model.llm.LlmMessage;
import com.kms.katalon.ai.core.model.llm.SystemMessage;
import com.kms.katalon.ai.core.model.llm.ToolCall;
import com.kms.katalon.ai.core.model.llm.UserMessage;
import com.kms.katalon.ai.core.services.ILlmService;
import com.kms.katalon.ai.dto.OpenAiErrorDetailDto;
import com.kms.katalon.ai.dto.OpenAiErrorDto;
import com.kms.katalon.discovery.core.model.ServerType;
import com.kms.katalon.discovery.core.services.IDiscoveryService;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.HttpResponse;
import com.kms.katalon.network.core.model.exception.HttpException;
import com.kms.katalon.network.core.model.exception.MalformedContentException;
import com.kms.katalon.network.core.model.exception.NetworkErrorException;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import io.modelcontextprotocol.spec.McpSchema;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpTimeoutException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseOpenAiService
implements ILlmService {
    private final Logger logger = LoggerFactory.getLogger(BaseOpenAiService.class);
    private static final List<String> INCOMPATIBLE_MODEL_ERROR_MESSAGES = Arrays.asList("Invalid parameter: 'response_format' of type 'json_schema' is not supported with this model.", "Unsupported parameter: 'temperature' is not supported with this model.", "Unsupported value: 'messages[0].role' does not support 'system' with this model.", "This is not a chat model and thus not supported in the v1/chat/completions endpoint. Did you mean to use v1/completions?", "'json_schema' is not one of ['json_object', 'text'] - 'response_format.type'", "response_format value as json_schema is enabled only for api versions");
    private static final String RATE_LIMIT_ERROR = "rate limit";
    @Inject
    protected IDiscoveryService discoveryService;
    @Inject
    protected INetworkPreferences networkPreferences;
    @Inject
    protected IHttpClient httpClient;
    protected ObjectMapper objectMapper = new ObjectMapper();
    protected String model;
    protected Integer maxCompletionTokens;

    public AssistantMessage getChatCompletions(List<LlmMessage> messages, CompletionOptions options) {
        try {
            ChatCompletionsOptions chatCompletesOptions = this.buildRequest(messages, options);
            ChatCompletionsData chatCompletionsData = this.sendRequest(chatCompletesOptions);
            HttpResponse httpResponse = chatCompletionsData.httpResponse();
            this.handleResponseError(httpResponse);
            ChatCompletions chatCompletions = ChatCompletions.fromJson((JsonReader)DefaultJsonReader.fromString((String)httpResponse.getBody(), (JsonOptions)new JsonOptions()));
            return this.parseChatCompletions(chatCompletions);
        }
        catch (NetworkErrorException e) {
            if (!this.discoveryService.isOnline(this.discoveryService.getServerUrl(ServerType.TESTOPS))) {
                throw new StudioAssistLlmApiNoInternetException((Throwable)e);
            }
            throw new StudioAssistLlmApiRuntimeException((Throwable)e);
        }
        catch (HttpTimeoutException e) {
            throw new StudioAssistLlmApiTimeoutException((Throwable)e);
        }
        catch (HttpException | IOException | URISyntaxException e) {
            throw new StudioAssistLlmApiRuntimeException(e);
        }
    }

    protected ChatCompletionsOptions buildRequest(List<LlmMessage> messages, CompletionOptions options) throws IOException {
        List requestMessages = messages.stream().flatMap(message -> this.mapToRequestMessages((LlmMessage)message).stream()).toList();
        ChatCompletionsOptions chatCompletionsOptions = new ChatCompletionsOptions(requestMessages);
        chatCompletionsOptions.setMaxCompletionTokens(this.maxCompletionTokens);
        if (StringUtils.isNotEmpty((CharSequence)this.model)) {
            chatCompletionsOptions.setModel(this.model);
        }
        if (StringUtils.isNotEmpty((CharSequence)options.getResponseSchema())) {
            JsonReader reader = DefaultJsonReader.fromString((String)options.getResponseSchema(), (JsonOptions)new JsonOptions());
            chatCompletionsOptions.setResponseFormat((ChatCompletionsResponseFormat)ChatCompletionsJsonSchemaResponseFormat.fromJson((JsonReader)reader));
        }
        if (CollectionUtils.isNotEmpty((Collection)options.getTools())) {
            List<ChatCompletionsToolDefinition> availableTools = options.getTools().stream().map(this::mapToToolDefinition).toList();
            chatCompletionsOptions.setTools(availableTools);
        }
        return chatCompletionsOptions;
    }

    protected List<ChatRequestMessage> mapToRequestMessages(LlmMessage message) {
        if (message instanceof SystemMessage) {
            SystemMessage systemMessage = (SystemMessage)message;
            return List.of(new ChatRequestSystemMessage(systemMessage.getContent()));
        }
        if (message instanceof UserMessage) {
            UserMessage userMessage = (UserMessage)message;
            ChatRequestUserMessage requestMessage = new ChatRequestUserMessage(userMessage.getContent());
            requestMessage.setName(userMessage.getName());
            return List.of(requestMessage);
        }
        if (message instanceof AssistantMessage) {
            AssistantMessage assistantMessage = (AssistantMessage)message;
            if (StringUtils.isNotBlank((CharSequence)assistantMessage.getContent())) {
                return List.of(new ChatRequestAssistantMessage(assistantMessage.getContent()));
            }
            List<ChatCompletionsToolCall> toolCalls = assistantMessage.getToolCalls().stream().map(this::mapToCompletionToolCall).toList();
            ChatRequestAssistantMessage toolRequestMessage = new ChatRequestAssistantMessage("");
            toolRequestMessage.setToolCalls(toolCalls);
            List<ChatRequestToolMessage> toolMessages = assistantMessage.getToolCalls().stream().map(toolCall -> new ChatRequestToolMessage(toolCall.getOutput(), toolCall.getCallId())).toList();
            return Stream.concat(Stream.of(toolRequestMessage), toolMessages.stream()).toList();
        }
        throw new IllegalArgumentException("Unsupported message type: " + message.getClass().getName());
    }

    private ChatCompletionsToolDefinition mapToToolDefinition(McpSchema.Tool tool) {
        try {
            HashMap<String, String> functionDef = new HashMap<String, String>();
            functionDef.put("name", tool.name());
            functionDef.put("description", tool.description());
            if (tool.inputSchema() != null) {
                functionDef.put("parameters", (String)tool.inputSchema());
            }
            HashMap<String, Object> toolDef = new HashMap<String, Object>();
            toolDef.put("type", "function");
            toolDef.put("function", functionDef);
            String toolJson = this.objectMapper.writeValueAsString(toolDef);
            JsonReader jsonReader = JsonProviders.createReader((Reader)new StringReader(toolJson));
            return ChatCompletionsToolDefinition.fromJson((JsonReader)jsonReader);
        }
        catch (IOException exception) {
            this.logger.warn("Cannot map tool: " + tool.name(), (Throwable)exception);
            return null;
        }
    }

    private ChatCompletionsToolCall mapToCompletionToolCall(ToolCall toolCall) {
        try {
            HashMap<String, String> functionDef = new HashMap<String, String>();
            functionDef.put("name", toolCall.getName());
            functionDef.put("arguments", toolCall.getInput());
            HashMap<String, Object> call = new HashMap<String, Object>();
            call.put("type", "function");
            call.put("id", toolCall.getCallId());
            call.put("function", functionDef);
            String json = this.objectMapper.writeValueAsString(call);
            JsonReader reader = JsonProviders.createReader((Reader)new StringReader(json));
            return ChatCompletionsToolCall.fromJson((JsonReader)reader);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected abstract ChatCompletionsData sendRequest(ChatCompletionsOptions var1) throws URISyntaxException, HttpException;

    protected void handleResponseError(HttpResponse httpResponse) throws MalformedContentException {
        int statusCode = httpResponse.getStatusCode();
        String errorMessage = Optional.ofNullable((OpenAiErrorDto)httpResponse.json(OpenAiErrorDto.class)).map(OpenAiErrorDto::getError).map(OpenAiErrorDetailDto::getMessage).orElse(null);
        if (400 <= statusCode && statusCode < 500) {
            if (407 == statusCode) {
                throw new StudioAssistLlmApiProxyException(errorMessage);
            }
            if (401 == statusCode || 403 == statusCode) {
                throw new StudioAssistLlmApiAuthenticationException(errorMessage);
            }
            if (400 == statusCode) {
                if (INCOMPATIBLE_MODEL_ERROR_MESSAGES.stream().anyMatch(errorMessage::startsWith)) {
                    throw new StudioAssistLlmApiIncompatibleModelException(errorMessage);
                }
            }
            if (429 == statusCode) {
                if (errorMessage != null && errorMessage.toLowerCase().contains(RATE_LIMIT_ERROR)) {
                    throw new StudioAssistLlmApiResourceExhaustedException(errorMessage);
                }
                throw new StudioAssistLlmApiResourceExhaustedException();
            }
            throw new StudioAssistLlmApiClientException(errorMessage);
        }
        if (500 <= statusCode) {
            if (504 == statusCode) {
                throw new StudioAssistLlmApiServerTimeoutException(errorMessage);
            }
            throw new StudioAssistLlmApiServerException(errorMessage);
        }
    }

    private AssistantMessage parseChatCompletions(ChatCompletions chatCompletions) {
        CompletionsFinishReason finishReason = chatCompletions.getChoices().stream().findFirst().map(ChatChoice::getFinishReason).orElse(null);
        if (CompletionsFinishReason.TOKEN_LIMIT_REACHED == finishReason) {
            throw new StudioAssistLlmApiServerTokenExceededException("Token exceeded");
        }
        if (CompletionsFinishReason.CONTENT_FILTERED == finishReason) {
            throw new StudioAssistLlmApiServerContentViolatedException("Content violated filterd by LLM");
        }
        if (CompletionsFinishReason.TOOL_CALLS == finishReason) {
            List<ToolCall> toolCalls = chatCompletions.getChoices().stream().findFirst().map(ChatChoice::getMessage).map(ChatResponseMessage::getToolCalls).stream().flatMap(Collection::stream).filter(call -> call instanceof ChatCompletionsFunctionToolCall).map(call -> (ChatCompletionsFunctionToolCall)call).map(toolCall -> {
                ToolCall call = new ToolCall();
                call.setName(toolCall.getFunction().getName());
                call.setCallId(toolCall.getId());
                call.setInput(toolCall.getFunction().getArguments().toString());
                return call;
            }).toList();
            return AssistantMessage.of(toolCalls);
        }
        String result = chatCompletions.getChoices().stream().findFirst().map(ChatChoice::getMessage).map(ChatResponseMessage::getContent).orElse("");
        return AssistantMessage.of((String)result);
    }

    protected record ChatCompletionsData(URI uri, HttpOptions httpOptions, HttpResponse httpResponse) {
    }
}

