/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.services;

import com.kms.katalon.ai.core.constant.StudioAssistTrackingKeyEnum;
import com.kms.katalon.ai.core.constant.StudioAssistTrackingValueEnum;
import com.kms.katalon.ai.core.context.IAgentSessionContext;
import com.kms.katalon.ai.core.model.agent.AgentConversation;
import com.kms.katalon.ai.core.model.agent.AgentMessage;
import com.kms.katalon.ai.core.model.agent.AgentSetting;
import com.kms.katalon.ai.core.model.agent.ToolCallMessage;
import com.kms.katalon.ai.core.model.agent.ToolCallStatus;
import com.kms.katalon.ai.core.model.agent.config.McpHttpServerDefinition;
import com.kms.katalon.ai.core.model.agent.config.McpServerDefinition;
import com.kms.katalon.ai.core.model.agent.config.McpSseServerDefinition;
import com.kms.katalon.ai.core.model.chat.ResponseMessage;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatItem;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatPair;
import com.kms.katalon.ai.core.model.chat.StudioAssistConversation;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.config.StudioAssistConfigType;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.prompt.PromptType;
import com.kms.katalon.ai.core.preferences.IStudioAssistPreferences;
import com.kms.katalon.ai.core.services.IStudioAssistController;
import com.kms.katalon.ai.core.services.IStudioAssistTrackingService;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.core.setting.IStudioAssistAiAutoTagSetting;
import com.kms.katalon.core.setting.StudioAssistSetting;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.session.core.model.AiAutoTagPolicyType;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
@Singleton
public class StudioAssistTrackingService
implements IStudioAssistTrackingService {
    @Inject
    private IStudioAssistPreferences preferences;
    @Inject
    private IStudioAssistController controller;
    private final Logger logger = LoggerFactory.getLogger(StudioAssistTrackingService.class);

    private String getTrackingConfigType() {
        StudioAssistConfig config;
        block11: {
            try {
                config = this.preferences.getConfig();
                if (config != null) break block11;
                return "";
            }
            catch (StudioAssistLoadingConfigException e) {
                this.logger.error("Error when getting StudioAssist config", (Throwable)e);
                return "";
            }
        }
        StudioAssistConfigType configType = config.getType();
        switch (configType) {
            case OPENAI: {
                return "openai";
            }
            case AZURE_OPENAI: {
                return "azure_openai";
            }
            case GEN_AI: {
                return "katalon_genai";
            }
            case GEMINI: {
                return "gemini";
            }
            case OPENAI_COMPATIBLE: {
                return "openai_compatible";
            }
            case AWS_BEDROCK: {
                return "aws_bedrock";
            }
        }
        return "";
    }

    public void trackStudioAssistChat(List<Object> trackingData) {
        trackingData.add(StudioAssistTrackingKeyEnum.SA_CONFIG.getValue());
        trackingData.add(this.getTrackingConfigType());
        Trackings.trackStudioAssistChat(trackingData);
    }

    public void trackOpenStudioAssistChat(String triggerMethod, String pageState, String chatMode) {
        Trackings.trackOpenStudioAssistChat((String)triggerMethod, (String)pageState, (String)this.getTrackingConfigType(), (String)chatMode);
    }

    public void trackCloseStudioAssistChat(StudioAssistConversation conversation, String chatMode) {
        HashMap<String, Object> trackingData = new HashMap<String, Object>();
        trackingData.put(StudioAssistTrackingKeyEnum.STUDIOASSIST_CHAT_ACTION.getValue(), StudioAssistTrackingValueEnum.CLOSE_CHAT.getValue());
        trackingData.put(StudioAssistTrackingKeyEnum.CONVERSATION_ID.getValue(), conversation.getConversationId());
        trackingData.put(StudioAssistTrackingKeyEnum.SA_CONFIG.getValue(), this.getTrackingConfigType());
        trackingData.put(StudioAssistTrackingKeyEnum.CHAT_MODE.getValue(), chatMode.toLowerCase());
        if (conversation instanceof AgentConversation) {
            AgentConversation agentConversation = (AgentConversation)conversation;
            this.processAgentConversationDetails(agentConversation, trackingData);
        }
        ArrayBlockingQueue chatHistory = conversation.getChatHistory();
        trackingData.put(StudioAssistTrackingKeyEnum.NUMBER_OF_QUESTION.getValue(), chatHistory.size());
        long numberOfSuccessAnswer = chatHistory.stream().filter(this::isSuccessfulAnswer).count();
        trackingData.put(StudioAssistTrackingKeyEnum.NUMBER_OF_SUCCESS_ANSWER.getValue(), (int)numberOfSuccessAnswer);
        Trackings.trackCloseStudioAssistChat(this.convertToTrackingData(trackingData));
    }

    private void processAgentConversationDetails(AgentConversation conversation, Map<String, Object> trackingData) {
        if (conversation == null || conversation.getChatHistory() == null) {
            return;
        }
        int totalToolCalls = 0;
        int successfulToolCalls = 0;
        HashMap<String, Integer> toolUsageCounts = new HashMap<String, Integer>();
        for (StudioAssistChatItem item : conversation.getChatHistory()) {
            AgentMessage agentMessage;
            List toolCalls;
            StudioAssistChatPair chatPair;
            ResponseMessage responseMessage;
            if (!(item instanceof StudioAssistChatPair) || !((responseMessage = (chatPair = (StudioAssistChatPair)item).getResponse()) instanceof AgentMessage) || (toolCalls = (agentMessage = (AgentMessage)responseMessage).getToolCalls()).isEmpty()) continue;
            totalToolCalls += toolCalls.size();
            for (ToolCallMessage toolCall : toolCalls) {
                toolUsageCounts.merge(toolCall.getName(), 1, Integer::sum);
                if (toolCall.getStatus() != ToolCallStatus.SUCCESS) continue;
                ++successfulToolCalls;
            }
        }
        trackingData.put(StudioAssistTrackingKeyEnum.TOTAL_NUMBER_OF_TOOL_CALLED.getValue(), totalToolCalls);
        trackingData.put(StudioAssistTrackingKeyEnum.NUMBER_OF_SUCCESS_TOOL_CALL.getValue(), successfulToolCalls);
        trackingData.put(StudioAssistTrackingKeyEnum.KS_MCP_USAGE.getValue(), this.formatToolUsage(toolUsageCounts));
    }

    private boolean isSuccessfulAnswer(StudioAssistChatItem item) {
        if (item instanceof StudioAssistChatPair) {
            StudioAssistChatPair pair = (StudioAssistChatPair)item;
            return Boolean.TRUE.equals(pair.getGoodQuestion());
        }
        return true;
    }

    private String formatToolUsage(Map<String, Integer> toolUsageMap) {
        if (toolUsageMap == null || toolUsageMap.isEmpty()) {
            return "";
        }
        return toolUsageMap.entrySet().stream().map(entry -> (String)entry.getKey() + ": " + String.valueOf(entry.getValue())).collect(Collectors.joining(", "));
    }

    private List<Object> convertToTrackingData(Map<String, Object> map) {
        return map.entrySet().stream().flatMap(entry -> List.of(entry.getKey(), entry.getValue()).stream()).toList();
    }

    public void trackConfigureStudioAssist() {
        String configType = this.getTrackingConfigType();
        boolean projectContextObjectRepositoriesEnabled = StudioAssistSetting.isProjectContextObjectRepositoriesEnabled();
        boolean projectContextCustomKeywordsEnabled = StudioAssistSetting.isProjectContextCustomKeywordsEnabled();
        boolean followUpQuestionsEnabled = StudioAssistSetting.isFollowUpQuestionEnabled();
        IStudioAssistAiAutoTagSetting studioAssistSetting = this.controller.getStudioAssistAiAutoTagSetting();
        boolean apiTestCaseGenTagEnabled = studioAssistSetting.isApiTestCaseGeneration();
        boolean codeGenTagEnabled = studioAssistSetting.isCodeGeneration();
        AiAutoTagPolicyType aiAutoTaggingPolicyType = Optional.ofNullable(ApplicationContext.getInstance().getAdministrationManagedKsSetting().getAiAutoTagging()).map(setting -> setting.getType()).orElse(AiAutoTagPolicyType.USER_MANAGED_AI_AUTO_TAG);
        boolean isAdminManagedAiAutoTag = aiAutoTaggingPolicyType == AiAutoTagPolicyType.ADMIN_MANAGED_AI_AUTO_TAG;
        ArrayList<Object> trackingData = new ArrayList<Object>();
        trackingData.add(StudioAssistTrackingKeyEnum.SA_CONFIG.getValue());
        trackingData.add(configType);
        ArrayList<String> contextTypes = new ArrayList<String>();
        if (projectContextObjectRepositoriesEnabled) {
            contextTypes.add("object_repository");
        }
        if (projectContextCustomKeywordsEnabled) {
            contextTypes.add("custom_keyword");
        }
        if (!contextTypes.isEmpty()) {
            trackingData.add(StudioAssistTrackingKeyEnum.CONTEXT_TYPE.getValue());
            trackingData.add(StringUtils.join(contextTypes, (String)","));
        }
        trackingData.add(StudioAssistTrackingKeyEnum.FOLLOW_UP_QUESTION.getValue());
        trackingData.add(String.valueOf(followUpQuestionsEnabled));
        this.addTagTrackingData(trackingData, StudioAssistTrackingKeyEnum.APPEND_API_TEST_CASE_GEN_TAG_ENABLED, StudioAssistTrackingKeyEnum.API_TEST_CASE_GEN_TAG_NAME, apiTestCaseGenTagEnabled, isAdminManagedAiAutoTag, studioAssistSetting.isApiTestCaseDefaultTag(), studioAssistSetting.isApiTestCaseCustomTag());
        this.addTagTrackingData(trackingData, StudioAssistTrackingKeyEnum.APPEND_CODE_GENERATION_TAG_ENABLED, StudioAssistTrackingKeyEnum.CODE_GENERATION_TAG_NAME, codeGenTagEnabled, isAdminManagedAiAutoTag, studioAssistSetting.isCodeGenerationDefaultTag(), studioAssistSetting.isCodeGenerationCustomTag());
        Trackings.trackStudioAssistConfig(trackingData);
    }

    private void addTagTrackingData(List<Object> trackingData, StudioAssistTrackingKeyEnum enabledKey, StudioAssistTrackingKeyEnum tagNameKey, boolean tagEnabled, boolean isAdminManagedAiAutoTag, boolean isDefaultTag, boolean isCustomTag) {
        trackingData.add(enabledKey.getValue());
        trackingData.add(String.valueOf(tagEnabled));
        if (tagEnabled) {
            trackingData.add(tagNameKey.getValue());
            trackingData.add(this.determineTagNamePolicy(isAdminManagedAiAutoTag, isDefaultTag, isCustomTag));
        }
    }

    private String determineTagNamePolicy(boolean isAdminManagedAiAutoTag, boolean isDefaultTag, boolean isCustomTag) {
        if (isAdminManagedAiAutoTag) {
            return "admin_config";
        }
        if (isDefaultTag) {
            return "default";
        }
        if (isCustomTag) {
            return "custom";
        }
        return "";
    }

    public void trackCustomizedPromptEvents(List<PromptType> customizedPrompts, List<PromptType> restoredPrompts) {
        ArrayList<String> trackingData = new ArrayList<String>();
        if (customizedPrompts != null && !customizedPrompts.isEmpty()) {
            ArrayList<String> customizedPromptNames = new ArrayList<String>();
            for (PromptType promptType : customizedPrompts) {
                customizedPromptNames.add(promptType.name().toLowerCase());
            }
            trackingData.add(StudioAssistTrackingKeyEnum.CUSTOMIZED_PROMPT_FEATURE.getValue());
            trackingData.add(StringUtils.join(customizedPromptNames, (String)","));
        }
        if (restoredPrompts != null && !restoredPrompts.isEmpty()) {
            ArrayList<String> restoredPromptNames = new ArrayList<String>();
            for (PromptType promptType : restoredPrompts) {
                restoredPromptNames.add(promptType.name().toLowerCase());
            }
            trackingData.add(StudioAssistTrackingKeyEnum.RESTORE_CUSTOMIZED_PROMPT_FEATURE.getValue());
            trackingData.add(StringUtils.join(restoredPromptNames, (String)","));
        }
        if (trackingData.isEmpty()) {
            return;
        }
        Trackings.trackStudioAssistPromptLibraryConfig(trackingData);
    }

    @Inject
    @org.eclipse.e4.core.di.annotations.Optional
    private void onSaSettingChange(@UIEventTopic(value="ON_SA_SETTING_CHANGE") Object object) {
        try {
            this.trackConfigureStudioAssist();
        }
        catch (Exception e) {
            this.logger.error("Exception while handle ON_SA_SETTING_CHANGE event", (Throwable)e);
            LogUtil.logError((Throwable)e, (String)"Exception while handle event studio assist setting change");
        }
    }

    public void trackStudioAssistAgentSetting(Map<String, Object> trackingData) {
        ArrayList data = new ArrayList();
        trackingData.forEach((key, value) -> {
            data.add(key);
            data.add(value);
        });
        Trackings.trackStudioAssistAgentSetting(data);
    }

    public void addAgentModeTrackingData(List<Object> trackingData, IAgentSessionContext sessionContext) {
        trackingData.add(StudioAssistTrackingKeyEnum.NUMBER_OF_AVAILABLE_TOOL.getValue());
        trackingData.add(String.valueOf(this.getNumberOfAvailableTools(sessionContext)));
        List<McpServerDefinition> enabledMcpServers = this.getEnabledMcpServers(sessionContext);
        long enabledHttpMcpServers = enabledMcpServers.stream().filter(server -> server instanceof McpHttpServerDefinition).count();
        long enabledSseMcpServers = enabledMcpServers.stream().filter(server -> server instanceof McpSseServerDefinition).count();
        trackingData.add(StudioAssistTrackingKeyEnum.NUMBER_OF_ENABLED_HTTP_MCP_SERVER.getValue());
        trackingData.add(String.valueOf(enabledHttpMcpServers));
        trackingData.add(StudioAssistTrackingKeyEnum.NUMBER_OF_ENABLED_SSE_MCP_SERVER.getValue());
        trackingData.add(String.valueOf(enabledSseMcpServers));
        AgentSetting agentSetting = sessionContext.getAgentSetting();
        if (agentSetting != null) {
            trackingData.add(StudioAssistTrackingKeyEnum.MAX_TOOL_CALL.getValue());
            trackingData.add(String.valueOf(agentSetting.getMaxToolCalls()));
            trackingData.add(StudioAssistTrackingKeyEnum.AUTO_APPROVE_ALL_USAGE.getValue());
            trackingData.add(String.valueOf(agentSetting.isAutoToolApproval()));
        }
    }

    private List<McpServerDefinition> getEnabledMcpServers(IAgentSessionContext sessionContext) {
        List disabledServers = Optional.ofNullable(sessionContext.getAgentSetting()).map(AgentSetting::getDisabledServers).orElse(List.of());
        return sessionContext.getMcpSetting().getServers().stream().filter(server -> !disabledServers.contains(server.getName())).toList();
    }

    private int getNumberOfAvailableTools(IAgentSessionContext sessionContext) {
        return sessionContext.getAvailableTools().size();
    }
}

