/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kms.katalon.ai.core.model.apigen.TestArtifactGenerationEndpoint;
import com.kms.katalon.ai.core.model.apigen.TestArtifactGenerationEndpointRequest;
import com.kms.katalon.ai.core.model.apigen.TestArtifactGenerationError;
import com.kms.katalon.ai.core.model.apigen.TestArtifactGenerationSubmitTaskRequest;
import com.kms.katalon.ai.core.model.apigen.TestArtifactGenerationTask;
import com.kms.katalon.ai.core.model.apigen.TestArtifactGenerationTaskRequest;
import com.kms.katalon.ai.core.model.exception.TestArtifactGenerationException;
import com.kms.katalon.ai.core.model.exception.TestArtifactGenerationRequestException;
import com.kms.katalon.ai.core.services.ITestArtifactGenerationService;
import com.kms.katalon.ai.dto.TestArtifactGenerationConfigDto;
import com.kms.katalon.ai.dto.TestArtifactGenerationEndpointResponseDto;
import com.kms.katalon.ai.dto.TestArtifactGenerationGetTaskResponseDto;
import com.kms.katalon.ai.dto.TestArtifactGenerationOpenApiPayloadDto;
import com.kms.katalon.ai.dto.TestArtifactGenerationSubmitTaskRequestDto;
import com.kms.katalon.ai.dto.TestArtifactGenerationSubmitTaskResponseDto;
import com.kms.katalon.common.About;
import com.kms.katalon.discovery.core.model.ServerType;
import com.kms.katalon.discovery.core.services.IDiscoveryService;
import com.kms.katalon.network.core.model.Authentication;
import com.kms.katalon.network.core.model.BearerAuthentication;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.HttpResponse;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.model.exception.HttpException;
import com.kms.katalon.network.core.model.exception.MalformedContentException;
import com.kms.katalon.network.core.model.exception.NetworkErrorException;
import com.kms.katalon.network.core.model.exception.UrlInvalidException;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import com.kms.katalon.session.core.model.AuthenticationToken;
import jakarta.inject.Inject;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class TestArtifactGenerationService
implements ITestArtifactGenerationService {
    private final Logger logger = LoggerFactory.getLogger(TestArtifactGenerationService.class);
    private ObjectMapper objectMapper = new ObjectMapper();
    @Inject
    IDiscoveryService discoveryService;
    @Inject
    INetworkPreferences networkPreferences;
    @Inject
    IHttpClient httpClient;

    public boolean isAvailable() {
        String baseUrl = this.discoveryService.getServerUrl(ServerType.PLATFORM);
        return !StringUtils.isBlank((CharSequence)baseUrl);
    }

    public TestArtifactGenerationTask submitTask(TestArtifactGenerationSubmitTaskRequest request) throws NetworkErrorException, JsonProcessingException, MalformedContentException, TestArtifactGenerationException, UrlInvalidException {
        URI uri = null;
        try {
            String baseUrl = this.discoveryService.getServerUrl(ServerType.PLATFORM);
            URI baseUri = new URI(baseUrl);
            URIBuilder uriBuilder = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath("v1/api-test-artifact/test-case-generation-jobs");
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new UrlInvalidException((Throwable)e);
        }
        TestArtifactGenerationOpenApiPayloadDto openApiPayload = new TestArtifactGenerationOpenApiPayloadDto();
        openApiPayload.setInlineContent(request.getPayload());
        TestArtifactGenerationConfigDto generatedArtifactConfig = new TestArtifactGenerationConfigDto();
        generatedArtifactConfig.setSelectedApiEndpoints(request.getSelectedApiEndPoints());
        generatedArtifactConfig.setTestObjectMaps(request.getTestObjectMaps());
        TestArtifactGenerationSubmitTaskRequestDto generationSubmitTaskRequest = new TestArtifactGenerationSubmitTaskRequestDto();
        generationSubmitTaskRequest.setOpenApiPayload(openApiPayload);
        generationSubmitTaskRequest.setGeneratedArtifactConfig(generatedArtifactConfig);
        String json = this.objectMapper.writeValueAsString((Object)generationSubmitTaskRequest);
        AuthenticationToken token = request.getKatOneToken();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Account-Id", Long.toString(request.getAccountId()));
        headers.put("X-Organization-Id", Long.toString(request.getOrganizationId()));
        headers.put("X-Client-App-Version", About.releaseVersion());
        headers.put("X-Client-App-Name", "katalon_studio");
        headers.put("X-Client-App-Module", "test_artifact_generation");
        BearerAuthentication authentication = Authentication.BearerAuthentication((String)token.getAccessToken());
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).authentication((Authentication)authentication).proxy(proxyConfig).build();
        HttpResponse response = null;
        try {
            response = this.httpClient.jsonPost(uri, json, httpOptions);
        }
        catch (HttpException e) {
            throw new NetworkErrorException((Throwable)e);
        }
        int statusCode = response.getStatusCode();
        if (statusCode >= 400 && statusCode < 500) {
            this.handleError(statusCode, response.getBody());
        } else if (statusCode >= 500 && statusCode < 600) {
            this.handleServerError(statusCode, response.getBody());
        }
        TestArtifactGenerationSubmitTaskResponseDto generationSubmitTaskResponse = (TestArtifactGenerationSubmitTaskResponseDto)response.json(TestArtifactGenerationSubmitTaskResponseDto.class);
        return generationSubmitTaskResponse.toDomainModel();
    }

    public TestArtifactGenerationTask getTask(TestArtifactGenerationTaskRequest request) throws UrlInvalidException, NetworkErrorException, TestArtifactGenerationException, MalformedContentException {
        URI uri = null;
        try {
            String baseUrl = this.discoveryService.getServerUrl(ServerType.PLATFORM);
            URI baseUri = new URI(baseUrl);
            URIBuilder uriBuilder = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath(MessageFormat.format("v1/api-test-artifact/test-case-generation-jobs/{0}", request.getTaskId()));
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new UrlInvalidException((Throwable)e);
        }
        AuthenticationToken token = request.getKatOneToken();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Account-Id", Long.toString(request.getAccountId()));
        headers.put("X-Organization-Id", Long.toString(request.getOrganizationId()));
        headers.put("X-Client-App-Version", About.releaseVersion());
        headers.put("X-Client-App-Name", "katalon_studio");
        headers.put("X-Client-App-Module", "test_artifact_generation");
        BearerAuthentication authentication = Authentication.BearerAuthentication((String)token.getAccessToken());
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).authentication((Authentication)authentication).proxy(proxyConfig).build();
        HttpResponse response = null;
        try {
            response = this.httpClient.get(uri, httpOptions);
        }
        catch (HttpException e) {
            throw new NetworkErrorException((Throwable)e);
        }
        int statusCode = response.getStatusCode();
        if (statusCode >= 400 && statusCode < 500) {
            this.handleError(statusCode, response.getBody());
        } else if (statusCode >= 500 && statusCode < 600) {
            this.handleServerError(statusCode, response.getBody());
        }
        TestArtifactGenerationGetTaskResponseDto generationGetTaskResponse = (TestArtifactGenerationGetTaskResponseDto)response.json(TestArtifactGenerationGetTaskResponseDto.class);
        return generationGetTaskResponse.toDomainModel();
    }

    public void cancelTask(TestArtifactGenerationTaskRequest request) throws UrlInvalidException, NetworkErrorException, TestArtifactGenerationException {
        URI uri = null;
        try {
            String baseUrl = this.discoveryService.getServerUrl(ServerType.PLATFORM);
            URI baseUri = new URI(baseUrl);
            URIBuilder uriBuilder = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath(MessageFormat.format("v1/api-test-artifact/test-case-generation-jobs/{0}", request.getTaskId()));
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new UrlInvalidException((Throwable)e);
        }
        AuthenticationToken token = request.getKatOneToken();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Account-Id", Long.toString(request.getAccountId()));
        headers.put("X-Organization-Id", Long.toString(request.getOrganizationId()));
        headers.put("X-Client-App-Version", About.releaseVersion());
        headers.put("X-Client-App-Name", "katalon_studio");
        headers.put("X-Client-App-Module", "test_artifact_generation");
        BearerAuthentication authentication = Authentication.BearerAuthentication((String)token.getAccessToken());
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).authentication((Authentication)authentication).proxy(proxyConfig).build();
        HttpResponse response = null;
        try {
            response = this.httpClient.delete(uri, httpOptions);
        }
        catch (HttpException e) {
            throw new NetworkErrorException((Throwable)e);
        }
        int statusCode = response.getStatusCode();
        if (statusCode >= 400 && statusCode < 500) {
            this.handleError(statusCode, response.getBody());
        } else if (statusCode >= 500 && statusCode < 600) {
            this.handleServerError(statusCode, response.getBody());
        }
    }

    public TestArtifactGenerationEndpoint getEndpoint(TestArtifactGenerationEndpointRequest request) throws UrlInvalidException, NetworkErrorException, TestArtifactGenerationException, MalformedContentException {
        URI uri = null;
        try {
            String baseUrl = this.discoveryService.getServerUrl(ServerType.PLATFORM);
            URI baseUri = new URI(baseUrl);
            URIBuilder uriBuilder = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath(MessageFormat.format("v1/api-test-artifact/test-case-generation-jobs/{0}/endpoints/{1}/result", request.getTaskId(), request.getEndpointId()));
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new UrlInvalidException((Throwable)e);
        }
        AuthenticationToken token = request.getKatOneToken();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Account-Id", Long.toString(request.getAccountId()));
        headers.put("X-Organization-Id", Long.toString(request.getOrganizationId()));
        headers.put("X-Client-App-Version", About.releaseVersion());
        headers.put("X-Client-App-Name", "katalon_studio");
        headers.put("X-Client-App-Module", "test_artifact_generation");
        BearerAuthentication authentication = Authentication.BearerAuthentication((String)token.getAccessToken());
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).authentication((Authentication)authentication).proxy(proxyConfig).build();
        HttpResponse response = null;
        try {
            response = this.httpClient.get(uri, httpOptions);
        }
        catch (HttpException e) {
            throw new NetworkErrorException((Throwable)e);
        }
        int statusCode = response.getStatusCode();
        if (statusCode >= 400 && statusCode < 500) {
            this.handleError(statusCode, response.getBody());
        } else if (statusCode >= 500 && statusCode < 600) {
            this.handleServerError(statusCode, response.getBody());
        }
        TestArtifactGenerationEndpointResponseDto generationEndPointResponse = (TestArtifactGenerationEndpointResponseDto)response.json(TestArtifactGenerationEndpointResponseDto.class);
        TestArtifactGenerationEndpoint endpoint = generationEndPointResponse.toDomailModel();
        endpoint.setId(request.getEndpointId());
        return endpoint;
    }

    private void handleError(int statusCode, String responseBody) throws TestArtifactGenerationException {
        TestArtifactGenerationError error = null;
        try {
            error = (TestArtifactGenerationError)this.objectMapper.readValue(responseBody, TestArtifactGenerationError.class);
        }
        catch (JsonProcessingException e) {
            throw new TestArtifactGenerationRequestException((Throwable)e);
        }
        throw new TestArtifactGenerationRequestException(error.getMessage());
    }

    private void handleServerError(int statusCode, String responseBody) throws TestArtifactGenerationException {
        TestArtifactGenerationError error = null;
        try {
            error = (TestArtifactGenerationError)this.objectMapper.readValue(responseBody, TestArtifactGenerationError.class);
        }
        catch (JsonProcessingException e) {
            throw new TestArtifactGenerationRequestException((Throwable)e);
        }
        throw new TestArtifactGenerationRequestException(error.getMessage());
    }
}

